-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- ExternFile.cs -- 
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Fri Jan 14 14:48:36 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Mon Mar 21 17:25:33 1994
-- Update Count    : 16
-- 
-- ***************************************************************

SPECIFICATION ExternFile

IMPORT File FROM File;
IMPORT FILE FROM Basics;

TYPE ExternFile = File
ABSTRACT OBJECT 
  (IN name : STRING)
  
PUBLIC
  
  -- INITIALLY 
  
  -- FINALLY 
  
  METHOD Open (IN mode : DIRECTION);
  
  METHOD Close ();
     
  METHOD Flush ();
    
  METHOD IsOpen () : BOOL;
    
  METHOD GetName () : STRING;
    
  METHOD GetMode () : DIRECTION;
    
  METHOD GetSize () : FILEPOS;
  
  METHOD GetFileDesc () : REF FILE;
    
PROTECTED
  
STATE
  
  filename : STRING;
  opened   : BOOL;  
  access_mode : DIRECTION;
  file_descr : REF FILE;
  
END OBJECT;

TYPE DIRECTION = ENUM read, write, append END ENUM;

TYPE FILEPOS = LONG INT;

EXCEPTION FileIsAlreadyOpen;
EXCEPTION FileIsNotOpen;
EXCEPTION CannotOpenFile;
EXCEPTION FileIsNotOpenedForWriting;
EXCEPTION FileIsNotOpenedForReading;
EXCEPTION WritingFailed;
EXCEPTION ReadingFailed;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* TextFile *);
