-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Environ -- Access of Environment Data
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Thu Mar 31 16:06:04 1994
-- Update Count    : 14
-- 
-- ***************************************************************

SPECIFICATION Environ

IMPORT UID, GID, PID FROM Basics;

PROCEDURE GetEnvironVar (IN name : STRING) : STRING;
  
PROCEDURE GetUserName () : STRING;
-- PROCEDURE GetGroupName () : STRING;
    
-- may raise NoPlatformSupport (s. Basics.cs)
PROCEDURE GetUserId () : UID;
-- TYPE UID = INT; --> Basics.cs

-- may raise NoPlatformSupport (s. Basics.cs)
PROCEDURE GetGroupId () : GID;
-- TYPE GID = UID; --> Basics.cs

-- may raise NoPlatformSupport (s. Basics.cs)
PROCEDURE GetProcessId () : PID;
-- TYPE PID = INT; --> Basics.cs

PROCEDURE IsFileExisting (IN path : STRING) : BOOL;
PROCEDURE IsFileReadable (IN path : STRING) : BOOL;
PROCEDURE IsFileWritable (IN path : STRING) : BOOL;
-- may raise NoPlatformSupport (s. Basics.cs)
PROCEDURE IsFileExecutable (IN path : STRING) : BOOL;
  
PROCEDURE SearchFile 
  (IN pathlist : ARRAY OF STRING, 
   IN no_of_pathes :INT,
   IN filename : STRING)
  : STRING;
  
EXCEPTION FileNotFound;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Environ *);
