-- ***************************************************************
-- CoLibri
-- ---------------------------------------------------------------
--
-- Double.cs -- Functions for Type DOUBLE
-- 
--   Copyright (C) sietec Systemtechnik GmbH & Co OHG 1994
--   All rights reserved
-- 
-- Author          : Kalle Koester
-- 
-- PURPOSE 
--      |>Description of modules purpose<|
--
-- REFER
--      |>Documents with client documentation<|
--
-- ---------------------------------------------------------------
--
-- Created On      : Wed Jan 12 14:57:15 1994
-- Last Modified By: Karl-Heinz Koester
-- Last Modified On: Fri Jan 28 18:23:46 1994
-- Update Count    : 13
-- 
-- ***************************************************************

SPECIFICATION Double

CONST max : DOUBLE = 1.7976931348623157e+308;
CONST min : DOUBLE = 2.2250738585072014e-308;
-- CONST smallest : DOUBLE;
  
-------------------------------------------------------------------------
-- Arithmetic operations
-------------------------------------------------------------------------

PROCEDURE Abs (IN value : DOUBLE) : DOUBLE;
  
-------------------------------------------------------------------------
-- Accessing Parts 
-------------------------------------------------------------------------
  
PROCEDURE IsInteger (IN value : DOUBLE) : BOOL;
PROCEDURE GetIntegralPart (IN value : DOUBLE) : DOUBLE;
PROCEDURE GetFractionalPart (IN value : DOUBLE) : DOUBLE;
PROCEDURE GetExponent (IN value : DOUBLE) : INT;
  
-- PROCEDURE Trunc (IN value : DOUBLE, IN position : INT) : DOUBLE;
PROCEDURE Trunc (IN value : DOUBLE) : DOUBLE;
-- PROCEDURE Round (IN value : DOUBLE, IN position : INT) : DOUBLE;
PROCEDURE Round (IN value : DOUBLE) : DOUBLE;

-- ***************************************************************
CONST spec_vid : STRING = 
   "@(#) $__Header$" ;

END SPECIFICATION (* Double *);
