/* calmanfp.c
 * This file contains routines to replace calmanfp.asm.
 *
 * This file Copyright 1992 Ken Shirriff.  It may be used according to the
 * fractint license conditions, blah blah blah.
 */

#include "fractint.h"
#include "fractype.h"

extern _CMPLX init, parm, new;

extern int color, oldcolor, realcolor, periodicitycheck, reset_periodicity,
    fractype, kbdcount, dotmode, show_orbit, orbit_ptr, potflag, maxit,
    inside, outside, fpu;

extern double closenuff, magnitude, rqlim;

static int tmp_word, inside_color, periodicity_color;

calcmandfpasmstart() {
    if (inside<0) {
	inside_color = maxit;
    } else {
	inside_color = inside;
    }

    if (periodicitycheck < 0) {
	periodicity_color = 7;
    } else {
	periodicity_color = inside_color;
    }
    oldcolor = 0;
    return 0;
}

#define ABS(x) ((x)>0?(x):-(x))
#define close 0.01

calcmandfpasm() {
    int cx;
    int savedand;
    double x,y,x2, y2, xy, Cx, Cy, savedx, savedy;
    int savedincr;

    if (periodicitycheck==0 || periodicitycheck == -59) {
	oldcolor = 0;
    } else if (reset_periodicity==0) {
	oldcolor = maxit-250;
    }

    /* initparms */
    savedx = 0;
    savedy = 0;
    savedand = 1;
    savedincr = 1;
    orbit_ptr = 0;
    kbdcount--; /* Only check the keyboard sometimes */
    if (kbdcount<0) {
	int key;
	kbdcount = 1000;
	key = keypressed();
	if (key) {
	    if (key=='o' || key=='O') {
		getakey();
		show_orbit = 1-show_orbit;
	    } else {
		color = -1;
		return -1;
	    }
	}
    }

    cx = maxit;

    if (fractype != JULIAFP && fractype != JULIA) {
	/* Mandelbrot_87 */
	cx--;
	Cx = init.x;
	Cy = init.y;
	x = parm.x+Cx;
	y = parm.y+Cy;
    } else {
	/* dojulia_87 */
	Cx = parm.x;
	Cy = parm.y;
	x = init.x;
	y = init.y;
    }
    x2 = x*x;
    y2 = y*y;
    xy = x*y;

    /* top_of_cs_loop_87 */
    do {
	x = x2-y2+Cx;
	y = 2*xy+Cy;
	if (outside<=-2) {
	    new.x = x;
	    new.y = y;
	}
	/* no_save_new_xy_87 */
	if (inside==-100) {
	    /* epsilon_cross */
	    if (ABS(x)<0.01) {
		realcolor = maxit-cx;
		if (realcolor==0) realcolor++;
		kbdcount -= realcolor;
		color = GREEN;
		oldcolor = 0;
		goto pop_stack;
	    } else if (ABS(y)<0.01) {
		realcolor = maxit-cx;
		if (realcolor==0) realcolor++;
		kbdcount -= realcolor;
		color = BROWN;
		oldcolor = 0;
		goto pop_stack;
	    }
	}
	/* end_epsilon_cross_87 */
	if (cx<oldcolor) {
	    if (savedand==0) {
		savedx = x;
		savedy = y;
		savedincr--;
		if (savedincr==0) {
		    savedand = (savedand<<1) + 1;
		    savedincr = 4;
		} else {
		    if (ABS(x-savedx)<closenuff && ABS(y-savedy)<closenuff) {
			oldcolor = 65535;
			realcolor = maxit;
			kbdcount = kbdcount-(maxit-cx);
			color = periodicity_color;
			goto pop_stack;
		    }
		}
	    }
	}
	/* no_periodicity_check_87 */
	if (show_orbit != 0) {
	    plot_orbit(x,y,-1);
	}
	/* no_show_orbit_87 */
	x2 = x*x;
	y2 = y*y;
	xy = x*y;
	if (potflag != 0) {
	    magnitude = x2+y2;
	}
	if (x2+y2 > rqlim) {
	    goto over_bailout_87;
	}

	cx--;
    } while (cx>0);

    /* reached maxit */
    oldcolor = 65535;
    kbdcount -= maxit;
    realcolor = maxit;
    if (inside==-59) {
	color = (x2+y2)*maxit/2+1;
    } else {
        color = inside_color;
    }

pop_stack:
    
    if (orbit_ptr) {
	scrub_orbit();
    }

    return color;

over_bailout_87:
    if (cx-10>=0) {
	oldcolor = cx-10;
    } else {
	oldcolor = 0;
    }
    color = realcolor = maxit-cx;
    if (realcolor==0) realcolor = 1;
    kbdcount -= realcolor;
    if (outside==-1) {
    } else if (outside>-2) {
	color = outside;
    } else {
	/* special_outside */
	int ax;
	if (outside==-2) {
	    color += new.x + 7;
	} else if (outside==-3) {
	    color += new.y + 7;
	} else if (outside==-4) {
	    if (new.y!=0) {
		color *= new.x/new.y;
	    }
	} else if (outside==-5) {
	    color +=  new.x + new.y;
	}
	/* check_color */
	if (color<0 || color>maxit) {
	    color = 0;
	}
    }
    goto pop_stack;

}
