/*
** Declaration of functions.
**
**	@(#)defs.h              e07@nikhef.nl (Eric Wassenaar) 940621
*/

/* main.c */
int main		PROTO((int, char **));
void set_defaults	PROTO((char *, int, char **));
int process_argv	PROTO((int, char **));
int process_file	PROTO((FILE *));
int process_name	PROTO((char *));
int execute_name	PROTO((char *));
bool execute		PROTO((char *, ipaddr_t));
bool host_query		PROTO((char *, ipaddr_t));
void set_server		PROTO((char *));
void set_logfile	PROTO((char *));
void fatal		PROTO((char *, ...));
void errmsg		PROTO((char *, ...));

/* info.c */
bool get_hostinfo	PROTO((char *));
bool get_domaininfo	PROTO((char *, char *));
int get_info		PROTO((querybuf *, char *, int, int));
bool print_info		PROTO((querybuf *, int, char *, bool));
void print_data		PROTO((char *, ...));
u_char *print_rrec	PROTO((char *, u_char *, u_char *, u_char *, bool));
u_char *skip_qrec	PROTO((char *, u_char *, u_char *, u_char *));
bool get_recursive	PROTO((char *));

/* list.c */
bool list_zone		PROTO((char *));
bool find_servers	PROTO((char *));
bool get_servers	PROTO((char *));
bool get_nsinfo		PROTO((querybuf *, int, char *));
bool transfer_zone	PROTO((char *, int, struct in_addr, char *));
bool get_zone		PROTO((char *, int, struct in_addr, char *));
bool get_mxrec		PROTO((char *));
char *get_primary	PROTO((char *));
bool check_zone		PROTO((char *));
bool get_soainfo	PROTO((querybuf *, int, char *));
void check_soa		PROTO((querybuf *, char *));
bool check_dupl		PROTO((ipaddr_t));

/* addr.c */
bool check_addr		PROTO((char *));
bool check_name		PROTO((ipaddr_t));

/* util.c */
int parse_type		PROTO((char *));
int parse_class		PROTO((char *));
char *in_addr_arpa	PROTO((char *));
void print_host		PROTO((char *, struct hostent *));
void show_res		PROTO((void));
void print_statistics	PROTO((char *, int, int));
void clear_statistics	PROTO((void));
void show_types		PROTO((char *, int, int));
void ns_error		PROTO((char *, int, int));
char *decode_error	PROTO((int));
void print_status	PROTO((querybuf *));
void pr_error		PROTO((char *, ...));
void pr_warning		PROTO((char *, ...));
bool want_type		PROTO((int, int));
bool want_class		PROTO((int, int));
bool indomain		PROTO((char *, char *, bool));
bool samedomain		PROTO((char *, char *, bool));
bool gluerecord		PROTO((char *, char *, char **, int));
char *pr_dotname	PROTO((char *));
char *pr_type		PROTO((int));
char *pr_class		PROTO((int));
int expand_name		PROTO((char *, int, u_char *, u_char *, u_char *, char *));
int check_size		PROTO((char *, int, u_char *, u_char *, u_char *, int));
bool valid_name		PROTO((char *, bool));

/* misc.c */
ptr_t *xalloc		PROTO((ptr_t *, siz_t));
char *itoa		PROTO((int));
char *utoa		PROTO((int));
char *stoa		PROTO((u_char *, int));
char *nsap_ntoa		PROTO((u_char *, int));

/* send.c */
#ifdef HOST_RES_SEND
int res_send		PROTO((char *, int, char *, int));
#endif /*HOST_RES_SEND*/
int _res_connect	PROTO((int, struct sockaddr_in *, int));
int _res_write		PROTO((int, char *, int));
int _res_read		PROTO((int, char *, int));
void _res_setaddr	PROTO((struct sockaddr_in *, char *));
void _res_perror	PROTO((char *));

/* extern */
ipaddr_t inet_addr	PROTO((char *));
char *inet_ntoa		PROTO((struct in_addr));
char *hostalias		PROTO((char *));
char *getenv		PROTO((char *));
char *strcpy		PROTO((char *, char *));
char *rindex		PROTO((char *, char));
char *index		PROTO((char *, char));
ptr_t *malloc		PROTO((siz_t));
ptr_t *realloc		PROTO((ptr_t *, siz_t));
void exit		PROTO((int));
