
/* DacMethods type. */

typedef struct {
	int id;
	char *name;
	int flags;
	/*
	 * The following function tries to detect the DAC;
	 * returns nonzero if succesful.
	 */
	int (*probe)();
	/*
	 * The following function initializes the DAC; it is usually
	 * called once after detection.
	 */
	void (*initialize)();
	/*
	 * The following function fills in dot clock limits, and
	 * mapping functions for the raw clock and horizontal
	 * CRTC timing, in the cardspecs structure.
	 */
	void (*qualifyCardSpecs)(CardSpecs *cardspecs);
	/*
	 * The following function saves RAMDAC registers into regs.
	 */
	void (*saveState)(unsigned char *regs);
	/*
	 * The following function sets the RAMDAC registers with the
	 * values from regs.
	 */
	void (*restoreState)(unsigned char *regs);
	/*
	 * The following function sets up the RAMDAC register values
	 * for the desired color operating mode. If the DAC has
	 * programmable clocks, it should also program the clock.
	 */
	void (*initializeState)(unsigned char *regs, int bpp, int colormode,
		int pixelclock);
	int stateSize;	/* Size in bytes of the state (saved registers). */
} DacMethods;

/* IDs */

#define NORMAL_DAC	1
#define S3_GENDAC	2	/* S3-GenDAC (8-bit DAC). */
#define S3_SDAC		3	/* S3-SDAC (16-bit DAC). */
#define TRIO64		4	/* Trio64 internal DAC. */
#define SIERRA_32K	5	/* Basic DAC with 32K color mode support. */
#define ATT20C490	6	/* Standard AT&T 8-bit DAC with truecolor. */
#define ATT20C498	7	/* Standard AT&T 16-bit DAC. */
#define IC_WORKS	8	/* IC Works DAC (16-bit ZoomDac). */

/* Flags. */

#define DAC_HAS_PROGRAMMABLE_CLOCKS	0x1

/* Color modes. */

#define CLUT8_6		0
#define CLUT8_8		1
#define RGB16_555	2
#define RGB16_565	3
#define RGB24_888_B	4	/* 3 bytes per pixel, blue byte first. */
#define RGB32_888_B	5	/* 4 bytes per pixel. */


/* Variables defined in ramdac.c. */

extern DacMethods normal_dac_methods;
extern DacMethods S3_SDAC_methods;
extern DacMethods S3_GENDAC_methods;
extern DacMethods Trio64_methods;
extern DacMethods Sierra_32K_methods;
extern DacMethods ATT20C490_methods;
extern DacMethods ATT20C498_methods;
extern DacMethods ARK1491_methods;
extern DacMethods ICW_methods;

extern DacMethods *all_dacs[];	/* List of all defined DACs. */


/* Functions defined in ramdac.c. */

/*
 * The following function probes the DACs in daclist, which must be
 * terminated by NULL. It returns the detected DAC if succesful, NULL
 * otherwise. The detected DAC is also initialized.
 */

extern DacMethods *probeDacs( DacMethods **daclist );
