.\" -*- nroff -*-
.\" Copyright (c) 1991, 1992 Cygnus Support
.\" written by K. Richard Pixley
.TH configure 1 "2 February 1993" "cygnus support" "Cygnus Support"
.de BP
.sp
.ti \-.2i
\(**
..

.SH NAME
configure \(em\& prepare source code to be built

.SH SYNOPSIS
configure HOST [--target=TARGET] [--srcdir=DIR] [--rm]
            [--site=SITE] [--prefix=DIR] [--exec_prefix=DIR]
            [--program_prefix=DIR] [--tmpdir=DIR]
            [--with-PACKAGE[=YES/NO]] [--norecursion]
            [--nfp] [-s] [-v] [-V | --version] [--help]

.SH DESCRIPTION
.I configure
is a program used to prepare souce code to be built.  It does this by
generating Makefiles and .gdbinit files, creating symlinks, recursing
in subdirectories, and some other miscellaneous file editing.

.SH OPTIONS
.I configure
accepts the following options:

.TP
.I \--target=TARGET
Requests that the sources be configured to target the
.I TARGET
machine.  If no target is specified explicitly, the target is assumed
to be the same as the host.

.TP
.I \--srcdir=DIR
tells configure to find the source in 
.I DIR.
Object code is always built in the current directory,
.I `.'.

.TP
.I \--rm
asks configure to remove a configuration rather than create one.

.TP
.I \--site=SITE
asks configure to use any site-specific Makefile fragments for
.I SITE
when building Makefiles.

.TP
.I \--prefix=DIR
sets the location in which to install files to
.I DIR.
The default is "/usr/local".

.TP
.I \--exec_prefix=DIR
sets the root directory for host-dependent files to
.I DIR.
The default location is the value of
.I prefix.

.TP
.I \--program_prefix=DIR
configures the source to install programs which have the same names as
common Unix programs, such as "make", in
.I DIR.
Also applies to programs which might be used for cross-compilation.

.TP
.I \--tmpdir=DIR
sets the directory in which configure creates temporary files to
.I DIR.

.TP
.I \--with-PACKAGE[=YES/NO]
sets a flag for the build to recognize that
.I PACKAGE
is explicitly present or not present.  If
.I \=YES/NO
is nonexistent, the default is
.I YES.

.TP
.I \--norecursion
asks that only the current directory be configured.  Normally
.I configure
recurs on subdirectories.

.TP
.I \-nfp
Notifies
.I configure
that all of the specified hosts have
.I no floating point
units.

.TP
.I \-s
used internally by configure to supress status messages on
subdirectory recursions.  Override with
.I \-v

.TP
.I \-v
verbose output.  Asks that configure print status lines for each
directory configured.  Normally, only the status lines for the current
directory are printed.

.TP
.I \--version
.I \-V
prints
.I configure
version number.

.TP
.I \-help
displays a brief usage summary.


.SH FILES
configure.in	for each directory's individual needs
.br
Makefile.in	Makefile template
.br
config.sub	for parsing configuration names
.br
config.guess	for guessing HOST when not specified
.br
config.status	non-recursively rebuilds current directory

.SH FILES
.ta \w'gmon.sum 'u
a.out	the namelist and text space.
.br
gmon.out	dynamic call graph and profile.
.br
gmon.sum summarized dynamic call graph and profile.

.SH "SEE ALSO"
.RB "`\|" configure "\|'"
entry in 
.B
info.
