# Makefile for the CLISP binaries
# DO NOT EDIT! GENERATED AUTOMATICALLY!

# -------------- Start of configurable section --------------------

# Directories used by "make install":
prefix = 
exec_prefix = $(prefix)
bindir = $(exec_prefix).bin
mandir = $(exec_prefix).man
libdir = $(exec_prefix).lib
lisplibdir = $(libdir).lisp

# Programs used by "make":
CC = cc
CFLAGS = -O -D__arm -D__riscos -wanp -JUnix: -IUnix:
CPP = cc -E
CLFLAGS =  -LUnix:o.Unixlib
LIBS = 
X_LIBS = 

MAKE = make
RM = remove
CP = cp ~A~CN
LN = cp ~A~CN
MV = cp ~A~CDF
CAT = cat
TOUCH = stamp
AR = ar
RANLIB = ranlib

# Programs used by "make install":
INSTALL = cp ~A~CN
INSTALL_PROGRAM = $(INSTALL)
INSTALL_DATA = $(INSTALL)

# Programs used by "make distrib":

# formatter for manual page
ROFF_MAN = nroff -man # try "groff -Tascii -mandoc" or "nroff -man"
ROFF_DVI =  # try "groff -Tdvi -mandoc"

# -------------- End of configurable section --------------------

COMMENT5 = /comment5
ANSIDECL = /ansidecl
TXT2C = /txt2c

DFILES = \
spvw.d \
spvwtabf.d \
spvwtabs.d \
spvwtabo.d \
eval.d \
control.d \
pathname.d \
stream.d \
io.d \
array.d \
hashtabl.d \
list.d \
package.d \
record.d \
sequence.d \
charstrg.d \
debug.d \
error.d \
misc.d \
predtype.d \
symbol.d \
lisparit.d \
unixaux.d \
acornaux.d \
lispbibl.d \
fsubr.d \
subr.d \
pseudofun.d \
constsym.d \
constobj.d \
acorn.d \
constpack.d \
avl.d \
sort.d \
aridecl.d \
arilev0.d \
arilev1.d \
intelem.d \
intlog.d \
intplus.d \
intcomp.d \
intbyte.d \
intmal.d \
intdiv.d \
intgcd.d \
int2adic.d \
intsqrt.d \
intprint.d \
intread.d \
rational.d \
sfloat.d \
ffloat.d \
dfloat.d \
lfloat.d \
flo_konv.d \
flo_rest.d \
realelem.d \
realrand.d \
realtran.d \
compelem.d \
comptran.d \
arilev1c.d \
arilev1e.d \
arilev1i.d \
genclisph.d \
modules.d \
noreadline.d \
main.d \
ariarm.d

CFILES = \
spvw.c \
spvwtabf.c \
spvwtabs.c \
spvwtabo.c \
eval.c \
control.c \
pathname.c \
stream.c \
io.c \
array.c \
hashtabl.c \
list.c \
package.c \
record.c \
sequence.c \
charstrg.c \
debug.c \
error.c \
misc.c \
predtype.c \
symbol.c \
lisparit.c \
unixaux.c \
acornaux.c \
lispbibl.c \
fsubr.c \
subr.c \
pseudofun.c \
constsym.c \
constobj.c \
acorn.c \
constpack.c \
avl.c \
sort.c \
aridecl.c \
arilev0.c \
arilev1.c \
intelem.c \
intlog.c \
intplus.c \
intcomp.c \
intbyte.c \
intmal.c \
intdiv.c \
intgcd.c \
int2adic.c \
intsqrt.c \
intprint.c \
intread.c \
rational.c \
sfloat.c \
ffloat.c \
dfloat.c \
lfloat.c \
flo_konv.c \
flo_rest.c \
realelem.c \
realrand.c \
realtran.c \
compelem.c \
comptran.c \
arilev1c.c \
arilev1e.c \
arilev1i.c \
genclisph.c \
modules.c \
noreadline.c \
main.c \
ariarm.c

OBJECTS = \
spvw.o \
spvwtabf.o \
spvwtabs.o \
spvwtabo.o \
eval.o \
control.o \
pathname.o \
stream.o \
io.o \
array.o \
hashtabl.o \
list.o \
package.o \
record.o \
sequence.o \
charstrg.o \
debug.o \
error.o \
misc.o \
predtype.o \
symbol.o \
lisparit.o \
unixaux.o \
acornaux.o \
ariarm.o

LSPFILES = \
init.lsp \
defseq.lsp \
backquot.lsp \
defmacro.lsp \
macros1.lsp \
macros2.lsp \
defs1.lsp \
timezone.lsp \
places.lsp \
floatpri.lsp \
type.lsp \
defstruc.lsp \
format.lsp \
user1.lsp \
user2.lsp \
trace.lsp \
macros3.lsp \
config.lsp \
compiler.lsp \
defs2.lsp \
loop.lsp \
clos.lsp \
conditio.lsp \
defs3.lsp \
gstream.lsp \
foreign.lsp \
screen.lsp \
stdwin1.lsp \
stdwin2.lsp \
rexx.lsp \
editor.lsp

FASFILES = \
init.fas \
defseq.fas \
backquot.fas \
defmacro.fas \
macros1.fas \
macros2.fas \
defs1.fas \
timezone.fas \
places.fas \
floatpri.fas \
type.fas \
defstruc.fas \
format.fas \
user1.fas \
user2.fas \
trace.fas \
macros3.fas \
config.fas \
compiler.fas \
defs2.fas \
loop.fas \
clos.fas \
conditio.fas \
defs3.fas \
gstream.fas \
foreign.fas \
screen.fas \
stdwin1.fas \
stdwin2.fas \
rexx.fas \
editor.fas

TXTFILES = \
LISP-tutorial.txt \
CLOS-guide.txt \
cltl2.txt

TESTLSPFILES = \
stage.init.lsp \
stage.defseq.lsp \
stage.backquot.lsp \
stage.defmacro.lsp \
stage.macros1.lsp \
stage.macros2.lsp \
stage.defs1.lsp \
stage.timezone.lsp \
stage.places.lsp \
stage.floatpri.lsp \
stage.type.lsp \
stage.defstruc.lsp \
stage.format.lsp \
stage.user1.lsp \
stage.user2.lsp \
stage.trace.lsp \
stage.macros3.lsp \
stage.config.lsp \
stage.compiler.lsp \
stage.defs2.lsp \
stage.loop.lsp \
stage.clos.lsp \
stage.conditio.lsp \
stage.defs3.lsp \
stage.gstream.lsp \
stage.foreign.lsp \
stage.screen.lsp \
stage.stdwin1.lsp \
stage.stdwin2.lsp \
stage.rexx.lsp \
stage.editor.lsp

TESTFASFILES = \
stage.init.fas \
stage.defseq.fas \
stage.backquot.fas \
stage.defmacro.fas \
stage.macros1.fas \
stage.macros2.fas \
stage.defs1.fas \
stage.timezone.fas \
stage.places.fas \
stage.floatpri.fas \
stage.type.fas \
stage.defstruc.fas \
stage.format.fas \
stage.user1.fas \
stage.user2.fas \
stage.trace.fas \
stage.macros3.fas \
stage.config.fas \
stage.compiler.fas \
stage.defs2.fas \
stage.loop.fas \
stage.clos.fas \
stage.conditio.fas \
stage.defs3.fas \
stage.gstream.fas \
stage.foreign.fas \
stage.screen.fas \
stage.stdwin1.fas \
stage.stdwin2.fas \
stage.rexx.fas \
stage.editor.fas


all : init allc allo lisp interpreted.mem halfcompiled.mem compiled.mem manual
	$(TOUCH) all


init : comment5 ansidecl txt2c $(DFILES) modules.h
	$(TOUCH) init

comment5 : ^.utils.comment5.c
	$(CC) $(CFLAGS) ^.utils.comment5.c -o comment5

ansidecl : ^.utils.ansidecl.d comment5
	$(LN) ^.utils.ansidecl.d ansidecl.d
	$(COMMENT5) ansidecl.d ansidecl.c
	$(RM) ansidecl.d
	$(CC) $(CFLAGS) ansidecl.c -o ansidecl
	$(RM) ansidecl.c

txt2c : ^.utils.txt2c.c
	$(CC) $(CFLAGS) ^.utils.txt2c.c -o txt2c


allc : init $(CFILES)
	$(TOUCH) allc

spvw.c : spvw.d comment5 ansidecl
	$(COMMENT5) spvw.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvw.c
	$(RM) TMPPIPE1

spvwtabf.c : spvwtabf.d comment5 ansidecl
	$(COMMENT5) spvwtabf.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabf.c
	$(RM) TMPPIPE1

spvwtabs.c : spvwtabs.d comment5 ansidecl
	$(COMMENT5) spvwtabs.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabs.c
	$(RM) TMPPIPE1

spvwtabo.c : spvwtabo.d comment5 ansidecl
	$(COMMENT5) spvwtabo.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabo.c
	$(RM) TMPPIPE1

eval.c : eval.d comment5 ansidecl
	$(COMMENT5) eval.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > eval.c
	$(RM) TMPPIPE1

control.c : control.d comment5 ansidecl
	$(COMMENT5) control.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > control.c
	$(RM) TMPPIPE1

pathname.c : pathname.d comment5 ansidecl
	$(COMMENT5) pathname.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > pathname.c
	$(RM) TMPPIPE1

stream.c : stream.d comment5 ansidecl
	$(COMMENT5) stream.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > stream.c
	$(RM) TMPPIPE1

io.c : io.d comment5 ansidecl
	$(COMMENT5) io.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > io.c
	$(RM) TMPPIPE1

array.c : array.d comment5 ansidecl
	$(COMMENT5) array.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > array.c
	$(RM) TMPPIPE1

hashtabl.c : hashtabl.d comment5 ansidecl
	$(COMMENT5) hashtabl.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > hashtabl.c
	$(RM) TMPPIPE1

list.c : list.d comment5 ansidecl
	$(COMMENT5) list.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > list.c
	$(RM) TMPPIPE1

package.c : package.d comment5 ansidecl
	$(COMMENT5) package.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > package.c
	$(RM) TMPPIPE1

record.c : record.d comment5 ansidecl
	$(COMMENT5) record.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > record.c
	$(RM) TMPPIPE1

sequence.c : sequence.d comment5 ansidecl
	$(COMMENT5) sequence.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sequence.c
	$(RM) TMPPIPE1

charstrg.c : charstrg.d comment5 ansidecl
	$(COMMENT5) charstrg.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > charstrg.c
	$(RM) TMPPIPE1

debug.c : debug.d comment5 ansidecl
	$(COMMENT5) debug.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > debug.c
	$(RM) TMPPIPE1

error.c : error.d comment5 ansidecl
	$(COMMENT5) error.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > error.c
	$(RM) TMPPIPE1

misc.c : misc.d comment5 ansidecl
	$(COMMENT5) misc.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > misc.c
	$(RM) TMPPIPE1

predtype.c : predtype.d comment5 ansidecl
	$(COMMENT5) predtype.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > predtype.c
	$(RM) TMPPIPE1

symbol.c : symbol.d comment5 ansidecl
	$(COMMENT5) symbol.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > symbol.c
	$(RM) TMPPIPE1

lisparit.c : lisparit.d comment5 ansidecl
	$(COMMENT5) lisparit.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lisparit.c
	$(RM) TMPPIPE1

unixaux.c : unixaux.d comment5 ansidecl
	$(COMMENT5) unixaux.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > unixaux.c
	$(RM) TMPPIPE1

acornaux.c : acornaux.d comment5 ansidecl
	$(COMMENT5) acornaux.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > acornaux.c
	$(RM) TMPPIPE1

lispbibl.c : lispbibl.d comment5 ansidecl
	$(COMMENT5) lispbibl.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lispbibl.c
	$(RM) TMPPIPE1

fsubr.c : fsubr.d comment5 ansidecl
	$(COMMENT5) fsubr.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > fsubr.c
	$(RM) TMPPIPE1

subr.c : subr.d comment5 ansidecl
	$(COMMENT5) subr.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > subr.c
	$(RM) TMPPIPE1

pseudofun.c : pseudofun.d comment5 ansidecl
	$(COMMENT5) pseudofun.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > pseudofun.c
	$(RM) TMPPIPE1

constsym.c : constsym.d comment5 ansidecl
	$(COMMENT5) constsym.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constsym.c
	$(RM) TMPPIPE1

constobj.c : constobj.d comment5 ansidecl
	$(COMMENT5) constobj.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constobj.c
	$(RM) TMPPIPE1

acorn.c : acorn.d comment5 ansidecl
	$(COMMENT5) acorn.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > acorn.c
	$(RM) TMPPIPE1

constpack.c : constpack.d comment5 ansidecl
	$(COMMENT5) constpack.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constpack.c
	$(RM) TMPPIPE1

avl.c : avl.d comment5 ansidecl
	$(COMMENT5) avl.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > avl.c
	$(RM) TMPPIPE1

sort.c : sort.d comment5 ansidecl
	$(COMMENT5) sort.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sort.c
	$(RM) TMPPIPE1

aridecl.c : aridecl.d comment5 ansidecl
	$(COMMENT5) aridecl.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > aridecl.c
	$(RM) TMPPIPE1

arilev0.c : arilev0.d comment5 ansidecl
	$(COMMENT5) arilev0.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev0.c
	$(RM) TMPPIPE1

arilev1.c : arilev1.d comment5 ansidecl
	$(COMMENT5) arilev1.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1.c
	$(RM) TMPPIPE1

intelem.c : intelem.d comment5 ansidecl
	$(COMMENT5) intelem.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intelem.c
	$(RM) TMPPIPE1

intlog.c : intlog.d comment5 ansidecl
	$(COMMENT5) intlog.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intlog.c
	$(RM) TMPPIPE1

intplus.c : intplus.d comment5 ansidecl
	$(COMMENT5) intplus.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intplus.c
	$(RM) TMPPIPE1

intcomp.c : intcomp.d comment5 ansidecl
	$(COMMENT5) intcomp.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intcomp.c
	$(RM) TMPPIPE1

intbyte.c : intbyte.d comment5 ansidecl
	$(COMMENT5) intbyte.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intbyte.c
	$(RM) TMPPIPE1

intmal.c : intmal.d comment5 ansidecl
	$(COMMENT5) intmal.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intmal.c
	$(RM) TMPPIPE1

intdiv.c : intdiv.d comment5 ansidecl
	$(COMMENT5) intdiv.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intdiv.c
	$(RM) TMPPIPE1

intgcd.c : intgcd.d comment5 ansidecl
	$(COMMENT5) intgcd.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intgcd.c
	$(RM) TMPPIPE1

int2adic.c : int2adic.d comment5 ansidecl
	$(COMMENT5) int2adic.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > int2adic.c
	$(RM) TMPPIPE1

intsqrt.c : intsqrt.d comment5 ansidecl
	$(COMMENT5) intsqrt.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intsqrt.c
	$(RM) TMPPIPE1

intprint.c : intprint.d comment5 ansidecl
	$(COMMENT5) intprint.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intprint.c
	$(RM) TMPPIPE1

intread.c : intread.d comment5 ansidecl
	$(COMMENT5) intread.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intread.c
	$(RM) TMPPIPE1

rational.c : rational.d comment5 ansidecl
	$(COMMENT5) rational.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > rational.c
	$(RM) TMPPIPE1

sfloat.c : sfloat.d comment5 ansidecl
	$(COMMENT5) sfloat.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sfloat.c
	$(RM) TMPPIPE1

ffloat.c : ffloat.d comment5 ansidecl
	$(COMMENT5) ffloat.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > ffloat.c
	$(RM) TMPPIPE1

dfloat.c : dfloat.d comment5 ansidecl
	$(COMMENT5) dfloat.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > dfloat.c
	$(RM) TMPPIPE1

lfloat.c : lfloat.d comment5 ansidecl
	$(COMMENT5) lfloat.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lfloat.c
	$(RM) TMPPIPE1

flo_konv.c : flo_konv.d comment5 ansidecl
	$(COMMENT5) flo_konv.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > flo_konv.c
	$(RM) TMPPIPE1

flo_rest.c : flo_rest.d comment5 ansidecl
	$(COMMENT5) flo_rest.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > flo_rest.c
	$(RM) TMPPIPE1

realelem.c : realelem.d comment5 ansidecl
	$(COMMENT5) realelem.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realelem.c
	$(RM) TMPPIPE1

realrand.c : realrand.d comment5 ansidecl
	$(COMMENT5) realrand.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realrand.c
	$(RM) TMPPIPE1

realtran.c : realtran.d comment5 ansidecl
	$(COMMENT5) realtran.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realtran.c
	$(RM) TMPPIPE1

compelem.c : compelem.d comment5 ansidecl
	$(COMMENT5) compelem.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > compelem.c
	$(RM) TMPPIPE1

comptran.c : comptran.d comment5 ansidecl
	$(COMMENT5) comptran.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > comptran.c
	$(RM) TMPPIPE1

arilev1c.c : arilev1c.d comment5 ansidecl
	$(COMMENT5) arilev1c.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1c.c
	$(RM) TMPPIPE1

arilev1e.c : arilev1e.d comment5 ansidecl
	$(COMMENT5) arilev1e.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1e.c
	$(RM) TMPPIPE1

arilev1i.c : arilev1i.d comment5 ansidecl
	$(COMMENT5) arilev1i.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1i.c
	$(RM) TMPPIPE1

genclisph.c : genclisph.d comment5 ansidecl
	$(COMMENT5) genclisph.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > genclisph.c
	$(RM) TMPPIPE1

modules.c : modules.d comment5 ansidecl
	$(COMMENT5) modules.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > modules.c
	$(RM) TMPPIPE1

noreadline.c : noreadline.d comment5 ansidecl
	$(COMMENT5) noreadline.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > noreadline.c
	$(RM) TMPPIPE1

main.c : main.d comment5 ansidecl
	$(COMMENT5) main.d > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > main.c
	$(RM) TMPPIPE1

ariarm.c : ariarm.d comment5  
	$(COMMENT5) ariarm.d > ariarm.c

ariarm.s : ariarm.c
	$(CPP) ariarm.c | grep -v '^#' | sed 's,% ,%,g' > ariarm.s

allo : allc spvw.o spvwtabf.o spvwtabs.o spvwtabo.o eval.o control.o pathname.o stream.o io.o array.o hashtabl.o list.o package.o record.o sequence.o charstrg.o debug.o error.o misc.o predtype.o symbol.o lisparit.o unixaux.o acornaux.o
	$(TOUCH) allo

alls : allc spvw.s spvwtabf.s spvwtabs.s spvwtabo.s eval.s control.s pathname.s stream.s io.s array.s hashtabl.s list.s package.s record.s sequence.s charstrg.s debug.s error.s misc.s predtype.s symbol.s lisparit.s unixaux.s acornaux.s
	$(TOUCH) alls

spvw.i : spvw.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c avl.c sort.c arilev0.c aridecl.c version.h
	$(CPP) $(CFLAGS) spvw.c > spvw.i

spvw.s : spvw.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c avl.c sort.c arilev0.c aridecl.c version.h
	$(CC) $(CFLAGS) -S spvw.c

spvw.o : spvw.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c avl.c sort.c arilev0.c aridecl.c version.h
	$(CC) $(CFLAGS) -c spvw.c

spvwtabf.i : spvwtabf.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) spvwtabf.c > spvwtabf.i

spvwtabf.s : spvwtabf.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S spvwtabf.c

spvwtabf.o : spvwtabf.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c spvwtabf.c

spvwtabs.i : spvwtabs.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) spvwtabs.c > spvwtabs.i

spvwtabs.s : spvwtabs.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S spvwtabs.c

spvwtabs.o : spvwtabs.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c spvwtabs.c

spvwtabo.i : spvwtabo.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) spvwtabo.c > spvwtabo.i

spvwtabo.s : spvwtabo.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S spvwtabo.c

spvwtabo.o : spvwtabo.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c spvwtabo.c

eval.i : eval.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) eval.c > eval.i

eval.s : eval.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S eval.c

eval.o : eval.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c eval.c

control.i : control.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) control.c > control.i

control.s : control.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S control.c

control.o : control.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c control.c

pathname.i : pathname.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) pathname.c > pathname.i

pathname.s : pathname.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S pathname.c

pathname.o : pathname.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c pathname.c

stream.i : stream.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CPP) $(CFLAGS) stream.c > stream.i

stream.s : stream.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -S stream.c

stream.o : stream.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -c stream.c

io.i : io.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CPP) $(CFLAGS) io.c > io.i

io.s : io.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -S io.c

io.o : io.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -c io.c

array.i : array.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CPP) $(CFLAGS) array.c > array.i

array.s : array.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -S array.c

array.o : array.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -c array.c

hashtabl.i : hashtabl.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c aridecl.c
	$(CPP) $(CFLAGS) hashtabl.c > hashtabl.i

hashtabl.s : hashtabl.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c aridecl.c
	$(CC) $(CFLAGS) -S hashtabl.c

hashtabl.o : hashtabl.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c aridecl.c
	$(CC) $(CFLAGS) -c hashtabl.c

list.i : list.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) list.c > list.i

list.s : list.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S list.c

list.o : list.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c list.c

package.i : package.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c arilev0.c
	$(CPP) $(CFLAGS) package.c > package.i

package.s : package.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c arilev0.c
	$(CC) $(CFLAGS) -S package.c

package.o : package.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c constpack.c arilev0.c
	$(CC) $(CFLAGS) -c package.c

record.i : record.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) record.c > record.i

record.s : record.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S record.c

record.o : record.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c record.c

sequence.i : sequence.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) sequence.c > sequence.i

sequence.s : sequence.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S sequence.c

sequence.o : sequence.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c sequence.c

charstrg.i : charstrg.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) charstrg.c > charstrg.i

charstrg.s : charstrg.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S charstrg.c

charstrg.o : charstrg.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c charstrg.c

debug.i : debug.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) debug.c > debug.i

debug.s : debug.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S debug.c

debug.o : debug.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c debug.c

error.i : error.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) error.c > error.i

error.s : error.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S error.c

error.o : error.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c error.c

misc.i : misc.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CPP) $(CFLAGS) misc.c > misc.i

misc.s : misc.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -S misc.c

misc.o : misc.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c arilev0.c
	$(CC) $(CFLAGS) -c misc.c

predtype.i : predtype.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) predtype.c > predtype.i

predtype.s : predtype.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S predtype.c

predtype.o : predtype.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c predtype.c

symbol.i : symbol.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) symbol.c > symbol.i

symbol.s : symbol.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S symbol.c

symbol.o : symbol.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c symbol.c

lisparit.i : lisparit.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c aridecl.c arilev0.c arilev1.c intelem.c intlog.c intplus.c intcomp.c intbyte.c intmal.c intdiv.c intgcd.c int2adic.c intsqrt.c intprint.c intread.c rational.c sfloat.c ffloat.c dfloat.c lfloat.c flo_konv.c flo_rest.c realelem.c realrand.c realtran.c compelem.c comptran.c arilev1c.c arilev1e.c arilev1i.c ariarm.c
	$(CPP) $(CFLAGS) lisparit.c > lisparit.i

lisparit.s : lisparit.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c aridecl.c arilev0.c arilev1.c intelem.c intlog.c intplus.c intcomp.c intbyte.c intmal.c intdiv.c intgcd.c int2adic.c intsqrt.c intprint.c intread.c rational.c sfloat.c ffloat.c dfloat.c lfloat.c flo_konv.c flo_rest.c realelem.c realrand.c realtran.c compelem.c comptran.c arilev1c.c arilev1e.c arilev1i.c ariarm.c
	$(CC) $(CFLAGS) -S lisparit.c

lisparit.o : lisparit.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c aridecl.c arilev0.c arilev1.c intelem.c intlog.c intplus.c intcomp.c intbyte.c intmal.c intdiv.c intgcd.c int2adic.c intsqrt.c intprint.c intread.c rational.c sfloat.c ffloat.c dfloat.c lfloat.c flo_konv.c flo_rest.c realelem.c realrand.c realtran.c compelem.c comptran.c arilev1c.c arilev1e.c arilev1i.c ariarm.c
	$(CC) $(CFLAGS) -c lisparit.c

unixaux.i : unixaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) unixaux.c > unixaux.i

unixaux.s : unixaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S unixaux.c

unixaux.o : unixaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c unixaux.c

acornaux.i : acornaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) acornaux.c > acornaux.i

acornaux.s : acornaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S acornaux.c

acornaux.o : acornaux.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c acornaux.c

genclisph.i : genclisph.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) genclisph.c > genclisph.i

genclisph.s : genclisph.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S genclisph.c

genclisph.o : genclisph.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c genclisph.c

modules.i : modules.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c modules.h
	$(CPP) $(CFLAGS) -DNO_CLISP_H modules.c > modules.i

modules.s : modules.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c modules.h
	$(CC) $(CFLAGS) -DNO_CLISP_H -S modules.c

modules.o : modules.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c modules.h
	$(CC) $(CFLAGS) -DNO_CLISP_H -c modules.c

noreadline.i : noreadline.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) noreadline.c > noreadline.i

noreadline.s : noreadline.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S noreadline.c

noreadline.o : noreadline.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c noreadline.c

main.i : main.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CPP) $(CFLAGS) main.c > main.i

main.s : main.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -S main.c

main.o : main.c lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c
	$(CC) $(CFLAGS) -c main.c

ariarm.o : ariarm.s
	$(CC) $(CFLAGS) -c ariarm.s

lisp : $(OBJECTS) modules.o   
	$(CC) $(CFLAGS) $(CLFLAGS) $(OBJECTS) modules.o $(LIBS) $(X_LIBS) -o lisp


alllsp : $(LSPFILES)
	$(TOUCH) alllsp

config.lsp : .lsp
	$(CP) .lsp config.lsp

interpreted.mem : lisp $(LSPFILES)
	/lisp -m 750KW -x "(load \"init.lsp\") (sys::%saveinitmem) (exit)"
	$(MV) lispinit.mem interpreted.mem

init.fas : init.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c init.lsp

defseq.fas : defseq.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defseq.lsp

backquot.fas : backquot.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c backquot.lsp

defmacro.fas : defmacro.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defmacro.lsp

macros1.fas : macros1.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c macros1.lsp

macros2.fas : macros2.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c macros2.lsp

defs1.fas : defs1.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defs1.lsp

timezone.fas : timezone.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c timezone.lsp

places.fas : places.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c places.lsp

floatpri.fas : floatpri.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c floatpri.lsp

type.fas : type.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c type.lsp

defstruc.fas : defstruc.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defstruc.lsp

format.fas : format.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c format.lsp

user1.fas : user1.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c user1.lsp

user2.fas : user2.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c user2.lsp

trace.fas : trace.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c trace.lsp

macros3.fas : macros3.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c macros3.lsp

config.fas : config.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c config.lsp

compiler.fas : compiler.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c compiler.lsp

defs2.fas : defs2.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defs2.lsp

loop.fas : loop.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c loop.lsp

clos.fas : clos.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c clos.lsp

conditio.fas : conditio.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c conditio.lsp

defs3.fas : defs3.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c defs3.lsp

gstream.fas : gstream.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c gstream.lsp

foreign.fas : foreign.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c foreign.lsp

screen.fas : screen.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c screen.lsp

stdwin1.fas : stdwin1.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c stdwin1.lsp

stdwin2.fas : stdwin2.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c stdwin2.lsp

rexx.fas : rexx.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c rexx.lsp

editor.fas : editor.lsp lisp interpreted.mem
	/lisp -m 750KW -M interpreted.mem -q -c editor.lsp

halfcompiled.mem : lisp $(LSPFILES) compiler.fas
	-$(RM) interpreted.mem
	/lisp -m 750KW -x "(load \"init.lsp\") (sys::%saveinitmem) (exit)"
	$(MV) lispinit.mem interpreted.mem
	$(TOUCH) compiler.fas
	echo > halfcompiled.mem

compiled.mem : lisp $(FASFILES)
	/lisp -x "(load \"init.fas\") (sys::%saveinitmem) (exit)"
	$(MV) lispinit.mem compiled.mem


# Perform self-tests.
check : test
	$(TOUCH) check

# Test: recompile $(LSPFILES) and check if the resulting .mem file has the same length.
test : compiled.mem stage $(TESTLSPFILES) $(TESTFASFILES)
	echo "Compare the .fas files by hand."

stage :
	-mkdir stage

stage.init.lsp : init.lsp
	$(LN) init.lsp stage

stage.defseq.lsp : defseq.lsp
	$(LN) defseq.lsp stage

stage.backquot.lsp : backquot.lsp
	$(LN) backquot.lsp stage

stage.defmacro.lsp : defmacro.lsp
	$(LN) defmacro.lsp stage

stage.macros1.lsp : macros1.lsp
	$(LN) macros1.lsp stage

stage.macros2.lsp : macros2.lsp
	$(LN) macros2.lsp stage

stage.defs1.lsp : defs1.lsp
	$(LN) defs1.lsp stage

stage.timezone.lsp : timezone.lsp
	$(LN) timezone.lsp stage

stage.places.lsp : places.lsp
	$(LN) places.lsp stage

stage.floatpri.lsp : floatpri.lsp
	$(LN) floatpri.lsp stage

stage.type.lsp : type.lsp
	$(LN) type.lsp stage

stage.defstruc.lsp : defstruc.lsp
	$(LN) defstruc.lsp stage

stage.format.lsp : format.lsp
	$(LN) format.lsp stage

stage.user1.lsp : user1.lsp
	$(LN) user1.lsp stage

stage.user2.lsp : user2.lsp
	$(LN) user2.lsp stage

stage.trace.lsp : trace.lsp
	$(LN) trace.lsp stage

stage.macros3.lsp : macros3.lsp
	$(LN) macros3.lsp stage

stage.config.lsp : config.lsp
	$(LN) config.lsp stage

stage.compiler.lsp : compiler.lsp
	$(LN) compiler.lsp stage

stage.defs2.lsp : defs2.lsp
	$(LN) defs2.lsp stage

stage.loop.lsp : loop.lsp
	$(LN) loop.lsp stage

stage.clos.lsp : clos.lsp
	$(LN) clos.lsp stage

stage.conditio.lsp : conditio.lsp
	$(LN) conditio.lsp stage

stage.defs3.lsp : defs3.lsp
	$(LN) defs3.lsp stage

stage.gstream.lsp : gstream.lsp
	$(LN) gstream.lsp stage

stage.foreign.lsp : foreign.lsp
	$(LN) foreign.lsp stage

stage.screen.lsp : screen.lsp
	$(LN) screen.lsp stage

stage.stdwin1.lsp : stdwin1.lsp
	$(LN) stdwin1.lsp stage

stage.stdwin2.lsp : stdwin2.lsp
	$(LN) stdwin2.lsp stage

stage.rexx.lsp : rexx.lsp
	$(LN) rexx.lsp stage

stage.editor.lsp : editor.lsp
	$(LN) editor.lsp stage

stage.init.fas : stage.init.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.init.lsp

stage.defseq.fas : stage.defseq.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defseq.lsp

stage.backquot.fas : stage.backquot.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.backquot.lsp

stage.defmacro.fas : stage.defmacro.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defmacro.lsp

stage.macros1.fas : stage.macros1.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.macros1.lsp

stage.macros2.fas : stage.macros2.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.macros2.lsp

stage.defs1.fas : stage.defs1.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defs1.lsp

stage.timezone.fas : stage.timezone.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.timezone.lsp

stage.places.fas : stage.places.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.places.lsp

stage.floatpri.fas : stage.floatpri.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.floatpri.lsp

stage.type.fas : stage.type.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.type.lsp

stage.defstruc.fas : stage.defstruc.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defstruc.lsp

stage.format.fas : stage.format.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.format.lsp

stage.user1.fas : stage.user1.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.user1.lsp

stage.user2.fas : stage.user2.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.user2.lsp

stage.trace.fas : stage.trace.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.trace.lsp

stage.macros3.fas : stage.macros3.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.macros3.lsp

stage.config.fas : stage.config.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.config.lsp

stage.compiler.fas : stage.compiler.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.compiler.lsp

stage.defs2.fas : stage.defs2.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defs2.lsp

stage.loop.fas : stage.loop.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.loop.lsp

stage.clos.fas : stage.clos.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.clos.lsp

stage.conditio.fas : stage.conditio.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.conditio.lsp

stage.defs3.fas : stage.defs3.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.defs3.lsp

stage.gstream.fas : stage.gstream.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.gstream.lsp

stage.foreign.fas : stage.foreign.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.foreign.lsp

stage.screen.fas : stage.screen.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.screen.lsp

stage.stdwin1.fas : stage.stdwin1.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.stdwin1.lsp

stage.stdwin2.fas : stage.stdwin2.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.stdwin2.lsp

stage.rexx.fas : stage.rexx.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.rexx.lsp

stage.editor.fas : stage.editor.lsp lisp compiled.mem
	/lisp -M compiled.mem -q -c stage.editor.lsp

compiled2.mem : lisp $(TESTFASFILES)
	/lisp -x "(cd \"stage.\") (load \"init.fas\") (cd \"^.\") (sys::%saveinitmem) (exit)"
	-$(RM) compiled2.mem
	$(MV) lispinit.mem compiled2.mem


manual : ANNOUNCE COPYRIGHT GNU-GPL SUMMARY NEWS README clisp.1 clisp.html impnotes.txt $(TXTFILES)
	$(TOUCH) manual

manualx : manual clisp.man
	$(TOUCH) manualx

ANNOUNCE : ^.ANNOUNCE
	-$(LN) ^.ANNOUNCE ANNOUNCE

COPYRIGHT : ^.COPYRIGHT
	-$(LN) ^.COPYRIGHT COPYRIGHT

GNU-GPL : ^.GNU-GPL
	-$(LN) ^.GNU-GPL GNU-GPL

SUMMARY : ^.SUMMARY
	-$(LN) ^.SUMMARY SUMMARY

README : _README lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c txt2c 
	$(TXT2C) < _README > txt.c
	$(CC) $(CFLAGS) txt.c -o txt
	/txt > README
	$(RM) txt.c
	$(RM) txt

clisp.1 : _clisp.1 lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c txt2c 
	$(TXT2C) < _clisp.1 > txt.c
	$(CC) $(CFLAGS) txt.c -o txt
	/txt | grep -v '^ *$$' > clisp.1
	$(RM) txt.c
	$(RM) txt

clisp.html : _clisp.html lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c txt2c 
	$(TXT2C) < _clisp.html > txt.c
	$(CC) $(CFLAGS) txt.c -o txt
	/txt > clisp.html
	$(RM) txt.c
	$(RM) txt

impnotes.txt : _impnotes.txt lispbibl.c fsubr.c subr.c pseudofun.c constsym.c constobj.c acorn.c txt2c 
	$(TXT2C) < _impnotes.txt > txt.c
	$(CC) $(CFLAGS) txt.c -o txt
	/txt > impnotes.txt
	$(RM) txt.c
	$(RM) txt

clisp.man : clisp.1
	$(ROFF_MAN) clisp.1 > clisp.man

clisp.dvi : clisp.1
	$(ROFF_DVI) clisp.1 > clisp.dvi

LISP-tutorial.txt : ^.doc.LISP-tutorial.txt
	-$(LN) ^.doc.LISP-tutorial.txt LISP-tutorial.txt

CLOS-guide.txt : ^.doc.CLOS-guide.txt
	-$(LN) ^.doc.CLOS-guide.txt CLOS-guide.txt

cltl2.txt : ^.doc.cltl2.txt
	-$(LN) ^.doc.cltl2.txt cltl2.txt


# clean0 is harmless: removes only superfluous things: temporary files.
clean0 : force
	-$(RM) core ansidecl.c genclisph clisp1.h clisp2.h clisp3.h txt.c txt

# clean1 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format and the tables in
# constobj.d, constpack.d, constsym.d, subr.d, fsubr.d, pseudofun.d.
clean1 : clean0
	-$(RM) lispbibl.h clisp.h *.i *.s *.o *.a lisp stage.* suite.*
	-rmdir stage
	-rmdir suite
	-$(RM) README clisp.1 clisp.html impnotes.txt $(TXTFILES) clreadline.3 readline.dvi

# clean2 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format.
clean2 : clean1
	-$(RM) interpreted.mem halfcompiled.mem compiled.mem compiled2.mem

# clean3 removes everything that becomes obsolete once lisp is recompiled.
# It leaves everything generated by "make allc".
clean3 : clean2
	-$(RM) $(FASFILES) *.lib

# clean4 removes everything that becomes obsolete
# when switching to a new version of the C compiler.
# It leaves everything generated by "make init".
clean4 : clean3
	-$(RM) $(CFILES)

# clean5 even undoes "make init".
clean5 : clean4
	-$(RM) config.lsp
	-$(RM) comment5 ansidecl ccpaux deelif deerror dedefined traddecl deema mergestrings txt2c

# clean6 lets us go back to "makemake > makefile".
clean6 : clean5
	-$(RM) makefile

# clean7 lets us go back to the main "configure".
clean7 : clean6
	-$(RM) config.status config.log config.cache machine.h unixconf.h makemake
	-$(RM) readline.tar.Z

# clean8 moreover cleans up the SRCDIR.
clean8 : clean7
	-$(RM) lisparit0.d

# The normal "start over" command:
mostlyclean : clean4

# Clear all files that are built by "make ...":
clean : clean5

# Make "clear for distribution":
distclean : clean7

# Remove everything that can be generated otherwise:
realclean : clean8


force:
	$(TOUCH) force

