------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             E X P _ D I S T                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains utility routines used for the generation of the
--  stubs relevant to the distribution annex.

with Types; use Types;

package Exp_Dist is


   procedure Add_Racw_Receivers (RCI_Spec : Node_Id; Last_Racw_Num : Int);
   --  Add a dispathing receiver declaration for each racw type appearing in
   --  the visible declarations of a RCI package spec. Last_Racw_Num is the
   --  number of the last racw type declaration found.

   procedure Add_Racw_RW (N : Node_Id);
   --  Add procedures and representation clauses to override read and write
   --  attribute for the RACW type whose declaration node is N.

   function Is_ACWLP_Type (E : Entity_Id) return Boolean;
   --  Returns true if the entity is an access class-wide limited private type.

   function Is_RCI_Pkg_Spec_Or_Body (Cunit : Node_Id) return Boolean;
   --  Determines if a compilation unit is the specification or the
   --  body of a remote call interface package.

   procedure Generate_Stubs_Files (N : Node_Id);
   --  Create the stubs files for a remote call interface package specification
   --  or body. If the corresponding unit is a package declaration requiring
   --  a body, then only the client stubs package body and the server stubs
   --  package specification are generated. If it is a package body or a
   --  package declaration which  does not require a body, the server stubs
   --  package body is also generated.

   procedure To_Calling_Stubs_Decls_Cunit (RCI_Decl_Cunit : Node_Id);
   --  Convert a RCI package spec compilation unit node into the corresponding
   --  calling stubs package spec compilation unit node.

   procedure To_Receiving_Stubs_Decls_Cunit (RCI_Decl_Cunit : Node_Id);
   --  Convert a RCI package Spec compilation unit into the corresponding
   --  receiving stubs package spec compilation unit node.

end Exp_Dist;
