------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--              A D A . T E X T _ I O . D E C I M A L _ A U X               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines for Ada.Text_IO.Decimal_IO that are
--  shared among separate instantiations of this package. The routines in
--  the package are identical semantically to those declared in Text_IO,
--  except that default values have been supplied by the generic, and the
--  Num parameter has been replaced by Integer or Long_Long_Integer, with
--  an additional Scale parameter giving the value of Num'Scale. In addition
--  the Get routines return the value rather than store it in an Out parameter.

private package Ada.Text_IO.Decimal_Aux is

   function Get_Dec
     (File  : in File_Type;
      Width : in Field;
      Scale : Integer)
      return  Integer;

   function Get_LLD
     (File  : in File_Type;
      Width : in Field;
      Scale : Integer)
      return  Long_Long_Integer;

   procedure Put_Dec
     (File  : File_Type;
      Item  : Integer;
      Fore : in Field;
      Aft  : in Field;
      Exp  : in Field;
      Scale : Integer);

   procedure Put_LLD
     (File  : in File_Type;
      Item  : in Long_Long_Integer;
      Fore : in Field;
      Aft  : in Field;
      Exp  : in Field;
      Scale : Integer);

   function Gets_Dec
     (From  : in String;
      Last  : access Positive;
      Scale : Integer)
      return  Integer;

   function Gets_LLD
     (From  : in String;
      Last  : access Positive;
      Scale : Integer)
      return  Long_Long_Integer;

   procedure Puts_Dec
     (To    : out String;
      Item  : in Integer;
      Aft   : in Field;
      Exp   : in Field;
      Scale : Integer);

   procedure Puts_LLD
     (To    : out String;
      Item  : in Long_Long_Integer;
      Aft   : in Field;
      Exp   : in Field;
      Scale : Integer);

end Ada.Text_IO.Decimal_Aux;
