/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - S N A M E S                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.27 $                             */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C file that corresponds to the Ada package specification
   Snames. It was created manually from the file snames.ads.

/* Name_Id values */

#define Name_uParent (First_Name_Id + 256 +  12)
#define Name_uTag    (First_Name_Id + 256 +  16)
#define Name_Off     (First_Name_Id + 256 + 152)
#define Name_Space   (First_Name_Id + 256 + 154)
#define Name_Time    (First_Name_Id + 256 + 155)

/* Define the function to return one of the numeric values below.  Note
   that it actually returns a char since an enumeration value of less
   than 256 entries is represented that way in Ada.  The operand is a Chars
   field value.  */

#define Get_Attribute_Id snames__get_attribute_id
extern char Get_Attribute_Id PROTO ((int));

/* Define the numeric values for the attributes.  */

#define  Attr_Abort_Signal                   0
#define  Attr_Access                         1
#define  Attr_Address                        2
#define  Attr_Address_Size                   3
#define  Attr_Adjacent                       4
#define  Attr_Aft                            5
#define  Attr_Alignment                      6
#define  Attr_Bit_Order                      7
#define  Attr_Body_Version                   8
#define  Attr_Callable                       9
#define  Attr_Caller                        10
#define  Attr_Ceiling                       11
#define  Attr_Component_Size                12
#define  Attr_Compose                       13
#define  Attr_Constrained                   14
#define  Attr_Copy_Sign                     15
#define  Attr_Count                         16
#define  Attr_Default_Bit_Order             17
#define  Attr_Definite                      18
#define  Attr_Delta                         19
#define  Attr_Denorm                        20
#define  Attr_Digits                        21
#define  Attr_Emax                          22
#define  Attr_Enum_Rep                      23
#define  Attr_Epsilon                       24
#define  Attr_Exponent                      25
#define  Attr_External_Tag                  26
#define  Attr_First                         27
#define  Attr_First_Bit                     28
#define  Attr_Fixed_Value                   29
#define  Attr_Floor                         30
#define  Attr_Fore                          31
#define  Attr_Fraction                      32
#define  Attr_Identity                      33
#define  Attr_Image                         34
#define  Attr_Img                           35
#define  Attr_Input                         36
#define  Attr_Integer_Value                 37
#define  Attr_Large                         38
#define  Attr_Last                          39
#define  Attr_Last_Bit                      40
#define  Attr_Leading_Part                  41
#define  Attr_Length                        42
#define  Attr_Machine                       43
#define  Attr_Machine_Emax                  44
#define  Attr_Machine_Emin                  45
#define  Attr_Machine_Mantissa              46
#define  Attr_Machine_Overflows             47
#define  Attr_Machine_Radix                 48
#define  Attr_Machine_Rounds                49
#define  Attr_Mantissa                      50
#define  Attr_Max                           51
#define  Attr_Max_Interrupt_Priority        52
#define  Attr_Max_Priority                  53
#define  Attr_Max_Size_In_Storage_Elements  54
#define  Attr_Maximum_Alignment             55
#define  Attr_Min                           56
#define  Attr_Model                         57
#define  Attr_Model_Emin                    58
#define  Attr_Model_Epsilon                 59
#define  Attr_Model_Mantissa                60
#define  Attr_Model_Small                   61
#define  Attr_Modulus                       62
#define  Attr_Output                        63
#define  Attr_Partition_Id                  64
#define  Attr_Passed_By_Reference           65
#define  Attr_Pos                           66
#define  Attr_Position                      67
#define  Attr_Pred                          68
#define  Attr_Range                         69
#define  Attr_Range_Length                  70
#define  Attr_Read                          71
#define  Attr_Remainder                     72
#define  Attr_Round                         73
#define  Attr_Rounding                      74
#define  Attr_Safe_Emax                     75
#define  Attr_Safe_First                    76
#define  Attr_Safe_Large                    77
#define  Attr_Safe_Last                     78
#define  Attr_Safe_Small                    79
#define  Attr_Scale                         80
#define  Attr_Scaling                       81
#define  Attr_Signed_Zeros                  82
#define  Attr_Size                          83
#define  Attr_Small                         84
#define  Attr_Storage_Size                  85
#define  Attr_Storage_Unit                  86
#define  Attr_Succ                          87
#define  Attr_Tag                           88
#define  Attr_Terminated                    89
#define  Attr_Tick                          90
#define  Attr_Truncation                    91
#define  Attr_Unbiased_Rounding             92
#define  Attr_Unchecked_Access              93
#define  Attr_Universal_Literal_String      94
#define  Attr_Unrestricted_Access           95
#define  Attr_Val                           96
#define  Attr_Valid                         97
#define  Attr_Value                         98
#define  Attr_Version                       99
#define  Attr_Wide_Image                   100
#define  Attr_Wide_Value                   101
#define  Attr_Wide_Width                   102
#define  Attr_Width                        103
#define  Attr_Word_Size                    104
#define  Attr_Write                        105

#define  Attr_Elab_Body                    106
#define  Attr_Elab_Spec                    107
#define  Attr_Storage_Pool                 108

#define  Attr_Base                         109
#define  Attr_Class                        110

/* Define the function to return one of the numeric values below.  Note
   that it actually returns a char since an enumeration value of less
   than 256 entries is represented that way in Ada.  The operand is a Chars
   field value.  */

#define Get_Pragma_Id snames__get_pragma_id
extern char Get_Pragma_Id PROTO ((int));

/* Define the numeric values for the pragmas.  */

#define  Pragma_Abort_Defer                  0
#define  Pragma_Ada_83                       1
#define  Pragma_Ada_95                       2
#define  Pragma_All_Calls_Remote             3
#define  Pragma_Annotate                     4
#define  Pragma_Assert                       5
#define  Pragma_Asynchronous                 6
#define  Pragma_Atomic                       7
#define  Pragma_Atomic_Components            8
#define  Pragma_Attach_Handler               9
#define  Pragma_Controlled                  10
#define  Pragma_Convention                  11
#define  Pragma_CPP_Class                   12
#define  Pragma_CPP_Constructor             13
#define  Pragma_CPP_Destructor              14
#define  Pragma_CPP_Virtual                 15
#define  Pragma_CPP_Vtable                  16
#define  Pragma_Debug                       17
#define  Pragma_Discard_Names               18
#define  Pragma_Elaborate                   19
#define  Pragma_Elaborate_All               20
#define  Pragma_Elaborate_Body              21
#define  Pragma_Error_Monitoring            22
#define  Pragma_Export                      23
#define  Pragma_Import                      24
#define  Pragma_Inline                      25
#define  Pragma_Inspection_Point            26
#define  Pragma_Interface                   27
#define  Pragma_Interface_Name              28
#define  Pragma_Interrupt_Handler           29
#define  Pragma_Interrupt_Priority          30
#define  Pragma_Linker_Options              31
#define  Pragma_List                        32
#define  Pragma_Locking_Policy              33
#define  Pragma_Machine_Attribute           34
#define  Pragma_Memory_Size                 35
#define  Pragma_Normalize_Scalars           36
#define  Pragma_Optimize                    37
#define  Pragma_Pack                        38
#define  Pragma_Page                        39
#define  Pragma_Preelaborate                40
#define  Pragma_Priority                    41
#define  Pragma_Pure                        42
#define  Pragma_Queuing_Policy              43
#define  Pragma_Remote_Call_Interface       44
#define  Pragma_Remote_Types                45
#define  Pragma_Restrictions                46
#define  Pragma_Reviewable                  47
#define  Pragma_Shared                      48
#define  Pragma_Shared_Passive              49
#define  Pragma_Source_Reference            50
#define  Pragma_Suppress                    51
#define  Pragma_System_Name                 52
#define  Pragma_Task_Dispatching_Policy     53
#define  Pragma_Unimplemented_Unit          54
#define  Pragma_Unsuppress                  55
#define  Pragma_Volatile                    56
#define  Pragma_Volatile_Components         57
#define  Pragma_Storage_Size                58
#define  Pragma_Storage_Unit                59

/* Define the numeric values for the conventions.  */

#define  Convention_Ada                      0
#define  Convention_Intrinsic                1
#define  Convention_Entry                    2
#define  Convention_Protected                3
#define  Convention_Assembler                4
#define  Convention_C                        5
#define  Convention_COBOL                    6
#define  Convention_CPP                      7
#define  Convention_Fortran                  8
#define  Convention_Stdcall                  9

/* End of a-snames.h (C version of Snames package spec) */
