/* Prototypes for the profile management functions */

short GetPrivateProfileString (char * AppName, char * KeyName,
			       char * Default, char * ReturnedString,
			       short Size, char * FileName);

int GetProfileString (char * AppName, char * KeyName, char * Default, 
		      char * ReturnedString, int Size);

int GetPrivateProfileInt (char * AppName, char * KeyName, short Default,
			   char * File);

int GetProfileInt (char * AppName, char * KeyName, int Default);

int WritePrivateProfileString (char * AppName, char * KeyName, char * String,
				char * FileName);

int WriteProfileString (char * AppName, char * KeyName, char * String);

void sync_profiles (void);

void free_profiles (void);
char *get_profile_string (char *AppName, char *KeyName, char *Default,
			  char *FileName);

/* New profile functions */

/* Returns a pointer for iterating on appname section, on profile file */
void *profile_init_iterator (char *appname, char *file);

/* Returns both the key and the value of the current section. */
/* You pass the current iterating pointer and it returns the new pointer */
void *profile_iterator_next (void *s, char **key, char **value);

/* Removes all the definitions from section appname on file */
void profile_clean_section (char *appname, char *file);
