;   >>> this is file LOADLIN.ASM
;============================================================================
;   LOADLIN v1.5 (C) 1994 Hans Lermen (lermen@elserv.ffm.fgan.de)
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;----------------------------------------------------------------------------
;   Comments and bug reports are welcome and may be sent to:
;   E-Mail:    lermen@elserv.ffm.fgan.de
;   SnailMail: Hans Lermen
;              Am Muehlenweg 38
;              D53424 REMAGEN-Unkelbach
;              GERMANY
;
;============================================================================
;
; NOTE:
;
;   This program could not have been written as quickly without
;   the information found in the source code of F.Coutant's BOOTLIN
;
;   This program contains some modified source code from
;   my protected mode extender (LDOSX (C) 1991..1994 H.Lermen),
;   which was written as a fast multitasking alternative
;   to DJ.Delorie's extender (it runs DJ-GCC compiled binaries under DOS).
;
;   I was too lazy to reprogram the subroutines completely, so,
;   if You wonder what nonsense they are doing, keep in mind that they
;   were written for an other purpose.
;
;============================================================================
;
; Contributions and bug fixes for 1.5:
;
;
;   Javier Achirica <javier@autom.uva.es>
;
;       invented the switch-out-of-setup method (Javier's method),
;       which makes the BIOSINTV and REALBIOS method superfluous on nearly
;       all machines. The trick is: let setup run in V86 and intercept
;       just before going to protected mode.
;       (Thank you Javier for this very good work).
;
;============================================================================

              name    load_linux
              .386
              locals
              jumps

REALBIOS_FILE equ 'C:\REALBIOS.INT'

SIGNATURE                = 'SrdH' ; "HdrS"

space4k                  =     1000h
space2k                  =      800h
space1k                  =      400h

our_stacksize            =     space2k

kernel_start_ equ     01000h     ; here the kernel must go
kernel_end    equ     09000h
standard_setup_sects  equ 4      ; number of setup sectors, older kernels
maximum_setup_sects   equ (32-1) ; max number of setup sectors for newer kernels
High_Seg      equ     kernel_end ; here first 512 + 4*512 + n*512 bytes of image must go
High_Addr     equ     (High_Seg*16)

setup_intercept_int equ   7fh


debug_stop macro marker
           mov   ax,0b800h
           mov   ds,ax
           mov   byte ptr ds:[1],70h
           mov   byte ptr ds:[0],marker
           jmp   short $
           endm

align_  macro   start,val
        org     (((($-start)+(val-1))/val)*val)
        endm


psp_seg segment  at 0 use16

; -------------PSP Program Segment Prefix----------------------
        org      2h
  PSP_memend_frame            dw ?
        org      2ch
  PSP_envir_frame             dw ?
        org      80h
  PSP_DTA                     db ? (100h-80h) dup(?)
; -------------------------------------------------------------
psp_seg ends

code    segment  para use16
        assume   cs:code,ds:psp_seg,es:code
code_org0     label   byte

; ---------------------------------------------------------------------
;                        Bootsector (512 bytes)
;                        within this BEFORE start of setup:
;                        (may be set by "LOADLIN")
bootsec       label   byte
              org     20h
CL_MAGIC      dw      ?  ;0020   commandline magic number (=0xA33F)
CL_OFFSET     dw      ?  ;0022   commandline offset
                         ; Address of commandline is calculated:
                         ;   0x90000 + contents of CL_OFFSET
                         ; The command line is parsed by "init/main.c"
                         ; Value of NAME=XXXX are put into the environement
                         ; and can then be interpreted by the drivers
                         ; and /etc/rc. The variabel "root=xxxx" is
                         ; interpreted by main directly, "single" is
                         ; interpreted by init or simpleinit.
              org     1F1h
setup_sects   db      ?  ; no. of sectors
ro_flag       dw      ?  ; =0: root file system should be mounted read-write
                         ;<>0: root file system should be mounted readonly
                         ; (this will be overwritten by the kernel commandline
                         ;  options "ro" / "rw")
;             --------------------------------
;                        within this AFTER setup has run:
              org     0
curr_curs     dw      ?  ;0000 saved cursor position
ext_mem_size  dw      ?  ;0002     extended memory size in Kb (from int 0x15)
              org     80h
hd0_disk_par  label   byte ;080     hd0-disk-parameter from intvector 0x41
hd1_disk_par  label   byte ;090     hd1-disk-parameter from intvector 0x46

;             --------------------------------
;                        within this as loaded from "zImage"
              org     01F4h
kernel_size   dw      ?  ; size of kernel-part in the image-file
                         ; (in 16 byte units, rounded up)
swap_dev      dw      ?  ; swap device

ram_disk      dw      ?  ;01F8 size of ram-disk (in 1Kb units ) or ZERO
                         ; if ram_disk is nonZERO then the kernel
                         ; (driver/block/ramdisk.c: rd_load() )
                         ; will try to load the contents for the ram-disk
                         ; from the "root_dev" which MUST then have the
                         ; floppyMAJOR.
                         ; The file-system on that floppy must be MINIX
                         ; If rd_load() succeeds it sets the root_dev
                         ; to the ramdisk for mounting it.
                         ;
                         ; LOADLIN parses the commandline for the string
                         ; "ramdisk=nnn" where nnn is the value for "ram_disk"
                         ; after the kernel images has been loaded by LOADLIN
                         ; it asks for inserting the floppy.
                         ; (NOTE: You may have LOADLIN in A: and root_dev in B:
                         ;        or vice versa).

vga_mode      dw      ?  ;01FA VGA-Mode
                         ;      -3 = ask
                         ;      -2 = Extended VGA
                         ;      -1 = Normal VGA
                         ;       0 = as "0" was pressed
                         ;       n = as "n" was pressed
                         ;
                         ; LOADLIN parses the commandline for the string
                         ; "vga=nnn" where nnn is the value for "vga_mode"
                         ; it also excepts:
                         ; "vga=ask","vga=normal",'vga=extended"

root_dev      dw      ?  ;01FC Root Device (high=Major, low=minor)
                         ;(this can be overwritten by the kernel commandline
                         ; option "root=XXXX")
bootmagic     dw      ?  ;01FE Bootsector magic (0AA55h)

; -------------------------------------------------------------------
                         ; this area will be used to pass params
                         ; from LOADLINX to LOADLIN, if the params file name is @@loadlinx@@ switch
                         ;
                         ; NOTE: @@loadlinx@@ must NOT be used,
                         ;       if starting LOADLIN without LOADLINX
              org     0200h
params_from_loadlinX label byte


; -------------------------------------------------------------------
              org     0200h
setup_prog    label   byte
                                    ; the setup-program itself
                                    ; must be started at 9020h:0 !!!
                                    ;                    =======
              jmp     short start_of_setup
                                    ; the setup header
                                    ; (if you have applied the setup.S patch,
                                    ;  or later, if we have it in the standard kernel)
setup_header_sign     dd    ?
setup_header_version  dw    ?
setup_realmode_switch dd    ?
start_sys_seg         dw    ?
kernel_version        dw    ?
                                    ; end of header
start_of_setup:
              org     setup_prog
              db      maximum_setup_sects*512 dup(?)
; -------------------------------------------------------------
; the following layout is private tp LOADLIN.EXE :

                align_ code_org0,4096
pagedir         dd    2 dup(0)  ; must be aligned to 4 K
                                ; NOTE: we have only 1 (one) pagetable, so we
                                ;       need only 1 pagedir entry
                                ;       All current known CPUs (386,486,PENTIUM)
                                ;       tolerate the garbage behind this,
                                ;       as long as there is no access > 4MB.
                                ;       So we may overlap the pagedir with
                                ;       our code
PSP_frame       dw    0  ; our psp
fhandle         dw    0  ; file handle of imagefile
kernel_start    dw    0  ; place were the kernel must at time of
                         ; start of setup
free_mem_start  dw    0  ; frame of free memory, starting at the begin of LOADLIN.EXE
kernel_load_frame dw  0  ; where to load the image

    ; ----------------------------v
    ; the following values are cleared on each call to "parscommandline"
    ; (see "clear_to_default")
parse_switches  label byte
new_setup_size  dw    0
new_vga_mode    dw    0
new_ram_disk    dw    0
new_root_dev    dw    0
new_ro_flag     dw    0
cl_pointer      dw    0  ; while parsing: aux pointer to command_line
got_vga_mode    db    0
got_ram_disk    db    0
got_root_dev    db    0
got_ro_flag     db    0
option_v        db    0
option_t        db    0
option_t_forced db    0
option_realbios db    0
option_rx       db    0
option_ja       db    0
option_clone    db    0
option_oldxd    db    0
option_n        db    0
option_nodiskprompt db 0
intv_size       dw    0
wrong_realbios  db    0
have_to_force_realmode db 0 ; 0 = is in realmode
                            ; 1 = is in V86, have to reenter realmode before
                            ;     kernel goes to protected mode
                            ;
have_to_intercept_setup db 0; 0 = old method, no interception
                            ; 1 = intercept boot/setup.S (Javier's method)
                            ;     of older kernels just before going to
                            ;     protected mode.
                            ; 2 = same as 1, but intercepting newer kernels
                            ;     with the setup.dif patch applied.
                            ;

debug_file_handle dw    0  ; set to file handle if option -d is set
logo_out        db    0
kernelversion   dd    0     ; binary kernel version, decoded from
                            ; the version string as follows:
                            ; "1.2.3 (root@...) #4" becomes 01020304h
                            ; if string is only 1.2.3  ---> #0 is assumed
parse_switches_end label byte
    ; ----------------------------^

can_exit_to_dos db    0
cannot_load_because_of_windows db 0
print_dots      db    0
cpu_check_status dw   0

;NOTE: all uninitialized data has been moved to end of modul
;      since version 1.4

; -------------------------------------------------------------


  _DEALLOCATE_PAGES          = 45h;
  _GET_VERSION               = 46h;
  _ALLOCATE_RAW_PAGES        = 5A01H
  EMM_int                    = 67h;



  descript    struc
    limit     dw    ?
    base0     dw    ?
    base16    db    ?
    typbyte   db    ?
    limit16   db    ?
    base24    db    ?
  descript    ends


  Gdescript struc
    gateoffs0    dw      ?
    gateselector dw      ?
    gatenotused  db      ?
    gatetyppbyte db      ?
    gateoffs16   dw      ?
  Gdescript ends


  ; definition of COMMON decriptor types (bit0..4 of descript.typbyte )
  ; (bit 4 of descript.typbyte =0)
  data_d        =     10000b    ; data segment descriptor
    writable    =     00010b    ; =1 if write acces allowed to data segment
    expand_down =     00100b    ; =1 limit counts down from base
  code_d        =     11000b    ; code segment
    readable    =     00010b    ; =1 if code also can be read (cannot be ovwritten)
    conforming  =     00100b    ; =1 code can be accesses and executed
                                ;    regardless of it's privilege level

  ; definition of SYSTEM decriptor types  (bit0..4 of descript.typbyte )
  ; (bit 4 of descript.typbyte =0)
  TSS286_avail_d   =  01h
  LDT_d            =  02h
  TSS286_busy_d    =  03h
  call_gate_d      =  04h
  task_gate_d      =  05h
  INT286_gate_d    =  06h
  TRAP286_gate_d   =  07h
  TSS386_avail_d   =  09h
  TSS386_busy_d    =  0bh
  call386_gate_d   =  0ch
  INT386_gate_d    =  0eh
  TRAP386_gate_d   =  0fh

  ; definition of privilege levels (bit5..6 of descript.typbyte )
  p0               =  0      ;
  p1               =  1*32   ; super visor levels
  p2               =  2*32   ;
  puser            =  3*32


  ;definition of granularity ( bits7..8 in descript.limit16 )
  gran_byte        =  0
  gran_page        =  10000000b  ; 4k granularity
  ; for data_selectors:
  data_USE16       =  0
  gran_big         =  01000000b  ; big segment
  data_USE32       =  gran_big   ; use 32-bit stack pointer ESP instead of SP
  ;                Intel says: relevant only together with expand_down  for data_d
  ;                But that is WRONG :
  ;                BIG segment must be set also if the descriptor is greater 64K
  ;                and is used to load SS !
  ;                (because SP cannot access behind 64K)
  ;
  ; for code_selectors:
  code_USE32       =  01000000b  ; default operand size 32 bit (for code segments)
  code_USE16       =  00000000b  ; default operand size 16 bit (for code segments)


  ; segment present bit (bit7 of descript.typbyte )
  is_present       =128
  not_present      =0

  descriptor macro name,typ,plevel,present,limit,gran,base
  name descript <limit and 0ffffh,base and 0ffffh,low (base shr 16),typ or plevel or present,(limit shr 16) or gran,high (base shr 16)>
            endm


  ;GDT Global Descriptor Table -------------------------v
             align_  code_org0,16
  gdtnull    descript  <?>    ;0000   never accessable
  gdtvcpi_code descript <?>   ;0008
  gdtvcpi2   descript  <?>    ;0010
  gdtvcpi3   descript  <?>    ;0018
  descriptor gdt_core,(data_d+writable),p0,is_present,0fffffh,(gran_page+data_USE32),0
  descriptor gdt_code,(code_d+readable),p0,is_present,0ffffh,(gran_byte+code_USE16),High_Addr
  descriptor gdt_data,(data_d+writable),p0,is_present,0ffffh,(gran_byte+data_USE16),High_Addr
  descriptor gdt_ldt,LDT_d,p0,is_present,7,gran_byte,(High_Addr+(ldtnull-code_org0))
  descriptor gdt_tss,TSS286_avail_d,p0,is_present,0ffh,gran_byte,(High_Addr+(our_tss-code_org0))
  gdtlast    descript  <?>    ; dummy for addressing

  g_vcpi_code equ      (gdtvcpi_code-gdtnull)
  g_core     equ       (gdt_core-gdtnull)
  g_code     equ       (gdt_code-gdtnull)
  g_data     equ       (gdt_data-gdtnull)
  g_ldt      equ       (gdt_ldt-gdtnull)
  g_tss      equ       (gdt_tss-gdtnull)
  ;GDT Global Descriptor Table -------------------------^


  ;LDT Local  Descriptor Table -------------------------v
  ldtnull    descript  <?>    ;0000   never accessable
  ldtlast    descript  <?>    ; dummy for addressing
  ;LDT Local  Descriptor Table -------------------------^

  ;                  align_  SYSTEMDATA_,1024
  ;IDT Interrupt Descriptor Table -------------------------v
  idtnull    descript  32 dup (<0>)
  idtlast    descript  <?>    ; dummy for addressing
  ;IDT Interrupt Descriptor Table -------------------------^

  our_tss    dd        128 dup (?)    ; our TSS Task State Segment


  ;params for switching TO protected mode -------------------------v
                          ;NOTE: this Data MUST be in LOW_MEM (below 1 Mbyte),
                          ;      data referenced by this structure
                          ;      CAN be in memory above 1 Mbyte
                          ;      On switching to protected mode the server
                          ;      first loads CR3 (paging base) from "our_CR3".
                          ;
                        ; value of CR3 to be loaded by server
    our_CR3    dd       (High_Addr+(pagedir-code_org0))
                        ; linear address in first Mbyte pointing to
                        ; value of GDTR ("our_GDTR") to be loaded by server
    our_GDTRptr dd      (High_Addr+(our_GDTR-code_org0))
                        ; linear address in first Mbyte pointing to
                        ; value of IDTR ("our_IDTR") to be loaded by server
    our_IDTRptr dd      (High_Addr+(our_IDTR-code_org0))
                        ; value of LDTR to be loaded by server
    our_LDTR   dw       g_ldt
                        ; value of TR to be loaded by server
    our_TR     dw       g_tss
                        ; Fword, pointer to code to be started by server
    protected_mode_target DD ?
                          DW g_code
  ;  belongs to above
    our_GDTR   dw       (gdtlast-gdtnull)-1    ;limit (byte gran)
                        ;linear (not physical) base address of "gdtnull"
    laddr_GDT  dd       (High_Addr+(gdtnull-code_org0))
               dw       ?    ; (just for align "laddr_IDT" to Dword)
    our_IDTR   dw       (idtlast-idtnull)-1    ;limit (byte gran)
                        ;linear (not physical) base address of "Idtnull"
    laddr_IDT  dd       (High_Addr+(idtnull-code_org0))
  ;-------------------------------------------------------------------^

  pagedir_template dd     (High_Addr+(page0-code_org0)+3)

; -------------------------------------------------------------


;=============================================================================


DOS_WRITE_STRING        = 009h ; Display a '$' terminated string
DOS_BUFFERED_INPUT      = 00Ah ; Read text and store it in a buffer
DOS_OPEN_FILE           = 03Dh ; Open an existing file
DOS_CREATE_FILE         = 03Ch ; create a new file
DOS_CLOSE_FILE          = 03Eh ; Close a file
DOS_READ_FROM_HANDLE    = 03Fh ; Read from DOS file handle
DOS_WRITE_TO_HANDLE     = 040h ; write to DOS file handle
DOS_TERMINATE_EXE       = 04Ch ; Terminate program

DosCall macro function_code
    mov ah,function_code
    int 21h
endm
DosInt macro
    int 21h
endm



push_ macro r1,r2,r3,r4,r5,r6,r7,r8,rx
           irp   parm,<&r1,&r2,&r3,&r4,&r5,&r6,&r7,&r8,&rx>
             ifndef parm
               exitm
             endif
             push parm
           endm
         endm
pop_  macro r1,r2,r3,r4,r5,r6,r7,r8
           irp   parm,<&r8,&r7,&r6,&r5,&r4,&r3,&r2,&r1>
             ifdef parm
               pop parm
             endif
           endm
         endm

pushAD_struc macro prefix
           irp   parm,<edi,esi,ebp,esp,ebx,edx,ecx,eax>
             prefix&&parm  dd  ?
           endm
         endm



cpu_86     equ   0
cpu_286    equ   2
cpu_386V86 equ   3       ; is >=386, but in virtual 86 mode
cpu_386GE  equ   4       ; >=386
cpu_386GE_real_paging equ 5
cpu_type   dw    0

cpu_check proc near
        pushf
        xor     ax,ax   ;0000 to ax
        push    ax
        popf            ; try to put that in flags
        pushf
        pop     ax      ; look at what really went into flags
        and     ah,0f0h ; mask off high flag bits
        cmp     ah,0f0h
        je      is_8086
        mov     ax,0f000h
        push    ax      ; try to set the high bits
        popf
        pushf
        pop     ax      ; look at actual flags
        and     ah,0f0h
        je      is_80286
                        ; is x86, x >= 3
                        ; check for V86 or real-paging -mode
        mov     ah,040h ; try to clear IOPL
        push    ax
        popf
        pushf
        pop     ax
        and     ah,030h
        jne     is_v86
        cmp     option_clone,0
        jnz     @@clone
        .386p
        mov     eax,cr0        ; normally this would cause a GP(0)-exception
                               ; (i386 Programmers Reference Guide, INTEL 1987)
                               ; if in V86-mode, but most EMMXXXX drivers
                               ; seem to intercept this exception and allow
                               ; reading the CR0.
        .386
        or      eax,eax
        jz      is_v86         ; not a valid CR0, reserved bits are allways set
                               ; (this may be not true on a 486 clone such as
                               ;  the 486DLC, so if you have trouble with
                               ;  interpreting real mode as V86 use the -clone switch
                               ;
        test    al,01h         ; test PE -bit
        jz      is_greater_equal_80386
is_v86:
        mov     ax,cpu_386V86
cpu_check_exit:
        mov     cpu_type,ax
        popf
        ret
is_8086:
        mov     ax,cpu_86
        jmp     cpu_check_exit
is_80286:
        mov     ax,cpu_286
        jmp     cpu_check_exit
is_greater_equal_80386:
        test    eax,eax         ; test PG - bit
        js      is_386_real_pageing
        mov     ax,cpu_386GE
        jmp     cpu_check_exit

is_386_real_pageing:
        mov     ax,cpu_386GE_real_paging
        jmp     cpu_check_exit

@@clone:                 ; on some 486 clones we have problems with CR0,
                         ; so we are looking for EMM, and then
                         ; we assume to be in V86, if we have EMM.
        push    ds
        xor     ax,ax
        mov     ds,ax
        mov     ds,word ptr ds:[emm_int*4+2]
        mov     ax,cpu_386V86
        cmp     dword ptr ds:[10+4],'0XXX'
        jne     @@cl1
        cmp     dword ptr ds:[10],'QMME'
        je      @@clex
        cmp     dword ptr ds:[10],'XMME'
        je      @@clex
@@cl1:
        mov     ax,cpu_386GE
@@clex:
        pop     ds
        jmp     cpu_check_exit

cpu_check endp

;=============================================================================


start:
        .8086    ; we are not sure here if on a 368 CPU
        mov      cs:PSP_frame,es
        mov      ax,cs     ; switch the to our stack
        mov      ss,ax
        lea      sp,stack_top
        mov      ds,ax
        mov      es,ax
        call     clear_uninitialized_data
        mov      ds,cs:PSP_frame
        cld
        lea      si,PSP_DTA+1
        lea      di,comline+1
        mov      cl,PSP_DTA
        xor      ch,ch
        jcxz     start__2
start__:                          ; skip leading blanks
        cmp      byte ptr [si],' '
        jne      start__2
        inc      si
        loop     start__
start__2:
        mov      comline-1,ch
        mov      comline,cl
        inc      cx             ; get the CR too
        rep movsb               ; get the commandline out of psp

        push     cs
        pop      ds
        assume   ds:code
                 ; from now on we have CS=DS=ES=SS

                 ; make sure that size byte is correct
                 ; ( some DOS versions set only CR .. sometimes )
        lea      di,comline+1
        mov      al,13
        call     strlen
        cmp      al,comline
        jnb      start_0
        mov      comline,al
start_0:
        mov      bx,word ptr comline-1
        xchg     bh,bl
        mov      comline[bx+1],0  ; replace CR by ZERO

        mov      logo_out,0
        mov      print_dots,0

        mov      kernel_start,kernel_start_ ; real kernel_start
        mov      free_mem_start,cs  ;save CS as later freemem

                 ; now check if (on error) we can exit do DOS
        lea      bx,comspec_tx
        call     get_env_variable     ; we expect COMSPEC= in the environement
        mov      al,byte ptr es:[di]
        mov      can_exit_to_dos,al
                 ; check if we are running under windows
        lea      bx,windows_tx
        call     get_env_variable     ; we expect WINDIR= in the environement
        mov      al,byte ptr es:[di]
        mov      cannot_load_because_of_windows,al
        push     ds
        pop      es


        lea      ax,modul_end+15
        shr      ax,4
        mov      bx,ax
        add      ax,High_Seg
        mov      es,PSP_frame
        cmp      ax,es:PSP_memend_frame
        jnb      err_uppermem

        push     ds
        pop      es                     ; restore es

        mov      ax,free_mem_start
        mov      kernel_load_frame,ax
        cmp      ax,kernel_start
        jnb      start_1
        mov      ax,kernel_start
        mov      kernel_load_frame,ax
start_1:

                 ; check if we are on the right CPU
        mov      cpu_check_status,0

        call     cpu_check
        lea      dx,err_wrong_cpu_tx
        cmp      ax,cpu_386V86
        jb       err_print    ; has no 386 or greater at all

        .386    ; now we are sure beeing on a 386(and greater) CPU
m2:
        call     parscommandline
        call     cpu_check    ; do it once more, because of option_clone

        mov      cpu_check_status,2
        call     get_default_bios_intvectors
        cmp      ax,cpu_386GE
        jb       m2_1
        test     intv_size,0fffch
        jnz      start_continue    ; has $BIOSINTV or REALBIOS.INT
        cmp      option_t_forced,0
        jnz      start_continue
        mov      have_to_intercept_setup,1
        jmp      start_continue
m2_1:
        mov      cpu_check_status,4
                              ; have 386, but are in V86-mode
        call     check_VCPI_present
        jz       err_wrong_cpu   ; has no VCPI-server
        mov      cpu_check_status,6
        call     check_low_mem_mapping
        jz       err_wrong_cpu   ; has no identical phys/log mapping
        mov      have_to_force_realmode,1
        test     intv_size,0fffch
        jnz      plain_switch    ; has $BIOSINTV or REALBIOS.INT
                                 ; has no $BIOSINTV driver loaded
                                 ; but will try to start Linux anyway
        cmp      option_t_forced,0
        jnz      plain_switch
        mov      word ptr cs:intv_buf+(4*15h+2),0
        mov      have_to_intercept_setup,1
plain_switch:
        mov      cpu_check_status,8


start_continue:
        cmp      comline,0   ; have we an emtpy string ?
        jnz      m3
        lea      dx,empty_tx
        jmp      err_print

                          ; have file-name at minimum
                          ; trying to open it
m3:
        mov      ax,DOS_OPEN_FILE shl 8
        lea      dx,image_name
        DosInt
        jnc      fileopened
m4:
        lea      dx,err_file_notfound_tx
m4_:
        call     print
        lea      dx,enter_commandline_tx
        call     print
        call     readstring
        cmp      comline,0   ; have we an emtpy string ?
        jnz      m2
        lea      dx,abort_tx
        call     print
        jmp      err_exit

fileopened:
        mov      fhandle,ax
                          ; first look if it is really an image
        mov      bx,ax
        mov      ecx,512
        mov      di,cs
        call     read_handle   ; read the bootsector
        jnc      have_bootsect
fileopened_wrong:
        DosCall  DOS_CLOSE_FILE
        lea      dx,err_wrong_file_tx
        jmp      m4_
err_wrong_setup:
        DosCall  DOS_CLOSE_FILE
        lea      dx,err_wrong_setup_tx
        jmp      m4_
err_setup_too_long:
        DosCall  DOS_CLOSE_FILE
        lea      dx,err_setup_too_long_tx
        jmp      m4_

have_bootsect:
        cmp      ax,cx
        jne      fileopened_wrong
        cmp      bootmagic,0AA55h
        jne      fileopened_wrong
                            ; ok, now get the setup part
        mov      di,cs
        lea      bx,setup_prog
        shr      bx,4
        add      di,bx
        mov      bx,fhandle
        xor      ecx,ecx
        mov      ch,setup_sects
        shl      cx,1
        jnz      new_bootsect
        mov      ch,2*standard_setup_sects
new_bootsect:
        cmp      cx,maximum_setup_sects*512
        ja       err_setup_too_long
        mov      new_setup_size,cx
        call     read_handle   ; read setup
        jc       fileopened_wrong
        cmp      ax,cx
        jne      fileopened_wrong
        cmp      have_to_intercept_setup,0
        jz       dont_patch
        cmp      dword ptr ds:setup_header_sign,SIGNATURE
        jnz      not_signed
        mov      have_to_intercept_setup,2
        mov      word ptr ds:setup_realmode_switch,offset real_switch
        mov      word ptr ds:setup_realmode_switch+2,High_Seg
        mov      ax,kernel_load_frame
        mov      word ptr ds:start_sys_seg,ax
        jmp      dont_patch
not_signed:
        xor      di,di
        mov      cx,new_setup_size
        mov      al,0FAh    ; cli
        cld
keep_searching:
        repnz scasb
        jcxz     err_wrong_setup
        cmp      dword ptr [di],70E680B0h ; mov al,80h
                                          ; out 70h,al
        jnz      keep_searching
        mov      byte ptr [di-1],0CDh   ; int op code
        mov      byte ptr [di],setup_intercept_int  ; int number
        mov      word ptr [di+1],4444h ; inc sp       adjust stack
                                       ; inc sp       (discard flags)
        mov      byte ptr [di+3],90h   ; nop
dont_patch:
                          ; we convert the kernel version string
                          ; to a binary number
        xor      eax,eax
        cmp      have_to_intercept_setup,2
        jne      dont_patch_
        call     get_kernel_version
dont_patch_:
        mov      kernelversion,eax
        call     handle_kernel_specifics
                          ; ok, now check the size of the kernel
        mov      ax,High_Seg
        sub      ax,kernel_load_frame
        cmp      ax,kernel_size
        ja       have_space
        lea      dx,err_kernel_to_big_tx
        cmp      option_t,0
        je       err_print

have_space:
                           ; now we update the params
        cmp      command_line,0
        jz       no_comline
        mov      CL_MAGIC,0A33Fh
        lea      ax,command_line
        mov      CL_OFFSET,ax
        mov      si,cl_pointer
        mov      byte ptr [si-1],0 ;delete the last blank


no_comline:
                           ; check for ramdisk
        cmp      got_ram_disk,0
        jz       no_change_on_ramdisk
        mov      ax,new_ram_disk
        mov      ram_disk,ax
no_change_on_ramdisk:
                           ; check for vga
        cmp      got_vga_mode,0
        jz       no_change_on_vga
        mov      ax,new_vga_mode
        mov      vga_mode,ax

no_change_on_vga:
                           ; check for ro_flag
        cmp      got_ro_flag,0
        jz       no_change_on_ro
        mov      ax,new_ro_flag
        mov      ro_flag,ax

no_change_on_ro:
                           ; check for root_dev
        cmp      got_root_dev,0
        jz       no_change_on_root_dev
        mov      ax,new_root_dev
        mov      root_dev,ax

no_change_on_root_dev:
        cmp      cannot_load_because_of_windows,0
        jz       no_windows
        call     force_error_verbose
no_windows:

                           ; check for -v option
        cmp      option_v,0
        jz       no_option_v
                           ; option -v (verbose) is set
                           ; print some information
        call     print_verbose

no_option_v:
                           ; check for -t option
        cmp      option_t,0
        jz       no_option_t
        DosCall  DOS_CLOSE_FILE
        lea      dx,option_t_terminate_tx
        cmp      option_t_forced,0
        jz       no_option_t_forced
        lea      dx,option_t_forced_tx
no_option_t_forced:
        call     print
        jmp      err_exit

no_option_t:
                           ; start of critical section
                           ; =========================
        call     close_debug_file

        ;---------------------------------------
        mov      ax,High_Seg   ; move us high
        mov      es,ax
        push     cs
        pop      ds
        xor      si,si
        xor      di,di
        lea      cx,modul_end+3
        shr      cx,2
        rep movsd
        push     es
        pop      ds
                 ; we have move ourself up
                 ; must now change cs
        push     ds
        lea      ax,back_from_low
        push     ax
        retf
back_from_low:
        mov      ax,ds     ; switch the stack to top
        mov      ss,ax
        lea      sp,stack_top
                 ; from now on we have CS=DS=ES=SS=setup_memory
        ;-------------------------------------------
        cmp      have_to_force_realmode,0
        je       back_from_low_continue
                 ; we have to do this once more
                 ; because some VCPI-servers rely on an unmovable page0
        call     get_VCPI_interface

back_from_low_continue:

                            ; now loading the kernel
        mov      bx,fhandle
        movzx    ecx,kernel_size
        shl      ecx,4
        mov      di,kernel_load_frame
        mov      print_dots,2
        call     read_handle   ; read the kernel
        call     print_crlf
        mov      print_dots,0
        call     print_crlf
        jc       err_io
        add      eax,15
        and      al,0f0h
        cmp      eax,ecx
        jnz      fileopened_wrong
                           ; ok, all is read into memory
        DosCall  DOS_CLOSE_FILE

        cmp      ram_disk,0 ; have we a ramdisk
        jz       no_ram_disk
        cmp      option_nodiskprompt,0;
        jnz      no_ram_disk
                           ;we must prompt for insertion of floppy
        lea      dx,insert_floppy_tx
        call     print
        call     readstring    ; just to wait for prompt
no_ram_disk:

        cli
___go:
        cmp      have_to_intercept_setup,1
        ja       ___go_switch
        je       ___go_skip_move
        call     move_kernel_down
___go_skip_move:
        cmp      have_to_intercept_setup,1
        jne      ___go_switch
        xor      ax,ax
        mov      ds,ax
        mov      word ptr ds:[4*setup_intercept_int],offset real_switch
        mov      word ptr ds:[4*setup_intercept_int+2],cs
___go_switch:
        mov      ax,High_Seg
        mov      ds,ax
        mov      es,ax

        cmp      have_to_intercept_setup,0
        ja       ___go_continue
        call     switch_to_protected_mode_and_return_in_386realmode

___go_continue:
        call     restore_bios_default_vectors
        lea      bx,setup_prog
        shr      bx,4
        mov      ax,High_Seg
        add      ax,bx
        lea      sp,setup_stack_top  ; separate stack during
                                     ; setup and real_switch
        push     ax
        push     0
        mov      ax,root_dev

        retf     ; and now it's the job of setup
                 ; but NOTE:
                 ;   on have_to_force_realmode >0 setup calls real_switch

setup_own_stack df 0


real_switch proc far
        ;  NOTE:  we have to preserve ALL registers !
        ;         to avoid conflicts with future kernels
        cli
        push_    ds,es,fs,gs
        pushad
        mov      al,80h
        out      [70h],al
        mov      ax,cs
        mov      ds,ax
        mov      es,ax
        mov      word ptr setup_own_stack+4,ss
        mov      dword ptr setup_own_stack,esp
                        ; Ok,ok, today setup has our stack (no need to switch)
        mov      ss,ax  ; ... but we want to be sure for the future,
        lea      sp,stack_top ; so we switch to our stack
        cmp      have_to_intercept_setup,2 ; have we to move the kernel down ?
        je       @@3  ; no, setup will do it (knows the location of the image)
                      ; yes, we have patched in the intercept code,
                      ; so the kernel expects the kernel at 10000h
        call     move_kernel_down
@@3:
        call     switch_to_protected_mode_and_return_in_386realmode
        lss      esp,cs:setup_own_stack ; restore setup's stack
        popad
        pop_     ds,es,fs,gs
        retf
real_switch endp

;=============================================================================


move_kernel_down proc near
                           ; is the kernel at its right place ?
        cli
        mov      ax,kernel_start
        cmp      kernel_load_frame,ax
        je       short @@ex  ; yes
                           ; no, must move it down
        push_    ds,es
        cld
mgran = 08000h
        mov      bp,mgran shr 4
        mov      ax,kernel_size
        mov      bx,kernel_start
        mov      dx,kernel_load_frame
@@loop:
        mov      cx,mgran shr 2
        mov      ds,dx
        mov      es,bx
        xor      si,si
        xor      di,di
        rep movsd
        add      bx,bp
        add      dx,bp
        sub      ax,bp
        cmp      ax,bp
        ja       @@loop
        mov      cx,ax
        shl      cx,2
        mov      ds,dx
        mov      es,bx
        xor      si,si
        xor      di,di
        rep movsd

IF 0   ; I guess, it's not needed
                           ; now clear the space behind the kernel (BSS)
@@clear:
        push     cs
        pop      ds
        mov      bp,mgran shr 4
        mov      bx,kernel_start
        add      bx,kernel_size
        mov      dx,High_Seg
        xor      eax,eax
        sub      dx,bx     ; count of remaining space
        jc       @@ex0
        jmp      @@ctest
@@cloop:
        mov      cx,mgran shr 2
        mov      es,bx
        xor      di,di
        rep stosd
        add      bx,bp
        sub      dx,bp
@@ctest:
        cmp      dx,bp
        ja       @@cloop
        mov      cx,dx
        shl      cx,2
        mov      es,bx
        xor      di,di
        rep stosd

@@ex0:
ENDIF
        pop_     ds,es
        mov      ax,kernel_start
        mov      kernel_load_frame,ax
@@ex:
        ret
move_kernel_down endp


err_wrong_cpu:
        lea      dx,err_cpu_v86_tx
err_print:
        cmp      word ptr comline-1,0   ; have we an command line
        jnz      err_print_2 ; no
                             ; yes, print help and status
        push     dx
        lea      dx,usage_tx
        call     print
        pop      dx
err_print_2:
        call     print
        cmp      cpu_type,cpu_386V86
        jb       err_exit
        call     print_verbose_stat
        jmp      err_exit
err_io:
        lea      dx,err_io_tx
        call     print
        jmp      err_exit

err_uppermem:
        lea      dx,err_uppermem_tx
        call     print
err_exit:
        cmp      cs:can_exit_to_dos,0
        jz       idle
        mov      al,1
exit_to_dos:
        call     close_debug_file
        DosCall  DOS_TERMINATE_EXE
idle:
        lea      dx,err_in_config_sys_tx
        call     print
        call     close_debug_file
idle_:
        sti
        jmp      idle_

real_print   proc    near
; input: DX = offset of string within CODE
        .8086
        push    ds
        push    cs
        pop     ds
        push_   bx,cx,si
        mov     si,dx
        cld
        xor     ax,ax
@@loop:
        lodsb
        test    ax,ax
        jz      @@ok
        cmp     al,'$'
        jnz     @@loop
@@ok:
        dec     si
        sub     si,dx
        jz      @@null
        mov     cx,si
        mov     bx,1
        DosCall DOS_WRITE_TO_HANDLE
        cmp     debug_file_handle,0
        jz      @@ex
        mov     bx,debug_file_handle
        DosCall DOS_WRITE_TO_HANDLE
@@null:
@@ex:
        pop_    bx,cx,si
        pop     ds
        ret
        .386
real_print   endp

print proc near
        cmp      cs:logo_out,0
        jnz      @@ex
        mov      cs:logo_out,1
        push_    ax,dx
        lea      dx,logo_tx
        call     real_print
        pop_      ax,dx
@@ex:
        call     real_print
        ret
print endp


print_crlf proc near
        pushf
        push    ax
        push    dx
        lea     dx,@@crlf
        call    print
        pop     dx
        pop     ax
        popf
        ret
@@crlf  db      13,10,'$'
print_crlf endp

print_dot proc  near
        pushf
        cmp     cs:print_dots,1
        jb      @@ex
        push    ax
        push    dx
        lea     dx,@@dot_tx
        je      @@1
        lea     dx,@@start_tx
        dec     cs:print_dots
@@1:
        call    print
        pop     dx
        pop     ax
@@ex:
        popf
        ret
@@start_tx db    13,10,'LOADING'
@@dot_tx  db    '.$'
print_dot endp

read_handle proc    near
; input:
;   BX=  handle
;  ECX=  count
;   DI=  frame of destination
; output:
;   CARRY =1 , then read-error
;  EAX= number of bytes transferred (even on CARRY=1)
;
granularity = 02000h
        push    ds
        push    esi
        push    dx
        push    ecx
        mov     ds,di
        mov     esi,ecx
        mov     ecx,granularity
        xor     dx,dx
        jmp     @@start
@@next:
        DosCall DOS_READ_FROM_HANDLE
        call    print_dot
        jc      @@err
        cmp     ax,cx
        jne     @@eof
        sub     esi,ecx
        mov     ax,ds
        add     ax,(granularity shr 4)
        mov     ds,ax
@@start:
        cmp     esi,ecx
        ja      @@next
        mov     cx,si
        DosCall DOS_READ_FROM_HANDLE
        call    print_dot
        jc      @@err
@@eof:
        movzx   eax,ax
        sub     esi,eax
        pop     ecx
        mov     eax,ecx
        sub     eax,esi
        clc
@@ex:
        pop     dx
        pop     esi
        pop     ds
        ret
@@err:
        pop     ecx
        mov     eax,ecx
        sub     eax,esi
        stc
        jmp     @@ex
read_handle endp


read_comline_from_file proc near
;;        mov      ax,DOS_OPEN_FILE shl 8
;;        lea      dx,image_name+1
;;        DosInt
        push     fs
        call     @@open
        jnc      @@isopen
@@err:
        lea      dx,err_comfile_tx
        call     print
        mov      word ptr comline-1,0
        jmp      @@ex
@@ioerr:
;;        DosCall  DOS_CLOSE_FILE
        call     @@close
        jmp      @@err
@@isopen:
        mov      bx,ax
        cld
        lea      di,comline+1
@@loop:
        mov      dx,di
        mov      cx,1
;;        DosCall  DOS_READ_FROM_HANDLE
        call     @@read
        jc       @@ioerr
        cmp      ax,1
        jne      @@eof
        mov      al,byte ptr [di]
        cmp      al,13
        je       @@loop
        cmp      al,'#'
        je       @@skipeol
@@skipcontinue:
        inc      di
        cmp      di, offset comline_end-1
        jnb      @@eof
        cmp      al,' '
        ja       @@loop
        cmp      di,offset comline+2
        jna      @@1
        cmp      byte ptr [di-2],' '  ; ignore multiple spaces
        jne      @@1
        dec      di
        jmp      @@loop
@@1:
        mov      byte ptr [di-1],' '
        jmp      @@loop
@@eof:
        mov      byte ptr [di],0
        mov      ax,di
        sub      ax,offset comline+1
        xchg     al,ah
        mov      word ptr comline-1,ax
;;        DosCall  DOS_CLOSE_FILE
        call     @@close
        jmp      @@ex
@@skipeol:
        mov      dx,di
        mov      cx,1
;;        DosCall  DOS_READ_FROM_HANDLE
        call     @@read
        jc       @@ioerr
        cmp      ax,1
        jne      @@eof
        cmp      byte ptr [di],10
        jne      @@skipeol
        jmp      @@skipcontinue

@@ex:
        pop      fs
        ret

; -----------

@@virtual db     0

@@open:                    ; virtual open routine
        cmp      dword ptr image_name,'ol@@'
        jne      @@open_d
        cmp      dword ptr image_name+4,'ilda'
        jne      @@open_d
        cmp      dword ptr image_name+4+4,'@@xn'
        je       @@open_v
@@open_d:
        mov      @@virtual,0
        lea      dx,image_name+1
        mov      ax,DOS_OPEN_FILE shl 8
        DosInt
        ret
@@open_v:
        mov      @@virtual,1
        mov      ax,High_Seg
        mov      fs,ax
        lea      ax,params_from_loadlinX
        clc
        ret

@@close:
        cmp      @@virtual,0
        jz       @@close_d
        ret
@@close_d:
        DosCall  DOS_CLOSE_FILE
        ret
@@read:
        cmp      @@virtual,0
        jz       @@read_d
        mov      al, byte ptr fs:[bx]
        or       al,al
        jz       @@read_eof
        inc      bx
        mov      byte ptr [di],al
        mov      ax,1
        clc
        ret
@@read_eof:
        xor      ax,ax
        clc
        ret
@@read_d:
        DosCall  DOS_READ_FROM_HANDLE
        ret


read_comline_from_file endp


check_token proc near
; input:
;   ES=DS=CS= seg of all pointers
;   DI = pointing to token
;   BX = pointing to string-table, terminated by a ZERO-string
; output:
;   AX = -1, no match found
;      =  0, found a matching string, BX = index*2 of that string
;      =  1, same as AX=0, but token was terminated by '='
;   DI =  pointing to token behind terminator (0 or '=')
;
        push_   cx,dx
        cld
        xor     dx,dx
        jmp     @@loop_entry
@@loop:
        pop     di
        inc     dx
        xchg    bx,di
        xor     ax,ax
        mov     cx,-1
        repnz scasb       ; skip to next string in table
        xchg    bx,di
        cmp     byte ptr [bx],0
        jz      @@not_found
@@loop_entry:
        push    di
        mov     cx,size aux_token
        call    name_compare
        jz      @@loop
        pop     ax     ; clean up stack
        xchg    dx,bx  ; get index
        shl     bx,1
        xor     ax,ax
        cmp     byte ptr [di-1],'='
        jne     @@ex
        inc     ax
@@ex:
        pop_    cx,dx
        test    ax,ax
        ret
@@not_found:
        mov     ax,-1
        jmp     @@ex
check_token endp


clear_to_default proc near
        push_    ax,di,es
        call     close_debug_file
        push     cs
        pop      es
        xor      ax,ax
        mov      cx,parse_switches_end-parse_switches
        lea      di,parse_switches
        cld
        rep stosb
        pop_     ax,di,es
        ret
clear_to_default endp


;=============================================================================


INCLUDE LOADLINI.ASM

;=============================================================================

; -------------------------------------------------------------
clear_uninitialized_data proc near
        .8086
        push_   ax,cx,di
        xor     ax,ax
        lea     di,uninitialized_data_start
        mov     cx,(uninitialized_data_stop-uninitialized_data_start)/2
        cld
        rep stosw
        mov     ax,word ptr pagedir_template
        mov     word ptr pagedir,ax
        mov     ax,word ptr pagedir_template+2
        mov     word ptr pagedir+2,ax
        pop_    ax,cx,di
        ret
        .386
clear_uninitialized_data endp


          align dword
          db           space1k dup(?)
setup_stack_top label byte
          db           space1k dup(?)
stack_top label byte


uninitialized_data_start label byte

                db    ?   ; belongs to comline
comline         db    128 dup(?) ; copied from PSP_DTA
                db    2*1024-128 dup(?) ; extended commandline
comline_end     label byte
image_name      db    80 dup(?)
aux_token       db    80 dup(?)

command_line    db    space2k dup(?)  ; kernel accepts maximum of 2Kb

  ; -------------------------------v
  ; this buffer is for the "default bios interruptvectors"
  ; as is set from the BIOS,
  ; Its contents are delivered by the BIOSINTV.SYS device driver
  ; (must be AT TOP of config.sys).
  ; Or from the REALBIOS.INT file.
  ; We need this after returning from V86-mode
  ; because NOTHING is valid any more but the ROM-BIOS
  ; (and LOADLIN of cause)
  ;
intv_buf        dd     128 dup(?)   ;  intvector  0:0
                dd     128 dup(?)
bios_data       db     256 dup(?)   ;  BIOS-data 40:0
dummy_dos_data  db     (256-4-16-2) dup(?) ; (DOS-data  50:0, not valid at boot tome
real_bios_int15 dw     ?            ; result of int15 at time of realbios
real_bios_magic dw     ?            ; must be 0a5a5h for post alpha-release
reset_jmpop     db     ?            ;  TOP BIOS FFFF:0
reset_entry     dd     ?
biosdate        db     9 dup(?)
machineid       db     ?
                db     ?
masterIMR       db     ?            ;  port 21
slaveIMR        db     ?            ;  port A1
bios_scratch    db     1024 dup(?)  ;  scratch  9FC0:0
realbios_end    label  byte
  ; -------------------------------^


  ; -------------------------------v
                align_ code_org0,4096
IF 0                                ; now moved at start of our code
                                    ; (overlapping our code)
pagedir         dd     1024 dup(?)  ; must be aligned to 4 K
ENDIF
page0           dd     1024 dup(?)  ; must be aligned to 4 K
  ; -------------------------------^


uninitialized_data_stop label byte
; -------------------------------------------------------------


modul_end:

code    ends


        end      start
