------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                        S Y S T E M . T A S K I N G                       --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.10 $                             --
--                                                                          --
--       Copyright (c) 1991,1992,1993,1994, FSU, All Rights Reserved        --
--                                                                          --
-- GNARL is free software; you can redistribute it  and/or modify it  under --
-- terms  of  the  GNU  Library General Public License  as published by the --
-- Free Software  Foundation;  either version 2, or (at  your  option)  any --
-- later  version.  GNARL is distributed  in the hope that  it will be use- --
-- ful, but but WITHOUT ANY WARRANTY;  without even the implied warranty of --
-- MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
-- eral Library Public License  for more details.  You should have received --
-- a  copy of the GNU Library General Public License along with GNARL;  see --
-- file COPYING.LIB.  If not,  write to the  Free Software Foundation,  675 --
-- Mass Ave, Cambridge, MA 02139, USA.                                      --
--                                                                          --
------------------------------------------------------------------------------

--  This package body has to be eliminated once the offset calculation for
--  ATCB is done statically. Also, the temporary placement of queuing
--  primitives has to move back to Tasking.Queuing. (compiler error) ???

with System.Task_Primitives;
--  Used for,  Task_Primitives.TCB_Ptr,
--             Task_Primitives.Self

with System.Storage_Elements;
--  Used for,  Storage_Elements.Storage_Offset,
--             Storage_Elements."-"
--             Storage_Elements.Storage_Count

with Unchecked_Conversion;

package body System.Tasking is

   function "-"
     (A    : System.Address;
      B    : System.Address)
      return Storage_Elements.Storage_Offset
   renames Storage_Elements."-";

   function "-"
     (A    : System.Address;
      I    : Storage_Elements.Storage_Offset)
      return System.Address
   renames Storage_Elements."-";

   function Get_LL_TCB_Offset return Storage_Elements.Storage_Count;

   LL_TCB_Offset : Storage_Elements.Storage_Count := Get_LL_TCB_Offset;

   function Address_To_Task_ID is new
     Unchecked_Conversion (System.Address, Task_ID);

   function TCB_Ptr_To_Address is new
     Unchecked_Conversion (Task_Primitives.TCB_Ptr, System.Address);

   -----------------------
   -- Get_LL_TCB_Offset --
   -----------------------

   function Get_LL_TCB_Offset return Storage_Elements.Storage_Count is
      ATCB_Record : Ada_Task_Control_Block (0);

   begin
      return ATCB_Record.LL_TCB'Address - ATCB_Record'Address;
   end Get_LL_TCB_Offset;

   ----------
   -- Self --
   ----------

   --  This is an INLINE_ONLY version of Self for use in the RTS.

   function Self return Task_ID is
      S : Task_Primitives.TCB_Ptr := Task_Primitives.Self;

   begin
      return Address_To_Task_ID (TCB_Ptr_To_Address (S) - LL_TCB_Offset);
   end Self;

   ------------------
   -- Service_Info --
   ------------------

   function Get_Service_Info (Block : Communication_Block)
      return System.Address is
   begin
      return Block.Service_Info;
   end Get_Service_Info;

   -------------------
   -- Get_Cancelled --
   -------------------

   function Get_Cancelled (Block : Communication_Block) return Boolean is
   begin
      return Block.Cancelled;
   end Get_Cancelled;

   ----------------------
   -- Set_Service_Info --
   ----------------------

   procedure Set_Service_Info
     (Block : in out Communication_Block;
      Service_Info : System.Address) is
   begin
      Block.Service_Info := Service_Info;
   end Set_Service_Info;

   -------------------
   -- Set_Cancelled --
   -------------------

   procedure Set_Cancelled
     (Block : in out Communication_Block;
      Cancelled : Boolean) is
   begin
      Block.Cancelled := Cancelled;
   end Set_Cancelled;

   --------------
   -- Finalize --
   --------------

   procedure Finalize (Object : in out Protection) is
   begin
      System.Task_Primitives.Finalize_Lock (Object.L);
   end Finalize;

end System.Tasking;
