------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 S Y S T E M . O S 2 L I B . T H R E A D S                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--             Copyright (c) 1993,1994 NYU, All Rights Reserved             --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces.C; use Interfaces.C;

package System.OS2Lib.Threads is
pragma Preelaborate (Threads);

   type PID is new unsigned_long;
   type PPID is access all PID;
   --  Process ID, and pointer to process ID

   type TID is new unsigned_long;
   type PTID is access all TID;
   --  Thread ID, and pointer to thread ID

   -------------------------------------------------------------
   -- Thread Creation, Activation, Suspension And Termination --
   -------------------------------------------------------------

   --  Note: <bsedos.h> defines the "Informations" and "param" parameter below
   --  as a ULONG, but everyone knows that in general an address will be passed
   --  to it. We declared it here with type PVOID (which it should have had)
   --  because Ada is a bit more sensitive to mixing integers and addresses.

   type PFNTHREAD is access procedure (Informations : System.Address);
   --  TBSL should use PVOID instead of Address as per above node ???

   function DosCreateThread
     (F_ptid  : PTID;
      pfn     : PFNTHREAD;
      param   : PVOID;
      flag    : ULONG;
      cbStack : ULONG)
      return    APIRET;
   pragma Import (C, DosCreateThread, "DosCreateThread");

   Block_child     : constant := 1;
   No_Block_child  : constant := 0;
   Commit_stack    : constant := 2;
   No_Commit_stack : constant := 0;
   --  Values for "flag" parameter in DosCreateThread call

   procedure DosExit (Action : ULONG; Result : ULONG);
   pragma Import (C, DosExit, "DosExit");

   EXIT_THREAD  : constant := 0;
   EXIT_PROCESS : constant := 1;
   --  Values for "Action" parameter in Dos_Exit call

   function DosResumeThread (Id : TID) return APIRET;
   pragma Import (C, DosResumeThread, "DosResumeThread");

   function DosSuspendThread (Id : TID) return APIRET;
   pragma Import (C, DosSuspendThread, "DosSuspendThread");

   procedure DosWaitThread (Thread_Ptr : PTID; Option : ULONG);
   pragma Import (C, DosWaitThread, "DosWaitThread");

   DCWW_WAIT   : constant := 0;
   DCWW_NOWAIT : constant := 1;
   --  Values for "Option" parameter in DosWaitThread call

   ---------------------------------------------------
   -- Accessing properties of Threads and Processes --
   ---------------------------------------------------

   --  Structures translated from BSETIB.H

   --  Thread Information Block (TIB)
   --  Need documentation clarifying distinction between TIB, TIB2 ???

   type TIB2 is record
      tib2_ultid        : ULONG;  -- Thread I.D.
      tib2_ulpri        : ULONG;  -- Thread priority
      tib2_version      : ULONG;  -- Version number for this structure
      tib2_usMCCount    : USHORT; -- Must Complete count
      tib2_fMCForceFlag : USHORT; -- Must Complete force flag
   end record;

   type PTIB2 is access all TIB2;

   --  Thread Information Block (TIB)

   type TIB is record
      tib_pexchain      : PVOID;  -- Head of exception handler chain
      tib_pstack        : PVOID;  -- Pointer to base of stack
      tib_pstacklimit   : PVOID;  -- Pointer to end of stack
      tib_ptib2         : PTIB2;  -- Pointer to system specific TIB
      tib_version       : ULONG;  -- Version number for this TIB structure
      tib_ordinal       : ULONG;  -- Thread ordinal number
   end record;

   type PTIB is access all TIB;

   --  Process Information Block (PIB)

   type PIB is record
      pib_ulpid         : ULONG;   -- Process I.D.
      pib_ulppid        : ULONG;   -- Parent process I.D.
      pib_hmte          : ULONG;   -- Program (.EXE) module handle
      pib_pchcmd        : PCHAR;   -- Command line pointer
      pib_pchenv        : PCHAR;   -- Environment pointer
      pib_flstatus      : ULONG;   -- Process' status bits
      pib_ultype        : ULONG;   -- Process' type code
   end record;

   type PPIB is access all PIB;

   function DosGetInfoBlocks
     (Pptib : access PTIB;
      Pppib : access PPIB)
      return  APIRET;
   pragma Import (C, DosGetInfoBlocks, "DosGetInfoBlocks");

   -----------------
   --  Priorities --
   -----------------

   function DosSetPriority
     (Scope   : ULONG;
      Class   : ULONG;
      Delta_P : long;
      PorTid  : TID)
      return    APIRET;
   pragma Import (C, DosSetPriority, "DosSetPriority");

   PRTYS_PROCESS     : constant := 0;
   PRTYS_PROCESSTREE : constant := 1;
   PRTYS_THREAD      : constant := 2;
   --  Values for "Scope" parameter in DosSetPriority call

   PRTYC_NOCHANGE         : constant := 0;
   PRTYC_IDLETIME         : constant := 1;
   PRTYC_REGULAR          : constant := 2;
   PRTYC_TIMECRITICAL     : constant := 3;
   PRTYC_FOREGROUNDSERVER : constant := 4;
   --  Values for "class" parameter in DosSetPriority call

end System.OS2Lib.Threads;
