------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                       S Y S T E M . I M G _ L L D                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with System.Img_Decimal; use System.Img_Decimal;
with System.Img_LLI;     use System.Img_LLI;

package body System.Img_LLD is

   -----------------------------
   -- Image_Long_Long_Decimal --
   -----------------------------

   function Image_Long_Long_Decimal
     (V     : Long_Long_Integer;
      Scale : Integer)
      return  String
   is
      P : Natural := 0;
      S : String (1 .. 64);

   begin
      Set_Image_Long_Long_Decimal
        (V, S, P, Scale, 2, Integer'Max (1, Scale), 0);
      return S (1 .. P);
   end Image_Long_Long_Decimal;

   ---------------------------------
   -- Set_Image_Long_Long_Decimal --
   ---------------------------------

   procedure Set_Image_Long_Long_Decimal
     (V     : Long_Long_Integer;
      S     : out String;
      P     : in out Natural;
      Scale : Integer;
      Fore  : Natural;
      Aft   : Natural;
      Exp   : Natural)
   is
      Digs : String := Image_Long_Long_Integer (V);
      --  Sign and digits of decimal value

      D : Natural;
      --  Number of characters in Digs buffer

   begin
      Set_Decimal_Digits (Digs, Digs'Length, S, P, Scale, Fore, Aft, Exp);
   end Set_Image_Long_Long_Decimal;

end System.Img_LLD;
