------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                 ADA.TEXT_IO.WIDE_TEXT_IO.ENUMERATION_IO                  --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved       --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO.Wide_Text_IO.Enumeration_Aux;

package body Ada.Text_IO.Wide_Text_IO.Enumeration_IO is

   package Aux renames Ada.Text_IO.Wide_Text_IO.Enumeration_Aux;

   ---------
   -- Get --
   ---------

   procedure Get (File : in File_Type; Item : out Enum) is
      Buf    : Wide_String (1 .. Enum'Width);
      Buflen : Natural;

   begin
      Aux.Get_Enum_Lit (File, Buf, Buflen);
      Item := Enum'Wide_Value (Buf (1 .. Buflen));

   exception
      when Constraint_Error => raise Data_Error;
   end Get;

   procedure Get (Item : out Enum) is
   begin
      Get (Current_Input, Item);
   end Get;

   procedure Get
     (From : in Wide_String;
      Item : out Enum;
      Last : out positive)
   is
      Start : Natural;

   begin
      Aux.Scan_Enum_Lit (From, Start, Last);
      Item := Enum'Wide_Value (From (Start .. Last));

   exception
      when Constraint_Error => raise Data_Error;
   end Get;

   ---------
   -- Put --
   ---------

   procedure Put
     (File  : in File_Type;
      Item  : in Enum;
      Width : in Field := Default_Width;
      Set   : in Type_Set := Default_Setting)
   is
      Image : constant Wide_String := Enum'Wide_Image (Item);

   begin
      Aux.Put (File, Image, Width, Set);
   end Put;

   procedure Put
     (Item  : in Enum;
      Width : in Field := Default_Width;
      Set   : in Type_Set := Default_Setting)
   is
   begin
      Put (Current_Output, Item, Width, Set);
   end Put;

   procedure Put
     (To   : out Wide_String;
      Item : in Enum;
      Set  : in Type_Set := Default_Setting)
   is
      Image : constant Wide_String := Enum'Wide_Image (Item);

   begin
      Aux.Puts (To, Image, Set);
   end Put;

end Ada.Text_IO.Wide_Text_IO.Enumeration_IO;
