------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                A D A . T E X T _ I O . F L O A T _ A U X                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines for Ada.Text_IO.Float_IO that are
--  shared among separate instantiations of this package. The routines in
--  this package are identical semantically to those in Float_IO itself,
--  except that generic parameter Num has been replaced by Long_Long_Float,
--  and the default parameters have been removed because they are supplied
--  explicitly by the calls from within the generic template. This package
--  is also used by Ada.Text_IO.Fixed_IO, and Ada.Text_IO.Decimal_IO.

private package Ada.Text_IO.Float_Aux is

   procedure Load_Real
     (File : in File_Type;
      Buf  : out String;
      Ptr  : in out Natural);
   --  This is an auxiliary routine that is used to load a possibly signed
   --  real literal value from the input file into Buf, starting at Ptr + 1.

   procedure Get
     (File  : in File_Type;
      Item  : out Long_Long_Float;
      Width : in Field);

   procedure Put
     (File : in File_Type;
      Item : in Long_Long_Float;
      Fore : in Field;
      Aft  : in Field;
      Exp  : in Field);

   procedure Gets
     (From : in String;
      Item : out Long_Long_Float;
      Last : out Positive);

   procedure Puts
     (To   : out String;
      Item : in Long_Long_Float;
      Aft  : in Field;
      Exp  : in Field);

end Ada.Text_IO.Float_Aux;
