/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"

/*
 * Globals
 */


static	Widget	merge_shell = NULL;
static	Widget	t_1;
static	Widget	but_a, but_d;
static	Widget	tog_1, tog_2;
static	XawTextSelectType	select_types[] = {XawselectLine, XawselectParagraph,
						  XawselectAll, XawselectNull};

static	void	hide_merger (void);
static	void	clear_merger (void);
static	void	remove_merger (void);
static	void	apply_merger (void);


/*********************************************************
 * name:	start_merger
 * description:	Aufrufen des Merge-Feldes
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	27.Aug.1993
 *********************************************************/
void	start_merger (void)
{
	Widget	icon, label;
	Widget	form, f;
	char	*file;
	Boolean	b;

	/*
	 * Alte Shell zerstoeren
	 */
	if (merge_shell)
		XtDestroyWidget(merge_shell);

	/*
	 * Neu Shell erzeugen
	 */
	merge_shell = XtVaCreatePopupShell ("package_builder",topLevelShellWidgetClass,
						toplevel,
						XtNallowShellResize, TRUE,
						NULL);

	/*
	 * Form darauf erzeugen
	 */
	form = XtVaCreateManagedWidget ("package_form",formWidgetClass,
						merge_shell,
						NULL);

	/*
	 * Das Icon und den Label darauf erzeugen
	 */
	icon = XtVaCreateManagedWidget ("package_icon", iconWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNborderWidth, 0,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Pack_PM,
						NULL);
	label = XtVaCreateManagedWidget ("package_label", labelWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNborderWidth, 0,
						XtNfromHoriz, icon,
						XtNlabel, "Package Builder",
						NULL);

	/*
	 * Das Textfeld und den Label fuer den Archive-Namen.
	 */
	label = XtVaCreateManagedWidget ("package_label", labelWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNborderWidth, 0,
						XtNfromVert, icon,
						XtNlabel, "Package Name (without .tar, etc) :",
						NULL);

	file = getString();
	if (!file)
		file = getenv("HOME");

	t_1 = XtVaCreateManagedWidget ("package_text", asciiTextWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainRight,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNeditType, XawtextEdit,
						XtNstring, file,
						XtNfromVert, icon,
						XtNfromHoriz, label,
						XtNresizable, TRUE,
						XtNresize, XawtextResizeWidth,
						NULL);
	XtOverrideTranslations(t_1, XtParseTranslationTable(
					"<Key>Return: no-op()"));

	/*
	 * Darunter jetzt eine Box mit den moeglichen Compressionsmethoden
	 */
	label = XtVaCreateManagedWidget ("package_label", labelWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNborderWidth, 0,
						XtNfromVert, t_1,
						XtNlabel, "Compression :",
						XtNvertDistance,10,
						NULL);

	b = FALSE;
	if (strstr(file,".tar.Z"))
		b = TRUE;

	tog_1 = XtVaCreateManagedWidget ("package_label", toggleWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNfromHoriz, label,
						XtNfromVert, t_1,
						XtNlabel, " Compress ",
						XtNvertDistance,10,
						XtNstate, b,
						NULL);

	if (strstr(file,".tar.gz") || strstr(file,"tar.z"))
		b = TRUE;
	tog_2 = XtVaCreateManagedWidget ("package_label", toggleWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNtop, XtChainTop,
						XtNbottom, XtChainTop,
						XtNfromHoriz, tog_1,
						XtNfromVert, t_1,
						XtNradioGroup, tog_1,
						XtNlabel, " GNU-Zip ",
						XtNstate, b,
						XtNvertDistance,10,
						NULL);

	/*
	 * Das Text-Widget fuer die zu verpackenden Files
	 */
	merge_window = XtVaCreateManagedWidget ("package_field", asciiTextWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainRight,
						XtNtop, XtChainTop,
						XtNbottom, XtChainBottom,
						XtNfromVert, label,
						XtNvertDistance, 10,
						XtNscrollVertical, XawtextScrollWhenNeeded,
						XtNscrollHorizontal, XawtextScrollWhenNeeded,
						XtNheight,100,
						XtNwidth, 400,
						XtNselectTypes, select_types,
						XtNdisplayCaret, FALSE,
						NULL);
	XtOverrideTranslations (merge_window, XtParseTranslationTable(
						"<Btn1Up>: end-single()"));

	/*
	 * Die Form fuer die Buttons
	 */
	f = XtVaCreateManagedWidget ("package_bform", formWidgetClass, form,
						XtNleft, XtChainLeft,
						XtNright, XtChainRight,
						XtNtop, XtChainBottom,
						XtNbottom, XtChainBottom,
						XtNfromVert, merge_window,
						XtNborderWidth, 0,
						XtNvertDistance, 20,
						NULL);

	icon = XtVaCreateManagedWidget ("hide_info", commandWidgetClass, f,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNlabel,"  Hide  ",
						NULL);
	XtAddCallback (icon, XtNcallback, (XtCallbackProc) hide_merger, NULL);

	icon = XtVaCreateManagedWidget ("hide_info", commandWidgetClass, f,
						XtNhorizDistance,145,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNlabel," Clear ",
						XtNfromHoriz, icon,
						NULL);
	XtAddCallback (icon, XtNcallback, (XtCallbackProc) clear_merger, NULL);

	icon = XtVaCreateManagedWidget ("hide_info", commandWidgetClass, f,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNlabel," Remove ",
						XtNfromHoriz, icon,
						NULL);
	XtAddCallback (icon, XtNcallback, (XtCallbackProc) remove_merger, NULL);

	icon = XtVaCreateManagedWidget ("apply_info", commandWidgetClass, f,
						XtNleft, XtChainLeft,
						XtNright, XtChainLeft,
						XtNlabel," Create ",
						XtNfromHoriz, icon,
						NULL);
	XtAddCallback (icon, XtNcallback, (XtCallbackProc) apply_merger, NULL);

	/*
	 * Shell managen
	 */
	XtManageChild(merge_shell);
}




/*********************************************************
 * name:	hide_merger
 * description:	verstecken des Mergerwindows.
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	7.Sep.1993
 *********************************************************/
static void	hide_merger (void)
{
	XtDestroyWidget(merge_shell);
	merge_shell = NULL;
	merge_window = NULL;
}


/*********************************************************
 * name:	clear_merger
 * description:	loeschen und ruecksetzen der felder im Merger
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	7.Sep.1993
 *********************************************************/
static	void	clear_merger (void)
{
	char	*got = getPath(&root);

	XtVaSetValues(merge_window,XtNstring,NULL,NULL);
	XtVaSetValues(t_1,XtNstring,got,NULL);
	XtVaSetValues(tog_1,XtNstate,FALSE);
	XtVaSetValues(tog_2,XtNstate,FALSE);
	free(got);
}



/*********************************************************
 * name:	remove_merger
 * description:	loeschen eines Eintrags aus der Merger-Liste.
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	8.Sep.1993
 *********************************************************/
static	void	remove_merger (void)
{
	XawTextPosition	begin,end;

	XawTextGetSelectionPos (merge_window, &begin, &end);
	if (end > begin) {
		XawTextBlock	text;

		text.ptr = NULL;
		text.length = 0;
		text.firstPos = 0;
		text.format = FMT8BIT;

		XawTextUnsetSelection(merge_window);
		XtVaSetValues(merge_window,XtNeditType,XawtextAppend,NULL);
		XawTextReplace(merge_window,begin,end,&text);
		XtVaSetValues(merge_window,XtNeditType,XawtextRead,NULL);
	}
	else
		WARNING ("You have to select some items before trying\nto remove them from the list.");
}


/*********************************************************
 * name:	apply_merger
 * description:	Ein Tar-Archive erstellen, sofern es moeglich ist.
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	8.Sep.1993
 *********************************************************/
static	void	apply_merger (void)
{
	char	*s;
	char	*a;
	Boolean	gzip;
	Boolean	compress;
	char	*filename;
	FILE	*fp;
	char	dummy[255];

	XtVaGetValues(merge_window,XtNstring,&s,NULL);
	if (!strlen(s)) {
		WARNING("There are no items in this package.\nPut some in before pressing this\nbutton!");
		return;
	}

	a = s;
	while ((a = strchr(a,'\n')))
		*a = ' ';

	XtVaGetValues(tog_1,XtNstate,&compress,NULL);
	XtVaGetValues(tog_2,XtNstate,&gzip,NULL);

	XtVaGetValues(t_1,XtNstring, &filename,NULL);

	if ((a = strrstr(filename,".tar.gz")) ||
	    (a = strrstr(filename,".tar.z")) ||
	    (a = strrstr(filename,".tar.Z")))
		*a = '\0';

	if (compress)
		sprintf(dummy,"%s.tar.Z",filename);
	else if (gzip)
		sprintf(dummy,"%s.tar.gz",filename);
	else
		sprintf(dummy,"%s.tar",filename);

	if ((fp = fopen(dummy,"w"))) {
		char	buf[1024];

		fclose(fp);
		if (compress) {
			sprintf(buf,"tar -cf - %s | compress > %s",s,dummy);
		}
		else if (gzip) {
			sprintf(buf,"tar -cf - %s | gzip > %s",s,dummy);
		}
		else
			sprintf(buf,"tar -cf %s %s",dummy,s);
		system(buf);
		refreshFolderByPathname(filename);
	}
	else
		WARNING("Error: Cannot create package!");
}
