/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"

/*
 * Global variables
 */
static	Widget	text_5, text_6;
static	void	set_root(void);
static	void	do_root(void);

static	char	*newroot;


/*********************************************************
 * name:	hide_dialog
 * description:	loescht das Dialog-Fenster
 * input:	none
 * output:	none
 * date:	0.5.93
 *********************************************************/
void	hide_dialog (void)
{
	XUngrabPointer(XtDisplay(toplevel),CurrentTime);
	XtDestroyWidget (dialog);
	dialog = NULL;
}

/*********************************************************
 * name:	hide_dialog
 * description:	loescht das Dialog-Fenster
 * input:	none
 * output:	none
 * date:	0.5.93
 *********************************************************/
void	hide_idialog (void)
{
	if (oldfile)
		free(oldfile);
	XtDestroyWidget (info_shell);
	info_shell = NULL;
}


/*********************************************************
 * name:	setSize
 * description:	richtiges Setzen der Min-Max-Grenzen
 * input:	none
 * output:	none
 * date:	0.5.93
 *********************************************************/
void	setSize (void)
{
	Arg	args[3];
	Dimension	w,h;

	/*
	 * Max und Minsize setzen
	 */
	XtSetArg(args[0],XtNheight,&h);
	XtSetArg(args[1],XtNwidth,&w);
	XtGetValues(dialog,args,2);

	XtSetArg(args[2],XtNminWidth,w);
	XtSetArg(args[1],XtNmaxHeight,h);
	XtSetArg(args[0],XtNminHeight,h);
	XtSetValues(dialog,args,3);
}


/*********************************************************
 * name:	WARNING
 * description:	erzeugt ein Hinweisfenster
 * input:	char *text
 * output:	none
 * date:	10.6.93
 *********************************************************/
void	WARNING (char *text)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	but = makeDialog(0,NULL,NULL,NULL,NULL,text,FALSE,TRUE,Icon_Warning_PM);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) hide_dialog,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);
/*	XGrabPointer(XtDisplay(toplevel),XtWindow(toplevel), True,
			ButtonReleaseMask | ButtonPressMask,
			GrabModeAsync, GrabModeAsync, XtWindow(dialog), None,
			CurrentTime);
*/}

/*********************************************************
 * name:	init_goto
 * description:	erzeugt den requester fuer das goto
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	init_goto (void)
{
	Widget	but;
	char	*got;

	got = getPath(&root);
	NO_MULTI = TRUE;
	but = makeDialog(1,"Path:",NULL,got,NULL,"Show Directory",TRUE,FALSE,
			 Icon_Goto_PM);
	XtAddCallback(but,XtNcallback,(XtCallbackProc) gotoDir, NULL);
	XtManageChild (dialog);
	free(got);
}


/*********************************************************
 * name:	gotoDir
 * description:	Die Callbackroutine fuer den Goto-Dir-Requester.
 *		Ziel ist es, zunaechst einmal den bestehenden
 *		Pfad nach dem entsprechenden Directory zu
 *		durchsuchen, und eventuell den Pfad aufzufuellen.
 * input:	none.
 * output:	none, Zeigt wenn gefunden das Directory an
 *		und veraendert entsprechend den Directory-baum.
 * author:	Ove Kalkan
 * date:	26.Aug.1993
 *********************************************************/
void	gotoDir (void)
{
	char	*path;
	struct stat	buf;
	Dir_Glyph	*from = NULL;
	char		*got;
	char		*mark;

	/*
	 * Zunaechst einmal muss der Text aus dem Dialog geholt werden
	 */
	XtVaGetValues(text_1,XtNstring,&path,NULL);

	/* Shell zerstoeren */
	if (dialog)
		XtDestroyWidget(dialog);
	dialog = NULL;

	/*
	 * Nachsehen, ob das File auch exisitert und ein Directory-name ist
	 */
	if (stat(path,&buf) == -1) {
		WARNING("Error: Unknown Path!\nCannot show Directory.");
		return;
	}
	if (!S_ISDIR(buf.st_mode)) {
		WARNING("Error: File exists, but\nis not a Directory.");
		return;
	}

	/*
	 * Directory raussuchen
	 */
	from = &root;
	got = getPath(from);
	if (strcmp(got,path)) {
		int	i;
		Boolean	NOTENDE = TRUE;

		/* Hier die Marke setzen */
		if (strncmp(path,got,strlen(got))) {
			NOTENDE = FALSE;
			from = NULL;
		}
		else {
			mark = path+strlen(got)+1;
			mark = strchr(mark,'/');
			if (mark)
				*mark = '\0';
		}
		while (NOTENDE) {
			i = 0;

			if (!from->open)
				fillDir(from);
			while (i < from->dir_count) {
				free(got);
				got = getPath(from->dir[i]);
				if (strcmp(path,got)) {
					i++;
				}
				else {
					from = from->dir[i];
					i = 16000;
					if (mark) {
						*mark++ = '/';
						mark = strchr(mark,'/');
						if (mark)
							*mark = '\0';
					}
					else
						NOTENDE = FALSE;
				}
			}
			if (i < 16000) {
				NOTENDE = FALSE;
				from = NULL;
			}
		}
	}

	/*
	 * Bingo wenn from != NULL
	 */
	free(got);
	if (from) {
		if (defaults.multi_window) {
			if (!from->open && from->dir_count == 0) {
				fillDir(from);
			}
			newFolder (from);
		}
		else {
			selc_f = 16000;
			selc_fo = NULL;
			folders[0]->dir = from;
			if (!from->open && from->dir_count == 0) {
				fillDir(from);
			}
			fillFolder(folders[0]);
			FILE_CHANGED = TRUE;
			refresh_files(folders[0]->window,NULL,NULL,NULL);
			XtVaSetValues(folders[0]->label,XtNlabel,path,NULL);
		}
		DIR_CHANGED = TRUE;
		refresh_dirs(NULL,NULL,NULL,NULL);
	}
	else
		WARNING("Error: Cannot find Directory.\nMake sure that the directory\nresides on your root path.");
}


/*********************************************************
 * name:	init_root
 * description:	erzeugt den requester fuer das change root
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	init_root (void)
{
	Widget	but;
	char	*path = NULL;

#ifdef RESTRICTED_DIRS
	path = getenv("HOME");
#endif
	NO_MULTI = TRUE;
	but = makeDialog(1,"Path:",path,NULL,NULL,"Change Root of Directorytree",
			 TRUE,FALSE,Icon_Root_PM);
	XtAddCallback(but,XtNcallback,(XtCallbackProc) set_root,NULL);
	XtManageChild (dialog);
}

static	void	set_root (void)
{
	struct	stat	buf;
	char	*home;
	Widget	but;

	XtDestroyWidget(dialog);
	dialog = NULL;
	XtVaGetValues(text_1,XtNstring,&home,NULL);
	if (stat(home,&buf)) {
		WARNING("Error: Cannot change rootdir. Path does not exist!");
		return;
	}
	if (!S_ISDIR(buf.st_mode)) {
		WARNING("Error: Cannot change rootdir. File is not a directory");
		return;
	}
	if (!(getFlags(&buf) & DIR_READABLE)) {
		WARNING("Error: Cannot change rootdir. Directory exists but is not accessable!");
		return;
	}
	newroot = (char *) malloc(strlen(home)+1);
	if (!newroot)
		FATAL_ERROR("set_root: malloc failed!");
	sprintf(newroot,"%s",home);

#ifdef	RESTRICTED_DIRS
	home = getenv("HOME");
	if (!strncmp(newroot,home,strlen(home))) {
		WARNING("Error: Cannot access directorys out of the HOME path!");
		free(newroot);
		return;
	}
#endif
	but = makeDialog(0,NULL,NULL,NULL,NULL,"Warning: Because of some internal functions it would\nbe necessary to close all directorywindows to change the root-directory.\nTo continue press the ok button.",
			 TRUE,FALSE,Icon_Warning_PM);
	XtAddCallback(but,XtNcallback,(XtCallbackProc) do_root,NULL);
	XtManageChild (dialog);	
}


static	void	do_root (void)
{
	int	i;

	XtDestroyWidget(dialog);
	dialog = NULL;

	i = folder_count;
	/*
	 * Alle folder loeschen, da sie spaeter auf root zugreifen wuerden
	 * und somit die Pfade zermanscht wuerden.
	 */
	if (defaults.multi_window)
		while (i--)
			hideFolder(NULL,(XtPointer) folders[i],NULL);

	root.name = newroot;
	root.x = 0;
	root.y = 0;
	root.open = TRUE;
	root.parent = NULL;
	root.dir = NULL;
	root.dir_count = 0;

	/*
	 * Den Status des Root-Directories holen
	 */
	{
		struct stat buf;

		(void) stat (root.name,&buf);
		root.flags = getFlags(&buf);
	}

	fillDir(&root);
	if (!defaults.multi_window) {
		Arg	args[1];
		char	*s = getPath(&root);

		selc_f = 16000;
		FILE_CHANGED = TRUE;
		folders[0]->fs_type = FS_NORMAL;
		folders[0]->dir = &root;
		fillFolder(folders[0]);
		refresh_files(folders[0]->window,NULL,NULL,NULL);
		XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
		XtSetValues(folders[0]->label,args,1);
	}
	DIR_CHANGED = TRUE;
	refresh_dirs(NULL,NULL,NULL,NULL);
}


/*********************************************************
 * name:	init_quit
 * description:	Fragen ob Programm beenden oder nicht
 * input:	none
 * output:	none
 * date:	10.6.93
 *********************************************************/
void	init_quit (void)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	but = makeDialog(0,NULL,NULL,NULL,NULL,"Termintate Xfilemanager?",TRUE,TRUE,
			 Icon_Warning_PM);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) quit_all,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);
/*	XGrabPointer(XtDisplay(toplevel),XtWindow(toplevel), True,
			ButtonReleaseMask | ButtonPressMask,
			GrabModeAsync, GrabModeAsync, XtWindow(dialog), None,
			CurrentTime);
*/
}




/*
 * name:	makeDialog
 * description:	erzeugt ein Dialogfenster
 * input:	Dimension text	Anzahl der Textfenster
 *		char	*label1		- Label fuer Textfeld 1
 *		char	*label2		- Label fuer Textfeld 2
 *		char	*text1		- Text der in Textfeld 1 stehen soll
 *		char	*text2		- Text der in Textfeld 2 stehen soll
 *		char	*title		- Ueberschrift des Dialogs
 *		Boolean	CANCEL		- CancelButton erzeugen
 *		Boolean	OVERRIDE	- Ob es eine Override-Shell werden soll
 *		Pixmap	icon		- das Icon
 * output:	den Acceptbuttton zum setzen des Callbacks
 */
Widget	makeDialog(Dimension text, char *label1, char *label2, char *text1,
		   char *text2, char *title, Boolean CANCEL, Boolean OVERRIDE,
		   Pixmap picon)
{
	Arg	args[11];
	Widget	form;
	Widget	icon;
	Widget	label;
	Widget	fl, tl;
	Widget	but, obut;
	int	w;

	/*
	 * Falls noch ein Dialog-Fenster geoeffnet ist, dann loeschen
	 */
	if (dialog)
		XtDestroyWidget(dialog);

	XUngrabPointer(XtDisplay(toplevel),CurrentTime);

	/*
	 * Das DialogWidget erzeugen
	 */
	if (OVERRIDE)
		dialog = XtVaCreatePopupShell ("dialog_shell", 
						overrideShellWidgetClass,
						toplevel, 
						XtNallowShellResize, TRUE,
						XtNtitle,"Xfilemanager - Dialog",
						NULL);
	else
		dialog = XtVaCreatePopupShell ("dialog_shell",
						topLevelShellWidgetClass,
						toplevel, 
						XtNallowShellResize, TRUE,
						NULL);

	/*
	 * Die Form zum Anordnen der Widgets darauf erzeugen
	 */
	form = XtCreateManagedWidget ("dialog_form", formWidgetClass, dialog,
					args, 0);

	/*
	 * Den Simple fuer das Icon erstellen
	 */
	XtSetArg(args[0],XtNtop, XtChainTop);
	XtSetArg(args[1],XtNbottom, XtChainTop);
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[3],XtNleft, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNimageWidth, 32);
	XtSetArg(args[6],XtNimageHeight, 32);
	XtSetArg(args[7],XtNimage, picon);
	icon = XtCreateManagedWidget ("dialog_icon", iconWidgetClass, form,
					args, 8);

	/*
	 * den Label darauf erzeugen, der sagt, das es sich hierbei um
	 * eine Verschiebe-Aktion handelt
	 */
	XtSetArg(args[5],XtNlabel, title);
	XtSetArg(args[6],XtNfromHoriz, icon);
	label = XtCreateManagedWidget ("dialog_title", labelWidgetClass, form,
					args, 7);
	tl = icon;
	if (strchr(title,'\n'))
		tl = label;

	if (text > 0) {
		/*
		 * Die Breite des Widgets fuer eine schoene Ausrichtung des
		 * Widgets ermitteln
		 */
		w = strlen(label1);
		if (text > 1 && strlen(label2) > w)
			w = strlen(label2);
		w *= 10;

		/*
		 * Nun die From Sachen (Label & Text)
		 */
		XtSetArg(args[5],XtNlabel, label1);
		XtSetArg(args[6],XtNfromVert, icon);
		XtSetArg(args[7],XtNwidth, w);
		XtSetArg(args[8],XtNjustify,XtJustifyLeft);
		fl = XtCreateManagedWidget ("dialog_from", labelWidgetClass, form,
						args, 9);

		XtSetArg(args[2],XtNright, XtChainRight);
		XtSetArg(args[4],XtNresizable,TRUE);
		XtSetArg(args[5],XtNfromHoriz, fl);
		XtSetArg(args[7],XtNeditType, XawtextEdit);
		XtSetArg(args[8],XtNresize, XawtextResizeWidth);
		XtSetArg(args[9],XtNstring, text1);
		XtSetArg(args[10], XtNwidth, 150);
		text_1 = XtCreateManagedWidget("dialog_text1", asciiTextWidgetClass,
						form, args,11);
		XtOverrideTranslations(text_1, XtParseTranslationTable(
						"<Key>Return: no-op()"));
		if (MULTI && !NO_MULTI) {
			XtVaSetValues(text_1,
					XtNeditType,XawtextRead,
					XtNdisplayCaret,FALSE,
					XtNcursor, def_cursor,
					XtNheight, 70,
					XtNscrollVertical, XawtextScrollWhenNeeded,
					NULL);
		}
		tl = text_1;
	}
	NO_MULTI = FALSE;
	if (text > 1) {
		/*
		 * Nun die To Sachen (Label & Text)
		 */
		XtSetArg(args[2],XtNright, XtChainLeft);
		XtSetArg(args[4],XtNborderWidth, 0);
		XtSetArg(args[5],XtNlabel, label2);
		XtSetArg(args[6],XtNfromVert, tl);
		XtSetArg(args[7],XtNwidth, w);
		XtSetArg(args[8],XtNjustify,XtJustifyLeft);
		fl = XtCreateManagedWidget ("dialog_from", labelWidgetClass, form,
						args, 9);

		XtSetArg(args[2],XtNright, XtChainRight);
		XtSetArg(args[4],XtNresizable,TRUE);
		XtSetArg(args[5],XtNfromHoriz, fl);
		XtSetArg(args[7],XtNeditType, XawtextEdit);
		XtSetArg(args[8],XtNresize, XawtextResizeWidth);
		XtSetArg(args[9],XtNstring, text2);
		text_2 = XtCreateManagedWidget("dialog_text2", asciiTextWidgetClass,
						form, args,11);
		XtOverrideTranslations(text_2, XtParseTranslationTable(
						"<Key>Return: no-op()"));
		tl = fl;
	}

	/*
	 * Zum Schluss noch die 2 Buttons
	 */
	but = NULL;
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[5],XtNfromVert, tl);
	XtSetArg(args[6],XtNvertDistance, 10);

	/*
	 * wenn gewuenscht, den Cancel Button
	 */
	if (CANCEL) {
		XtSetArg(args[4],XtNlabel, " Cancel ");
		but = XtCreateManagedWidget ("dialog_cancel", commandWidgetClass, form,
						args, 7);
		XtAddCallback(but,XtNcallback, (XtCallbackProc) hide_dialog, NULL);
	}

	/*
	 * Immer den OK-Button
	 */
	XtSetArg(args[4],XtNlabel, "   Ok   ");
	XtSetArg(args[7],XtNfromHoriz, but);
	obut = XtCreateManagedWidget ("dialog_accept", commandWidgetClass, form,
					args, 8);

	/*
	 * Hier die Position der Maus feststellen und das Fenster so plazieren,
	 * das der Mauszeiger genau ueber dem Cancel-Button ist
	 */
	{
		Window	a,b;
		int	ax,ay,bx,by;
		unsigned int	m;
		XtWidgetGeometry	ra,rb;

		XQueryPointer(XtDisplay(toplevel),XtWindow(toplevel),
				&a,&b,&ax,&ay,&bx,&by,&m);
		ra.x = (0 > ax - 30 ? 0 : ax - 30);
		ra.y = (0 > ay - 60 - text*24 ? 0 : ay - 60 - text*24);
		ra.request_mode = CWX | CWY;
		XtMakeGeometryRequest(dialog,&ra,&rb);
	}
	return(obut);
}




/*********************************************************
 * name:	quit_all
 * description:	Programmende, nachdem Quit bestaetigt wurde
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	quit_all (void)
{
	if (defaults.save_ws_on_exit)
		saveWorkspace(&workspace);
	exit(0);
}



/*********************************************************
 * name:	init_info
 * description:	erzeugt den file_info-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	init_info(void)
{
	Widget	form, icon,f;
	Widget	label, w, bw[4];
	extern	char *getString(void);
	extern	char *getPath(Dir_Glyph *dir);
	char	*file;
	Arg	args[11];
	struct	stat	buf;
	char	dummy[256];
	uid_t	uid = getuid();
	gid_t	gid = getgid();
	int	b = 0;
	struct	passwd *pw;
	struct	group *gr;
	WidgetClass	class;


	/*
	 * erst alten Dialog zerstoeren
	 */
	if (info_shell)
		XtDestroyWidget(info_shell);

	XUngrabPointer(XtDisplay(toplevel),CurrentTime);
	oldfile = getString();		/* Filenamen zum verifizieren sichern */

	/*
	 * Das DialogWidget erzeugen
	 */
	XtSetArg(args[0],XtNallowShellResize,TRUE);
	XtSetArg(args[1],XtNtransientFor, toplevel);
	XtSetArg(args[2],XtNtitle,"Xfilemanager - Fileinformation");
	info_shell = XtCreatePopupShell ("dialog_shell", topLevelShellWidgetClass,
					toplevel, args, 3);

	/*
	 * Die Form zum Anordnen der Widgets darauf erzeugen
	 */
	form = XtCreateManagedWidget ("dialog_form", formWidgetClass, info_shell,
					args, 0);
	/*
	 * Den Simple fuer das Icon erstellen
	 */
	XtSetArg(args[0],XtNtop, XtChainTop);
	XtSetArg(args[1],XtNbottom, XtChainTop);
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[3],XtNleft, XtChainLeft);
	XtSetArg (args[4],XtNimageWidth, 32);
	XtSetArg (args[5],XtNimageHeight, 32);
	XtSetArg (args[6],XtNborderWidth, 0);
	XtSetArg (args[7],XtNimage, Icon_Info_PM);
	icon = XtCreateManagedWidget ("dialog_icon", iconWidgetClass, form,
					args, 8);

	/*
	 * den Label darauf erzeugen, der sagt, das es sich hierbei um
	 * eine Verschiebe-Aktion handelt
	 */
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNfromHoriz, icon);
	XtSetArg(args[6],XtNlabel,"File-Information");
	label = XtCreateManagedWidget ("info_title", labelWidgetClass, form,
					args, 7);

	/*
	 * Den Status des Files fuer die uebrigen Boxen holen
	 */
	file = getString();
	lstat (file,&buf);

	/*
	 * Die Box fuer den Filenamen
	 */
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[7],XtNlabel,"Filename :");
	XtSetArg(args[8],XtNfromVert, icon);
	label = XtCreateManagedWidget ("info_name", labelWidgetClass, form,
					args, 9);

	free (file);
	if (selc_g)
		file = selc_g->name;
	else
		file = selc_fo->file[selc_f]->name;

	XtSetArg(args[2],XtNright, XtChainRight);
	XtSetArg(args[4],XtNfromHoriz, label);
	XtSetArg(args[5],XtNfromVert, icon);
	if ((uid == buf.st_uid || uid == 0) && strcmp(file,"..")) {	/* Filename veraenderbar fuer Owner
						   und Root */
		XtSetArg(args[6],XtNeditType, XawtextEdit);
		XtSetArg(args[7],XtNstring, file);
		XtSetArg(args[8],XtNresize, XawtextResizeWidth);
		XtSetArg(args[9],XtNwidth, 13*strlen(file));
		XtSetArg(args[10],XtNresizable, TRUE);
		text_5 = XtCreateManagedWidget("name_text", asciiTextWidgetClass,
						form, args,11);
		XtOverrideTranslations(text_5, XtParseTranslationTable(
						"<Key>Return: no-op()"));
	}
	else {
		XtSetArg(args[6],XtNlabel, file);
		XtSetArg(args[7],XtNborderWidth, 0);
		XtSetArg(args[8],XtNjustify, XtJustifyLeft);
		text_5 = XtCreateManagedWidget("name_text", labelWidgetClass,
						form, args,9);
	}

#ifndef COHERENT
	/* Es handelt sich um einen Link, also noch das Target ausgeben */
	text_4 = NULL;
	if ((selc_g && (selc_g->flags & DIR_LINK)) || (selc_fo && selc_f < 16000 &&
	     (selc_fo->file[selc_f]->prog_type == FILE_LINK ||
	      selc_fo->file[selc_f]->prog_type == FILE_LDIR))) {
		int	length = 0;
		int	flag = 0;

		XtSetArg(args[2],XtNright,XtChainLeft);
		XtSetArg(args[3],XtNleft,XtChainLeft);
		XtSetArg(args[4],XtNborderWidth,0);
		XtSetArg(args[5],XtNlabel,"Link to :");
		XtSetArg(args[7],XtNfromVert, text_5);
		XtSetArg(args[6],XtNjustify, XtJustifyRight);
		XtSetArg(args[8],XtNwidth,150);
		label = XtCreateManagedWidget("link_info",labelWidgetClass,form,args,9);

		file = getString();
		if (oldfile)
			length = readlink(oldfile,link_target,255);
		if (length < 0) {
			flag = 1;
			sprintf(link_target,"Link failure");
		}
		else
			link_target[length] = '\0';

		XtSetArg(args[2],XtNright,XtChainLeft);
		XtSetArg(args[4],XtNfromHoriz, label);
		XtSetArg(args[5],XtNfromVert, text_5);
		if ((uid == buf.st_uid || uid == 0) && !flag) {
			XtSetArg(args[6],XtNlabel, link_target);
			text_4 = XtCreateManagedWidget("link_text", commandWidgetClass,
							form, args,7);
			XtAddCallback(text_4,XtNcallback,(XtCallbackProc) call_link_cb,NULL);
		}
		else {
			XtSetArg(args[6],XtNlabel, link_target);
			XtSetArg(args[7],XtNborderWidth, 0);
			XtSetArg(args[8],XtNjustify, XtJustifyLeft);
			text_4 = XtCreateManagedWidget("name_text", labelWidgetClass,
							form, args,9);
		}
	}
	else 
#endif	/* Coherent Unix kann keine Links */
	{
		XtSetArg(args[2],XtNright, XtChainLeft);
		XtSetArg(args[3],XtNleft, XtChainLeft);
		XtSetArg(args[4],XtNborderWidth, 0);
		XtSetArg(args[5],XtNwidth, 150);
		XtSetArg(args[6],XtNjustify, XtJustifyRight);
		XtSetArg(args[7],XtNlabel,"Filetype :");
		XtSetArg(args[8],XtNfromVert, text_5);
		label = XtCreateManagedWidget ("info_name", labelWidgetClass, form,
					args, 9);
		/*
		 * Kurzbeschreibung
		 */
		XtSetArg(args[5],XtNfromHoriz,label);
		XtSetArg(args[8],XtNfromVert,text_5);
		if (selc_g)
			XtSetArg(args[7],XtNlabel,"Directory");
		else if (selc_fo && selc_f < 16000) {
			File_Glyph	*ff = selc_fo->file[selc_f];

			if (ff->prog_type < max_filetypes) {
				XtSetArg(args[7],XtNlabel,
					 filetypes[ff->prog_type].description);
			}
			else {
				switch (ff->prog_type) {
				case FILE_EXEC:
					XtSetArg(args[7],XtNlabel,"Executable");
					break;
				case FILE_TAR:
					XtSetArg(args[7],XtNlabel,"Tar-Archive");
					break;
				case FILE_CTAR:
					XtSetArg(args[7],XtNlabel,"Compressed Tar-Archive");
					break;
				case FILE_DIR:
					XtSetArg(args[7],XtNlabel,"Directory");
					break;
				case FILE_GHOST:
					XtSetArg(args[7],XtNlabel,"Empty File");
					break;
				case FILE_ROOT:
					XtSetArg(args[7],XtNlabel,"Parent Directory");
					break;
				default:
					XtSetArg(args[7],XtNlabel,"Unknown File");
				}
			}
		}
		else
			XtSetArg(args[7],XtNlabel,"Unknown File");
		label = XtCreateManagedWidget ("info_name", labelWidgetClass, form,
						args, 9);
	}
	w = label;

	/*
	 * Die Box fuer den Filepath
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[3],XtNleft, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth,0);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[7],XtNlabel,"Location :");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_name", labelWidgetClass, form,
					args, 9);

	if (selc_g) {
		if (selc_g->parent)
			file = getPath(selc_g->parent);
		else
			file = NULL;
	}
	else
		file = getPath(selc_fo->dir);

	XtSetArg(args[6],XtNfromHoriz, label);
	XtSetArg(args[5],XtNfromVert, w);
	XtSetArg(args[7],XtNlabel, file);
	w = XtCreateManagedWidget("location_text", labelWidgetClass,
					form, args,8);
	if (file)
		free(file);

	/*
	 * Die Box fuer den Filegroesse
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[7],XtNlabel,"Size :");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_name", labelWidgetClass, form,
					args, 9);

	sprintf(dummy,"%d Bytes",buf.st_size);
	XtSetArg(args[6],XtNfromHoriz, label);
	XtSetArg(args[5],XtNfromVert, w);
	XtSetArg(args[7],XtNlabel, dummy);
	w = XtCreateManagedWidget("location_text", labelWidgetClass,
					form, args,8);

	/*
	 * Die Box fuer den Owner
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[7],XtNlabel,"Owner :");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_owner", labelWidgetClass, form,
					args, 9);

	/*
	 * Username holen
	 */
	pw = getpwuid(buf.st_uid);
	if (pw)
		sprintf(dummy,"%s",pw->pw_name);
	else
		sprintf(dummy,"Unknown User");

	XtSetArg(args[4],XtNfromVert, w);
	XtSetArg(args[5],XtNfromHoriz, label);
	if (uid == buf.st_uid || uid == 0) {	/* Filename veraenderbar fuer Owner
						   und Root */
		XtSetArg(args[2],XtNright, XtChainRight);
		XtSetArg(args[6],XtNeditType, XawtextEdit);
		XtSetArg(args[7],XtNstring,  dummy);
		XtSetArg(args[8],XtNwidth, 13*strlen(dummy));
		XtSetArg(args[9],XtNresize, XawtextResizeWidth);
		XtSetArg(args[10],XtNresizable, TRUE);
		text_6 = XtCreateManagedWidget("name_text", asciiTextWidgetClass,
						form, args,11);
		XtOverrideTranslations(text_6, XtParseTranslationTable(
						"<Key>Return: no-op()"));
	}
	else {
		XtSetArg(args[6],XtNlabel, dummy);
		XtSetArg(args[7],XtNborderWidth, 0);
		XtSetArg(args[8],XtNjustify, XtJustifyLeft);
		text_6 = XtCreateManagedWidget("name_text", labelWidgetClass,
						form, args,9);
	}
	w = label;

	/*
	 * Die Box fuer den Groups
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[7],XtNlabel,"Group :");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_group", labelWidgetClass, form,
					args, 9);

	/*
	 * Groupname holen
	 */
	gr = getgrgid(buf.st_gid);
	if (gr)
		sprintf(dummy,"%s",gr->gr_name);
	else
		sprintf(dummy,"Unknown Group");
	XtSetArg(args[4],XtNfromVert, w);
	XtSetArg(args[5],XtNfromHoriz, label);
	if (uid == buf.st_uid || uid == 0) {	/* Filename veraenderbar fuer Owner
						   und Root */
		XtSetArg(args[2],XtNright, XtChainRight);
		XtSetArg(args[6],XtNeditType, XawtextEdit);
		XtSetArg(args[7],XtNstring,  dummy);
		XtSetArg(args[8],XtNwidth, 13*strlen(dummy));
		XtSetArg(args[9],XtNresize, XawtextResizeWidth);
		XtSetArg(args[10],XtNresizable, TRUE);
		text_3 = XtCreateManagedWidget("name_text", asciiTextWidgetClass,
						form, args,11);
		XtOverrideTranslations(text_3, XtParseTranslationTable(
						"<Key>Return: no-op()"));
	}
	else {
		XtSetArg(args[6],XtNlabel, dummy);
		XtSetArg(args[7],XtNborderWidth, 0);
		XtSetArg(args[8],XtNjustify, XtJustifyLeft);
		text_3 = XtCreateManagedWidget("name_text", labelWidgetClass,
						form, args,9);
	}
	w = label;

	/*
	 * Die Box fuer die Createion Time
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[7],XtNlabel,"Creation Time :");
	XtSetArg(args[8],XtNfromVert, w);
/*	label = XtCreateManagedWidget ("info_group", labelWidgetClass, form,
					args, 9);

	{
		struct	tm	*tt;

		tt = localtime (&buf.st_ctime);
		sprintf(dummy,"%d.%d.%d",tt->tm_mday,tt->tm_mon+1,1900+tt->tm_year);
	}
	XtSetArg(args[8],XtNfromVert,w);
	XtSetArg(args[7],XtNlabel,dummy);
	XtSetArg(args[5],XtNfromHoriz,label);
	label = XtCreateManagedWidget ("creat_time", labelWidgetClass, form,
					args,9);
	w = label;
*/
	/*
	 * Die Box fuer die Modification Time
	 */
	XtSetArg(args[5],XtNwidth, 150);
	XtSetArg(args[7],XtNlabel,"Last Modification :");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_group", labelWidgetClass, form,
					args, 9);

	{
		struct	tm	*tt;

		tt = localtime (&buf.st_mtime);
		if (tt)
			sprintf(dummy,"%d.%d.%d",tt->tm_mday,tt->tm_mon+1,1900+tt->tm_year);
		else
			sprintf(dummy,"No Time");
	}
	XtSetArg(args[8],XtNfromVert,w);
	XtSetArg(args[7],XtNlabel,dummy);
	XtSetArg(args[5],XtNfromHoriz,label);
	label = XtCreateManagedWidget ("creat_time", labelWidgetClass, form,
					args,9);
	w = label;

	/*
	 * Nun die Dialogbox fuer die Rechte
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 80);
	XtSetArg(args[6],XtNjustify, XtJustifyLeft);
	XtSetArg(args[7],XtNlabel,"");
	XtSetArg(args[8],XtNfromVert, w);
	label = XtCreateManagedWidget ("info_empty", labelWidgetClass, form,
					args, 9);	
	XtSetArg(args[6],XtNjustify, XtJustifyCenter);
	XtSetArg(args[5],XtNwidth, 70);
	XtSetArg(args[7],XtNlabel,"Read");
	XtSetArg(args[9],XtNfromHoriz,label);
	bw[1] = XtCreateManagedWidget ("info_ruser", labelWidgetClass, form,
					args, 10);	
	XtSetArg(args[7],XtNlabel,"Write");
	XtSetArg(args[9],XtNfromHoriz,bw[1]);
	bw[2] = XtCreateManagedWidget ("info_wuser", labelWidgetClass, form,
					args, 10);	
	XtSetArg(args[7],XtNlabel,"Execute");
	XtSetArg(args[9],XtNfromHoriz,bw[2]);
	bw[3] = XtCreateManagedWidget ("info_xuser", labelWidgetClass, form,
					args, 10);

	/*
	 * Rechte des Owners darstellen
	 */
	w = label;
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[5],XtNwidth, 80);
	XtSetArg(args[8],XtNfromVert, w);
	XtSetArg(args[7],XtNlabel,"Owner :");		
	label = XtCreateManagedWidget ("info_empty", labelWidgetClass, form,
					args, 9);

	if (uid == buf.st_uid || uid == 0) {
		class = toggleWidgetClass;
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[10],XtNstate, (S_IRUSR&buf.st_mode ? TRUE : FALSE));
		tog[0] = XtCreateManagedWidget ("toggle", class, form,
					args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[0]);
		XtSetArg(args[10],XtNstate, (S_IWUSR&buf.st_mode ? TRUE : FALSE));
		tog[1] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[1]);
		XtSetArg(args[10],XtNstate, (S_IXUSR&buf.st_mode ? TRUE : FALSE));
		tog[2] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
	}
	else {
		class = labelWidgetClass;
		XtSetArg(args[7],XtNlabel, (S_IRUSR&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		tog[0] = XtCreateManagedWidget ("toggler", class, form,
						args, 10);	
		XtSetArg(args[7],XtNlabel, (S_IWUSR&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[0]);
		tog[1] = XtCreateManagedWidget ("toggler", class, form,
						args, 10);
		XtSetArg(args[7],XtNlabel, (S_IXUSR&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[1]);
		tog[2] = XtCreateManagedWidget ("toggler", class, form,
						args, 10);
	}

	/*
	 * Rechte der Group darstellen
	 */
	w = label;
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[5],XtNwidth, 80);
	XtSetArg(args[8],XtNfromVert, w);
	XtSetArg(args[7],XtNlabel,"Group :");		
	label = XtCreateManagedWidget ("info_empty", labelWidgetClass, form,
					args, 9);

	if (uid == buf.st_uid || uid == 0) {
		class = toggleWidgetClass;
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[10],XtNstate, (S_IRGRP&buf.st_mode ? TRUE : FALSE));
		tog[3] = XtCreateManagedWidget ("toggle", class, form,
					args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[3]);
		XtSetArg(args[10],XtNstate, (S_IWGRP&buf.st_mode ? TRUE : FALSE));
		tog[4] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[4]);
		XtSetArg(args[10],XtNstate, (S_IXGRP&buf.st_mode ? TRUE : FALSE));
		tog[5] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
	}
	else {
		class = labelWidgetClass;
		XtSetArg(args[7],XtNlabel, (S_IRGRP&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		tog[3] = XtCreateManagedWidget ("tog_ruser", class, form,
						args, 10);	
		XtSetArg(args[7],XtNlabel, (S_IWGRP&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[3]);
		tog[4] = XtCreateManagedWidget ("tog_wuser", class, form,
						args, 10);
		XtSetArg(args[7],XtNlabel, (S_IXGRP&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[4]);
		tog[5] = XtCreateManagedWidget ("tog_xuser", class, form,
						args, 10);
	}

	/*
	 * Rechte der Others darstellen
	 */
	w = label;
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[6],XtNjustify, XtJustifyRight);
	XtSetArg(args[5],XtNwidth, 80);
	XtSetArg(args[8],XtNfromVert, w);
	XtSetArg(args[7],XtNlabel,"Other :");		
	label = XtCreateManagedWidget ("info_empty", labelWidgetClass, form,
					args, 9);

	if (uid == buf.st_uid || uid == 0) {
		class = toggleWidgetClass;
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[10],XtNstate, (S_IROTH&buf.st_mode ? TRUE : FALSE));
		tog[6] = XtCreateManagedWidget ("toggle", class, form,
					args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[6]);
		XtSetArg(args[10],XtNstate, (S_IWOTH&buf.st_mode ? TRUE : FALSE));
		tog[7] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
		XtSetArg(args[7],XtNlabel,"  ");
		XtSetArg(args[9],XtNfromHoriz,tog[7]);
		XtSetArg(args[10],XtNstate, (S_IXOTH&buf.st_mode ? TRUE : FALSE));
		tog[8] = XtCreateManagedWidget ("toggle", class, form,
						args, 11);
	}
	else {
		class = labelWidgetClass;
		XtSetArg(args[7],XtNlabel, (S_IROTH&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[4],XtNborderWidth, 1);
		XtSetArg(args[6],XtNjustify, XtJustifyCenter);
		XtSetArg(args[5],XtNwidth, 70);
		XtSetArg(args[9],XtNfromHoriz,label);
		tog[6] = XtCreateManagedWidget ("tog_ruser", class, form,
						args, 10);	
		XtSetArg(args[7],XtNlabel, (S_IWOTH&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[6]);
		tog[7] = XtCreateManagedWidget ("tog_wuser", class, form,
						args, 10);
		XtSetArg(args[7],XtNlabel, (S_IXOTH&buf.st_mode ? "Yes" : "No"));
		XtSetArg(args[9],XtNfromHoriz,tog[7]);
		tog[8] = XtCreateManagedWidget ("tog_xuser", class, form,
						args, 10);
	}

	/*
	 * Zum Schluss noch eine Form fuer die Buttons erzeugen
	 */
	XtSetArg(args[0],XtNtop, XawChainBottom);
	XtSetArg(args[1],XtNbottom, XawChainBottom);
	XtSetArg(args[2],XtNleft, XawChainLeft);
	XtSetArg(args[3],XtNright, XawChainRight);
	XtSetArg(args[4],XtNborderWidth,0);
	XtSetArg(args[5],XtNfromVert, label);
	XtSetArg(args[6],XtNvertDistance, 20);
	f = XtCreateManagedWidget("info_cform",formWidgetClass,form,args,7);

	/*
	 * In der neuen Form die Commandbuttons erzeugen
	 */
	XtSetArg(args[0],XtNleft, XawChainLeft);
	XtSetArg(args[1],XtNright, XawChainLeft);
	XtSetArg(args[2],XtNlabel, "  Hide  ");
	w = XtCreateManagedWidget("hide_info",commandWidgetClass,f,args,3);
	XtAddCallback(w,XtNcallback,(XtCallbackProc) hide_idialog,NULL);

	{
		int	a = (uid == buf.st_uid || uid == 0 ? 0 : 1);

		XtSetArg(args[0],XtNleft, XawChainLeft);
		XtSetArg(args[1],XtNright, XawChainLeft);
		XtSetArg(args[2],XtNlabel, " Reset ");
		XtSetArg(args[3],XtNhorizDistance,160);
		XtSetArg(args[4],XtNfromHoriz, w);
		XtSetArg(args[5],XtNsensitive,FALSE);
		w = XtCreateManagedWidget("hide_info",commandWidgetClass,f,args,5+a);
		XtAddCallback(w,XtNcallback,(XtCallbackProc) reset_cb,NULL);

		XtSetArg(args[0],XtNleft, XawChainLeft);
		XtSetArg(args[1],XtNright, XawChainLeft);
		XtSetArg(args[2],XtNlabel, " Apply ");
		XtSetArg(args[3],XtNfromHoriz, w);
		XtSetArg(args[4],XtNsensitive,FALSE);
		w = XtCreateManagedWidget("apply_info",commandWidgetClass,f,args,4+a);
		XtAddCallback(w,XtNcallback,(XtCallbackProc) apply_cb,NULL);
	}

	XtManageChild(info_shell);
}



/*********************************************************
 * name:	apply_cb
 * description:	change modes, owners and names of files
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	1.7.93
 *********************************************************/
void	apply_cb(void)
{
	Boolean		b;
	Arg		args[1];
	mode_t		mode = 0;
	struct	stat	buf;
	char		*of, *nf;

	/*
	 * Bisherige Rechte des Files holen und nur die Benutzerrechte,
	 * keine speziellen flags loeschen
	 */
	lstat(oldfile,&buf);
	mode = buf.st_mode & ~(S_IRUSR | S_IWUSR | S_IXUSR |
			       S_IRGRP | S_IWGRP | S_IXGRP |
			       S_IROTH | S_IWOTH | S_IXOTH);

	/*
	 * Benutzerrechte holen und setzen
	 */
	XtSetArg(args[0],XtNstate,&b);
	XtGetValues(tog[0],args,1);
	mode |= (b ? S_IRUSR : 0);
	XtGetValues(tog[1],args,1);
	mode |= (b ? S_IWUSR : 0);
	XtGetValues(tog[2],args,1);
	mode |= (b ? S_IXUSR : 0);
	XtGetValues(tog[3],args,1);
	mode |= (b ? S_IRGRP : 0);
	XtGetValues(tog[4],args,1);
	mode |= (b ? S_IWGRP : 0);
	XtGetValues(tog[5],args,1);
	mode |= (b ? S_IXGRP : 0);
	XtGetValues(tog[6],args,1);
	mode |= (b ? S_IROTH : 0);
	XtGetValues(tog[7],args,1);
	mode |= (b ? S_IWOTH : 0);
	XtGetValues(tog[8],args,1);
	mode |= (b ? S_IXOTH : 0);

	if (mode != buf.st_mode)
		chmod (oldfile,mode);

	/*
	 * File umbenennen falls erforderlich
	 */
	XtSetArg(args[0],XtNstring,&nf);
	XtGetValues(text_5,args,1);

	of = strrchr(oldfile,'/') + 1;
	if (strcmp(of,nf)) {
		char 	*p;

		p = strrchr(oldfile,'/');
		if (p) {
			int	i;
			char	sa[1024];

			*p = '\0';
			sprintf(sa,"mv %s/%s %s/%s",oldfile,of,oldfile,nf);
			SYSTEM(sa);

			i = strlen(oldfile);
			*p = '/';
			/* Oldfile wird fuer das chown auf newfile gesetzt */
			if (!(oldfile = (char *) realloc((void *) oldfile,
							 i + strlen(nf) + 2)))
				FATAL_ERROR("apply_cb: realloc failed");
			strncpy(&oldfile[i+1],nf,strlen(nf));
			oldfile[i+1+strlen(nf)] = '\0';
		}
	}
	/*
	 * Group und Owner setzen - Owner zuletzt
	 */
	{
		char	*grp, *own;
		uid_t	uid;
		gid_t	gid;

		struct	passwd	*pws;
		struct	group	*grs;

		/*
		 * Namen der Group oder des Owners holen
		 */
		XtSetArg(args[0],XtNstring, &grp);
		XtGetValues(text_3,args,1);
		XtSetArg(args[0],XtNstring, &own);
		XtGetValues(text_6,args,1);
		/*
		 * Zu den Namen die UserId und die GroupId holen, falls moeglich
		 */

		pws = getpwnam (own);
		if (pws) {
			uid = pws->pw_uid;
		}
		else {
			WARNING("Change Owner: Not a valid user");
			return;
		}
		grs = getgrnam (grp);
		if (grs) {
			gid = grs->gr_gid;
		}
		else {
			WARNING("Change Group: Not a valid group");
			return;
		}
		chown(oldfile,uid,gid);
	}
}


/*********************************************************
 * name:	reset_cb
 * description:	reset modes, owners and names of files
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	1.7.93
 *********************************************************/
void	reset_cb(void)
{
	struct	stat	buf;
	Arg		args[1];
	struct	passwd	*pw;
	struct	group	*gr;
	char		*b;

	/*
	 * Status des urspruenglich angewaehlten Files wieder herstellen
	 */
	lstat(oldfile,&buf);

	/*
	 * Filenamen ruecksetzen
	 */
	b = strrchr(oldfile,'/');
	XtSetArg(args[0],XtNstring,b+1);
	XtSetValues(text_5,args,1);

	/*
	 * Owner und Groups ruecksetzen
	 */
	pw = getpwuid(buf.st_uid);
	XtSetArg(args[0],XtNstring,pw->pw_name);
	XtSetValues(text_6,args,1);

	gr = getgrgid(buf.st_gid);
	XtSetArg(args[0],XtNstring,gr->gr_name);
	XtSetValues(text_3,args,1);

	/*
	 * Rightflags ruecksetzen
	 */
	XtSetArg(args[0],XtNstate, (S_IRUSR&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[0],args,1);
	XtSetArg(args[0],XtNstate, (S_IWUSR&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[1],args,1);
	XtSetArg(args[0],XtNstate, (S_IXUSR&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[2],args,1);
	XtSetArg(args[0],XtNstate, (S_IRGRP&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[3],args,1);
	XtSetArg(args[0],XtNstate, (S_IWGRP&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[4],args,1);
	XtSetArg(args[0],XtNstate, (S_IXGRP&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[5],args,1);
	XtSetArg(args[0],XtNstate, (S_IROTH&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[6],args,1);
	XtSetArg(args[0],XtNstate, (S_IWOTH&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[7],args,1);
	XtSetArg(args[0],XtNstate, (S_IXOTH&buf.st_mode ? TRUE : FALSE));
	XtSetValues(tog[8],args,1);

}



/*********************************************************
 * name:	getFilter
 * description:	Den Filterstring fuer einen Folder berechnen
 * input:	Folder_Glyph *folder;
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.1993
 *********************************************************/
void	getFilter (Folder_Glyph *folder)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	NO_MULTI = TRUE;
	but = makeDialog(1,"Filter :",folder->filter,NULL,NULL,"Filefilter",TRUE,FALSE,Icon_Filter_PM);
	XtAddCallback(but,XtNcallback,(XtCallbackProc) apply_filter,(XtPointer) folder);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}



/*********************************************************
 * name:	apply_filter
 * description:	Den Filterstring fuer einen Folder setzen
 *		und refreshen
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.1993
 *********************************************************/
void	apply_filter (Widget w, XtPointer c, XtPointer s)
{
	char		*a;
	Folder_Glyph	*f = (Folder_Glyph *) c;
	Arg		args[1];

	XtSetArg(args[0],XtNstring,&a);
	XtGetValues(text_1,args,1);
	if (f->filter)
		free(f->filter);
	if (strlen(a))
		f->filter = a;
	else
		f->filter = NULL;
	XtDestroyWidget(dialog);
	dialog = NULL;
	if (selc_fo == f) {
		selc_fo = f;
		selc_f = 16000;
	}
	fillFolder(f);
	FILE_CHANGED = TRUE;
	refresh_files(f->window,NULL,NULL,NULL);
}


#ifndef COHERENT
/*********************************************************
 * name:	call_link_cb
 * description:	aufrufen von init_link
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	Friday, 13th.Aug.1993
 *********************************************************/
void	call_link_cb(void)
{
	init_link(oldfile,link_target);
}
#endif
