/* #module    IdxTeX    "3-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */
/*
 * Module Name:	IdxTeX
 *
 * Author:	R L Aurbach	CR&DS MIS Group    26-Apr-1986
 *
 * Function:
 *	Main Line of the IdxTeX program.  This program processes .idx files
 *	produced by LaTeX and generates files which will produce a properly
 *	formatted index.
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	26-Apr-1986	Original Code
 * 1-002	RLA	13-Jun-1986	Add support for /TOC qualifier
 * 1-003	RLA	06-Apr-1987	Change version number to 1.2 to reflect
 *					  corrections with spelling processing
 * 2-004	RLA	07-Apr-1987	Add range and master index support.
 * 3-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module IdxTeX - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#include <stdlib.h>
#include <io.h>
#define F_OK		0	/* access(): File exists */
#else
#	include <sys/file.h>
/*extern char *sprintf();*/
#endif
#include <stdio.h>
/* #include <malloc.h> */
#include "IdxDef.h"
/*
 * Module Definitions:
 */
#define   TRUE	1
#define   FALSE	0
#define   linebfsize	133	/* Max size of a line */
/*
 * Global Declarations:
 */
    TREE_PTR	    root = 0;	/* Root of the Index Tree */
/*
 * Static Declarations:
 */
#ifdef MSDOS
void main(int argc, char *argv[]);
#lse
void main();
#endif
/*
 * External References:
 */
#ifdef MSDOS
extern void idx_command(int argc, char *argv[], char *file,
	int *toc_flag, int *mst_flag);
extern int idx_parse_master(char *linebf, char *filename, char *vol_ptr);
extern void idx_process_file(char *filename, char *vol);
extern void idx_generate(FILE *file, int toc_flag, int mst_flag);
#else
extern void idx_command();
extern int idx_parse_master();
extern void idx_process_file();
extern void idx_generate();
#endif
/*
 * Functions Called:
 */
/*
 * Function IdxTeX - Documentation Section
 *
 * Discussion:
 *	This is the main line of the IdxTeX program.  It reads the input file,
 *	parsing the information, and generates an output file based on the 
 *	information from the input file.
 *
 * Calling Synopsis:
 *	$ IdxTeX :== $Crl_Public:IdxTeX
 *	$ IdxTeX filespec [/TOC:{ARTICLE | REPORT}] [/MASTER]
 *
 * Inputs:
 *	filespec	    ->	Name of the input file to be processed.  The
 *				default filespec SYS$DISK:[].IDX is processed
 *				against this specification.  If the /MASTER
 *				qualifier is present, the default file type is
 *				.MDX.
 *
 * Outputs:
 *	filespec	    ->	The program produces an output file which is
 *				the resultant filespec from processing .IND as
 *				the primary file specification and the fully-
 *				qualified input filespec as the default.
 *
 * Return Value:
 *	returns SUCCESS
 *
 * Global Data:
 *	none
 *
 * Files Used:
 *	reads an input file as specified above.
 *	produces an output file as specified above.
 *
 * Assumed Entry State:
 *	Called from DCL level.
 *
 * Normal Exit State:
 *	Returns to DCL level.
 *
 * Error Conditions:
 *	Input file not found	-- program issues a message and exits 
 *				    immediately.
 *	Input file format error -- program ignores any lines of the input file
 *				    which it does not understand.
 *
 * Algorithm:
 *	A. Call Idx_Command to process the command line.
 *	B. If processing a master index,
 *	    1. Open the Master Index input file.
 *	    2. For all records in the file,
 *		a. Read the next record.
 *		b. Call Idx_Process_File to process it.
 *	    3. Close the Master Index input file.
 *	C. Else,
 *	    1. Call Idx_Process_File to process the input file.
 *	D. Open the output file.
 *	E. Call Idx_Generate to generate the output file.
 *	F. Close the output file.
 *
 * Special Notes:
 *	none
 */
/*
 * Function IdxTeX - Code Section
 */
void main(argc,argv)
int argc;
char *argv[];
{
/*
 * Local Declarations
 */
  FILE	*file;			/* file pointer			*/
  char	dna[133];		/* Default filename arg		*/
  char	linebf[linebfsize];	/* I/O line buffer		*/
  char	filename[256];		/* Input file name		*/
  int	toc_flag;		/* /TOC qualifier flag		*/
  int	mst_flag;		/* /MASTER qualifier flag	*/
  FILE	*mst_file;		/* master file pointer		*/
  char  *vol = 0;		/* volume string descriptor ptr	*/
/*
 * Module Body
 */
/* Process the command line.  The routine will force exit on error. */
  if (argc < 2) {
    (void) printf("usage: idxtex file [/TOC={Article | Report}]\n");
    exit(1);
  }  
  idx_command(argc, argv, filename, &toc_flag, &mst_flag);
  (void)sprintf(dna, "%s.idx", filename);
  (void)printf("\nIdxTeX, the automatic index generator for LaTeX, version 2.0\n");
/* 
 * If doing master index processing,
 *  A. Open the master index file.
 *  B. For all records in the file,
 *	1. Read the next record.
 *	2. Call Idx_Process_File to process it.
 *  C. Close the file.
 *
 * Otherwise,
 *  A. Call Idx_Process_File to process the file.
 */
  vol = malloc(linebfsize);
  if (mst_flag) {
    (void)sprintf(dna, "%s.mdx",filename);
    if ((mst_file = fopen(dna, "r")) == NULL) {
      (void)printf("Could not open the master file\n");
      exit(1);
    }
    (void)printf("\nProcessing Master File %s\n", dna);
    while (fgets(linebf, linebfsize, mst_file) != 0) {
      if (idx_parse_master (linebf, filename, vol)) {
	(void)printf("\tProcessing index file %s.idx\n", filename);
	idx_process_file(filename, vol);
      }
    }
    (void)fclose(mst_file); 
    (void)sprintf(dna,"%s.mnd", filename);
  }
  else {
    idx_process_file(filename, vol);
    (void)sprintf(dna,"%s.ind", filename);
  }
/* Now generate the output file... */
  if ((file = fopen(dna, "w")) == NULL) {
    (void)printf("Could not open the output file\n");
    exit(1);
  }
  idx_generate (file, toc_flag, mst_flag);
  (void)fclose(file);
  (void)printf("\nDone.\n");
}
