/* #module    GloBldFil    "2-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */
/*
 * Module Name:	GloBldFil *5
 * Author:	R L Aurbach	CR&DS MIS Group    22-Aug-1986
 *
 * Function:
 *	Build the output file.
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	22-Aug-1986	Original Code
 * 2-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module GloBldFil - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#	include <stdlib.h>
#	include <io.h>
#	define F_OK		0	/* access(): File exists	*/
#else
#	include <sys/file.h>
/* extern char *sprintf(); */
#endif
#include  <string.h>
#include  <stdio.h>
#include "GloDef.h"
/*
 * Module Definitions:
 */
/*
 * Global Declarations:
 */
#ifdef MSDOS
int	Glo_Build_File(void);
#else
int	Glo_Build_File();
#endif
/*
 * Static Declarations:
 */
/*
 * External References:
 */
    extern char		infile[256];
    extern NODE_PTR	root;
    extern int		flag;
/*
 * Functions Called:
 */
/*
 * Function Glo_Build_File - Documentation Section
 *
 * Discussion:
 *	Create the output file which will be included into the final document
 *	to create the glossary.
 *
 * Calling Synopsis:
 *	status = Glo_Build_File ()
 *
 * Inputs:
 *	none
 *
 * Outputs:
 *	none
 *
 * Return Value:
 *	status	    ->	is a boolean integer which indicates success or
 *			failure.
 *
 * Global Data:
 *	root	    ->	the data structure is scanned.
 *
 *	flag	    ->	the flag is used to control the format of the output.
 *
 *	infile	    ->	the input filespec is used to generate the output
 *			filespec.
 *
 * Files Used:
 *	An output file is generated.  The output file specification is 
 *	constructed using "SYS$DISK:[].GLS" as the file spec and infile
 *	as the default filespec.
 *
 * Assumed Entry State:
 *	none
 *
 * Normal Exit State:
 *	status == TRUE	    success.
 *
 * Error Conditions:
 *	status == FALSE	    failure.
 *
 * Algorithm:
 *	A. Construct the filename of the output file and open it.
 *	B. Build a style-dependent preamble to the file. 
 *	C. For each node in the root,
 *	    1. Generate a data line for the item.
 *	    2. For each definition line,
 *		a. Generate a data line for the definition.
 *	D. Close the file.
 *
 * Special Notes:
 *	none
 */
/*
 * Function Glo_Build_File - Code Section
 */
int	Glo_Build_File ()
{
/*
 * Local Declarations
 */
  NODE_PTR	    node;
  STRING_PTR	    string;
  char	    dna[256];
  FILE	    *f;
/*
 * Module Body
 */
  if (root == 0)	    return (FALSE);
/* Open the output file.						*/
  (void)sprintf(dna, "%s.gls", infile);
  if ((f = fopen(dna,"w")) == NULL) return (FALSE);
/* Write the style dependent header information.			*/
  if (flag != NONE) {
    (void)fprintf(f,"\\newdimen\\infomapmargin  \\newdimen\\infomapwidth\n");
    (void)fprintf(f,"\\infomapmargin 115pt  \\infomapwidth 103pt\n");
    (void)fprintf(f,"\\def\\infomaplabel#1{\\raisebox{0pt}[1em][0pt]");
    (void)fprintf(f,"{\\makebox[\\labelwidth][l]\n");
    (void)fprintf(f,"    {\\parbox[t]{\\infomapwidth}{\\bf #1}}}}\n\n");
  }
  if (flag == ARTICLE)
    (void)fprintf(f,"\\def\\theglossary{\\section{\\glossaryname}\n");
  if (flag == REPORT) {
    (void)fprintf(f,"\\def\\theglossary{\\chapter*{\\glossaryname\\markboth{\\glossaryname}\n");
    (void)fprintf(f,"    {Glossary}} \\addcontentsline{toc}{chapter}{\\glossaryname}\n");
  }
  if (flag != NONE) {
    (void)fprintf(f,"   \\typeout{Glossary.} \\list{}{\\leftmargin\\infomapmargin\n");
    (void)fprintf(f,"   \\labelwidth\\leftmargin\\advance\\labelwidth-\\labelsep\n");
    (void)fprintf(f,"   \\let\\makelabel\\infomaplabel}}\n");
    (void)fprintf(f,"\\let\\endtheglossary\\endlist\n\n");
  }
/* Begin the actual glossary code.					    */
  (void)fprintf(f,"\\begin{theglossary}\n\n");
/* Process each node in the data structure				    */
  node = root;
  while (node != 0) {
    (void)fprintf(f,"\\item[%s] ", node->item);
    string = node->hdr;
    while (string != 0)	{
      if ((strlen(string->desc)) > 0)
	(void)fprintf(f, "%s", string->desc);
      else (void)fprintf(f,"\n");
      string = string->next;
    }
    (void)fprintf(f,"\n");
    node = node->next;
  }
/* Done.								    */
  (void)fprintf(f,"\\end{theglossary}\n\n");
  (void)fclose(f);
  return(TRUE);
}
