.TH ibuild 1 "4 June 1992" "InterViews" "InterViews Reference Manual"
.SH NAME
ibuild \- InterViews user interface builder
.SH SYNOPSIS
.B ibuild
.RI [ options ]
.RI [ file ]
.SH DESCRIPTION
Ibuild is an editor that
allows a user to create InterViews and Unidraw based user interfaces
by directly manipulating and composing
graphical parallels of the interface objects in
the InterViews toolkit.  

During an ibuild
session, a user can save the composed interfaces into
an external interface file or directly generate C++ code.  When
compiled and executed, the generated code would construct the exact
same interfaces as those specified in ibuild.

A significant amount of the editing 
semantics like cutting and pasting are identical to those found in
.I idraw.
You can also restore a previously saved interface by
typing ibuild
and the interface filename on the command line.  

Initially when ibuild
starts up, it looks for the environment variable "TOOLDIR" to locate
the external tool files and decide what tools to install
initially.  These external tool files describe graphical parallels of
library and user customized interface objects and allow ibuild
to reconstruct them from session to session.  If this variable is not
found the current directory is assumed.

The first row of an ibuild
editor displays information about its brush (border width) foreground and
background color etc, in a fashion similar to that in idraw.
The next two rows show tools that initiate direct manipulation and 
pulldown menus that contain 
.I commands.
A panner on the top right corner lets you pan and zoom the workspace.
The middle portion of the editor shows the 
.I workspace
for composing and assembling user interface components.
The bottom of the editor contains rows of 
.I prototypical 
tools in the form of names 
and iconic drawings that represent familiar InterViews abstractions.
Clicking on one tool, dragging and releasing it 
in the workspace
allows a user to place an instance of the corresponding prototype
at the desired location.

.SH ARGUMENTS
Standard InterViews library options.
.SH "IBUILD TOOLS"
Direct manipulation tools lie horizontally along ibuild's
second row.  You must engage a tool before you can use it.  You engage
a tool by clicking on its icon or by typing the character below and to
the right of its icon.  The icon of the tool that's engaged appears in
inverted colors.  Once engaged, you use the tool by clicking the left
mouse button in the workspace.

The
.BR Select ,
.BR Move ,
.BR Resize ,
.BR Examine ,
.BR Relate ,
.B Edit
tools manipulate text based user interface components.
.BR Magnify 
makes a part of the view expand to fill the entire view.
.BR Narrow
allows a user to navigate the structure of a composed interface in the
same editor.

Ibuild provides the following tools:
.TP 15
.B Select
Select an interface component, unselecting all others.  
A component is selected if
its \fIhandles\fP are visible.  Handles are small inverse-video
squares that surround the component.
If you hold down the shift
key, \fBSelect\fP \fIextends\fP the selection: it selects the
unselected component (or unselects the selected component) you clicked on
but does not unselect other selections.  Clicking anywhere other than
on a component unselects everything; you may also drag a rubberband
rectangle around a group of components to select all of them at once.
.I Shortcut:
the right mouse button invokes
.B Select
while the mouse is in the workspace.
.TP
.B Move
Move components from one spot to another.
.I Shortcut:
the middle mouse button invokes
.B Move
while the mouse is in the workspace.
.TP
.B Resize
Exercise the resizing behavior of the selected user interface components.
When user interface components from the bottom panel are initially
created in the workspace, or when selected components are composed with
composition interface objects in the 
.B Composition
pulldown menu, they are displayed with their natural sizes.  Resize
simulates the resizing of the application window during running of the
application by letting users drag and
sweep the selected user interface component.
.TP
.B Examine
Examine attributes associated with the selected user interface
components.  User interface components in ibuild
contain attributes which either assist users in designing the layout
of the interface or in customizing the generated code.
Typically the popup menu of the
.B Examine
tool shows "Info" and "Props" entries as options.  Selecting "Info"
causes a component specific dialog box to pop up.  Some of the common
attributes shown in the dialog
box include "Base Class Name", which describes the actual 
class name in the InterViews
library that the selected component corresponds to, and "Class Name",
which describes the user specified class name of the component.
If the 
value of "Class Name" is same as that of the "Base Class Name", the
library class is used for instantiating the component during code
generation, else
a set of subclass files are generated to assist the customization of
the new class as described earlier.
Unidraw elements can be subclassed by going through the same exercise
of changing the class names.  Some Unidraw elements can have more than
one class name.  For instance, the "Info" dialog box associated with a
rectangle in a viewer shows class names of the component, the view and
the graphic associated with it.
"Member Name" describes the member name of the
selected component as a member variable of the closest enclosing
.I MonoScene
object.  If the member name is exported, the
.I MonoScene
object will be able to access and manipulate this specific
member instance.  "Canvas Dimemsions" shows how much workspace
(corresponding to actual screen space) in pixels is actually allocated
to the selected component.  "Natural Size", "Shrinkability" and
"Stretchability" describe how much workspace the selected component
want to have.

The dialog box associated with the "Props" entry shows the selected
component's instance name and user defined properties.  Property
specification takes the form "attribute:value".

In order to assist users in locating certain elements with certain
member names or instance names, ibuild allows a user to probe these
attributes by SHIFT-Left-Clicking on these elements when they are
composed.  The "Info" entry will have a pullright menu that has class
name, member name pairs in it, while the pullright menu associated
with the "Props" entry has class name, instance name pairs.

Examining a
.I GraphicBlock
component causes a third "Graphics" entry to display in the popup
menu.  Selecting this option causes graphics in the
.I GraphicBlock
to be transferred to idraw
for further refinement.  Graphics can be transferred back to
ibuild by simply saving and quitting idraw.
Attributes associated with graphics in ibuild
not known to idraw such as member name are not lost in this process.
This option is supported only for backward compatibility, a much
better technique is to use the
.I Narrow
tool to narrow into
.B GraphicBlocks,
which changes ibuild into idraw in the same window.

.I Note:
All machine generated names are guaranteed to be unique in one session
of ibuild.  This property is lost with user defined names and when files
generated by different sessions of ibuild
are compiled together.

.TP
.B Relate
Relate provides a direct manipulation interface to semantically connect
compatible components.  Typically the end result of the 
.B Relate
operation is the sharing of attributes between the related components.
For instance, relating a scroller to a filebrowser lets the scroller
take the filebrowser's member name as its scrolling target.  Relating
two push buttons causes the push buttons to mutually exclude each other
when receiving mouse clicks.  In this case the second (destination)
push button would share the ButtonState defined by the first (source)
push button.  
.B Relate 
is also very useful for semantically connecting Unidraw objects.  For
instance, an 
.B Editor
needs to be related to all Unidraw objects like 
.I CommandControls, PanelControls,
and
.I Viewers
enclosed.  In this case, the simpliest way to establish the
relations is to relate the 
.B Editor
with the object right below it in the instance hierarchy, which causes
the relations to establish recursively.

.TP
.B Edit
Edit manipulates text based components.  Engaging the
.I Edit
tool allows users to perform editing on
.I MenuItem,
.I PushButton,
.I RadioButton,
.I CheckBox,
.I Message,
.I StringEditor,
.I PulldownMenu,
.I PullrightMenu,
.I CommandControl,
.I HPanelControl and
.I VPanelControl
components.

.TP
.B Magnify
Magnify a portion of the interface specified by sweeping out a
rectangular area.  Ibuild will magnify the area to occupy the entire
screen, if possible.

.TP
.B Narrow
Allow a user to navigate the structure of composed interfaces in the
same editor.
Initially, ibuild
starts at global scope.  Engaging the 
.B Narrow
tool and selecting a component causes the hierarchy of the interface
to be displayed in a popup menu with the highlighted entry showing the
current scope.  Selecting a different entry causes the editor
to switch to the scope of the selected component.
For instance, if a user chooses to narrow into an
.I HBox,
cutting or pasting components in the workspace now will
only affects the 
.I HBox.
.I Note:
Leaf level components don't define new scopes.  Narrowing into
graphics related components like GraphicBlocks, CommandControls, 
PanelControls, and Viewers 
transform ibuild into idraw in the same window, in addition to
switching the scope level.  This feature is extremely useful since
specifying structured graphics objects, class names, member names can
all be done within ibuild.  Firing up idraw using the 
.B Examine 
tool is still supported for backward compatibilty purposes.

.SH "PULLDOWN MENUS"

The pulldown menus 
.BR File ,
.BR Edit ,
.BR Composition ,
.BR Font ,
.BR Border ,
.BR FgColor ,
.BR BgColor ,
.BR Align , 
and
.B View
lie across ibuild's
third row.  They contain commands which you execute by pulling down the menu
and releasing the mouse button on the command or by typing the
character associated with the command.
.PP
The
.B File
menu contains the following commands to operate on files:
.TP 15
.B New
Destroy the current interface and replace it with an unnamed blank
interface.
.TP
.B Revert
Reread the current interface, destroying any unsaved changes.
.TP
.B Open...
Specify an existing interface file to edit through a FileChooser(3I), which
lets you browse the file system easily.
.TP
.B Save As...
Save the current interface in a file with a specific name.
.TP
.B Save
Save the current interface in the file it came from.
.TP
.B Generate
Generate code for the interface(s) in ibuild.
A sequence of dialog boxes would popup to let users check off files
they don't want overwritten.  The generated files include sets of
subclass files and support files.  Subclass files will have
class name postfixes and support files will have file name postfixes.  For
instance, if the file name of a session of ibuild
is "dialogBox" and the top level
.I MonoScene
object that drives the interface is "DialogBox". 
Support files generated include
"dialogBox-props", "dialogBox-make", "dialogBox-imake", "dialogBox-main.c".
"dialogBox-imake" and "dialogBox-make" are generated by ibuild and 
.I ibmkmf.
For each
.I MonoScene
component in ibuild,
a set of subclass files are generated and in this case, they
include "DialogBox.c", "DialogBox.h", 
"DialogBox-core.c" and "DialogBox-core.h".
"dialogBox-props"
contains InterViews properties for customization.  "dialogBox-main.c"
contains a prototypical main routine to drive the interface. 
"DialogBox-core.c" encapsulates all information about appearance of the
interface.  The protected member variables in "DialogBox-core.h"
describe what objects are
exported to the subclass (i.e. DialogBox) objects for manipulation.
"DialogBox.h" and "DialogBox.c" allows users to implement
application specific interfaces.  These two files are under the users'
control while the core files (DialogBox-core.[ch]) are under ibuild's
control.
.TP
.B Create Tool...
Create a prototypical tool of the current interface and install it in
the bottom tools palette.  Users can choose between having the file
name, a miniaturized graphic of the existing interface or a customized
bitmap as the new tool's icon.
The newly created tool can then be treated
as a library tool for instantiation.  This allows domain
specific abstractions to be built and used across sessions of ibuild.
.TP
.B Tools...
Allow a user to install or remove tools to or from the bottom tools
panel.  Users can choose to install(or remove) multiple tools from the
left(right) stringbrowser by selecting multiple entries and hitting
the "<< Install" ("Remove >>") button.
.TP
.B Execute...
Let user choose an executable from a filechooser and execute the
selected file without leaving ibuild.
.TP
.B Quit
Quit the current session of ibuild.

.PP
The
.B Edit
menu contains the following commands to edit components:
.TP 15
.B Undo
Undo the last done change to the component.  Successive
.B Undo
commands undo earlier and earlier editing operations.
.TP
.B Redo
Redo the last editing operation.  Successive \fBRedo\fP commands redo
later and later editing operations up to the first operation undone by
\fBUndo\fP.  Undone operations that have not been redone are lost as
soon as a new operation is performed.
.I Note: 
Changes made through the
.I Examine
tool and 
.I Relate
tool are undoable.
.TP
.B Cut
Remove the selected components from the workspace and place them in a
temporary storage area called the \fIclipboard\fP.
.TP
.B Copy
Copy the selected components into the clipboard.
.TP
.B Paste
Paste copies of the components in the clipboard into the workspace.
Together,
.BR Cut ,
.BR Copy , 
and
.B Paste
let you transfer components between workspaces
simply by cutting components
out of one view and pasting them into another.  Cutting, copying and pasting
works even within the same interface structure by the use of the
.I Narrow
tool.
.TP
.B Duplicate
Duplicate the selected components and add the copies to the workspace.
.TP
.B Delete
Destroy the selected components.
.TP
.B Select All
Select every components in the workspace.
.TP
.B Show Glue
Show HGlue components with horizontal strips and VGlue components with
vertical strips.  Showing Glue components with strips let the
structure associated with the interface be more apparent.
.TP
.B Hide Glue
Show HGlue and VGlue components with their background color.  This is
useful when the actual appearance of the interface is desired
.TP
.B Natural Size
Bring the selected interface components back to their natural form,
similar to how they are displayed initially when the generated interfaces are
executed.

.PP
The
.B Composition
menu contains the following commands to modify the structure of the
interface.
.TP 15
.B Dissolve
Dissolve the selected components by deleting the top level parents and
exposing their children of the selected components.  Leaf level
components cannot be dissolved.
Compose the selected components with the corresponding composition
object.  The order of selection decides the order in which they are
composed.
.TP
.B HBox
Tile the selected components left to right in abutting fashion.
.TP
.B VBox
Tile the selected components top to bottom in abutting fashion.
.TP
.B Deck
Stack the selected components on top of each other with the last
selected component on the top.
.TP
.B Frame
Put a frame around each of the selected components.
.TP
.B ShadowFrame
Put a shadowframe around each of the selected components.
.TP
.B Viewport
Put a viewport around each of the selected components.
.TP
.B MenuBar
Tile the selected components like that of an
.I HBox.
It also implements the "sweeping" effect when 
.I MenuItems, Pulldown menus
or
.I Pullright menus 
are the selected components.
.TP
.B Shaper
Redefine the resizing behavior of the selected components. 
.I Shaper
is an ibuild
generated class which is useful for overriding the default resizing
behavior of library components
.TP
.B MonoScene Subclass, Dialog Subclass, Editor Subclass

Introduce user defined subclass objects for customizing the
interfaces.  These are abstraction mechanisms that
break complicated user interfaces down into more manageable, more
reusable sub-components that are more amenable to user
customization.  Without subclass objects, the generated code consists
of static functions that assemble the library user
interface elements into complete interfaces.  Member names associated
with the components are therefore useless.  With subclass objects,
children of a subclass instance become
the instance's interior definition.  If the interior
components are exported, they become member variables of the subclass
instance.  Selecting
.I MonoScene Subclass
will cause each selected components to be enclosed in a 
.I MonoScene
subclass object.  Selecting
.I Dialog Subclass 
is similar to selecting
.I MonoScene Subclass
except in addition, 
it provides features of the Dialog class in the library.
.I Editor Subclass 
is useful when the end application is a domain-specific editor.
Objects kept by an editor like the 
.I KeyMap, Selection, Component, 
and 
.I ControlState 
can all be subclassed to define domain specific behavior.

.TP
.B Reorder
Reorder the components inside a composition according to the current
selection order.  For instance, narrowing into an
.I HBox,
re-selecting its components and execute
.I Narrow
defines ordering of the components in the 
.I HBox
corresponding to the new selection order.
.TP
.B Raise
Bring the selected components to the front of the 
interface so that they
are drawn on top of (after) the other components in the interface.
For example if a selected component is raised in a
.B Deck,
it will appear on top of all the components.
.TP
.B Lower
Send the selected components to the back of the interface so that they are
drawn behind (before) the other components in the interface.
.PP
The
.B Font
menu contains a set of fonts with which to print text based components
.  When you set
the current font from the menu, you will also set all the selected
components' fonts to that font.  A font indicator in the upper right
corner displays the current font.
.PP
The
.B Border
menu contains a set of brushes that
are used to set border widths of 
.I Border
and
.I Frame
components.  A border indicator in the
upper left corner displays the current border.
.PP
The
.B FgColor
and
.B BgColor
menus contain a set of colors with which to draw components and text.
When you set the current foreground or background color from the
FgColor or BgColor menu, you will also set all the selected components'
foreground or background colors.  
.PP
The
.B Align
menu contains commands to set the alignment of the message on 
.I Message
based components.  Examples of these components include
.I Pulldown 
and
.I Pullright
menus, 
.I MenuItem
components and
.I Message
components.  The effects of alignment is more apparent when the
selected components are resized.
.PP
The
.B View
menu contains the following commands:
.TP 15
.B New View
Create a duplicate ibuild window containing a second view of the
current interface component.  The second view may be panned, zoomed, 
and edited
independently of the first.  Any number of additional views may be
made in this manner.  Changes made to a component through one view
appear synchronously in all other views of the same interface.  You may
also view another interface in any ibuild window via the Open command.
Consistency between multiple views of the
same component is maintained.
.TP
.B Close View
Close the the current editor.  If the current editor is the last one,
ibuild will prompt for confirmation.
.TP
.B View Parent
Set the current editor's component to be the current component's
parent. Together with the
.I Narrow
tool, they create a convenient mechanism for navigating the structure
of an interface.  Viewing the parent of graphics related objects
switch ibuild from graphics editing mode back to interface editing mode.
.TP
.B View Root
Set the current editor's component to be the current component's
root, which is the default when ibuild
initially starts.
.TP
.B Normal Size
Set the magnification to unity so the interface appears at actual size.
.TP
.B Reduce to Fit
Reduce the magnification until the interface fits entirely within the
view.
.TP
.B Center Screen
Center the view over the center of the ibuild
window.

.SH "CODE GENERATION"

Conceptually, components created in the workspace are instances of the
actual InterViews and Unidraw counterparts.  
All separate components (uncomposed and composed components without
common parents) generate
separate windows after code generation.  For example, if the user 
specified filename associated with an ibuild
session is "hello", "hello-imake", "hello-make", "hello-props" and
"hello-main.c" are generated.  "hello-imake" and "hello-make" are
imakefile and makefile generated by ibuild using
.I ibmkmf.
"hello-props" contains attribute:value pairs required by InterViews to
associate properties to user interface objects on a per instance
basis.  "hello-main.c" contains a generated main() routine to
instantiate the interfaces.  If no
.I MonoScene
objects exist in ibuild,
static functions are generated in "hello-main.c" to assemble the
interface components.
.I MonoScene
(or 
.I MonoScene subclass
) objects are user defined abstractions to decompose complex user
interfaces into simpler higher level elements, as described later.

All user interface components can be subclassed simply by renaming their
"Class Name" attribute to be different from the "Base Class Name",
using the Examine tool and selecting the "Info entry".  
A set of four files are generated for each
subclassed components in ibuild.
If the "Class Name" of a subclassed component is "Displayer" and the
"Base Class Name" is "StringEditor",
"Displayer.h", "Displayer.c", "Displayer-core.h" and "Displayer-core.c"
will be generated.  In this case "Displayer_core" is a subclass 
of "StringEditor"
and "Displayer" is subclass of "Displayer_core".
The "-core.*" postfixed files are core files which are under ibuild's
control.  They may contain enhanced widget definitions to accommodate
for library deficiencies and to provide a more convenient user model.
"Displayer.h" and "Displayer.c" are subclass files which are provided 
for customization, which typically involves redefinition of some
virtual functions defined by the base class.

Ibuild also allows the creation of new user interface abstractions by
providing 
.I MonoScene subclass, 
.I Dialog subclass, 
and 
.I Editor subclass
composition mechanisms.  
Typically, the top most composition of a completed user interface
component is a 
.I MonoScene
subclass object. All enclosed components of a subclass object
can be thought of as its members.
For instance, if a 
.I Dialog
subclass instance called "Informer" is used to wrap (abstract) 
the previous interface,
"Informer.h", "Informer.c", "Informer-core.h" and "Informer-core.c"
will be generated.  In this case "Informer_core" is a subclass of "Dialog"
and "Informer" is subclass of "Informer_core".  Like "Displayer",
"Informer-core.h" and "Informer-core.c" are under ibuild's
control while "Informer.h" and "Informer.c" are for user customization.
In addition to providing enhanced widget definitions, "Informer-core.c"
also contains definitions of its appearance by instantiating its
member components.  "Informer-core.h" provides an interface to "Informer.h"
where the exported members can be selected by using the Examine
tool as explained later.


.SH "X DEFAULTS"
You can customize the number of undoable changes and the font, border,
or color menus by setting resources in your X defaults
database.  Each string of the form ``ibuild.resource:definition'' sets
a resource.  For example, to customize any of the paint menus, set a
resource given by the concatenation of the menu's name and the entry's
number (e.g., ``ibuild.font2'') for each entry that you want to
override.  All menus use the number 1 for the first entry.

You must set resources only for the entries that you want to override,
not all of them.  If you want to add entries to the menus, simply set
resources for them.  However, don't skip any numbers after the end of
the menu, because the menu will end at the first undefined resource.
To shorten a menu instead of extending it, specify a blank string as
the resource for the entry following the last.
.PP
Ibuild understands the following resources:
.TP 15
.B history
Set the maximum number of undoable changes (20 by default).
.TP
.B initialfont
Specify the font that will be active on startup.  Supply a number that
identifies the font by its position in the Font menu starting from 1
for the first entry.
.TP
.BI font i
Define a custom font to use for the \fIi\fPth entry in the Font menu.
Give three strings separated by whitespace.
The first string defines the font's name, the second string the
corresponding print font, and the third string the print size.  For
example, ``ibuild.font3:8x13bold Courier-Bold 13'' defines the third
font entry.
.TP
.B initialborder
Specify the border that will be active on startup.  Give a number
which identifies the border by its position
in the Border menu starting from 1 for the first entry.  Border 
specification is similar to brush specification in idraw
except that 
only solid brushes should be used because they are used to set border
widths of Border and Frame components.
.TP
.BI border i
Define a custom border to use for the
.IR i th
entry in the 
.B Border
menu.  Unlike normal brush specification, 
the first 16-bit hexadecimal number should always be 0xffff to 
indicate solid brush.  The second hexadecimal number should give
the desired border width in pixels.  Border specification only
affects certain interface objects as described earlier.
.TP
.B initialfgcolor
Specify the foreground color that will be active on startup.
Give a number which identifies the color by its position
in the FgColor menu starting from 1 for the first entry.
.TP
.BI fgcolor i
Define a custom color to use for the
.IR i th
entry in the FgColor menu.  Give a string defining the name of the
color and optionally three decimal numbers between 0 and 65535
following the name to define the red, green, and blue components of
the color's intensity.  The intensities override the name; that is,
ibuild will look the name up in a window system database of common
colors only if you omit the intensities.  You can define shades of
gray by using equal proportions of each primary color.  For example,
``ibuild.fgcolor8:Indigo 48896 0 65280'' defines a color which is a
mixture of red and blue.
.TP
.B initialbgcolor
Specify the background color that will be active on startup.
Give a number which identifies the color by its position
in the BgColor menu starting from 1 for the first entry.
.TP
.BI bgcolor i
Define a custom color to use for the
.IR i th
entry in the BgColor menu.  The same rules apply to background colors
as to foreground colors.

.SH SEE ALSO
idraw(3I), Interactor(3I), World(3I)

.SH BUGS
.I Ibuild
provides
.I Narrow
tool for viewing the internal nodes of an interface.  A user therefore
can potentially remove all children of a composition, leaving the
composition unselectable and causes subsequent confusion in code generation.
