.TH SplineComp 3U "23 January 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
SplineComp, SplineView, PSSpline, ClosedSplineComp, ClosedSplineView,
PSClosedSpline \- open and closed spline component subjects, views,
and PostScript external representations
.SH SYNOPSIS
.B #include <Unidraw/Components/spline.h>
.SH DESCRIPTION
SplineComp and ClosedSplineComp are VerticesComps that define open and
closed splines, respectively.  SplineComp uses an SFH_OpenBSpline
graphic to store its graphical attributes, while ClosedSplineComp uses
an SFH_ClosedBSpline.  SplineView and ClosedSplineView are
VerticesViews for displaying open and closed splines.  PSSpline and
PSClosedSpline are PSVertices that externalize their subject's
information in PostScript form.
.SH SPLINECOMP PUBLIC OPERATIONS
.TP
.B "SplineComp(SFH_OpenBSpline* = nil)"
The constructor takes an optional control point hit-detecting
stroked-filled open B-spline graphic that defines the attributes of
the spline.
.TP
.B "SFH_OpenBSpline* GetSpline()"
Return the SFH_OpenBSpline graphic that defines the spline's
attributes.  GetSpline is simply a more specific form of the
GetGraphic operation.
.SH SPLINEVIEW PUBLIC OPERATIONS
.TP
.B "SplineView(SplineComp* = nil)"
Create a SplineView, optionally supplying the subject.
.TP
.B "virtual Manipulator* CreateManipulator("
.ns
.TP
.B "   Viewer*, Event&, Transformer*, Tool*"
.ns
.TP
.B ")"
.ns
.TP
.B "virtual void InterpretManipulator(Manipulator*)"
SplineView redefines its response to manipulation with a
GraphicCompTool.  The user clicks the left mouse button to specify
each vertex and clicks with the middle mouse button to specify the
final vertex.  Vertex positioning will be constrained by gravity, if
any.  SplineView also defines a response to the ReshapeTool, allowing
the user to click on one of its control points to reposition it.  The
subject is actually replaced (via ReplaceCmd) with a new SplineComp
subject reflecting the repositioned control point.  Repositioning will
be influenced by gravity.
.TP
.B "SplineComp* GetSplineComp()"
Return the subject.
.SH PSSPLINE PUBLIC OPERATIONS
.TP
.B "PSSpline(SplineComp* = nil)"
Construct a PostScript external representation of the given subject,
if any.
.SH PSSPLINE PROTECTED OPERATIONS
.TP
.B "virtual const char* Name()"
PSSpline identifies itself as "BSpl" in the PostScript output.
.SH CLOSEDSPLINECOMP PUBLIC OPERATIONS
.TP
.B "ClosedSplineComp(SFH_ClosedBSpline* = nil)"
The constructor takes an optional control point hit-detecting
stroked-filled closed B-spline graphic that defines the attributes of
the closed spline.
.TP
.B "SFH_ClosedBSpline* GetClosedSpline()"
Return the SFH_ClosedBSpline graphic that defines the closed spline's
attributes.  GetClosedSpline is simply a more specific form of the
GetGraphic operation.
.SH CLOSEDSPLINEVIEW PUBLIC OPERATIONS
.TP
.B "ClosedSplineView(ClosedSplineComp* = nil)"
Create a ClosedSplineView, optionally supplying the subject.
.TP
.B "virtual Manipulator* CreateManipulator("
.ns
.TP
.B "   Viewer*, Event&, Transformer*, Tool*"
.ns
.TP
.B ")"
.ns
.TP
.B "virtual void InterpretManipulator(Manipulator*)"
ClosedSplineView redefines its response to manipulation with a
GraphicCompTool.  The user clicks the left mouse button to specify
each vertex and clicks with the middle mouse button to specify the
final vertex.  Vertex positioning will be constrained by gravity, if
any.  ClosedSplineView also defines a response to the ReshapeTool, allowing
the user to click on one of its control points to reposition it.  The
subject is actually replaced (via ReplaceCmd) with a new ClosedSplineComp
subject reflecting the repositioned control point.  Repositioning will
be influenced by gravity.
.TP
.B "ClosedSplineComp* GetClosedSplineComp()"
Return the subject.
.SH PSCLOSEDSPLINE PUBLIC OPERATIONS
.TP
.B "PSClosedSpline(ClosedSplineComp* = nil)"
Construct a PostScript external representation of the given subject,
if any.
.SH PSCLOSEDSPLINE PROTECTED OPERATIONS
.TP
.B "virtual const char* Name()"
PSClosedSpline identifies itself as "CBSpl" in the PostScript output.
.SH SEE ALSO
Event(3I), GraphicComp(3U), GraphicCompTool(3U),
GraphicView(3U), Grid(3U), PatternCmd(3U), PostScriptView(3U),
ReshapeTool(3U), Rubband(3I), Transformer(3I), VerticesComp(3U),
Viewer(3U), align(3U), edit(3U), splines(3U)
