/* face-finger.h -- Routines defined in face-finger.c */

/* Copyright (C) 1988,1990,1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (_FACE_FINGER_H_)
#define _FACE_FINGER_H_

#include <bitmap.h>

/* Write the bits of USER's face on STREAM, in the standard face format.
   If we can.  We first send the width, the height, and the length of
   each row in bytes.  These are printed in ASCII representation.  Then
   we send height lines of width bytes.  We don't care about byte swapping,
   because any finger that calls us knows the standard format of bitmaps. */
void send_face ();

/* Tell CONNECTION to send us the face for USER, and then display that
   face.  Returns non-zero if CONNECTION had a face for USER. */
int face_finger ();

/* Read a BITMAP * from CONNECTION.  USER is the name of the user to
   read the bits for. */
BITMAP *get_face_bits ();

#endif /* _FACE_FINGER_H_ */
