/* config.h -- GNU Finger configuration

   Copyright (c) 1990, 1991, 1992  Free Software Foundation, Inc.

   This file is part of GNU Finger

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _FINGER_CONFIG_H
#define _FINGER_CONFIG_H

/* AIX... sigh. This must go first in the file. */
#if defined(__GNUC__)
#define alloca __builtin_alloca
#else  /* !__GNUC__ */
#if defined(HAVE_ALLOCA_H)
#include <alloca.h>
#else  /* !HAVE_ALLOCA_H */
#ifdef _AIX
 #pragma alloca
#else  /* !_AIX */
char *alloca ();
#endif /* !_AIX */
#endif /* !HAVE_ALLOCA_H */
#endif /* !__GNUC__ */


#if !__STDC__
#define volatile
#endif


/* This file contains defines which control the configuration of GNU
   Finger. */

/* Don't change */
#define VERSION_STRING version_string
extern char version_string[];

/* Don't change */
#define MAILDIR maildir_string
extern char maildir_string[];

/* Define to enable running of ~/.fingerrc scripts */
#define SUPPORT_FINGERRC

/* Define to check that ~/.fingerrc is owned by the user we're execing
   as. Really only does anything to promote security on systems that
   won't allow anyone to give away their files. */
#define CHECK_OWNER_FINGERRC

/* Define to make sure ~/.fingerrc isn't writable by anyone except the
   owner. Highly recommended. */
#define CHECK_RDONLY_FINGERRC

/* Define if the default service for the finger client is related to
   the basename. */
#define BASENAME_IS_SERVICE

/* TCP service or port for fingering a client machine unless specified
   in `clients'. */
#define CFINGER_SERVICE "cfinger"

/* TCP service or port for in.fingerd to use to pass requests to the
   server in.fingerd. You shouldn't have to change this unless you wish
   to attempt some unusual feat, like running several mutually incompatible
   parallel fingers. */

#define FINGER_TO_FINGER_SERVICE "finger"

/* TCP port number for CFINGER_SERVICE. [Not used, but still here in case I
   change my mind.] */
#define CFINGER_PORT 2003

/* Shell to use when execing ~/.fingerrc instead of user's login shell.
   Comment out to use user's login shell. */
#define FINGERRC_SHELL "/bin/sh"

/* Define if you want --info to be the default, rather than --brief. */
#define INFO_IS_DEFAULT

/* Default polling interval for fingerd, in seconds */
#define DEFAULT_POLL_INTERVAL 120

/* Define HAVE_X11 if you are using the X11 window system. */
/* #define HAVE_X11 */

/* Define X11R5 if you are using release 5 of the X11 window system.
   Define PrintWidget if you want to be able to print mugshots from X. */
#if defined (HAVE_X11)
/* #define X11R5 */
# define X11R4
/* # define X11R3 */
# define PrintWidget
#endif

/* Define HAVE_SUN_WINDOWS if you have that proprietery window system.
   This and HAVE_X11 are not mutually exclusive. */
/* #define HAVE_SUN_WINDOWS */

/* Define NAMESERVER if you need to link with the resolv library in order
   to use the nameserver. */
#define NAMESERVER

#ifdef HAVE_LASTLOG_H
#define HAVE_LASTLOG
#endif

/* Change the definition of FingerDir if you don't want things in the
   default place.  This directory contains the database of clients to
   poll, the serverhost file, and accumulated data about users.

   Change the definition of BinDir and EtcDir to suit your personal
   system setup.  BinDir is where the user-callable programs go,
   (finger, fingerd), while EtcDir is where the inet daemons
   go (in.fingerd, in.cfingerd).

   Change the definition of MugShotPath to be a colon-separated list of
   directories to search for mugshots (faces).   Note that this value
   should be surrounded by double quotes. */

#define FingerDir /etc/fingerdir
#define BinDir /usr/bin
#define EtcDir /usr/sbin
#define MugShotPath "/usr/local/lib/mugshots:/usr/lib/mugshots"

/* Define USE_DATABASE if you want to keep information about users in
   a DBM database.  You can define the format of this database by simply
   editing ./lib/site/userformat.  The installation instructions should
   be clear on how to do that. */
/* #define USE_DATABASE */

/* **************************************************************** */
/*								    */
/*			Defines for FACE parameters		    */
/*								    */
/* **************************************************************** */

/* Define MIT_MUGSHOTS if you store your mugshots in the same format as
   the Lisp machine mugshots used at ai.mit.edu. */
/* #define MIT_MUGSHOTS */

/* Define X11_MUGSHOTS if you store your mugshots in X11 bitmap format. */
/* #define X11_MUGSHOTS */

/* Define BITMAP_MUGSHOTS if you want to use the format supplied with GNU
   Finger. */
/* #define BITMAP_MUGSHOTS */

/* Define FACE_MUGSHOTS if your faces are stored in the Facesaver format
   from uunet.uu.net. */
/* #define FACE_MUGSHOTS */

/* Define RAST_MUGSHOTS if your mugshots are all of Rastafarians.  No, wait,
   I mean if your mugshots are stored in Sun rasterfile format. */
/* #define RAST_MUGSHOTS */


/* **************************************************************** */
/*								    */
/*		   Defines Controlling the Internals		    */
/*								    */
/* **************************************************************** */

/* Define ENOUGH_FREE_MACHINES to be the minimum of free machines that
   you think is reasonable for your site.  If the number of free machines
   is smaller than this number, then finger .free spits out an admonishment
   along with the info. */
#define ENOUGH_FREE_MACHINES 3


/* This file is included by all sources, so we resolve all
   dependencies here. */

#include <sys/types.h>

#if defined(DIRENT) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENGTH(dirent) (strlen ((dirent)->d_name))
#else  /* !DIRENT && !_POSIX_VERSION */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef USG
#ifdef SYSNDIR
#include <sys/ndir.h>
#else  /* !SYSNDIR */
#include <ndir.h>
#endif /* !SYSNDIR */
#else  /* !USG */
#include <sys/dir.h>
#endif /* !USG */
#endif /* !DIRENT && !_POSIX_VERSION */

#if defined(USG) || defined (STDC_HEADERS)
#include <string.h>
#if !defined(NeXT)
#define index strchr
#define rindex strrchr
#define bcopy(s, d, n)  (memcpy ((d), (s), (n)))
#define bcmp(s1, s2, n)  (memcmp ((s1), (s2), (n)))
#define bzero(d, n)  (memset ((d), 0, (n)))
#endif /* !NeXT */
#else
#include <strings.h>
#endif

#if !defined (RETSIGTYPE)
#define RETSIGTYPE void
#endif

/* Assume utmpx always has ut_host */
#if defined (HAVE_UTMPX_H) && !defined (HAVE_UT_HOST)
#define HAVE_UT_HOST 1
#endif

#ifndef MAX
#define MAX(A,B) ((A) > (B) ? (A) : (B))
#endif

#endif /* !_FINGER_CONFIG_H */
