# Module fr CLISP
# Bruno Haible 12.7.1994

# Alle Abhngigkeiten von modules.h werden hier gesammelt!


#ifdef NO_CLISP_H
  #include "lispbibl.c"
#else
  #include "clisp.h"
#endif

#ifndef DYNAMIC_MODULES

# Anzahl dazugelinkter Module

global var uintC module_count =
  #define MODULE(module_name)  1+
  #include "modules.h"
  #undef MODULE
  0;

# Tabelle der Module:
  extern uintC subr_tab_data_size;
  extern uintC object_tab_size;
  #define MODULE(module_name)  \
    extern subr_ CONCAT3(module__,module_name,__subr_tab)[]; \
    extern uintC CONCAT3(module__,module_name,__subr_tab_size); \
    extern object CONCAT3(module__,module_name,__object_tab)[]; \
    extern uintC CONCAT3(module__,module_name,__object_tab_size); \
    extern subr_initdata CONCAT3(module__,module_name,__subr_tab_initdata)[]; \
    extern void CONCAT3(module__,module_name,__init_function)();
  #include "modules.h"
  #undef MODULE
  global module_ modules[] =
    { { "clisp",
        (subr_*)&subr_tab_data, &subr_tab_data_size,
        (object*)&object_tab, &object_tab_size,
        TRUE, NULL, NULL
      },
      #define MODULE(module_name)  \
        { STRING(module_name), \
          &CONCAT3(module__,module_name,__subr_tab)[0], &CONCAT3(module__,module_name,__subr_tab_size), \
          &CONCAT3(module__,module_name,__object_tab)[0], &CONCAT3(module__,module_name,__object_tab_size), \
          FALSE, \
          &CONCAT3(module__,module_name,__subr_tab_initdata)[0], \
          &CONCAT3(module__,module_name,__init_function) \
        },
      #include "modules.h"
      #undef MODULE
      { NULL, NULL, NULL, NULL, NULL, FALSE, NULL, NULL }
    };

#endif
