------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             S E M _ C H 1 1                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;
package Sem_Ch11 is
   procedure Analyze_Exception_Declaration              (N : Node_Id);
   procedure Analyze_Handled_Statements                 (N : Node_Id);
   procedure Analyze_Raise_Statement                    (N : Node_Id);

   procedure Analyze_Exception_Handlers (L : List_Id);
   --  Analyze list of exception handlers of a handled statement sequence

end Sem_Ch11;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Thu Aug 19 13:38:14 1993;  author: banner
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Sun Jan  9 09:42:47 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.3
--  date: Sun Feb 20 18:40:06 1994;  author: dewar
--  (Analyze_Exception_Handlers): Move spec from body to spec of Sem_Ch11,
--   since this procedure is now called from Exp_Ch9.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
