------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             S E M _ A T T R                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Attribute handling is isolated in a separate package to ease the addition
--  of implementation defined attributes. Logically this processing belongs
--  in chapter 4. See Sem_Ch4 for a description of the relation of the
--  Analyze and Resolve routines for expression components.

with Types; use Types;
package Sem_Attr is

   procedure Analyze_Attribute (N : Node_Id);
   --  Performs bottom up semantic analysis of an attribute. Note that the
   --  parser has already checked that type returning attributes appear only
   --  in appropriate contexts (i.e. in subtype marks, or as prefixes for
   --  other attributes).

   procedure Eval_Attribute (N : Node_Id);
   --  Performs compile time evaluation of attributes where possible, leaving
   --  the Potentially_Static and Raises_Constraint_Error flags appropriately
   --  set, and replacing the node with a literal node if the value can be
   --  computed at compile time. All static attribute references are folded,
   --  as well as a number of cases of non-static attributes that can always
   --  be computed at compile time (e.g. floating-point model attributes that
   --  are applied to non-static subtypes). Of course in such cases, the
   --  Potentially_Static flag will not be set on the resulting literal.

   procedure Resolve_Attribute (N : Node_Id; Typ : Entity_Id);
   --  Performs type resolution of attribute. If the attribute yields
   --  a universal value, mark its type as that of the context. On
   --  the other hand, if the context itself is universal (as in
   --  T'Val (T'Pos (X)), mark the type as being the largest type of
   --  that class that can be used at run-time. This is correct since
   --  either the value gets folded (in which case it doesn't matter
   --  what type of the class we give if, since the folding uses universal
   --  arithmetic anyway) or it doesn't get folded (in which case it is
   --  going to be dealt with at runtime, and the largest type is right).

end Sem_Attr;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.4
--  date: Sun Jan  9 09:42:19 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.5
--  date: Tue Jul 26 16:56:53 1994;  author: dewar
--  (Eval_Attribute): Spec moved here from body of Sem_Eval
--  ----------------------------
--  revision 1.6
--  date: Fri Aug  5 15:07:50 1994;  author: dewar
--  (Eval_Attribute): Small change to documentation, mentioning that non-static
--   attribute references can be folded.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
