------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               G N A T K 8                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.8 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This is a small utility program that incorporates the file krunching
--  algorithm used by the GNAT compiler (when the -gnatk switch is used)

--     gnatk8  filename  length

--  where length is a decimal value, outputs to standard output the krunched
--  name, followed by the original input file name. The file name has an
--  optional extension, which, if present, is copied unchanged to the output.
--  The length argument is optional and defaults to 8 if omitted.

with Krunch;
with Ada.Command_Line; use Ada.Command_Line;
with System.Io;        use System.Io;

function Gnatk8 return Status is
   Count        : Natural;
   Maxlen       : Natural;
   Exit_Program : exception;

begin
   Count := Argument_Count;

   if Count < 1 or else Count > 2 then
      Put_Line ("Usage: gnatk8  filename[.extension]  [krunch-count]");
      raise Exit_Program;

   else
      --  If the length (krunch-count) argument is omitted use default of 8.

      if Count = 1 then
         Maxlen := 8;

      else
         Maxlen := 0;

         for J in Argument (2)'Range loop
            if Argument (2) (J) /= ' ' then
               if Argument (2) (J) not in '0' .. '9' then
                  Put_Line ("Illegal argument for krunch-count");
                  raise Exit_Program;
               else
                  Maxlen := Maxlen * 10 +
                    Character'Pos (Argument (2) (J)) - Character'Pos ('0');
               end if;
            end if;
         end loop;
      end if;

      declare
         Fname : String  := Argument (1);
         Klen  : Natural := Fname'Length;
         Ext   : Natural := Klen + 1;

      begin
         for J in 1 .. Fname'Length loop
            if Fname (J) = '.' then
               Klen := J - 1;
               Ext := J;
               exit;
            end if;
         end loop;

         Krunch (Fname, Klen, Maxlen, False);

         Put (Fname (1 .. Klen));
         Put (Fname (Ext .. Fname'Length));
         New_Line;
      end;
   end if;

   return Success;

exception
   when Exit_Program =>
      return Failure;

end Gnatk8;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.6
--  date: Mon Jun 13 17:05:56 1994;  author: banner
--  Extensive change (and cleanup) to use new Ada.Command_Line package.
--  ----------------------------
--  revision 1.7
--  date: Wed Aug 24 18:48:42 1994;  author: banner
--  eliminate use of Text_IO. use System.Io instead.
--  ----------------------------
--  revision 1.8
--  date: Wed Aug 24 21:10:59 1994;  author: dewar
--  Minor reformatting
--  Avoid use of value attribute
--  Return Failure status if error, Success otherwise (make into function)
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
