------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 6                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Expand routines for chapter 6 constructs

with Types; use Types;

package Exp_Ch6 is

   procedure Expand_N_Function_Call            (N : Node_Id);
   procedure Expand_N_Subprogram_Body          (N : Node_Id);
   procedure Expand_N_Procedure_Call_Statement (N : Node_Id);

   procedure Expand_Call (N : Node_Id);
   --  This procedure contains common processing for Expand_N_Function_Call,
   --  Expand_N_Procedure_Statement, and Expand_N_Entry_Call.

   procedure Expand_Dispatch_Call (Call_Node : Node_Id);
   --  The subprogram call (Call_Node) is replaced a by a call to the correct
   --  primitive operation whose access is stored in the dispatch table pointed
   --  by the tag of the controlling argument.

end Exp_Ch6;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.5
--  date: Tue Nov 30 18:50:36 1993;  author: comar
--  Make Expand_Dispatch_Call Visible, because it is now directly used
--   from the semantics to expand lately recognized disp calls.
--  ----------------------------
--  revision 1.6
--  date: Sun Jan  9 09:32:56 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.7
--  date: Thu Feb  3 00:49:49 1994;  author: dewar
--  (Expand_Call): Moved here from body (used for entry calls)
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
