/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A _ N L I S T S                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.2 $                              */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C header corresponding to the Ada package specification for
   Nlists. It also contains the implementations of inlined functions from the
   the package body for Nlists.  It was generated manually from nlists.ads and
   nlists.adb and must be kept synchronized with changes in these files.

   Note that only routines for reading the tree are included, since the
   tree transformer is not supposed to modify the tree in any way. */

/*  The following is the structure used for the list headers table */

struct List_Header
{
  Int first;
  Int last;
  Node_Id parent;
};

/* The list headers are stored in an array. The pointer to this array is
   passed as a parameter to the tree transformer procedure and stored in the
   global variable List_Headers_Ptr after adjusting it by subtracting
   List_First_Entry, so that List_Id values can be used as subscripts.	*/

extern struct List_Header *List_Headers_Ptr;

/* Node List Access Functions */

INLINE Node_Id
First (List)
     List_Id List;
{
  return List_Headers_Ptr [List].first;
}

INLINE Node_Id
Last (List)
     List_Id List;
{
  return List_Headers_Ptr [List].last;
}

INLINE Node_Id
Next (Node)
     Node_Id Node;
{
  Int Id = Nodes_Ptr [Node].V.NX.link;

  if (IN (Id, List_Range))
    return Empty;
  else return Id;
}

#define Prev nlists__prev
extern Node_Id Prev PROTO((Node_Id));

INLINE Boolean
Is_Empty_List (Id)
     List_Id Id;
{
  return (First (Id) == Empty);
}

INLINE Boolean
Is_Non_Empty_List (Id)
     List_Id Id;
{
  return (First (Id) != Empty);
}

INLINE Boolean
Is_List_Member (Node)
     Node_Id Node;
{
  return Nodes_Ptr [Node].in_list;
}

#define List_Containing nlists__list_containing
extern List_Id List_Containing	PROTO((Node_Id));

/* End of a-nlists.h (C version of Nlists package specification) */

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.1
date: Sun Jan 16 03:59:27 1994;  author: dewar
Initial revision
----------------------------
revision 1.2
date: Sun Jan 16 11:30:28 1994;  author: dewar
Note that the initial revision was split off from a-atree.h version 1.23.
This version of a-nlists.h matches nlists.ads V1.2 and nlists.adb V1.2
----------------------------
** New changes after this line and before endif. **
#endif
