#define FOCUSC           h->color[1]
#define NORMALC          h->color[0]
#define HOT_NORMALC      h->color[2]
#define HOT_FOCUSC       h->color[3]

#define DIR_FORWARD     1
#define DIR_BACKWARD    0

#define B_EXIT		0
#define B_CANCEL	1
#define B_ENTER		2
#define B_USER          100

enum {
    WIDGET_INIT,
    WIDGET_FOCUS,
    WIDGET_UNFOCUS,
    WIDGET_DRAW,
    WIDGET_KEY,
    WIDGET_HOTKEY,
    WIDGET_CHECK_HOTKEY,	/* If current answers 1, don't send hotkey */
    WIDGET_DESTROY
} Widget_Messages;

enum {
    DLG_KEY,			/* Sent on keypress before sending to widget */
    DLG_INIT,			/* Sent on init */
    DLG_END,			/* Sent on shutdown */
    DLG_ACTION,			
    DLG_DRAW,			/* Sent for updating dialog managed area */
    DLG_FOCUS,			/* Sent on give focus to a widget */
    DLG_UNFOCUS,		/* Sent on remove focus from widget */
    DLG_ONE_UP,			/* Sent on selecting next */
    DLG_ONE_DOWN,		/* Sent on selecting prev */
    DLG_POST_KEY,		/* Sent after key has been sent */
    DLG_IDLE			/* Sent if idle is active */
} Dialog_Messages;

typedef struct Dlg_head {
    WINDOW *window;

    chtype *color;
    int count;
    int running;
    int direction;
    int ret_value;
    int send_idle_msg;
    char *help_ctx;
    struct Widget_Item *current, *first, *last;
    int (*callback) (struct Dlg_head *, int, int);
} Dlg_head;

/* Every Widget must have this as it's first element */
typedef struct Widget {
    int x, y;
    int color;			/* If the widget uses it, the color */
    int (*callback)(Dlg_head *,int, int);  /* The callback function */
    void (*destroy)(void *);
    struct Dlg_head *parent;
} Widget;

typedef struct Widget_Item {
    int dlg_id;
    struct Widget_Item *next;	/* next in circle buffer */
    struct Widget_Item *prev;	/* previous in circle buffer */
    Widget *widget;		/* point to the component */
} Widget_Item;

/* draw box in window */
void draw_box (WINDOW *w, int y, int x, int ys, int xs);

/* creates new dialog circle buffer */
Dlg_head *dlg_new (WINDOW *w, chtype *col, int (*callback)
		   (struct Dlg_head *, int, int), int, int, char *);

int  add_widget (Dlg_head *dest, void *Widget);

/* Runs dialog d */
void run_dlg (Dlg_head *d);
void set_idle_proc (Dlg_head *d, int state);

void destroy_dlg (Dlg_head *h);
int  dlg_select_widget (struct Dlg_head *h, void *widget);
void dlg_one_up (Dlg_head *h);
void dlg_one_down (Dlg_head *h);

typedef void  (*destroy_fn)(void *);

void init_widget (Widget *w, int y, int x,
		  int (*callback)(Dlg_head *, int, int),
		  destroy_fn destroy);
int std_callback (Dlg_head *h, int Msg, int Par);
int default_proc (Dlg_head *h, int Msg, int Par);

#define send_message(w,h,Msg,Par) \
    (*w->widget->callback)(h, Msg, Par)
