
/* Structure used to hold dialog values */
typedef struct Dialog {
    void   *backpointer;	/* The previous dialog */
    WINDOW *d;			/* The dialog */
} Dialog;

extern WINDOW *top_window;

char *input_dialog (char *header, char *text, char *def_text);
char *input_expand_dialog (char *header, char *text, char *def_text);
int message (int error, char *header, char *text, ...);
int error (int status, int errnum, char *text,  ...);
void create_dialog (int cols, int rows, char *header, char *text, int error);
#define WITH_HOTKEYS 16
int query_dialog (char *header, char *text, int flags, int count, ...);
void destroy_dialog (void);
void done_dialog (void);

enum {
   D_NORMAL = 0,
   D_ERROR  = 1,
   D_INSERT = 2
} dialog_options;

WINDOW *get_top_text (void);


/* The refresh stack */
typedef struct Refresh {
    void (*refresh_fn)(void *);
    void *parameter;
    int  flags;
    struct Refresh *next;
} Refresh;

/* We search under the stack until we find a refresh function that covers */
/* the complete screen, and from this point we go up refreshing the */
/* individual regions */

enum {
    REFRESH_COVERS_PART,	/* If the refresh fn convers only a part */
    REFRESH_COVERS_ALL		/* If the refresh fn convers all the screen */
};

void push_refresh (void (*new_refresh)(void *), void *data, int flags);
void pop_refresh (void);
void do_refresh (void);
void my_wputs (WINDOW *w, int y, int x, char *text);

extern Refresh *refresh_list;
