
/* Routines to parse the ~/.splitvtrc file and set default options */

#include <stdio.h>
#include <ctype.h>
#include "splitvt.h"

extern char *myputenv();  /* Portable setenv() function in misc.c */

#define WARN(X)	fprintf(stderr, X, lineno); sleep(2);

char *startupfile="%s/.splitvtrc";	/* %s is replaced by $HOME */


char extract(arg)	/* get a char from x/^x format */
char *arg;
{
	if ( *arg == '^' ) {
		++arg;
		if ( islower(*arg) )
			*arg=toupper(*arg);
		return(*arg-'@');
	}
	return(*arg);
}


static int lineno=0;	/* The current line in the startup file */


void set_something(args)
char *args[];
{
	int i;

	if ( ! args[1] ) {
		WARN("Warning: No argument to 'set' in ~/.splitvtrc line %d\n");
		return;
	}
	if ( strcmp(args[1], "command_char") == 0 ) {
		if ( ! args[2] ) {
			WARN("Warning: No command_char to set in ~/.splitvtrc line %d\n");
			return;
		}
		command_c=extract(args[2]);
	} else if ( strcmp(args[1], "switch_char") == 0 ) {
		if ( ! args[2] ) {
			WARN("Warning: No switch_char to set in ~/.splitvtrc line %d\n");
			return;
		}
		switch_c=extract(args[2]);
	} else if ( strcmp(args[1], "quote_char") == 0 ) {
		if ( ! args[2] ) {
			WARN("Warning: No switch_char to set in ~/.splitvtrc line %d\n");
			return;
		}
		quote_c=extract(args[2]);
	} else if ( strcmp(args[1], "upper_lines") == 0 ) {
		if ( ! args[2] ) {
			WARN("Warning: No number of lines to set in ~/.splitvtrc line %d\n");
			return;
		}
		if ( (i=atoi(args[2])) == 0 ) {
			WARN("Warning: Invalid number of lines in ~/.splitvtrc line %d\n");
			return;
		} else
			UU_lines=i;
	} else if ( strcmp(args[1], "login") == 0 ) {
		if ( ! args[2] ) {
			WARN("Syntax error in ~/.splitvtrc line %d (Usage: set login [on|off])\n");
		} else if ( strcmp(args[2], "on") == 0 )
			dologin=1;
		else if ( strcmp(args[2], "off") == 0 )
			dologin=0;
		else {
			WARN("Syntax error in ~/.splitvtrc line %d (Usage: set login [on|off])\n");
		}
	} else {
		WARN("Warning: Invalid parameter to 'set' in ~/.splitvtrc line %d\n");
	}
}

void set_argv(args)
char *args[];
{
	int i;

	if ( ! args[1] ) {
		WARN("Warning: Nothing to run in ~/.splitvtrc line %d\n");
	}
	if ( *args[1] == '-' ) {
		if ( strcmp(&args[1][1], "upper") == 0 ) {
			for ( i=2; args[i]; ++i ) {
				if ( (upper_args[i-2]=
				(char *)malloc(strlen(args[i])+1)) == NULL ) {
					perror("malloc");
					exit(5);
				}
				strcpy(upper_args[i-2], args[i]);
			}
			upper_args[i-2]=NULL;
		} else if ( strcmp(&args[1][1], "lower") == 0 ) {
			for ( i=2; args[i]; ++i ) {
				if ( (lower_args[i-2]=
				(char *)malloc(strlen(args[i])+1)) == NULL ) {
					perror("malloc");
					exit(5);
				}
				strcpy(lower_args[i-2], args[i]);
			}
			lower_args[i-2]=NULL;
		} else {
			WARN("Warning: Invalid argument to 'run' in ~/.splitvtrc line %d\n");
		}
		return;
	}

	/* Straight command line for both upper and lower windows */
	for ( i=1; args[i]; ++i ) {
			if ( ((upper_args[i-1]=(char *)malloc(strlen(args[i])+1)) == NULL) ||
			     ((lower_args[i-1]=(char *)malloc(strlen(args[i])+1)) == NULL) ) {
				perror("malloc");
				exit(5);
			}
			strcpy(upper_args[i-1], args[i]);
			strcpy(lower_args[i-1], args[i]);
	}
	upper_args[i-1]=NULL;
	lower_args[i-1]=NULL;
}

void splitvtrc()
{
	char *home, splitvtrc[256];
	FILE *rcfile;
	char line[BUFSIZ], newline[BUFSIZ*2], *parsed[256];
	char *head, *tail, *ptr, *subptr;
	char *envptr, envbuf[128];
	int  i, n, quoted=0;
	int  ignoring=0, ifs=0;

	if ( (home=(char *)getenv("HOME")) == NULL )
		home="";

	sprintf(splitvtrc, startupfile, home);
	if ( (rcfile=fopen(splitvtrc, "r")) == NULL )
		return;

	while ( fgets(line, BUFSIZ-1, rcfile) ) {
		++lineno;
		/* Clean up leading and tailing whitespace */
		for ( head=line; WHITESPACE(*head); ++head );
		for ( tail=(head+strlen(head)); 
			(WHITESPACE(*(tail-1)) && (tail > head)); --tail );
		*tail='\0';
		if ( (*head == '\0') || (*head == '#') )
			continue;

		/* Parse the line */
		tail=head; 
		for ( i=0, head=ptr=newline; *tail; ) {
			if ( WHITESPACE(*tail) ) {
				*(ptr++)='\0';
				parsed[i++]=head;
				do {
					++tail;
				} while ( *tail && WHITESPACE(*tail) );
				head=ptr;
			}
			/* Not whitespace */

			/* Environment variable expansion */		
			if ( *tail == '$' ) {
				n=0;
				for (subptr=(tail+1);isalpha(*subptr);++subptr)
					envbuf[n++]=(*subptr);
				envbuf[n]='\0';
				tail=subptr;
				if ( (envptr=(char *)getenv(envbuf)) ) {
					strcpy(ptr, envptr);
					ptr+=strlen(envptr);
				}
				continue;
			}
				
			/* Support backslash escape */
			if ( *tail == '\\' )
				++tail;

			if ( *tail )
				*(ptr++) = *(tail++);
		}
		*ptr='\0';  /* cap the new buffer with a null */
		parsed[i++]=head;
		parsed[i++]=NULL;

		/* Perform flow control (no nested if statements) */
		if ( strcmp(parsed[0], "if") == 0 ) {
			if ( !parsed[1] ) {
				WARN("Warning: bad if syntax in ~/.splitvtrc line %d\n");
				continue;
			}
			if ( ifs ) {
				WARN("Warning: ignoring nested if statement in ~/.splitvtrc line %d\n");
				continue;
			} ++ifs;

			/* if <> syntax */
			if ( ! parsed[2] ) {
				if ( *parsed[1] )
					ignoring=0;
				else
					ignoring=1;
				continue;
			}

			/* if <> operand <> syntax */
			if ( strcmp(parsed[2], "==") == 0 ) {
				if ( strcmp(parsed[1], parsed[3]) == 0 )
					ignoring=0;
				else
					ignoring=1;
			} else if ( strcmp(parsed[2], "!=") == 0 ) {
				if ( strcmp(parsed[1], parsed[3]) == 0 )
					ignoring=1;
				else
					ignoring=0;
			} else
				WARN("Warning: unknown if conditional in ~/.splitvtrc line %d\n");
			continue;
		}
		if ( strcmp(parsed[0], "else") == 0 ) {
			if ( ignoring )
				ignoring=0;
			else
				ignoring=1;
			continue;
		}
		if ( strcmp(parsed[0], "endif") == 0 ) {
			--ifs;
			ignoring=0;
			continue;
		}
		if ( ignoring )
			continue;

		/* Check for a variable setting */
		if ( parsed[1] == NULL ) {
			for ( n=0; parsed[0][n]; ++n ) {
				if ( parsed[0][n] == '=' )
					break;
			}
			if ( parsed[0][n] ) {
				myputenv(parsed[0]);
				continue;
			}
		}

		/* Check for various commands */
		if ( strcmp(parsed[0], "set") == 0 )
			set_something(parsed);
		else if ( strcmp(parsed[0], "run") == 0 )
			set_argv(parsed);
		else {
			WARN("Warning: Invalid directive in ~/.splitvtrc line %d\n");
		}
	}
	return;
}
