#include <stdlib.h>
#include <string.h>
#include "link.h"

#define ALLOC_TXT	20000	// Dimension du buffer pour allocation
							// des chaines.


static char *ptacc = NULL;
static char *lastacc = NULL;

char *strdup_err (const char *str, int quit)
{
	char *ret = strdup(str);
	if (ret == NULL){
		fprintf (stderr,"Can't allocate %d bytes of memory\n",strlen(str)+1);
		if (quit) exit (-1);
	}
	return ret;
}
void *malloc_err (int size, int quit)
{
	void *ret = malloc(size);
	if (ret == NULL){
		fprintf (stderr,"Can't allocate %d bytes of memory\n",size);
		if (quit) exit (-1);
	}
	return ret;
}
/*
	Accumule une chaine dans un tableau dynamique et retourne son adresse.
	C'est l'quivalent d'un strdup rapide sans liberation possible.
*/
char *alloctxt_add (const char *str)
{
	int len = strlen(str) + 1;
	if (ptacc == NULL || ptacc + len >= lastacc){
		ptacc = (char*)malloc_err (ALLOC_TXT,1);
		lastacc = ptacc + ALLOC_TXT;
	}
	strcpy (ptacc,str);
	char *ret = ptacc;
	ptacc += len;
	return ret;
}


