.ND

.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.PP
.bp
.NH
List\ of\ Abbreviations
.br
.PP
.PP
The main task in Networking is to remember what all the
abbreviations one encounters really mean. Here's a list of
those used frequently throughout the guide:
.IP ACU\ 
Automatic Call Unit. A modem.
.FS 
Alternatively: A teenager with a telephone.
.FE
.IP ARP\ 
Address Resolution Protocol. Used to map IP addresses
to Ethernet addresses.
.IP ARPA\ 
Advanced Research Project Agency.
.IP BBS\ 
Bulletin Board System. Dial-up mailbox system.
.IP BGP\ 
Border Gateway Protocol. A protocol for exchanging
routing information between autonomous systems.
.IP BIND\ 
Berkeley Interned Name Domain. An implementation
of a DNS server.
.IP BNU\ 
Basic Networking Utilities. A popular UUCP version (also
called HoneyDanBer UUCP).
.IP BSD\ 
Berkeley Source Distribution. A Un*x flavor.
.IP CCITT\ 
International organization of postal services.
.IP CSLIP\ 
Compressed Serial Line IP. An protocol for exchanging IP
packets over a serial line, using header compression.
.IP DNS\ 
Domain name system. Internet standard for mapping of host names
to IP addresses.
.IP EGP\ 
External Gateway Protocol. A protocol for exchanging
routing information between autonomous systems.
.IP FQDN\ 
Fully Qualified Domain Name. The hostname with the full domain name.
.IP FTP\ 
File Transfer Protocol.
.IP FYI\ 
``For Your Information.'' Series of documents with informal
information on Internet topics.
.IP GMU\ 
Groucho Marx University. Fictitious University used throughout
this book.
.IP ICMP\ 
Internet Control Message Protocol. A networking protocol.
.IP IETF\ 
Internet Engineering Task Force.
.IP IP\ 
Internet Protocol. A networking protocol.
.IP ISO\ 
International Standards Organization.
.IP ISDN\ 
Integrated Services Digital Network. New telecommunications
technology using digital circuitry instead of analog.
.IP MX\ 
Mail Exchanger. A DNS resource record type.
.IP NFS\ 
Network File System. Standard for accessing data on remote
disks transparently.
.IP NIS\ 
Network Information System. An RPC-based software for network-wide
file-sharing.
.IP NNTP\ 
Network News Transfer Protocol.
.IP OSI\ 
Open Systems Interface. An ISO standard on network software.
.IP PLIP\ 
Parallel Line IP. A protocol for exchanging IP packets over
a parallel line or a printer port.
.IP TCP\ 
Transfer Control Protocol. A networking protocol.
.IP TCP/IP\ 
Sloppy description of the Internet protocol suite
as a whole.
.IP RARP\ 
Reverse Address Resolution Protocol. Permits hosts to
find out their IP address at boot time.
.IP RFC\ 
Request For Comments. Series of documents describing
Internet standards.
.IP RPC\ 
Remote Procedure Call. Protocol for executing procdures inside
a process on a remote host.
.IP RIP\ 
Routing Information Protocol. Routing protocol used inside
LANs (Autonomous Systems).
.IP SLIP\ 
Serial Line IP. A protocol for exchanging IP packets over
a serial line.
.IP SMTP\ 
Simple Mail Transfer Protocol.
.IP SOA\ 
Start of Authority. A DNS resource record type.
.IP UDP\ 
User Datagram Protocol. A networking protocol.
.IP UUCP\ 
Unix to Unix Copy.
A suite of network transport commands for dial-up
networks.
.IP YP\ 
Yellow Pages. An older name for NIS.
.PP
.bp
.NH
Foreword
.br
.PP
.PP
.PP
When I first heard rumors of Linux, I was struggling with Andrew Tanenbaum's
Minix on my old Atari. Running a multitasking system on a M 68000 is not
wholly satisfactory, which was not the fault of Minix but rather that of
said architecture. I finally figured out that it was the time to
upgrade. I had already worked on Un*ces and was looking for a
machine which was not too expensive, but would allow me to run
a Un*xoid operating system which was not too expensive either.
Although hedging a deep distrust of PC's (after all, aren't they all
DOS machines inside?), I decided to try Linux, and have not regretted
it since.
.PP
After going through a number of ups and downs, like file system crashes,
occasional core dumps, overwritten password files, etc, my Linux
setup has settled in the meanwhile and has become a stable environment.
The kernel and C library have become that good that most standard
software may be compiled with no more effort than is required on any
other mainstream Un*x system, and a broad assortment of packaged
Linux distributions allows you to almost drop it onto your hard disk
and start playing.
.PP
The only thing that occasinally gets in the way of Linux
enthusiasts is what may be called the Great Information Void ---
a phenomenon that drags the knowledge-thirsty user into a vortex
\&\fBREADME\fR's, \fBFAQ\fR's and other files spelt in capital letters
which help you solve many problems, but rarely give you the whole
picture. What is lacking is some sort of documentation that allows
users to understand 
the mechanism behind everything, and enables them to work things out
themselves.
.PP
To this end, a couple of people formed the Linux Documentation Project
(LDP) in late 1992, which aims at putting together a coherent set of
manuals. Stopping short of answering questions like ``How?'', or ``Why?',
or ``What's the meaning of life, universe, and all the rest?'', these
manuals attempt to cover most aspects of running and using a Linux
system. This book is part of the LDP series and deals with network
management and administration.
.PP
Without networking, there wouldn't be any Linux today. One of the main
factors in the Linux experience --- apart from the determination of
its contributors --- is that everything can be made available quickly, and
that developers and users may communicate with ease. All this is made possible
through the cooperation of unnumbered sites in networks, and the
cooperation of these networks among each other. (It also bears well
remembering that these services are often administered by people in their
spare time.)
.PP
Thus, there has always been a special interest among the Linux
community to bring networking to Linux. From an early stage, UUCP-based
software was available, which allowed to connect your Linux machine to
one of the networks using a dialup-connection. Later came the drive to
provide Linux with the necessary kernel functionality and user software
that allows participation in local TCP/IP-based networks, using Ethernet,
etc, which even allows to get your machine on the Internet. This effort is
still under way, but is rapidly evolving.
.PP
This manual tries to cover both types of networking, introducing you
to the basics, guiding you through the setup stages, and finally describes
how to set up and run a number of applications, including NFS, electronic 
mail, and Usenet news.
.PP
.NH 2
Organization\ of\ this\ Book
.br
.PP
.PP
This book is organized in the following way:
.PP
\&\fIChapter 1\fR gives you an introduction to networking in
general, working out the concepts and terminology. If you know
what the OSI model is, you might want to skip this.
.PP
\&\fIChapter 2\fR discusses the issues involved in TCP/IP-based
networking. This works out the concepts introduced in Chapter 1.
.PP
\&\fIChapter 3\fR gets down to the very basics of TCP/IP-networking
in Linux. It includes a tour of the kernel's networking interfaces,
and describes their configuration. It also covers setup of the resolving
library, dealing with both simple hosts tables and setup of a name
server.
.PP
\&\fIChapter 4\fR introduces you to various network applications
that can be found on most Un*xish systems, like \fBinetd\fR and
the ``\fBr\fR'' command suite (\fBrlogin\fR, \fBrsh\fR, etc.).
.PP
\&\fIChapter 5\fR deals with configuring NFS, the Networking
File System.
.PP
\&\fIChapter 6\fR describes how to set up your serial hardware for
dialling out and in.
.PP
\&\fIChapter 7\fR shows you how to manage Taylor UUCP. For those who
have never used UUCP before, and know next to nothing on how it works,
there is a short tour of its major principles.
.PP
\&\fIChapter 8\fR gives an overview of electronic mail, and the ideas
involved in it: address formats, routing, and the whole lot of it.
Part of the chapter is devoted to setting up \fBelm\fR, a standard
mail user interface included in almost every Un*x nowadays.
.PP
\&\fIChapter 9\fR guides you through the setup of \fBsmail\fR on
your system. If you want to echange mail with other sites, you either
have to run this, or \fBsendmail\fR.
.PP
\&\fIChapter 10\fR is a twin of chapter 9, in that it describes the setup
of the \fBsendmail\fR mail transport agent.
.PP
\&\fIChapter 11\fR covers the basic ideas of netnews, and the setup of
Cnews. Also has a short section on using NNTP.
.PP
\&\fIChapter 12\fR is a tour de force on newsreader configuration. It
tries to cover the basic tasks needed in administering \fBtin\fR,
\&\fBtrn\fR, and \fBnn\fR.
.PP
\&\fIAppendix A\fR describes how to build a so-called ``null printer 
cable'' for use with the PLIP parallel interface IP protocol decsribed
in chapter 3.
.PP
\&\fIAppendix B\fR contains a copy of the GNU General Public License.
.PP
The book ends with a annotated bibliography that contains a list of
books recommended for further reading.
.PP
.NH 2
The\ Linux\ Documentation\ Project
.br
.PP
.PP
The Linux Documentation Project, or LDP, is a loose team of writers,
proofreaders, and editors who are working together to provide complete
documentation for the Linux operating system.  The overall
coordinator of the project is Matt Welsh, who is heavily aided by Lars
Wirzenius and Michael K. Johnson.
.PP
This manual is one in a set of several being distributed by the LDP,
including a Linux Users' Guide, System Administrators' Guide, Network
Administrators' Guide, and Kernel Hackers' Guide. These manuals are
all available in LaTeX source format, \fB.dvi\fR format, and postscript
output by anonymous FTP from \fBnic.funet.fi\fR, in the directory
\&\fB/pub/OS/Linux/doc/doc-project\fR, and from \fBtsx-11.mit.edu\fR, in the
directory \fB/pub/linux/docs/guides\fR.
.PP
We encourage anyone with a penchant for writing or editing to join us in
improving Linux documentation. If you have Internet e-mail access, you can
join the \fBDOC\fR channel of the \fBLinux-Activists\fR mailing list by 
sending mail to 
.PP
.QP
.nh
linux-activists-request@niksula.hut.fi
.PP
with the line
.PP
.QP
.nh
X-Mn-Admin: join DOC
.PP
 
.PP
in the header or as the first line of the message body.  To leave the
channel, send a message to the same address, including the line
.PP
.QP
.nh
X-Mn-Admin: leave DOC
.PP
 
.PP
.NH 2
Typographical\ Conventions
.br
.PP
In writing this book, a number of typographical conventions were employed
to mark shell commands, variable arguments, etc. They are explained below.
.PP
.IP \fBBold\ Font\fR\ 
Used to mark \fBnew concepts\fR, \fBWARNINGS\fR, and \fBkeywords\fR
in a language.
.IP
.IP \fIItalics\ Font\fR\ 
Used for \fIemphasis\fR in text, and occasionally for quotes
or introductions at the beginning of a section.
.IP
.IP \fBTypewriter\ Font\fR\ 
Used to represent screen interaction, as in
.QP
.nh
.DS
.ft CW
# ls -l /bin/cp
-rwxr-xr-x  1 root    wheel    12104 Sep 25 15:53 /bin/cp
	 
.DE
.ft R
\&\&
.PP
Also used for code examples, whether it is ``C'' code, a shell
script, or something else, and to display general files, such as
configuration files.  When necessary for clarity's sake, these
examples or figures will be enclosed in thin boxes.
.IP
.IP \fB\fBTypewriter\ Slanted\ Font\fR\fR\ 
Used to mark \fBmeta-variables\fR in the text, especially in
representations of the command line.  For example,
.QP
.nh
\&\fB
ls -l \fBfoo\fR
\&\fR
.PP
.IP
where \fBfoo\fR would ``stand for'' a filename, such as \fB/bin/cp\fR.
.IP
.IP `Key\'\ 
Represents a key to press.  You will often see it in this form:
.QP
.nh
Press return`return' to continue.
.PP
.IP $<>$\ 
A diamond in the margin, like a black diamond on a ski hill,
marks ``danger'' or ``caution.''  Read paragraphs marked this
way carefully.
.IP
.IP \fB$\fR\ and\ \fB#\fR\ 
When preceding a shell command to be typed, these denote the
shell prompt. The `\fB$\fR' symbol is used as when the command
may be executed as a nomral user; `\fB#\fR' means that the
command requires super user privilieges.
.PP
.NH 2
Thanks
.br
.PP
This book owes very much to the numerous people who took the
time to proofread it and helped iron out many mistakes, both grammatical
and technical. The most vigorous
among them are Michael K. Johnson, Iain Lea, and Wolfgang Michaelis.
I also wish to thank Ian Taylor for sparing the time to read through the UUCP
chapter and fill in some of the gaps.
.PP
I would also like to thank Matt Welsh, who was the first to
encourage me when I uttered the idea ``someone'' might write a 
Networking Guide for Linux.
.PP
Extra praise goes to all the people who have contributed so much
time and energy through their work behind the scenes, especially
to Ari Lemke, maintainer of the mailing list at \fBniskula\fR, and
of the FTP archive at \fBfunet\fR; to
Ted T'so, who is maintaining the FTP archive at \fBtsx-11\fR; and
the numerous FTP administrators at \fBsunsite\fR.
.PP
Although they are not directly involved in the writing of this
guide, I would like to thank all those who started the whole
Linux business, and have kept the ball rolling for so long:
Linus Torvalds, Lars Wirzenius, Theodore T'so, H.J. Lu, Ross
Biro, Peter MacDonald, Fred van Kempen, Donald Becker,\&...
.PP
Of course, there are many more people involved in the shaping
of Linux than this short list can name; you know who you are!
.PP
.bp
.NH
Introduction\ to\ Networking
.br
.PP
.PP
.PP
.PP
.PP
.NH 2
History
.br
.PP
.PP
The idea of networking is probably as old as telecommunications 
itself. Consider people living in the stone age, where drums may have
been used to transmit messages between individuals. Suppose caveman A
wants to invite caveman B for hurling rocks at each other, but they
live too far apart for B to hear A banging his drum. So what are
A's options? He could 1) walk over to B's place,
.FS 
This option is in fact so rarely chosen, that any occurence
thereof inevitably leaves traces in history books, like, for example,
the Marathon run.
.FE
 2) get a bigger drum, or 3) ask C, who lives halfway between them,
to forward the message. The last is called networking.
.PP
Of course, we have come a long way from the primitive pursuits and
devices of our forebears. Nowadays, we have computers talk to each 
other over vast assemblages of wires, satellites, and the like, to
make an appointment for saturday's soccer match.
.FS 
The original spirit of which (see above) still shows on some
occasions in Europe.
.FE
 However, in the following, we will deal with the
means and ways by which this is accomplished, and
leave out the wires, as well as the soccer part.
.PP
We will encounter two types of networks in this guide, those based
on UUCP, and those based on TCP/IP. These are protocol suites
and software packages that supply means to transport data between two
computers.
In a networking environment, anything that is able to react reasonably
to communication requests from the network is called a \fIhost\fR.
This is very often a computer, but need not be; one can also think
of X terminals or printers as hosts. Small agglomerations of hosts are also
called \fIsites\fR.
.FS 
In the UUCP world, most sites consist of one host,
but it might also be a LAN with one computer handling the UUCP link
to the outside world. Such sites are most often managed in a way to
appear as a monolithic system to the outside world.
.FE
.PP
UUCP started out as a package of programs to transfer
files over serial lines, schedule those transfers, and initiate
execution of programs on remote sites. It has undergone major changes
since its first implementation in the late seventies, but is still
rather spartan about the service it offers. UUCP-based networks
are of the store-and-forward variety, which means that the physical
links between forwarding hosts are activated at certain intervals only
(usually several times a day), so that any data has to be stored
temporarily. The first of these networks evolved soon after the initial release,
with over 80 Unix-developing sites already connected in mid-1978.
They were running email as an application, as well as remote printing.
However, the system's central use was in distributing new software and
bugfixes.
.FS 
Not that the times had changed that much\&...
.FE
e
.FS 
This is detailed in a report by D. A. Novitz and Mike E. Lesk, named
``A simple dial-up network in a Unix(tm) environment'', published in
August 1978. It is available at some FTP servers.
.FE
 One year later, in 1979, after the release of UUCP with the new Unix V7,
three graduate students had the idea of a general information exchange
within the Unix community. They put together some scripts, which became
the first netnews system. In 1980, this network connected \fBduke\fR,
\&\fBunc\fR, and \fBphs\fR, at two Universities in North Carolina.
Out of this, Usenet finally grew, which nowadays stretches across
several continents, comprising networks of all sorts.
.PP
TCP/IP traces its descent to a research project funded by the DARPA
(Defense Advanced Research Projects Agency) in 1969. This was an
experimental network, the ARPANET, which was converted
into an operational one in 1975, after it had proven to be a success.
Its main difference from UUCP-based networks is that it is not
a store-and-forward network, but is based on packet switching. This means
that permanent or semi-permanent circuits are used to connect various sites,
with data not being transferred in files, but in smaller
chunks (packets) which are forwarded instantaneously.
This type of network is called a \fIpacket-switched\fR network.
.PP
In 1983, the new protocol suite TCP/IP was adopted as a new
standard, and all hosts on the network were required to use it.
When ARPANET finally grew into the Internet (with ARPANET itself passing
out of existence in 1990), the use of TCP/IP had spread to networks
beyond the Internet itself. Most notable are local area networks
used in Un*x networks.
.PP
The networking software included in the various distributions of
Linux comes from many places. Many authors have contributed
software packages to the net community, often maintaining them for years and
investing a lot of their work. Before you curse them because something doesn't
work the way you expect it to, imagine where you would be without their effort.
.PP
Where single authors have written an application program, they are
credited, sometimes giving their addresses when they still maintain
the particular package. Other software, such as the majority of TCP/IP
clients and daemons, comes from the BSD Networking Release 2.
Finally, we credit all those people who relentlessly keep hacking
the Linux kernel, especially Linus Torvalds, Ross Biro (who
wrote much of the original kernel TCP/IP code), Fred N. van Kempen (who has
rewritten much of the network code and taken over further
development), and Theodore Ts'o (who maintains the serial drivers).
There are many, many more of them. We thank you!
.PP
.NH 2
Two\ Examples
.br
.PP
To have realistic material for demonstration at hand during the following, 
we introduce two examples:
.PP
Consider a University, complete with many, many departments, wars over
funding, etc. We call it Groucho Marx University (GMU), situated somewhere
in Netland. Most departments run their own LANs, while some share
one, and others run several of them. They are all interconnected,
and are hooked to the Internet through a single high-speed link.
.PP
The other example is more like what you may encounter when setting up
your Linux box: Let's assume we have a little company that's brewing,
say, virtual beer.
.FS 
Hasn't that joke been beaten to death yet? Well, it hasn't \fB:-)\fR
.FE
 For this purpose, they have some PCs in their offices, all
running a bright and shiny Linux 1.0. They are
connected by an Ethernet. Name those machines \fBvlager\fR, \fBvstout\fR,
and \fBvale\fR (\fBv\fR standing for ``virtual'', of course). One day
they acquire the virtual winery which is located one floor above.
The winery people have their own network, with machines named
\&\fBvbeaujolais\fR, \fBvbardolino\fR and \fBvchianti\fR. So they decide
to join their respective networks, and connect \fBvlager\fR to
the winery's Ethernet.
We will follow the brewers through their plight in setting up an operational
local network.
.PP
Someday they decide to get on the net to get into closer touch
with their customers, so they look for a UUCP site that might feed
them mail and news. They find one, its name being \fBmoria.orcnet.org\fR.
Not a pleasant bunch of neighbors, altogether, but you can't help it,
can you?
.PP
Now, our virtual brewers try to pick a name for their site. Their
first idea is to call themselves \fBlong-live-linus\fR, but that's
too long a name for UUCP transports, so they settle for \fBlinus\fR.
In a later chapter we will peek over their shoulders while configuring
UUCP, email, and netnews.
.PP
``Now, why two examples?'' you might ask. Well, I thought I had to give 
one example of a site with Internet access, and one of a site with a UUCP
link. I hope this isn't getting too confusing. I will use the first
example mainly to explain TCP/IP networking features in this
chapter; later chapters dwelling on Linux configuration will only refer
to the virtual brewers.
However, consider the large-scale examples for GMU with a sense
of caution: I am in no way an Internet ``old hand''; my knowledge
comes from books and RFCs only.
.PP
.NH 2
The\ OSI\ Model
.br
.PP
.PP
.PP
.PP
One paradigm that has proven to be most useful is to view networking
as consisting of a number of tasks, organized in layers.
They are thought to be built on top of each other, with the
hardware being the lowest, and
the application program being the highest. Each layer has a well 
defined interface through which it offers one or more services to the
layer above it; it executes requests by using the interface
offered to it by the layer immediately below it. The functions
offered by an interface are also called \fIservice access points\fR.
Often, layers are split into sublayers to offer a clearer view
of their functionality and requirements.
.PP
One description of the network software's layering is given by a model
drawn up by the \fIInternational Standards Organization\fR,
ISO for short, and is called the \fIOpen Sytems Interface
(OSI) Reference Model\fR. It
consists of seven layers, which will be explained below as
far as they apply to the networks we discuss. Not all of the OSI
layers are present in all networks, as we will see.
It is not very enlightning to apply the OSI model to UUCP-based
networks, since most of its features are absent.
In this section, we will therefore refer to UUCP networks only shortly.
.PP
At each level, the software performing the task is thought of as
exchanging data with the corresponding level on the destination machine. 
The drivers are therefore referred to as \fIpeer processes\fR.
Peer processes are usually free to exchange data by whatever
means they choose, as long as they agree on it. For example,
they may split up the data into chunks, or choose from different
transport protocols and routes.
Now, the service two peer processes provide to the layer above them
can be distinguished by whether it is reliable, and whether a connection
is thought to exist or not.
.PP
Reliable service requires thorough checks on the integrity of thee
data transmitted
.FS 
You all know those fizzles and crackles on long distance calls.
You can image what they do to an electric pulse
less than a millisecond wide.
.FE
 and acknowledgements sent back to the sender, containing
positive or negative confirmation on the state of the data
received.
.FS 
Well, it's actually not that simple. Ask Prof. Murphy.
.FE
 The usefullness of reliable service is obvious. Unreliable service,
on the other hand, might be desirable if
the network user performs his own error checking, or simply because 
it is only important a significant portion of the data comes
through.
.PP
The second criterion is whether actual connections
are desired, or connectionless service will suffice. In real life,
telephone conversations versus letters sent by postal mail
give a pretty good example of the difference between the two types of service.
In the networking world, UUCP definitely is connectionless,
altough not necessarily unreliable (don't laugh!). The other
kind of service is, for example, a dialup session at your
favorite BBS --- where the ``application'' connection coincides with
the physical conection --- or an FTP session to an overseas
server --- providing for the illusion of a direct connection.
The latter is therefore also called a \fIvirtual connection\fR.
.PP
Lower layers may well provide unreliable
service, with a higher layer adding error checking and thus providing
a reliable service. Equally, a connection-oriented service may be built
upon a connectionless service by some layer making
sure that any data sent arrives at the destination host and is delivered
to the upper layer in the order sent.
.PP
To perform its duty, peer processes may need to exchange administrative
information related to the data being passed, for example checksums,
acknowledgements, or requests to build up or release a connection.
Therefore, each layer generally wraps up the data it is handed from
above, adding any information it wants to pass along to its peer.
Generally, this is done by adding a \fIheader\fR (and possibly a trailer).
This may be as little as a few
bits to separate packets from each other, and as much as a few dozen
bytes. This combined data is then passed to the software of the layer
below, which processes the data according to the service requested but
is completely ignorant of the packet's contents. It may then add its
own header, and so on. When the packet arrives at the remote host, each layer
in turn unwraps the data it is handed from below, processing it
according to the information contained in the header, and passes
it on to the layer above.
.PP
.NH 3
The\ Phyiscal\ Layer
.br
.PP
.PP
The basic layer is the \fBphysical layer\fR, which deals
with the physical aspects of the equipment used, like wiring,
timing logic, etc. We leave that to the people in the soldering iron
department.
.PP
The most widely used equipment is what is commonly known as \fIEthernet\fR.
It consists ofa single coaxial cable with hosts being attached to it
through connectors, taps or transceivers. Ethernets come in two flavors,
called \fIthick\fR and \fIthin\fR, respectively. Most people prefer
thin over thick Ethernet, because it is much cheaper: PC cards come for
as little as US$ 80. Together with a net transfer rate of 10 Megabit per
second this accounts for much of its popularity.
.PP
One of its drawbacks is that the cable length is usually limited to
200 meters, which precludes any use of Ethernet technology other than for LANs.
Several Ethernet segments may be linked to each other using repeaters,
bridges or routers. Repeaters simply copy the signals between two or
more segments, so that all segments together will act as if it was one Ethernet.
Due to timing requirements, there may not be more than four repeaters
between any two hosts on the network.  Bridges and
routers are more sophisticated. They analyze incoming data and only forward
it when the recipient host is not on the local Ethernet. They will
be covered in section See section Internetworking..
.PP
.NH 3
The\ Data\ Link\ Layer
.br
.PP
.PP
The next layer is the \fBdata link layer\fR which utilizes the
physical layer to exchange data with hosts it is physically
connected to. It is there to hide any idiosyncrasies of the hardware
and offer a uniform interface to the upper layers, so that the network
software need not worry about different types of hardware.
For each type of equipment used, a different driver
has to be implemented. For example, there are kernel drivers for handling
I/O with your Ethernet card, as well as a SLIP driver for sending
network traffic over a serial line.
The low-level protocol drivers UUCP uses to safely transfer data over
telephone lines also belong here.
.PP
The protocols involved in using an Ethernet are described in 
standard no. 802.3 issued by the IEEE.
.FS 
To be exact, IEEE 802.3 covers both the physical layer and the medium
acess sublayer (MAC) specifications of an Ethernet.
The medium access sublayer is the lower part of the
data link layer. The upper part is governed by the Logical Link
Control (LLC) protocol, which is the same for token bus (IEEE 802.4)
and token ring (IEEE 802.5). LLC itself is described in IEEE 802.2.
.FE
 The standard allows for an arbitrary number of hosts on an Ethernet.
To distinguish them, each host is assigned a unique 6-byte address, usually
written as \fBaa:bb:cc:dd:ee:ff\fR. Data is transported in chunks
(so-called \fIframes\fR) of up to 1500 bytes long, with a header and
trailer being added that contain source and destination address along
with a checksum.
.PP
To send a frame, a host has to wait until the Ethernet is idle (no
other traffic) and then may start sending its frame. All stations
will receive this and compare the destination address to their own
address. All but the proper recipient will discard the frame, while the
recipient will hand the frame's data to the upper layers.
.PP
If two stations try to send a frame at the same time, there is
a \fIcollision\fR. Both will stop transmitting and restart after a
random time interval.
.PP
On serial lines a ``de facto'' standard is frequently
used, which is SLIP, or \fIserial line IP\fR. A modification of this
is known as CSLIP, or \fIcompressed SLIP\fR, and
performs compression of IP headers to make better use
of the relatively low bandwidth provided by serial links.
.FS 
SLIP and CSLIP are described in RFC 1055 and RFC 1144, respectively.
.FE
 An entirely different serial protocol is PPP, or
\&\fIpoint-to-point protocol\fR. It has many more features than
SLIP, including a link negotiation phase. Its main advantage over
SLIP, however, is that it isn't limited to IP datagrams, but was
designed to allow for any type of datagrams to be transmitted.
It is assumed that it will one day replace SLIP.
.FS 
The original description of PPP can be found in RFC 1134, however
there are a number of ancillary RFCs.
.FE
 PPP is an example of a data link protocol that may be used for more
than one type of hardware. Although its main use today is for
serial lines, where are debates going on if it should one day become
the standard for ISDN-links.
.PP
In TCP/IP networks, the data link layer is also responsible for resolving
IP addresses to the hardware-dependent address. On Ethernets, for example,
the \fIAddress Resolution Protocol\fR, or ARP, is used to find the
Ethernet address corresponding to an IP address.
.FS 
ARP uses the broadcast feature of Ethernet to probe for
any host that recognizes the IP address as his. See RFC 826
for a specification of ARP.
.FE
e
.FS 
To allow booting a diskless client via the
network, there's a related protocol for mapping Ethernet to
IP addresses, named RARP (\fIreverse ARP\fR). This, however is
not implemented in the data link layer, but is provided by an
independent server.
.FE
 ARP uses the broadcast feature of Ethernet to send a query with the
unresolved IP address to all stations on the local Ethernet. The host
recognizing the address as its own returns a message to the sender,
containing its Ethernet address.
.PP
ARP, however, is not limited to Ethernets. It may be used over any
hardware that supports broadcasting, for example AX.25 (used for
transmitting IP packets over packet radios).
.PP
The results of ARP queries are stored in a kernel table from
which the driver may look them up. Entries in this table are
discarded after a certain time to keep this table from overflowing.
.PP
.NH 3
The\ Networking\ Layer
.br
.PP
.PP
On top of the data link layer lies the \fBnetworking layer\fR.
It is responsible for transporting data given to it to the destination host
using the services provided by the data link layer.
.PP
In TCP/IP networking, this operation is generally performed using
the \fIInternet Protocol\fR, abbreviated IP. The destination
host is given to it as a number 32 bits wide, called the
IP addresses. We will later see how they are made up
(see section See section IP Addresses.).
.PP
One of the networking layer's duties is interconnecting physically
dissimilar networks (like Ethernets, token rings, etc.) into one
apparently homogeneous
network. This is called internetworking, and the resulting 
``meta-network'' is called an internet. Note the subtle difference
between \fIan\fR internet and \fIthe\fR Internet here. The latter
is the official name of one particular internet.
.PP
To achieve the illusion of a single (inter-) network, the data link layer 
hides the diversity of the equipment used by defining an abstract
``interface''. This interface offers a set of operations which
is the same for all types of hardware.
.PP
In TCP/IP networking, interfaces are identified by a name. For example,
Ethernet interfaces in Linux are called \fBeth0\fR, \fBeth1\fR, etc,
and SLIP interfaces come as \fBsl0\fR, \fBsl1\fR, etc.
.PP
While the operations of the data link layer only involve hosts
that may communicate with each other directly --- e.g. all hosts
on an Ethernet ---, the network layer's task of delivering data to
\&\fIany\fR destination requires cooperation between a possibly large
number of hosts: when the destination cannot be reached directly,
the sender has to rely on one or more other hosts to act as forwarders.
The sequence of intermediate hosts the data has to travel is usually
referred to as a route.
.PP
Most networks implement some algorithm in the network layer
to construct these routes. In packet-switched networks, this algorithm
often performs ``dynamic'' routing, which means that routes are adjusted
whenever necessary. The opposite, static routing, is often used for
mail routing in UUCP-based networks, where new routes are computed
once every few days or weeks.
.PP
Another, equally important duty of the network layer is congestion control.
When network traffic increases, some links tend to congest quickly.
To relieve these, some of the sending hosts might be told to decrease
the rate at which they emit data. Networks that use a dynamic
routing scheme also have the option to adapt their routing
decisions to the actual network load.
.PP
In TCP/IP networking, routing and congestion control are
handled by IP, and a companion protocol, the \fIInternet Control
Message Protocol\fR (ICMP). Routing information in the networking layer
is usually static, but may be adapted dynamically from router daemons
(e.g. \fBrouted\fR). These daemons regularly exchange local routing
information, and update the kernel's routing tables according to the
information received.
.PP
The IP layer of remote
hosts may also send an ``ICMP Redirect Message'' when it detects
that a sending host has chosen a bad route. This enables the sending
host to augment its routing table by the hint returned in the redirect message.
.PP
Another responsibility of ICMP is to return an indication to
the sender in case an error occurred. For example, if a host receives
an IP packet for an address that it is unable to reach, it returns an
error message to the sender. The most widely known ICMP message, 
however, is the ``Echo'' message, which simply causes the destination host
to acknowledge its receipt. This is used by the Un*x \fBping\fR
tool (see See section ping.) to test the reachability of
foreign hosts and compute the delay in getting there.
.PP
The networking layer in UUCP is not as obvious as with IP.
UUCP does not perform any routing of its own, but expects
to be handed the destination's address in form of a route.
UUCP's network layer only pushes around files between hosts,
establishing point-point-connections to transfer them at
certain times.
Generation of the route has to be performed by higher levels.
.PP
The entirety of the lower three layers is also often referred to as
the \fIsubnet\fR, because this is where actual networking ---
in the terms of handing information from host to host ---
takes place. The layers above only deal with the destination host,
the service desired on the remote host, and possibly a route to it.
.PP
The service IP offers to the upper layers is connectionless and
unreliable. One reason for this is that experience has shown that
the subnet is inherently unreliable, even in the presence of a reliable
networking protocol: Gateways may fail, or packets might be routed
to the wrong destination, or take a long route only to pop up
at the destination much later, and so on. But then,
connection-oriented service which is not reliable is not very useful.
Another reason is that one
also wants to utilize the routing services provided by the IP level
for transports that don't need a connection to be established,
so that this is best added in a higher layer.
This is done in the next layer, the so-called \fBtransport layer\fR.
.PP
.NH 3
The\ Transport\ Layer
.br
.PP
.PP
Its task is to provide the upper layers with access to a remote
host's services.
In TCP/IP networks, different types of transport may be provided.
One is implemented using TCP, or \fITransport Control Protocol\fR.
It builds a connection-oriented reliable service on top of IP.
There are many gory details to this which we will not discuss here.
.PP
Another protocol implemented nearly everywhere is UDP, or
\&\fIUser Datagram Protocol\fR, which offers an unreliable
connectionless service. It takes packets of data and hands them to
the IP layer for transport, caring little if they arrive at all, and
even less if they do so in the order sent. However, if a host finds
it cannot deliver a UDP packet properly, it returns an error
indication, so that the sender has some notification of whether the
datagram got through.
.FS 
This feature is used by a debugging tool, \fBtraceroute\fR, to
detect the route IP datagrams take to a given destination. It
sets the datagram's ttl (time-to-live) value such that it is discarded
by the host that is exactly n hops away from the sender, gradually
increasing the ttl until it reaches the remote host.
From the error messages it can deduce the sequence of hosts the
datagrams pass.
.FE
.PP
Finally, there's a protocol that doesn't perform any actions by
itself, but simply hands data on to the IP level. This is the
RAW protocol.
.PP
Of course, networking requires a destination that the data should be
delivered to once it has arrived on the remote host.
For example, you wouldn't want your love letters to be passed to
the news subsystem, or all of \fBcomp.os.linux\fR to the printer
spooler. Thus, the destination address needs to contain a description
of the service to hand the message to.
.PP
On UUCP-based networks, this is solved by specifying
a program to be invoked which will process your data.
For example, to print this book on \fBhostA\fR, you would
issue the following command at the prompt:
.QP
.nh
\&\fB
$ uux - hostA!lpr -Plaserjet < netguide.dvi
\&\fR
.PP
.PP
With TCP/IP networking, a more general scheme is used.
Each service a site offers defines a so-called \fIservice access point\fR
through which it may be contacted. These service access points
are assigned \fIport numbers\fR. Now, when a process wants
to contact a service on a remote host, it passes the data to
be transferred to the networking software, alongside with
the remote host's address and the service's port.
.PP
One certainly wants the transport layer to support several concurrent
connections to the same service, like several remotely logged-in users.
To distinguish these, the client always has to specify a sender
port number, which has been generated uniquely by the originating
host.
Thus, a connection is determined uniquely by a host/port pair for
each of the two hosts involved.
.PP
In order for the client to know the proper port number
to use for accessing a particular service, an agreement has
to be reached between the administrators of both systems on
the assignment of these numbers. For services that are only used
within an organization, this can be done privately.
However, service numbers widely used (such as for the network filesystem,
\&\fBtelnet\fR, electronic mail, etc), have to be administered
centrally. This is done by the IETF (or \fIInternet Engineering
Task Force\fR), which regularly releases a RFC titled
``\fIAssigned Numbers\fR''.
.FS 
Its most recent release is RFC 1060.
.FE
 It describes, among many other things,
the port numbers assigned to \fIwell-known services\fR. There is also
generally a file translating service names to numbers, it is
called \fB/etc/services\fR. It is described below
in See section The services file..
.PP
However, this is not yet the entire truth. Consider a datagram
arriving on a host. Who decides what transport protocol it is handed
to? Of course, you may say, the transport layer might decide from the port
numbers of sender and destination which protocol is involved. But,
for some protocols, like RAW, there is no such thing as a connection
established beforehand, so there is no information on the protocol involved.
Therefore, there is an IP header field containing a protocol identification
which allows it to dispatch the datagram to the appropriate driver in
the transport layer. This identification is a 16 bit number. The correspondence
between protocols and numbers is, of course, also a matter of standardization,
and is also laid down in the ``Assigned Numbers'' RFC. On your host,
this information is kept in the file \fB/etc/protocols\fR.
.PP
All layers up to the transport are generally located in the kernel,
and so they are in Linux. The user interface most common in
the Un*x world is the \fIBerkeley Socket Library\fR. Its name
derives from a popular analogy for service access points that
views ports as sockets, and connecting to a port as plugging
in. It provides calls to specify a remote host, a transport protocol, and a
service (\fBbind(2)\fR) to which to connect or to
listen to (using \fBconnect(2)\fR, \fBlisten(2)\fR and
\&\fBaccept(2)\fR). The socket library is however somewhat more
general, in that it provides not only a class of 
network-based sockets (the \fBAF_INET\fR sockets), but also another
class that handles connections local to a machine (the \fBAF_UNIX\fR
class).  Some versions can also handle other classes as well, for
instance those that have a class of sockets for the XNS (Xerox Networking
System(?)) protocol, or for X.25.
.PP
.NH 3
The\ Upper\ Layers
.br
.PP
.PP
The \fBsession layer\fR usually deals with the way two communicating
processes exchange status information and service requests. For
example, a FTP application somehow has to tell the FTP service
on the remote host which file to retrieve, or which directory
to change to.
.PP
In TCP/IP networking, no standard session layer is provided. Every
application has to define and implement it separately. However, 
a common practice for applications using TCP connections is to
define a set of messages transferred as lines of ASCII text,
terminated by carriage return and linefeed. A protocol defines
the commands that may be issued by the client, and a set of
responses to be returned by the server. Responses most often
consist of a three-digit octal number that may be followed by
a human-readable interpretation of the message. Transmission
of text is usually terminated by a line containing a single
dot. An example is SMTP, the \fISimple Mail Transfer Protocol\fR.
.PP
Figure See section The Upper Layers. shows a sample SMTP session. Lines
beginning with a three-digit number are messages from the server,
all other lines are commands issued by the client.
.PP
[htbp]
.DS
.ft CW
220 monad.swb.de Smail 3.1.28.1 #6 ready at Tue, 29 Jun 93 10:45 MET DST
HELO fubar.swb.de
250 monad.swb.de Hello fubar.swb.de
MAIL FROM:okir@fubar.swb.de
250 <okir@fubar.swb.de> ... Sender Okay
RCPT TO:torvalds@niksula.hut.fi
250 <torvalds@niksula.hut.fi> ... Recipient Okay
DATA
354 Enter mail, end with "." on a line by itself
  --- (sending mail message) ---
\&\&.
250 Mail accepted
quit
221 monad.swb.de closing connection
 
.DE
.ft R
.PP
	Figure: 
A sample SMTP session.
The layer immediately above is the \fBpresentation layer\fR,
which provides for a system-independent representation of data
to be transferred. Again, in TCP/IP networks, every application
has to define this for itself. For example, FTP defines a
representation to transfer text files between any two machines,
and TELNET has a \fIvirtual terminal\fR to represent terminal
control sequences in a system-independent fashion.
.PP
Both of these layers are absent in UUCP networks.
.PP
The upmost layer is the \fBapplication layer\fR. This is the
user program performing a particular task, like \fBftp\fR
or the mail transport software.
.PP
.NH 3
Internetworking
.br
.PP
.PP
Above we stated that one of the networking layer's duties was to link
physically dissimilar networks to form an internet. But, of course,
it would be rather limiting to allow linking of networks only at
this level of the protocol stack. For example, assume a LAN that consists
of several Ethernets. Linking them by just inserting a long piece
of cable between the segments does not work because of the electrical
specifications. On the other hand, inserting a gateway at each
junction is forbidding because of the delay introduced. Imagine
some data of yours had to pass a dozen or so gateways just to
travel a few hundred yards distance, being constantly wrapped and
unwrapped by Ethernet drivers!
.PP
A simple solution to this problem is the use of \fIrepeaters\fR.
These are electrical devices used to connect two Ethernets, who
do not perform any analysis of data passing through it, but only
copy bits to and fro. Now traffic may float freely between all
Ethernets, and there are no limitations.
.PP
Sadly, this is not so. For one, timing specifications require
that a signal sent by one station on an Ethernet reaches any other
station within a certain amount of time. This puts an upper boundary
of four on the number of repeaters two stations may be apart.
.PP
Another drawback of repeaters is that instead of at most a few dozen
machines on one local segment, all machines from the linked segments
compete for the right to transmit a frame. When segments A and B are
linked by a repeater, all stations on segment A have to shut up when
a station on segment B talks.
.PP
Another solution is the use of \fIbridges\fR. These are still
Ethernet-specific devices, but instead of simple bit-shuffling,
a bridge receives entire frames, analyzes the recipient, and only
copies it to one of the adjacent segments when the recipient is known
to be on that segment (or known to be reachable through this segment).
A bridge does not suffer from the limitations of a repeater, because
the single Ethernets remain separate entities, and frames only get copied
to another segment if really needed. The drawback of bridges is that they
need to be configured properly.
.PP
Now, let's have a look at where these techniques fit in our protocol
stack. A gateway, as we said, is located in the networking layer.
Repeaters are on the other end of the scale, they operate entirely at
the physical layer, while bridges are in the data link layer.
.PP
Of course, one can also think of internetworking schemes that reside
in still higher levels. For example, one could think of a program
that accepts TCP connections for remote hosts, multiplexes
them onto a serial line, with a similar program demultiplexing the whole
on another machine and opening a separate TCP connection to the
target host.
.FS 
In fact, there is a program for Linux that does roughly this.
This is the \fBterm(1)\fR program written by Micheal O'Reilly,
\&\fBoreillym@tartarus.uwa.edu.au\fR.
.FE
 Such a program would definitely operate at the transport
layer.
.PP
.bp
.NH
Issues\ of\ TCP/IP\ Networking
.br
.PP
.PP
.PP
.PP
.NH 2
IP\ Addresses
.br
.PP
.PP
As mentioned in the previous chapter, the addresses understood by the
IP network layer are 32-bit numbers. Every machine must be assigned a
number unique to the networking environment. If you are running
a local network that does not have TCP/IP traffic with other 
networks, you may assign these numbers according to your personal
preferences. However, for sites on the Internet, numbers are
assigned by a central authority, the Network Information Center,
or NIC.
.FS 
To apply for an IP address for your network, send a mail to
\&\fBhostmaster@nic.ddn.mil\fR. It is recommended to obtain one
even if you don't intend to get on the Internet yet; you may
want to in the future.
.FE
.PP
For easier reading, IP addresses are split up into four 8 bit
numbers called \fIoctets\fR.
.FS 
They aren't called bytes because there are machines on the
Internet with byte sizes other than eight bits.
.FE
 For example, \fBuunet.uu.net\fR has an IP address of
\&\fB0xC0306002\fR, which is written as \fB192.48.96.2\fR.
This format is often referred to as the \fIdotted quad notation\fR.
.PP
Another reason for this notation is that IP addresses are
split into a \fInetwork\fR number, which is contained
in the leading octets, and a \fIhost\fR number, being the remainder.
Depending on the size of the network, the host part may need to be
smaller or larger. To accomodate different needs, there are
several classes of networks, defining different splits
of IP addresses.
.PP
.IP A\ 
Class A networks have network numbers of \fB1.0.0.0\fR through
\&\fB127.0.0.0\fR. This provides for a 24 bit host part, allowing
roughly 1.6 million hosts.
.IP B\ 
Class B networks have network numbers \fB128.0.0.0\fR through
\&\fB191.255.0.0\fR. This allows for 16065 nets with 
65534 hosts each.
.IP C\ 
Class C networks have network numbers \fB192.0.0.0\fR through
\&\fB223.255.255.0\fR. This allows for nearly 2 million networks
with up to 254 hosts.
.IP D\ 
Addresses falling into the range \fB224\fR through \fB254\fR
are reserved for future use and don't specifiy any network.
.PP
This shows that \fBuunet\fR's address refers to host \fB2\fR on the class C
network \fB192.48.96.0\fR.
.PP
When applying to the NIC for IP addresses, you do not do so for each
separate host you plan to use. Instead, you are assigned a network number,
and are allowed to assign all valid IP addresses within this range to hosts
on your network according to your preferences. The network class you are
assigned depends on the size of the network you are running.
.PP
You may have noticed that in the above list only 254 possible values were
allowed for octets in the host part. This is because host numbers
with octets all \fB0\fR or all \fB255\fR are reserved for special purpose. An
address with all host part octets zero refers to the network, and one with all host
part octets \fB255\fR is called a broadcast address. This refers
to all hosts on the specified network simultaneously.
Thus, \fB192.48.96.255\fR is not a valid host address, but refers
to all hosts on network \fB192.48.96.0\fR.
.PP
There are also two network addresses that are reserved, being \fB0.0.0.0\fR
and \fB127.0.0.0\fR. The first is called the \fIdefault route\fR, the latter
the \fIloopback address\fR. The default route has something to do with the way
IP routes datagrams.
.PP
The loopback network is a class A network reserved for testing and debugging
purposes. Usually, address \fB127.0.0.1\fR will be assigned to a special
interface of your host. This is called the \fIloopback interface\fR and
acts like a closed circuit. Any packet handed to it from TCP or UDP will
be returned to them as if they had just arrived from some network.
This allows you to develop and test networking software without ever
using a ``real'' network.
.PP
.NH 2
IP\ Routing
.br
.PP
.PP
<>
When you write a letter to someone, you will usually put a complete
address on the envelope, specifying the country, state, zip code,
etc. After putting it into the letter box, the postal services will
deliver it to its destination: they will send it to the country indicated,
whose national postal services will dispatch it to the proper state and region, etc.
The advantage of this hierarchical scheme is rather obvious: Wherever
you send the letter from, the local postmaster will know roughly the direction
to forward the letter to.
.PP
IP networks are structured in a similar way. The whole Internet
consists of a number of proper networks, called \fIautonomous systems\fR.
Each such system performs any routing between its member networks
internally, so that the task of delivering a datagram is reduced to finding
a path to the destination host's system. This means, as soon as the datagram 
is handed to \fIany\fR host that is on that particular network, further 
processing is done exclusively by the network itself.
.PP
This structure is reflected by splitting IP addresses into a host and
network part, as explained above. 
By default, the destination network is derived from the network part
of the IP address. Thus, hosts with identical IP network numbers should be
found on the same network, and vice versa.
.FS 
Autonomous systems are slightly more general, however. They may comprise
more than one IP network.
.FE
.PP
Now, of course, one would prefer a similar scheme \fIinside\fR
the network, too, since it may consist of a collection of hundreds of
smaller networks itself, with the smallest units being physical networks
like Ethernets. Therefore, IP allows you to subdivide an IP network into
several \fIsubnets\fR.
.PP
Note that this is different from what ``subnet'' means in the OSI model:
The OSI term refers to the entirety of equipment and software that
is responsible for getting data from one host to another:
.FS 
Probably the prefix ``sub'' was chosen to suggest that it denotes some
low-level functionality.
.FE
 The transport layer hands a packet to the subnet, which does lots of
``don't ask'' things, and finally it pops up at the destination host ---
if you're lucky, that is.
.PP
However, in IP-speak, a subnet is something very concrete. In fact,
it's just one of those things the OSI term wants to hide:
it is a subordinate part of an IP network that takes over
responsibility for delivering datagrams to a certain range of IP addresses.
Like an autonomous system, a subnet is identified by the network part of
the IP addresses it represents. However, the network part is now
extended to include some bits from the host part. The number of bits
that are interpreted as the subnet number is given by the so-called
\&\fIsubnet mask\fR. This is a 32 bit number, too, which specifies the bit
mask for the network part of the IP address.
.PP
A class B network, for example \fB149.76.0.0\fR, is identified by the first two
octets of its IP address. Thus, its subnet mask is \fB255.255.0.0\fR.
For delivery inside this network, it might be split up into 254 subnets, being
\&\fB149.76.1.0\fR through \fB149.76.254.0\fR. They all share the same IP network
number, while the third octet is used to distinguish between them.
Thus they will use a subnet mask of \fB255.255.255.0\fR.
.FS 
These subnets may now be subdivided again by further extending the network
part of the IP address. Of course, different ``sub-subnets'' may use different
subnet masks.
However, hosts on the \fIsame\fR subnet must use the same subnet mask for
this subnet.
.FE
.PP
It is worth noting that subnetting (as the technique of
generating subnets is called) is only an \fIinternal division\fR
of the network. Subnets are generated by the network owner (or the
administrators). Frequently, subnets are created to reflect existing
boundaries, be they physical (between two Ethernets), administrative
(between two departments), or geographical, and authority over these
subnets is delegated to some contact person. However, this structure
only affects the network's internal behavior, and is completely
invisible to the outside world.
.PP
At the lowest level, subnet boundaries usually coincide with hardware
boundaries. The viewpoint of a host on a given subnet is a very limited one:
The only hosts it may talk to directly are those of the subnet it is on.
All other hosts belong to the Great Blue Yonder which is accessed through
so-called \fIgateways\fR.
A gateway is a host that is connected to two or more subnets or networks
simultaneously. This may be a bridge (simply copying datagrams from one
Ethernet to another), a router (a special device that runs some sort
of IP routing software), or a computer.
Therefore, hosts which are connected to more than one subnet need
one IP address per subnet. Consequently, IP addresses and subnet
masks are not considered host parameters, but interface parameters.
.PP
Frequently, traffic between two subnets has to traverse more than
one gateway. The sequence of hosts to travel is called a \fIroute\fR.
The scheme by which datagrams are directed to the proper host is called
\&\fIrouting\fR.
Consider a datagram being handed to the IP layer of a host on some
Ethernet. It will check if the network portion of the IP address is
the same has the Ethernet's subnet number (as determined by the subnet mask),
and if so, will deliver it directly. Otherwise, it is passed to
a gateway which is supposed to deliver the datagram to the destination
host. The gateway, having received a datagram, basically
faces the same options as the sender, namely local delivery to one of the
adjacent Ethernets, or forwarding to another gateway --- but it is presumably
one step closer to the destination. Thus, in the presence of several
gateways, the cunning in IP routing lies in guessing the ``right'' one
to hand the datagram to. The ``right'' one --- apart from any quality
critera one might wish to consider --- is a gateway that is able to
forward the datagram to the destination network.
.PP
Thus, the routing information used by IP is basically an
(incomplete) table linking networks to gateways to reach them through.
A catch-all entry (the ``default gateway'') must generally be
supplied, too; this is the gateway associated with network
\&\fB0.0.0.0\fR.
.FS 
Routing data through a default gateway is inherently inefficient.
To straighten out bad default routes, a gateway may notify the
sending gateway of a better alternative by sending it an
``ICMP redirect'' message. ICMP is the Internet Control Message
Protocol. It is described in RFC 792.
.FE
.PP
Well, before you start collapsing or begin to wonder why you thought
networking seemed such a neat thing in the first place, we will provide
you with an example. In figure See section Groucho Marx Network., a part of the network
topology at Groucho Marx University (GMU) is shown.
.PP
GMU has a class B network address of \fB149.76.0.0\fR.
The administrators at the Groucho Computing Centre (GCC) have decided
to use the third octet as a subnet number to address LANs. 
Thus, the subnet mask is \fB255.255.255.0\fR.
The subnet numbers are shown at the center of the circles,
which represent LANs.
For example, the Mathematics Department runs a single LAN, which
has been assigned \fB149.76.4.0\fR, while the Collider Lab has
two LANs, having network addresses of \fB149.76.12.0\fR and
\&\fB149.76.14.0\fR, respectively.
Most LANs are connected to a Fiber Optics cable that runs across
the campus. This is a network by its own right, and has been given
number \fB149.76.1.0\fR.
.PP
In the above graphic, hosts which are on two networks at the same time
are shown with both addresses. For example, the machine that is
the gateway between \fB12.0\fR and the Fiber Optics cable has
address \fB149.76.12.1\fR when talking to the Collider Lab LAN,
and \fB149.76.1.12\fR when talking to network \fB149.76.1.0\fR.
.PP
An example routing table for \fB149.76.12.1\fR might
look like this:
.PP
.PP
.PP
Routing tables may be built by various means. For LANs, it is
usually most efficient to construct them by hand and feed them
to IP using the \fBroute\fR command at boot time (see
section See section Interface Configuration.). For larger internets (see
section refintro.osi.subnet), they are built
and adjusted at run-time by \fIrouting daemons\fR; these run on
central hosts of the network and exchange routing information to
compute ``optimal'' routes between the member networks.
.PP
The intended scope of their arbitration determines the protocol
employed. For routing inside autonomous systems (such as Groucho
Marx campus), the \fIinternal routing protocols\fR are used.
The most prominent one is RIP, or Routing Information Protocol,
which is, for example, supported by the BSD \fBrouted\fR daemon.
For routing between autonomous systems, \fIexternal routing protocols\fR
like EGP (External Gateway Protocol), or BGP (Border Gateway Protocol)
have to be used; these (as well as RIP) have been implemented in the
University of Cornell's \fBgated\fR. We will not describe them in
this document.
.FS 
For further information, please refer to RFC 1058 (RIP),
RFC 827, RFC 904 (EGP), RFC 1163, and RFC 1266 (BGP).
.FE
.PP
.PP
.PP
.NH 2
The\ Domain\ Name\ System
.br
.PP
.PP
<>
As described above, addressing in TCP/IP networking revolves
around 32 bit numbers. However, you will have a hard time
remembering more than a few of these. Therefore, ``ordinary''
names are generally used to name hosts on a network. It is
then the application's duty to find the IP address corresponding
to this name. This process is called \fIaddress resolution\fR.
.PP
Now, on a small network like an Ethernet, or even a cluster of them,
it is not very difficult to maintain tables mapping host names
to addresses. On Un*x systems, this information is usually
kept in a file named \fB/etc/hosts\fR. This is also the way
address resolution was initially handled on the Internet.
However, since the beginning of the eighties, the number
of sites and computer networks has exploded, so that it is virtually
impossible to keep routing information up to date.
.PP
This is why a new address resolution scheme has been adopted, the Domain
Name System, or DNS for short.
Host addresses have been organized in a hierarchy of domains.
A domain is a collection of sites that are related in some sense ---
be it because they form a proper network (e.g. all machines on a
campus, or all hosts on BITNET), because they all belong
to a certain organization (like the U.S. government), or because
they're simply geographically close. Such a domain may itself be part
of a larger domain, which is in turn part of a still larger domain.
This relationship is described as being a \fIsubdomain\fR of the
larger domain. To produce a unique address for each machine,
.FS 
In fact, what's needed is only a scheme that maps a name to a host.
It is perfectly legal for a machine to have several names (i.e.
\&\fIaliases\fR).
.FE
 names inside a domain must be unique. Assume a machine in the mathematics
department of Groucho Marx College is named \fBgauss\fR. The Ethernet
run by the maths department will then be called something like \fBmaths\fR,
and the whole campus network might be named \fBgroucho\fR. Thus, the
machine's address would be \fBgauss.maths.groucho.edu\fR. Such a name
determines the site's place in the domain hierarchy and is called
its \fIfully qualified domain name(FQDN)\fR.
.PP
There is also one pseudo-domain which encompasses all hostnames and
domains. It is called the \fIroot domain\fR and denoted by a single
dot. Therefore, fully qualified domain names are sometimes written
with a trailing dot to indicate that they are relative to the root 
domain.
.PP
There are a number of major domains, which are split up into
subdomains, which may again be split up, etc. The US top-level
domains are
.IP \fB.edu\fR\ 
Educational institutions like universities, etc.
.IP \fB.com\fR\ 
Commercial organizations, companies.
.IP \fB.org\fR\ 
Non-commercial organizations. Often private UUCP networks
are in this domain.
.IP \fB.mil\fR\ 
US military institutions.
.IP \fB.gov\fR\ 
US Government agencies.
.IP \fB.net\fR\ 
Gateways and other administrative host on a network.
.IP \fB.uucp\fR\ 
Officially, all site names formerly used as UUCP names
without domain, have been moved to this domain.
.PP
Outside the US, each country generally defines its own top domain, like
\&\fB.uk\fR for the United Kingdom, \fB.fr\fR for France, \fB.de\fR
for Germany, or \fB.au\fR for Australia etc.
.PP
Now the idea behind DNS is that address data may be retrieved from
so-called \fIname servers\fR that do not hold the entire database,
but only a fraction of the overall data in their cache. In the
beginning, a name server doesn't have much information than on
the local domain. The storage in which this data is kept
is called the \fIcache\fR. This information may be retrieved by anyone by
simply sending a query to the name server, which returns the
desired information.
.PP
Usually, there will be only one name server (or at most a few) for
any given domain. Clients within this domain will have to query one of
them to obtain addresses for a given hostname. So, how can a client
obtain the IP address from a host in a different domain?
.PP
Assume the client queries the local name server for \fBtsx-11.mit.edu\fR,
who fails to find it in its cache. However, instead of returning an
error, it checks if it finds the address of the \fBmit.edu\fR domain
name server in its cache. If this still fails, it looks for \fBedu\fR,
and finally for a name server for the root domain. Only if this fails,
too, will it return an error. However, if any name server address
is found, a query for \fBtsx-11.mit.edu\fR will be sent to this
server, which will most probably produce the corresponding address.
The local name server will return the resulting address to the client,
and store it in its cache for further use.
.PP
Now, DNS wouldn't buy us much if the root name server still had to
know all addresses. Therefore, the name space has been split up into
\&\fIzones of authority\fR that maintain their part of the name space
independently.
A zone of authority is roughly the same as a domain
for which an organization assumes responsibility.
It has a topmost node, which is the (domain) name, and comprises
all (domain and host) names below that node unto the beginning of
a new zone. For these, it has to provide name service mapping hostnames
in this zone to IP addresses. Responsibility may be further
delegated to subdomains, by creating new zones at these domains,
which then provide independent name service for themselves.
.PP
Now, when in the above example, the local name server queries the
root name server, this will look if it finds any authoritative
name server for the \fBedu\fR zone of authority. There sure are
name servers for \fBedu\fR, one of them being \fBa.isi.edu\fR.
The root name server will then return its IP address to the local
name server, along with the indication that this is a name server's
address. The local name server will then continue and query
\&\fBa.isi.edu\fR for \fBtsx-11.mit.edu\fR, which will probably return
a pointer to one of MIT's name servers, etc.
.PP
This looks like a lot of traffic being generated for looking
up one simple address, but is really only miniscule compared
to the amounts of data that would have to be transferred
with the old method.
.PP
We have seen in the example above that DNS does not only deal with
IP addresses of hosts, but also exchanges information on name servers.
There are in fact a number of types an entry in the DNS database may
have.
.PP
Entries in the DNS database are called \fIresource records\fR,
They have a certain type associated with them, describing the sort of data
contained, and a class, describing the sort of network address
associated. The latter accomodates the needs of different addressing
schemes, like IP addresses (the \fBIN\fR class), or addresses of
Hesiod networks
.FS 
Anybody explain to me what they are?
.FE
 (the \fBHS\fR class), and many more. The prototypical resource record
type is the \fBA\fR record which associates an IP address with a 
fully qualified domain name. Another type of record, linking aliases
for a domain or host to its \fIcanonical name\fR, is the \fBCNAME\fR
resource record.
.PP
Now, each zone maintains at least two \fImaster\fR name servers which are
authoritative for this particular zone.
Authoritative information is stored in the \fBSOA\fR resource
record (which stands for ``Start of Authority''). It is loaded
into the master name server at boot time, together with a list
of \fBA\fR records describing the names and IP addresses of all
hosts in the zone.
.PP
Any query for an address in that zone will eventually be passed
to one of them (unless, of course, an intermediate server has cached
the information).  However, as we read above, the root of a zone is 
part of the zone itself, whence the dilemma arises how to query a name
server whose address is the subject of the query itself. Therefore,
authoritative data has to be accompanied by information on the master
name servers of the zones directly below. It is kept in \fBNS\fR
and \fBA\fR resource records, which give the nameserver's hostname
and IP address for the subordinate zone. Since this information
is what holds the name space together, they are also called
\&\fIglue records\fR. Since nameservers belong to their respective
zone, these are never authoritative.
.PP
The master name servers for a zone are kept in sync by making one
the \fIprimary\fR name server, and the others \fIsecondary\fR.
The primary server loads its zone information from so-called
\&\fIzone files\fR at startup, while secondary servers transfer this
information from the primary server. To keep themselves fairly well
synchronized, secondary servers expire this data after a certain
time, which means they query the primary server if the zone's
authoritative information has changed, and if so, reload it.
.PP
.PP
.PP
.PP
Maybe an example to visualize this might be in order here. Consider the
section of the name space given in Fig. See section DNS picture..
Those domains marked by a fat dot define the root of a zone.
You can see that the physics department of our fictitious
Groucho Marx University have been given authority over their
network. Thus, the zone of authority starting at the node
labelled \fBgroucho.edu.\fR comprises all of the maths and English
department, while the physics department is a \fIseparate\fR zone.
.PP
Assume that the master name server for the physics department is
located at \fB149.76.12.1\fR. Then the configuration file loaded
into the nameserver might contain data as shown in
figure See section DNS Example., while the configuration
file for the master name server for GMU will have a line in it
as shown in figure See section DNS Example..
.PP
[htbp]
.DS
.ft CW
;
; Authoritative Information on physics.groucho.edu
@                IN       SOA          {
                     up.collider.physics.groucho.edu.
                     hostmaster.up.collider.physics.groucho.edu.
                     1034             ; serial no
                     360000           ; refresh
                     3600             ; retry
                     3600000          ; expire
                     3600             ; default ttl
                   }
;
; Our secondary name server
                 IN     NS           gauss.maths.groucho.edu.
;
; Hosts in the physics Dept.
;
; Collider Lab
up.collider      IN     A            149.76.12.1
down.collider    IN     A            149.76.12.4
strange.collider IN     A            149.76.12.6
boson.collider   IN     A            149.76.14.1
muon.collider    IN     A            149.76.14.7
\&\&...
;
; Nuclear Physics Dept.
bohr.nukes       IN     A            149.76.8.3
hahn.nukes       IN     A            149.76.8.77
\&\&...
 
.DE
.ft R
.PP
	Figure: 
An excerpt from the \fBnamed.hosts\fR file for the
Physics Department.
[htbp]
.DS
.ft CW
@                IN       SOA          {
                     vax12.gcc.groucho.edu.
                     hostmaster.vax12.gcc.groucho.edu.
                     233              ; serial no
                     360000           ; refresh
                     3600             ; retry
                     3600000          ; expire
                     3600             ; default ttl
                   }
\&\&....
;
; The zone of authority for the physics dept.
physics          IN        NS        up.collider.physics.groucho.edu.
                 IN        NS        gauss.maths.groucho.edu.
;
; Glue record
up.collider.physics IN     A         149.76.12.1
\&\&...
 
.DE
.ft R
.PP
	Figure: 
An excerpt from the \fBnamed.hosts\fR file for GMU.
In the two figures, you may note that some names end with a dot, while
others don't. That is because the latter are only given relative to the
domain \fBgroucho.edu\fR, and the others are given absolute. DNS
software distinguishes this by a trailing dot.
.PP
Finally, there's one special domain that is used to find hostnames
corresponding to IP addresses and networks.
This is called \fIreverse mapping\fR,
and may be used by some applications to find out the caller's hostname.
For example, some FTP servers only allow you to log in when they are
able to find your host name. The domain used for this is
\&\fBin-addr.arpa\fR. To find out the name corresponding to, say
\&\fB149.76.12.20\fR, you may query DNS for \fB20.12.76.149.in-addr.arpa\fR.
Equivalently, to find the name for network \fB149.76.0.0\fR, query
DNS for \fB76.149.in-addr.arpa\fR. Resource records linking
\&\fBin-addr.arpa\fR names to hostnames may be given using the \fBPTR\fR
record type.
.PP
Now, it would be sort of unwieldy for user programs to query
the name server directly, putting together UDP datagrams
manually, and waiting for responses to come in. Therefore, a
library is used, the so-called \fIresolver\fR. Its configuration
is explained below in section See section Resolver Configuration..
.FS 
For more information on DNS and its implementation, refer to
RFC 1034 and RFC 1035, as well as RFC 1033, which describes the
\&\fBnamed\fR configuration file format.
.FE
.PP
.bp
.NH
Configuring\ TCP/IP\ Networking
.br
.PP
.PP
.PP
.PP
.NH 2
General\ Remarks
.br
.PP
.PP
Due to the nature of TCP/IP development in Linux, there has not
been a single standard for networking applications and configuration
in the past.
For example, until recently, all configuration files as well
as most daemons resided under \fB/usr/etc/inet\fR. Many
moved this to \fB/etc/inet\fR to have these files on their root
partition, making \fB/usr/etc/inet\fR a symbolic link to \fB/etc/inet\fR.
In release 4.1 of the C library, H.J. Lu changed the location
of all network configuration files to
\&\fB/etc\fR, which is the common place for such things on other
Un*x systems. Fred van Kempen, in his distribution of
networking binaries, reintroduces \fB/usr/etc\fR and creates \fB/etc/net\fR.
Until things settle a bit more, I have found it convenient
to move everything to \fB/etc\fR, and make the other
directories point to \fB/etc\fR:
.QP
.nh
.DS
.ft CW
# mv /usr/etc/* /etc
# mv /etc/inet/* /etc
# rmdir /usr/etc /etc
# ln -s /etc /usr/etc
# ln -s /etc /etc/net
 
.DE
.ft R
\&\&
.PP
Other differences in network software distributions include the client
and server programs distributed,
which sometimes expect files in different places, etc. If you can't get
something to work, don't yell; get the latest networking software
and kernel release. Something that's wrong will probably have been
discovered by others as well, so that a fix (or at least a proposed
workaround) is likely to be known. Or it may simply be that some applications
won't work very well together because they make false assumptions
about the location of some file. After all, Linux is 
``work in progress''.
.PP
A good place to look before starting to configure Linux networking
is the NET-2-FAQ. It is maintained by Matt Welsh
.FS 
Matt can be reached at \fBmdw@tc.cornell.edu\fR.
.FE
 and is co-authored by a number of other people. It contains the most
up-to-date information. You can get it (among others) from
\&\fBtsx-11.mit.edu\fR, as \fB/pub/linux/doc/NET-FAQ\fR.
.PP
.NH 2
Software\ Installation
.br
.PP
.PP
.PP
.PP
.PP
.NH 3
Installing\ the\ Binaries
.br
.PP
.PP
For those who have been running network applications on Linux
kernels prior to release 0.99.10, note that
the new kernel networking code obsoletes some commands from the
NET-1 code (most notably the \fBconfig\fR command), and requires
a number of new commands. Most application software, however, should
continue to work.
.PP
Fred van Kempen has put together a complete binary and source distribution
of administration tools and application programs, together with a coherent
set of configuration files (not included in release 10 of the binary
distribution, although the in the source package).
.PP
The TCP/IP networking software to be used with the NET-2 release is
available by anonymous FTP from \fBtsx-11.mit.edu\fR in
\&\fB/pub/linux/packages/net/net-2\fR. There are three packages
below \fBbinaries/net\fR:
.PP
.IP \fBnet-base.tar.z\fR\ 
This contains the administration tools specific to the NET-2
release, such as \fBifconfig\fR, \fBroute\fR, etc, together
with configuration files and boot scripts. Note that the paths
used in these files are not consistent with any binary releases
prior to NET-2.
.IP \fBnet-std.tar.z\fR\ 
This has all basic network applications. It includes \fBtelnet\fR,
\&\fBrlogin\fR, \fBftp\fR and NFS clients and servers.
.IP \fBnet-ext.tar.z\fR\ 
This currently contains nothing but a version of the \fBtin\fR
newreader capable of reading and posting news via NNTP.
.PP
You may unpack all of these from the root directory, issuing
.QP
.nh
# zcat net-\fBxxx\fR.tar.z | tar xvvpoof -
.PP
at the shell prompt.
.PP
Alternatively, if you are a cautious person,
.FS 
Ever had a binary distribution overwrite your \fB/etc/passwd\fR file? \fB:-)\fR.
.FE
 you can unpack them in some
safe location and move them to the appropriate places by hand.
.PP
Sources to all programs are available from the same location, to
be found below the \fBsource\fR directory. The source of tools
included in \fBnet-base.tar.z\fR is in \fBsource/net/net-020.tar.z\fR
(of course, the release number will change).
.PP
.NH 3
Setting\ up\ the\ \fBproc\fR\ filesystem
.br
.PP
.PP
Some of the configuration tools of the NET-2 release rely on
the \fBproc\fR filesystem for communicating with the kernel. This
is a kernel interface implemented by Michael K. Johnson that permits
access to kernel run-time information through a filesystem-like
mechanism. When mounted, you can list its files like any other
filesystem, too, or display their contents. Typical items include
the \fBloadavg\fR file that contains the system load average, or
\&\fBmeminfo\fR, which shows current core memory and swap usage.
.PP
To this, the NET-2 code adds a \fBnet\fR directory.
It contains a number of files that show things like the
kernel ARP tables, the state of TCP connections, and the routing tables.
Most network administration tools get their information from these files.
.PP
The \fBproc\fR filesystem (or \fBprocfs\fR as it is also known)
is not in the kernel by default, you have to make sure it has been
configured in. The best way to find out if you have it, try to
mount it as described below. If the \fBprocfs\fR is not in your
kernel, you will get a message like ``\fBmount: fs type procfs
not supported by kernel\fR''. You will then have to recompile the
kernel and answer ``yes'' when asked for \fBprocfs\fR support.
.PP
The \fBprocfs\fR
is usually mounted on \fB/proc\fR at system boot time. The best 
method is to add the following line to \fB/etc/fstab\fR:
.PP
.QP
.nh
.DS
.ft CW
# procfs mont point:
none		/proc		proc	defaults
 
.DE
.ft R
\&\&
.PP
and execute ``\fBmount /proc\fR'' from your \fB/etc/rc\fR script.
.PP
.NH 2
Hardware\ Configuration
.br
.PP
.PP
.PP
.PP
.NH 3
A\ Tour\ of\ Linux\ IP\ interfaces
.br
.PP
The Linux networking software comes with a number of hardware
drivers. This section attempts to provide you with basic
information on configuring your hardware components for TCP/IP
networking.
.PP
.QP
.nh
\&\fB
Please note that due to the current pace of development,
the information of this section will be rapidly outdated, so you
should always check the kernel source \fBREADME\fRs, too.
\&\fR
.PP
.PP
As described in section See section The Data Link Layer., the device
drivers for the network hardware are located in the data link layer.
For each type of hardware, a special driver must be provided, while
the functionality they offer to the layer above (the IP networking layer)
is uniform across all hardware. There are a number of attributes
pertaining to an interface, for example its IP address, its broadcast
address, and its MTU. The MTU is the Maximum Transfer Unit and denotes
the maximum number of bytes the device is capable of transferring in one
transaction.
.PP
These attributes are set when configuring the system at boot time,
effectively making the hardware available to the IP networking layer.
.PP
Any hardware-specific configuration options must be set by different
means. At the moment, this usually involves changing kernel compile
options, and making a new kernel image. An alternative is to provide
a number of \fBioctl(2)\fR calls for each device driver that allows
to set the hardware parameters. An example of this is the driver
for Western Digital/SMC Elite cards that allows to configure a
board from software.
.PP
Of course, you somehow have to be able to specify an interface to
the IP layer. This happens by means of names assigned to the interfaces,
consisting of a part describing the interface type, and a unit number.
These are names defined internally in the kernel, and are not proper
device files in the \fB/dev\fR directory. However, the NET-2
code supports device files for most drivers which may be used for
configuring the driver, but the names of the device files and the
interface need not agree.
.PP
There are a number of standard names for IP interfaces in Linux. 
.IP \fBeth\fBn\fR\fR\ 
The \fB\fBn\fR\fR-th Ethernet card. The current kernel
supports one Ethernet board known as \fBeth0\fR.
.IP \fBlo\fR\ 
The local loopback interface. This is used for testing purposes.
It simply sends IP datagrams to your host. There's always
one loopback device configured into the kernel, and there's
little sense in having more or less.
                                
.IP
.IP \fBsl\fBn\fR\fR\ 
The \fB\fBn\fR\fR-th SLIP interface. SLIP interfaces are associated with
serial lines in the order in which they are allocated; i.e., the
first serial line being configured for SLIP becomes \fBsl0\fR,
etc. The kernel supports up to four SLIP interfaces. This number
may be increased when recompiling the kernel (change the
\&\fBSL_NRUNIT\fR macro in \fBnet/inet/slip.h\fR to suit your
needs.
.IP \fBplip\fBn\fR\fR\ 
The \fB\fBn\fR\fR-th PLIP interface. PLIP transports IP datagrams
over parallel lines. Up to three PLIP interfaces are supported.
They are allocated by the PLIP driver at system boot time, and
are mapped onto parallel ports as described in
section See section The PLIP Driver..
PLIP interfaces are associated with parallel
lines in the order in which they are allocated.
.PP
For other interface drivers that may be added in the future, like PPP,
ISDN, or X.25, other names will be introduced.
.PP
.NH 3
The\ Ethernet\ Driver
.br
.PP
.PP
The current Linux network code supports various brands of Ethernet
cards, as well as a driver of the D-Link pocket adapter. This adapter
allows to access an Ethernet through a parallel port. All drivers were
written by Donald Becker (\fBbecker@super.org\fR), except for the D-Link
driver which was written by Bjorn Ekwall.
.PP
Currently, the drivers are only able to handle one Ethernet board,
but the code will be extended to support several cards.
.PP
The following brands of boards are supported:
.IP 3Com\ 
 Boards 3c503 EtherLink II and 3c503/16 EtherLink II.
.IP Novell\ Eagle\ 
 NE1000, NE2000. A wide variety of clones is reported
to work with it.
.IP Western\ Digital/SMC\ 
WD8003 and WD8013.
.IP Hewlett\ Packard\ 
HP27245, HP27247, and HP27250.
.PP
``Supported'' here means, that it should work according to the specs. Read
\&\fBcomp.os.linux\fR or the NET channel of the mailing list to find out if
particular cards are troublesome. You might also want to check the README
files in the \fBnet/inet\fR subdirectory of the kernel source directory;
they usually contain the latest list of working hardware.
.PP
To use one of these cards with Linux, you may use a precompiled
kernel that contains drivers for all of them. At boot time, the code
will try to locate the board and determine its type. Cards are probed for
at the following addresses and in the following order:
.IP \fBWD80x3\fR\ 
\&\fB0x300, 0x280, 0x380, 0x240\fR
.FS 
This is disabled at the moment; the driver only probes for
a board at \fB0x280\fR on IRQ 15.
.FE
.IP \fB3c503\fR\ 
\&\fB0x300, 0x310, 0x330, 0x350, 0x250, 0x280, 0x2a0, 0x2e0\fR
.IP \fBNEx000\fR\ 
\&\fB0x300, 0x280, 0x320, 0x340, 0x360\fR
.IP \fBHP\fR\ 
\&\fB0x300, 0x320, 0x340, 0x280, 0x2C0, 0x200, 0x240\fR
.PP
Alternatively, you may compile the kernel yourself, including the drivers
you need. To do so, go to your kernel source directory and edit
\&\fBnet/inet/CONFIG\fR, which contains extensive comments on the compile-time
options available.
.PP
Sometimes the autoprobing code may not detect your card.  In this case
you have to `hard-wire' your card's configuration into the kernel. You do
this by re-compiling the kernel and specifying the board's address and IRQ
in the file \fBnet/inet/CONFIG\fR in the kernel source directory.
Especially WD80x3 cards are said to exhibit this behavior. The current net-2
release (as of Linux kernel 0.99.10) therefore disables autoprobing for
WD80x3 cards and only looks for a board at \fB0x280\fR, IRQ 15. 
.PP
If you're using 3Com's Etherlink card, the driver uses the AUI connector
by default. The connector type is not yet settable from software, so if
you want the BNC connector, you have to recompile the kernel, too.
.PP
.NH 3
The\ SLIP\ Driver
.br
.PP
.PP
SLIP, or \fISerial Line IP\fR, is a widely used protocol for sending
IP packets over a serial link. A number of institutions provide
dialup SLIP access to machines that are on the Internet, thus providing
IP connectivity to private persons (something that's otherwise hardly
affordable).
.PP
To use a serial port for SLIP, no hardware modifications are necessary.
After connecting to the SLIP server via, for example, \fBkermit\fR,
the \fIline discipline\fR is changed to \fBSLIPDISC\fR. With this
setting, the serial interface cannot be accesses from user processes
anymore, but only by the SLIP driver.
.PP
Changing to \fBSLIPDISC\fR is usually performed using a tool named
\&\fBdip\fR.
.FS 
\&\fBdip\fR apparently means \fIDialup IP\fR. \fBdip\fR was written
by Fred van Kempen.
.FE
 In fact, \fBdip\fR is much more versatile than this. It provides
a simple script interpreter that can dial and login for you, convert
the line to SLIP, and configure the network interface. See the sample
script that comes with the \fBdip\fR sources, or the manual page
for more information.
\&\fBdip\fR may as well be used set up \fIyour\fR machine as a SLIP
server.
.FS 
Just for kicks: how about a dialup FTP server instead of anonymous
UUCP?
.FE
 For this, you have to set up an account, say \fBslip\fR,
giving it \fBdip -i\fR as login shell.
.FS 
Currently, this fails because \fBlogin\fR does not support
arguments to the shell command. A way around this is to write a
small C program that simply calls \fBsystem("dip -i");\fR.
.FE
 When invoked with the \fB-i\fR switch, \fBdip\fR determines
the user who invoked it and looks up the client host's IP address
and related information in \fB/etc/diphosts\fR.
This is used to set up the SLIP interface
after the serial line has been converted to \fBSLIPDISC\fR. After
the line is dropped, \fBdip\fR frees the interface and exits.
.PP
.NH 3
The\ PLIP\ Driver
.br
.PP
.PP
PLIP stands for Parallel Line IP and implements a protocol for
exchanging packets between two machines via their printer ports:
the so-called Crynwr protocol.
.FS 
Although Crynwr sounds pretty much like a tiny village in Wales,
it is the name of a company.
.FE
 It uses five of the port's outgoing data lines and all five
of the port's incoming status lines. Four lines are used to transport
the low and high nibbles of the data bytes, respectively, while the fifth
is used as data strobe. This somewhat peculiar design enables it to even
work with unidirectional interfaces often used for printers. A packet driver
for bidirectional ports which uses the full eight bit path seems to be
in preparation, but is not yet available.
.PP
For connecting two machines using PLIP, you need a special cable sold at
some shops as ``Null Printer'' or ``Turbo Laplink'' cable. You can, however,
make one yourself fairly easy. Appendix See section A Null Printer Cable.
shows you how.
.PP
The PLIP driver for Linux was developed by Donald Becker. If compiled
into the kernel, it sets up a network interface for each of the possible
printer ports. The mapping is as follows:
.PP
.PP
.PP
This mapping does however not mean that you cannot use these
parallel ports as usual. They are only accessed by the PLIP driver
when the corresponding interface is configured \fBup\fR.
.PP
.NH 3
Using\ \fB\ wdsetup\fR
.br
.PP
.PP
If you own an Ethernet card by Western Digital or SMC, you are
lucky, because there is now a tool that allows you to configure your
board's hardware at run-time. It is called \fBwdsetup\fR and was 
written by Gregg Weber.
.FS 
To be reached at \fBgregg@netcom.com\fR.
.FE
 If your board is sophisticated enough, it will allow you
to view and change the board's configuration. 
.PP
There are three ways to configure an Ethernet board. Most
cards come with a number of jumpers on-board that allow to set
parameters like the I/O base address. With the dumbest ones, that's
all there is. Smarter cards have a number of registers, whose values
may be changed at any time, taking effect immediately. There may also
be an EEPROM with one or more configuration pages, with page 0
usually accessible for ``soft'' configuration. This means it
contains values that are copied into the card's registers after a hard
reset. Other pages contain factory settings that may not be changed.
Thus, in order for soft configuration to take effect, you have to make
sure that your card's jumpers are set so that page 0 is used after a
reset, instead of one of the other pages.
.PP
\&\fBwdsetup\fR checks if your card is soft-configurable. If it is not,
it displays a warning and exits. Otherwise, it allows you to display
and alter your card's registers both from the command line and
interactively. For \fBwdsetup\fR to locate the card, you should
provide it with its base address using the \fB-a\fR option (or
\&\fB--baseaddr\fR, alternatively):
.QP
.nh
# wdsetup -a \fBbaseaddr\fR
.PP
This command runs \fBwdsetup\fR in interactive mode, accessing
the card at \fB\fBbaseaddr\fR\fR. This address must be specified
as a 16 bit hex number, with the first (most significant) and third digit
even, the second digit between \fB0\fR and \fB3\fR, and the last
one \fB0\fR. Thus, \fB280\fR and \fBE1C0\fR are valid base
addresses, while \fB14B2\fR is not.
.PP
When you invoke \fBwdsetup\fR to run in interactive mode,
and you do not give it the card's base address, it will try to
locate it all by itself. If you have more than one card in your computer,
it will show all of them, and let you choose one. The author, however,
cautions that some cards (not necessarily Ethernet cards) may lock up
when their registers are read at the wrong time. If this happens to
you, you will have to use the \fB-a\fR option to skip
auto-detection.
.PP
You may alter the base address by invoking \fBwdsetup\fR with
the \fB-p\fR option. If, for example, your card is at \fB380\fR
by default, you move it to \fB280\fR by
.QP
.nh
# wdsetup -a 380 -p 280
.PP
Note that the kernel expects the board on \fB280\fR by default.
If you want to put it somewhere else, you have to change the 
configuration file \fBnet/inet/CONFIG\fR and recompile the kernel
(see section See section The Ethernet Driver. above).
.PP
The Ethernet cards produced by Western Digital and SMC have some
dual-port RAM to improve performance. The start of this RAM may be
mapped into the PC's memory space at different addresses. You may
move its start address using the \fB-b\fR option.
The card's IRQ may be changed using \fB-i\fR.
.PP
Some cards allow connecting different media to them. This may
be set by the \fB-m\fR option, which takes one of the symbolic
arguments \fBaui\fR, \fBbnc\fR, and \fBtwp\fR. These stand for
different connectors and media attached. \fBtwp\fR denotes twisted pair,
\&\fBbnc\fR stands for the BNC twist-on connector that is used with 
10base2 Ethernet, and AUI is the 15pin Dsub connector that is used to
connect to an Ethernet transceiver.
.PP
All settings may be viewed and altered in interactive mode, too. If any of
the following options is given, \fBwdssetup\fR will not enter interactive
mode (Where available, alternative option names are given as well):
.IP \fB-e\fR\ 
Dump EEPROM contents.
.IP \fB-r\fR\ 
Dump registers.
.IP \fB-v\fR\ 
Be verbose when dumping registers.
.IP \fB-p\ \fBnewaddr\fR\fR\ or\ \fB--newaddr\ \fBnewaddr\fR\fR\ 
Move the card's base address to \fB\fBnewaddr\fR\fR.
.IP \fB-b\ \fBaddr\fR\fR\ or\ \fB--ramstart\ \fBaddr\fR\fR\ 
Alter RAM start address to \fB\fBaddr\fR\fR.
.IP \fB-i\ \fBirq\fR\fR\ or\ \fB--irq\ \fBirq\fR\fR\ 
Set new interrupt number.
.IP \fB-m\ \fBmedia\fR\fR\ or\ \fB--media\ \fBmedia\fR\fR\ 
Set new network media type. \fB\fBmedia\fR\fR may be one of
\&\fBaui\fR, \fBbnc\fR, or \fBtwp\fR.
.PP
These options only set the card's registers. If you want to write
to the EEPROM soft configuration page, you have to use interactive mode.
.PP
\&\&.
.NH 2
Setting\ the\ hostname
.br
.PP
.PP
The NET-2 binary release also provides a new \fBhostname\fR command.
To set the hostname, it is invoked as 
.PP
.QP
.nh
/etc/hostname -S [\fBname\fR]
.PP
If the \fB\fBname\fR\fR argument is given, your machine's hostname is
set to this name. You may choose to use an unqualified hostname as
well as with the domain name. Usually, one would not use the
unqualified name.
.PP
If you don't give the \fB\fBname\fR\fR argument on the command line,
\&\fBhostname\fR looks for the file \fB/etc/HOSTNAME\fR, and sets the
hostname to what it finds in this file.
.PP
.NH 2
Assigning\ IP\ Addresses
.br
.PP
.PP
Before you can start out hacking away at your keyboard, you will have
to make some administrative decisions. One of them is what IP addresses
to assign to your hosts. In section See section IP Addresses.
we saw that hosts within a local network should be part of the same
logical IP network. Hence you have to assign an IP network
address. If you have several physical networks, you either
have to assign them different network numbers, or use subnetting
to split your IP address range into several subnetworks.
.PP
If your LAN is not connected to the Internet, you're free to choose
any (legal) network address. However, you have to make sure to
choose one from classes A, B, or C, else you will most probably
have severe difficulties in persuading TCP/IP to work. Maybe
it would be best to use one class C network for the whole of your
LAN, because even if you don't even dream of getting on the Internet
today, things may look different in a few years from now. To
operate several Ethernets (and other hardware, once a driver is
available), you have to use subnetting, of course.
.PP
However, if you intend to get on the Internet in the near future,
you should obtain an official IP address \fInow\fR. The best way to
proceed is to ask your network service provider to help you.
If you want to obtain a network number just in case
you might get on the Internet someday, request a Network Address
Application Form from \fBhostmaster@nic.ddn.mil\fR.
.PP
For subnetting, assign a number to each network you manage. Note that the
subnet number may not be zero, hence you start with subnet
number one. If you have a ``backbone'' whose sole purpose is to
connect the various subnets, remeber to also assign it a subnet number.
Then allocate a fraction of the IP address' host part sufficient
to hold the subnet numbers, plus a little room for future expansion.
Make sure the remaining host part bits are still sufficient to 
accomodate the maximum number of hosts you will have on any of the subnets.
.PP
Then start assigning numbers to the hosts on each of the subnets,
probably from different ranges for gateways and ordinary hosts,
respectively. A gateway needs one IP address per network it is on.
.PP
As an example, the brewery's network manager applies to the NIC
for a class B network number, and is given \fB192.72.0.0\fR.
To accomodate the two Ethernets, she decides to use eight bits of
the host part as additional subnet bits. This leaves another eight
bits for the host part, allowing for 254 hosts on each of the
subnets. She then assigns subnet number 1 to the brewery, and gives
the winery number 2. Their respective network addresses are thus
\&\fB192.72.1.0\fR and \fB192.72.2.0\fR. The subnet mask
is \fB255.255.255.0\fR.
.PP
Note that in this example we are using a class B network to keep
the example simple; a class C network would be more realistic.
With the new networking code, subnetting is not limited to byte
boundaries, so even a class C network may be split into several
subnets.
.PP
\&\fBvlager\fR, which is the gateway between the two networks, is
assigned a host number of 1 on both of them, which gives it
the IP addresses \fB192.72.1.1\fR and \fB192.72.2.1\fR,
respectively.
.PP
.NH 2
Interface\ Configuration\ for\ IP
.br
.PP
.PP
Your next job is to configure the interfaces so the IP layer can use
them. Usually, this is done at system boot time by executing the
\&\fBrc.inet1\fR script from \fB/etc/rc.d\fR. The commands used in
this script will be explained below.
.PP
Another important topic being addressed in this chapter is
configuration of the hostname resolver software. We will cover both
static host tables (using the\fB/etc/hosts\fR file) as well as
use of the BIND server. If you are only running an isolated Ethernet,
you may safely skip the section on \fBnamed\fR.
.PP
.PP
.NH 3
Interface\ Configuration\ with\ \fBifconfig\fR
.br
.PP
.PP
After each system boot, the first step in configuring your machine
for TCP/IP networking is to make your interfaces known to IP, along with the
IP addresses you have assigned to them. Remember from
section See section IP Routing. that the IP address is not really
assigned to the host itself, but to the network interface. This is
because the network part of the address has to agree for all
hosts on a single physical network, hence a machine that is on
several networks has to have one IP address per network.
.PP
Since the early days of Linux networking, IP addresses have been
used to be assigned to interfaces using the \fBconfig\fR command.
Fred van Kempen's recent NET-2 release uses a command for that purpose
which is more ``standard'', namely \fBifconfig\fR. Since the \fBconfig\fR
command is obsolete, we will only cover the latter.
.PP
\&\fBifconfig\fR's command line options are:
.QP
.nh
\&\fB
/etc/ifconfig \fBinterface\fR [\fBaddress\fR] [\fBparameters\fR]\fR
.PP
.PP
\&\fB\fBinterface\fR\fR is the interface name as described above.
\&\fB\fBaddress\fR\fR is the IP address to be assigned to the interface.
This may either be an IP address in dotted quad notation, or a
hostname. Note, however, that \fBifconfig\fR tries to resolve the hostname 
by looking it up in \fB/etc/hosts\fR. Thus, when giving the
hostname as the \fB\fBaddress\fR\fR parameter to \fBifconfig\fR,
you have to have this file set up on the local host.
.PP
By default, the subnet accessible through the interface is
deduced from the address parameter, using the standard subnet mask
pertaining to the address class. For a class B address, the default
subnet mask is \fB255.255.0.0\fR, thus the network number of
\&\fB192.71.1.1\fR is \fB192.71.0.0\fR. If subnetting is used, as is
the case with the Virtual Brewery, the network number is
however \fB192.1.1.0\fR. Therefore, an alternative subnet mask
has to be specified for this interface using the \fBnetmask\fR option
(see below). In our example, the correct netmask is \fB255.255.255.0\fR.
.PP
\&\fBifconfig\fR recognizes the following parameters:
.IP \fBup\fR\ 
This marks an interface ``up'', i.e. accessible to the
IP layer. This option is implied when an \fB\fBaddress\fR\fR is
given on the command line. It may also be used to re-eenable
an interface that has been taken down temporarily using the
\&\fBdown\fR option.
.IP \fBdown\fR\ 
This marks an interface ``down'', i.e. inaccessible to the
IP layer. This effectively disables any IP traffic through the
interface. Note, however, that this does not automatically
delete entries in the routing table that use this interface.
.IP \fBnetmask\ \fBmask\fR\fR\ 
This assigns a subnet mask to be used by the interface.
It may be given as either a 32-bit hexadecimal number 
preceded by \fB0x\fR, or as a dotted quad of decimal
numbers.
.IP
.IP \fBbroadcast\ \fBaddress\fR\fR\ 
IP allows for special addresses that may be used to broadcast
a datagram to all hosts on a logical network. This is
usually the network address with the host part bits all set to ones.
Some IP implementations use a different scheme
when this option is supplied, but Linux adheres
to the standard. 
.IP
.IP \fBmetric\ \fBnumber\fR\fR\ 
This option may be used to assign a metric value to the routing
table entry created for the interface. This metric is used
by the Routing Information Protocol (RIP) to build routing
tables for the network.
.FS 
.IP
RIP chooses the optimal route to a given host based on the
``length'' of the path. It is computed by summing up
the individual metric values of each host-to-host link.
By default, a hop has length 1, but this may be any positive
integer less than 16. (A route length of 16 is equal to infinity. Such routes
are considered unusable.) The \fBmetric\fR parameter sets this hop
cost, which is then broadcast by the routing daemon.
.FE
 The default metric used by \fBifconfig\fR
is a value of zero. If you don't run a RIP daemon, you
don't need this option at all; if you do, you will rarely
need to change the metric value.
                
.IP
.IP \fBmtu\fR\ 
This sets the Maximum Transmission Unit, which is the maximum
number of octets the interface is able to handle in one
transaction. For Ethernets, the MTU defaults to 1500; for SLIP
interfaces, this is 296.
.IP \fBtrailers\fR\ 
This is an option specific to Ethernet interfaces. It enables so-called
\&\fItrailer encapsulation\fR, a technique to minimize the number 
of memory-to-memory copies the receiving system needs to perform.
This is enabled by specifying \fBtrailers\fR on the \fBifconfig\fR
command line. To disable it, precede it with a dash (`\fB-\fR').
        
.IP
.IP \fBarp\fR\ 
Like \fBtrailers\fR, this is an Ethernet-specific option. It enables
the use of ARP, the Address Resolution Protocol used to detect
the IP addresses of hosts attached to the Ethernet. To enable
it, specify \fBarp\fR on the command line; to disable it, precede
the option with a dash (`\fB-\fR').  This is rarely
necessary.
.IP \fBpointopoint\fR\ 
This option is used for point-to-point IP links that involve
only two hosts. This option is needed to configure, for example,
SLIP or PLIP interfaces.
.PP
The IP address of the Ethernet board on \fBvlager\fR connecting it to the
brewery subnet, is \fB192.72.1.1\fR. To bring this interface up,
one would issue
.QP
.nh
.DS
.ft CW
# /etc/ifconfig eth0 192.72.1.1 netmask 255.255.255.0 \e
        broadcast 192.72.1.255 arp up
 
.DE
.ft R
\&\&
.PP
To enable the second Ethernet board, which connects vlager to the
winery's network, one issues
.QP
.nh
.DS
.ft CW
# /etc/ifconfig eth1 192.72.2.1 netmask 255.255.255.0 \e
        broadcast 192.72.2.255 arp up
 
.DE
.ft R
\&\&
.PP
To enable the loopback interface, use
.QP
.nh
.DS
.ft CW
# /etc/ifconfig lo 127.0.0.1
 
.DE
.ft R
\&\&
.PP
The commands to issue on \fBvstout\fR, which is host number 2 on the
brewery net, are
.QP
.nh
.DS
.ft CW
# /etc/ifconfig eth0 192.72.1.1 netmask 255.255.255.0 \e
        broadcast 192.72.1.255 arp up
 
.DE
.ft R
\&\&
.PP
This command brings up the Ethernet interface, telling IP that it
is directly connected to subnet 1. To be able to reach hosts on the
winery's Ethernet, IP still needs to be given a gateway to this subnet.
This is explained below in section ??.
.PP
\&\fBifconfig\fR may also be used to configure an interface as point-to-point
link, which means that the medium used only connects two hosts. In rare
cases, this might be applied to Ethernet links, but usually, point-to-point
links are used for SLIP or PLIP connections. To configure an interface as
point-to-point link, you invoke it using the \fBpointopoint\fR option:
.QP
.nh
# ifconfig \fBdevice address\fR pointopoint \fBremote\fR
.PP
Here, \fB\fBremote\fR\fR is the remote host's address given either
as dotted quad or as a hostname to be resolved using \fB/etc/hosts\fR.
.PP
Without an address or any other parameters specified, \fBifconfig\fR
will simply display the interface's configuration. This allows to
check the setting of an interface:
.QP
.nh
.DS
.ft CW
# /etc/ifconfig eth0
eth0       IP ADDR 192.72.1.1  BCAST 192.72.1.255  NETMASK 255.255.255.0
           MTU 1500  METRIC 0  POINT-TO-POINT ADDR 0.0.0.0
           FLAGS: 0x0043 ( UP BROADCAST RUNNING )
 
.DE
.ft R
\&\&
.PP
Without any parameter at all, \fBifconfig\fR displays the above
type of information for all interfaces marked \fBup\fR.
.PP
.NH 2
Building\ IP\ Routing\ tables
.br
.PP
.PP
.PP
.PP
To enable TCP/IP to communicate with remote hosts across physical
network boundaries, IP must be provided with information on how
to reach these hosts. Section See section IP Routing. describes
how this is done: IP keeps a table that maps logical networks
to the interface and gateway they may be accessed through.
This section describes several alternative ways this may be done.
.PP
Routing tables may be created in several ways. The case of an
isolated Ethernet is the simplest one: the route to the
network is entered into the table at boot time using a command named 
\&\fBroute\fR, and nothing more than this is needed. However,
if you have more than one physical network, you need gateways to
switch packets between them, and you have to create additonal routing
table entries to direct traffic to the proper gateway. These routes
have to be entered at boot time, too, and may optionally be monitored 
and adjusted during service. To build static routing tables,
the \fBroute\fR command must be used. Dynamic routing is performed
by \fIrouting daemons\fR like \fBrouted\fR or \fBgated\fR, which
exchange information on network reachability, route lengths, etc. Some
routing protocols provided by \fBgated\fR also
measure network load. Unless your network is really
very large, or richly interconnected, you will have no use for
running any of these. For this reason, only static routing tables
will be discussed in this book.
.PP
In the preceding section, you have already seen that IP considers
an interface as a special kind of route to a network. Routing table
entries, however, may also point to gateways, or single hosts
(for point-to-point links). Thus, there are a number of attributes
a routing table entry may have:
.IP \fBG\fR\ 
This flag is set if the route uses a gateway.
.IP \fBU\fR\ 
This flag is set if the interface to be used is up.
.IP \fBH\fR\ 
This flag is set if only a single host can
be reached through the route. For example, this is
the case for the loopback entry \fB127.0.0.1\fR.
.IP \fBN\fR\ 
This is the opposite of the \fBH\fR flag. It is set whenever
the interfaces accesses a subnet.
.IP \fBD\fR\ 
This is set if the table entry has been generated
by an ICMP redirect message (see See section The Transport Layer.).
.IP \fBM\fR\ 
This is set if the table entry was modified by an ICMP
redirect message.
.PP
These flags are also displayed by the \fBnetstat\fR command,
which is explained below in section See section Veryfying your IP setup..
.PP
.NH 3
Route\ to\ the\ Subnet
.br
.PP
.PP
Static routing tables are built by using \fBroute\fR. A simple
way of invoking it is
.PP
.QP
.nh
route add \fBdestination\fR
.PP
\&\fB\fBdestination\fR\fR specifies the host or network the routing table
entry points to. You may either specify an IP address in dotted quad
notation, or a symbolic host or network name. Symbolic names
are looked up in \fB/etc/hosts\fR and \fB/etc/networks\fR. If it is found
in either of them, the corresponding IP address is used as a host or
network address, respectively.
.PP
For the Virtual Brewery, the administrator would put together
the following \fB/etc/networks\fR file and install it on all hosts:
.PP
.QP
.nh
.DS
.ft CW
# Virtual Brewery /etc/networks file
# Maps symbolic network names to subnet numbers.
loop-net        127.0.0.0       # loopback network
brew-net        192.72.1.0      # subnet 1
wine-net        192.72.2.0      # subnet 2
 
.DE
.ft R
\&\&
.PP
We are now ready to set up the first entries in the routing tables
at the Virtual Brewery.  First, we do so on \fBvlager\fR, the host
that joins the two Ethernets, by executing
.PP
.QP
.nh
.DS
.ft CW
# route add 127.0.0.1
# route add brew-net
# route add wine-net
 
.DE
.ft R
\&\&
.PP
The first command creates an entry for \fB127.0.0.1\fR, while the following
enter a route to each of the subnets. At first glance, this looks pretty
stupid: we already \fIdid\fR specify a subnet number when configuring the
Ethernet interfaces, the loopback device \fIhas\fR been assigned number
\&\fB127.0.0.1\fR, and anyway, why don't these commands specify the interfaces
the networks may be reached by?
.PP
The answer is this:
After configuring the interfaces, the routing table entry is completely
empty. Although the kernel may receive IP packets from these devices,
it cannot send any. To be able to, it has to be told exactly \fIwhat\fR
subnet is accessible through the interface. For example, the loopback
device seems to offer access to a class A network, because \fB127.0.0.1\fR
is a class A address. IP has to be told explicitly that \fBlo\fR is an
interface to a single host. Analoguously, the routes to the two subnets
have to be enabled explicitly.
.PP
Now, why don't we have to specify the interface to \fBroute\fR? This is
because after configuring \fBeth0\fR with \fBifconfig\fR, the IP
layer knows that \fIif\fR there is a route to subnet \fB192.72.1.0\fR,
it can only use \fBeth0\fR!
.PP
When giving \fBroute\fR an IP address in dotted quad notation, it attempts
to guess whether it is a network or a hostname by looking at the host part
bits. If the address' host part is zero, \fBroute\fR assumes it denotes
a network, otherwise it takes it as a host address. 
.PP
Of course, this heuristic fails when you use subnetting. To override
this check, you may precede the IP address with one of the modifiers
\&\fB-net\fR or \fB-host\fR, respectively. This forces \fBroute\fR into
treating the address as a network or a host, respectively.
.PP
Thus, the Brewery's network administrator might alternatively have skipped
putting the network names into \fB/etc/networks\fR, and edited \fBrc.inet1\fR
directly:
.PP
.QP
.nh
.DS
.ft CW
# route add 127.0.0.1           # local host
# route add -net 192.72.1.0     # brewery subnet
# route add -net 192.72.2.0     # winery subnet
 
.DE
.ft R
\&\&
.PP
.NH 3
Routes\ through\ a\ Gateway
.br
.PP
.PP
In the presence of several subnets, the Linux IP layer has to be told
what gateways to reach them through. This is done using the \fBroute\fR
command, too. You invoke it as
.PP
.QP
.nh
route add \fBdestination\fR gw \fBgateway\fR
.PP
When you are using your Linux box in a larger network environment,
.PP
\&\fB\fBdestination\fR\fR is the destination subnet or host, while
\&\fB\fBgateway\fR\fR is the gateway to reach it through.
They may be either given in dotted quad notation, or as a hostname
listed in \fB/etc/hosts\fR.
The \fB\fBnetwork\fR\fR argument may also be the keyword \fBdefault\fR,
which creates a routing table entry for the default route
\&\fB0.0.0.0\fR. The default route names the gateway all datagrams to
unknown networks are forwarded to.
.PP
Again, the \fBroute\fR command does not take a command line option
that specifes the interface to use in accessing the gateway. Instead,
it tries to determine it from the gateway's address: the address
is checked against the routing tables constructed so far, so you have to
make sure the address is on a subnet you have already specified a
route to.
.PP
For example, \fBvstout\fR has to use \fBvlager\fR as a gateway when
communicating with a host on the winery subnet. However, \fBvlager\fR
has two addresses, being \fB194.72.1.1\fR and \fB194.72.2.1\fR.
Of course, when adding the route to the winery subnet, you have to
use the first IP address because this is on the subnet the kernel already
knows how to route to.
.FS 
Note that the gateway need not be on a subnet you are directly attached
to, but you may also specify one that is itself only reached through
one or more gateways. Routes with this property are called \fIindirect\fR.
.FE
 Thus, the sequence for enabling routing on \fBvstout\fR is
.PP
.QP
.nh
.DS
.ft CW
# route add 127.0.0.1
# route add brew-net
# route add wine-net gw 194.72.1.1 metric 1
 
.DE
.ft R
\&\&
.PP
The \fBmetric\fR argument is used to give some idea of the route's
``cost'', usually counting the number of gateways. It is used by some
routing protocols, like RIP, to choose between different routes if
there is more than one way for routing to a given subnet.
Although the metric argument is not needed if you use static routing,
there is a rule that says that routes whose gateway is
the local host should have a metric of zero, while those that use
a remote gateway should have a value greater than zero. If you
don't run any routing daemon, it's best to provide a \fB\fBmetric\fR\fR of
1 for all routes to remote gateways. If you omit \fB\fBmetric\fR\fR, it
defaults to zero.
.PP
To delete a route from the routing table, you invoke \fBroute\fR like
this:
.PP
.QP
.nh
route del \fBdestination\fR
.PP
If invoked without any arguments, \fBroute\fR displays the routing table,
including some interface statistics.
.FS 
In fact, it simply invokes \fBnetstat\fR with the \fB-r\fR switch.
\&\fBnetstat\fR is explained below in section See section netstat..
.FE
 On \fBvstout\fR, this produces:
.PP
.QP
.nh
.DS
.ft CW
# route -n
Kernel routing table
Destination net/address   Gateway address           Flags RefCnt    Use Iface
127.0.0.1                 *                         UH         0     50 lo
192.72.1.0                *                         UN         0    478 eth0
192.72.2.0                192.72.1.1                UGH        0    250 eth0
 
.DE
.ft R
\&\&
.PP
The \fB-n\fR option makes \fBroute\fR print host addresses as dotted
quad IP addresses. Without this option, it would attempt to resolve 
them to symbolic hostnames.
.PP
.NH 2
Verifying\ your\ IP\ Setup
.br
.PP
.PP
There's a number of useful tools for verifying the operation
of your TCP/IP network setup. We will describe them below.
.PP
.PP
.NH 3
\&\fBping\fR
.br
.PP
.PP
\&\fBping\fR is the networking equivalent of a sonar device.
.FS 
Anyone remember Pink Floyd's ``Echoes''?
.FE
 It measures the time a datagram requires to travel from your host
to a destination machine and back again. For this, it uses a special
feature of the ICMP protocol, the ``echo'' message. When a host's
IP layer receives an echo message, it returns a response bearing a time
stamp, plus the sequence number of the original packet.
.FS 
There's more information in it, but we won't go into this.
.FE
 \fBping\fR sends such ICMP messages to check for the reachability
of a host, as well as the delays encountered. A simple way
to invoke it is thus:
.FS 
Some \fBping\fR programs will only say ``\fBfoo\fR is alive''
when being invoked without any option. To obtain the behavior
shown in the example, you may have to add the \fB-s\fR switch
on other operating systems.
.FE
.QP
.nh
.DS
.ft CW
$ /etc/ping nic.funet.fi
PING nic.funet.fi: 64 byte packets
64 bytes from 128.214.6.100: icmp_seq=7. time=8998. ms
64 bytes from 128.214.6.100: icmp_seq=8. time=11530. ms
64 bytes from 128.214.6.100: icmp_seq=9. time=12368. ms
64 bytes from 128.214.6.100: icmp_seq=10. time=11762. ms
64 bytes from 128.214.6.100: icmp_seq=13. time=12172. ms
64 bytes from 128.214.6.100: icmp_seq=17. time=12326. ms
^C
\&\&
----nic.funet.fi PING Statistics----
30 packets transmitted, 6 packets received, 80 packet loss
round-trip (ms)  min/avg/max = 8998/11526/12368
 
.DE
.ft R
\&\&
.PP
By default, \fBping\fR will go on emitting packets forever. To stop it,
you have to interrupt it by typing Ctrl-C. This causes \fBping\fR to stop
and compute the packet loss rate, which is the ratio of outstanding 
responses to the total number of packets sent.
.PP
The above example shows very loaded lines, with many packets getting
dropped. On the Internet, it's not that uncommon for packets to disappear
or to arrive unordered.
This is not so much due to technical deficiencies as due to
temporary excess loads on forwarding hosts, which makes them delay or even
drop incoming datagrams.
.FS 
A host has to drop packets, for example, when the buffer space available
does not suffice to accomodate another incoming packet. Dropped packets
simply disappear, they are not rescheduled by the host immediately
preceding the one that drops it. The reason for this is potential deadlock
avoidance.
.FE
 On a LAN, you should never see such a thing. The output of \fBping\fR
should rather be like this:
.FS 
Note that you cannot give the destination host's name on the
command line unless you have properly set up address resolution.
.FE
.QP
.nh
.DS
.ft CW
$ /etc/ping vstout
PING vstout: 64 byte packets
64 bytes from 192.72.1.2: icmp_seq=0. time=11. ms
64 bytes from 192.72.1.2: icmp_seq=1. time=7. ms
64 bytes from 192.72.1.2: icmp_seq=2. time=12. ms
64 bytes from 192.72.1.2: icmp_seq=3. time=3. ms
^C
\&\&
----vstout.linus.lxnet.org PING Statistics----
5 packets transmitted, 4 packets received, 20 packet loss
round-trip (ms)  min/avg/max = 3/8/12
 
.DE
.ft R
\&\&
.PP
The packet loss in this example is due to us interrupting \fBping\fR while
waiting for \fBvstout\fR's response to packet number 4.
.PP
If you encounter unusual packet loss rates, this hints at a hardware problem,
like bad or missing terminators, etc. If you don't receive any packets at all,
or even see error messages, this means there is a configuration problem.
You may probe for these problems using \fBwdsetup\fR, described above in
section See section wdsetup.,
and \fBnetstat\fR, and \fBarp\fR, described below.
.PP
You may also check for all reachable hosts on your LAN by specifying the
broadcast address
.FS 
If you have Internet access, please, \fInever\fR do this with
any network but your local subnet. This will clog your (and
others') networks for a while, and will surely get you visits by
friendly people speaking softly and carrying big sticks.
.FE
:
.QP
.nh
.DS
.ft CW
$ /etc/ping 192.72.1.255
PING 192.72.1.255: 64 byte packets
64 bytes from 192.71.1.1: icmp_seq=0. time=27. ms
64 bytes from 192.71.1.4: icmp_seq=0. time=34. ms
64 bytes from 192.71.1.2: icmp_seq=0. time=39. ms
64 bytes from 192.71.1.3: icmp_seq=0. time=44. ms
64 bytes from 192.71.1.4: icmp_seq=1. time=39. ms
64 bytes from 192.71.1.2: icmp_seq=1. time=68. ms
64 bytes from 192.71.1.1: icmp_seq=1. time=103. ms
64 bytes from 192.71.1.3: icmp_seq=1. time=129. ms
^C
\&\&
----192.71.1.255 PING Statistics----
2 packets transmitted, 8 packets received, -400 packet loss
round-trip (ms)  min/avg/max = 27/55/129
 
.DE
.ft R
\&\&
.PP
.NH 3
\&\fBnetstat\fR
.br
.PP
.PP
This is a versatile command for checking various aspects of your network
interfaces' configuration, like viewing the routing tables, show interface
statistics (this is not yet there), or all connections active.
.PP
The \fB-r\fR option to \fBnetstat\fR is used to display the kernel
routing tables. When invoking \fBnetstat\fR on \fBvstout\fR, the output
may look like this:
.PP
.LP
.QP
.nh
.DS
.ft CW
$ netstat -nr
Routing tables
Destination      Gateway            Flags     Refs     Use  Interface
127.0.0.1        *                  UH       1527    66614  lo
192.72.1.0       *                  UN        556  7917876  eth0
192.72.2.0       192.72.1.1         UGN         0    76735  eth0
 
.DE
.ft R
\&\&
.PP
The first column is the destination network the entry applies to.
The second is the gateway to reach it through, and the last one is
the interface to be used. The flags field contains a combination
of the letters \fBU\fR, \fBG\fR, \fBH\fR, \fBN\fR and \fBD\fR, which denote
a route through an operating (``up'') interface, a route
through a gateway, a route to a single host (i.e. a point-to-point
link), and a route generated by an ICMP redirect message.
.PP
Other options are those to show active connections. Using the \fB-t\fR,
\&\fB-u\fR, \fB-w\fR and \fB-x\fR limits the display to certain protocols
only, namely TCP, UDP, RAW, and Unix domain sockets. Invoking 
\&\fBnetstat -t\fR on \fBvlager\fR produces
.QP
.nh
.DS
.ft CW
$ netstat -t
Active Internet connections
Proto Recv-Q Send-Q Local Address          Foreign Address        (State)
tcp        0      0 *:domain               *:*                    LISTEN  
tcp        0      0 *:time                 *:*                    LISTEN  
tcp        0      0 *:smtp                 *:*                    LISTEN  
tcp        0      0 vlager:smtp            vstout:1040            ESTABLISHED  
tcp        0      0 *:telnet               *:*                    LISTEN  
tcp        0      0 localhost:1046         vbardolino:telnet      ESTABLISHED  
tcp        0      0 *:chargen              *:*                    LISTEN  
tcp        0      0 *:daytime              *:*                    LISTEN  
tcp        0      0 *:discard              *:*                    LISTEN  
tcp        0      0 *:echo                 *:*                    LISTEN  
tcp        0      0 *:shell                *:*                    LISTEN  
tcp        0      0 *:login                *:*                    LISTEN  
 
.DE
.ft R
\&\&
.PP
This shows most servers simply waiting for an incoming connection. However,
the fourth line shows an incoming SMTP connection from \fBvstout\fR, and
the sixth line tells you there is an outgoing \fBtelnet\fR connection
to \fBvbardolino\fR.
.FS 
You can tell wether a connection is outgoing or not from the port numbers
involved. The port number shown for the \fIcalling\fR host will always 
be a simple number higher than \fB1024\fR, while on the host being called, a
well-known service port will be in use, for which \fBnetstat\fR uses
the symbolic name found in \fB/etc/services\fR.
.FE
.PP
Output for TCP and UDP sockets may be combined by invoking \fBnetstat\fR
with the \fB-a\fR switch. For more information, please refer to the
manual page.
.PP
.NH 3
\&\fBarp\fR
.br
.PP
.PP
In section See section The Data Link Layer. we already mentioned that the Ethernet
driver uses the ARP protocol to query for the Ethernet address corresponding
to a given IP address. However, there are other types of equipment
that also allow to use the ARP protocol; the ham-radio AX.25 hardware
is an example of this. Although a driver for this is not yet there,
\&\fBarp\fR already provides support for this.
.PP
The \fBarp\fR tool may be used to view and alter the kernel ARP tables.
Its command line options are
.QP
.nh
/etc/arp [-v] [-t \fBhwtype\fR] -a [\fBhostname\fR]           
.br
\&\&
/etc/arp [-v] [-t \fBhwtype\fR] -s \fBhostname\fR \fBhwaddr\fR
.br
\&\&
/etc/arp [-v] -d \fBhostname\fR [\fBhostname\fR\&...]    
.PP
All \fB\fBhostname\fR\fR arguments are expected to be symbolic host names (no
IP address), so that using \fBarp\fR is only possible after having configured
address resolution. It is, however, also possible to specify an IP address.
.PP
The first invocation displays the ARP tables related to the specified host, or
all hosts known. For example, invoking \fBarp\fR on \fBvlager\fR may yield
.PP
.QP
.nh
.DS
.ft CW
# arp -a
IP address      HW type                 HW address
192.72.1.3      10Mbps Ethernet         00:00:C0:5A:42:C1
192.72.1.2      10Mbps Ethernet         00:00:C0:90:B3:42
192.72.2.4      10Mbps Ethernet         00:00:C0:04:69:AA
 
.DE
.ft R
\&\&
.PP
When using the \fB-a\fR option together with a \fB\fBhostname\fR\fR only
shows the ARP table entry for that host if there is one.
Using the \fB-t\fR option limits the display to the hardware type specified.
This may be one of \fBether\fR, \fBax25\fR, or \fBpronet\fR,
standing for 10Mbps Ethernet, AMPR AX.25, and ProNet equipment,
.FS 
Can anybody tell me what this is?
.FE
 respectively.
.PP
The \fB-s\fR option is used to permanently add \fB\fBhostname\fR\fR's Ethernet
address to the ARP tables. The \fB\fBhwaddr\fR\fR argument specifies the
hardware address, which is by default expected to be an Ethernet address,
specified as six hexadecimal bytes separated by colons (`\fB:\fR').
You may also set the hardware address for other types of hardware, too, 
using the \fB-t\fR option.
One problem which may require you to use the \fB-s\fR option is
when for some reasons ARP queries for the remote host fail, whether
its ARP driver is buggy or there is another host in the network that
erroneously identifies itself with \fBhostname\fR's IP address.
.FS 
\&\fBAuthor's Note:
I'm wondering if this can also be used for proxy ARPing. Can anybody
help me with this?
\&\fR
.FE
.PP
Invoking \fBarp\fR using the \fB-d\fR switch deletes all ARP entries relating
to the given host.
This may be used to force the interface to re-attempt to obtain the Ethernet 
address for the IP address in question.
.PP
.NH 2
Name\ Service\ and\ Resolver\ Configuraton
.br
.PP
.PP
.PP
.PP
.PP
As explained in section See section The Domain Name System. above, TCP/IP networking
may rely on different schemes to convert names into addresses.
The simplest way, which takes no advantage of the way the name space
has been split up into zones, is a host table stored in a single file.
This is only useful for small LANs that are run by one single
administrator, and otherwise have no IP traffic with the outside world.
This information is stored in a file named \fB/etc/hosts\fR,
whose format is described below in See section The hosts file..
.PP
Alternatively, one may use BIND for resolving host names to
IP addresses. This may be a real chore, but once you've done it, 
changes in the network topology are easily made. On Linux,
as on many other Un*xish systems,
name service is provided through a program called \fBnamed\fR.
At startup, it loads a set of  master files into its cache, and
waits for queries from remote or local user processes. There are
different ways to set up BIND, and not all require to run a name
server on every host.
.PP
Whatever way you may choose, you have to configure your software
to adapt to the scheme used.
.PP
When talking of ``the resolver'', we do not mean any special application,
but rather refer to the \fIresolver library\fR, a collection of
functions that can be found in the standard C library. The central
routines are \fBgethostbyname(2)\fR and \fBgethostbyaddr(2)\fR which
look up all IP addresses belonging to a host, and vice versa.
They may be configured to simply look up the information in
\&\fB/etc/hosts\fR, query a number of name servers, or use NIS (Network
Information Service). Other applications, like \fBsmail\fR, may include
different drivers for any of these, and need special
care taken of them.
.PP
.NH 4
The\ \fBhost.conf\fR\ File
.br
.PP
.PP
The central file that controls your resolver setup is \fBhost.conf\fR.
It resides in \fB/etc\fR and describes to the resolver which services
to use, and in what order.
.PP
Options in \fBhost.conf\fR must occur on separate lines. Fields may be
separated by white space (spaces or tabs). A hash sign (`\fB#\fR')
instroduces a comment that extends to the next newline.
.PP
The following options are available:
.IP \fBorder\fR\ 
This determines the order in which the resolving services are
tried. Valid options are \fBbind\fR for queryig the name server,
\&\fBhosts\fR for lookups in \fB/etc/hosts\fR, and \fBnis\fR for
NIS lookups.
Any or all of them may be specified. The order in which they appear
on the line detemines the order in which the respective services
are tried.
.IP
.IP \fBmulti\fR\ 
Takes \fBon\fR or \fBoff\fR as options. This detemines if a host
in \fB/etc/hosts\fR is allowed to have several IP addresses. It
has no effect on DNS or NIS queries.
.IP
.IP \fBnospoof\fR\ 
As explained above in section See section The Domain Name System., DNS allows to find
the hostname belonging to an IP address by using the \fBin-addr.arpa\fR
domain. Attempts by name servers to supply a false hostname are called
``\fIspoofing\fR''. To guard against this, the resolver may be configured
to check if the original IP address is in fact associated with the
hostname obtained. If not, the name is rejected and an error
returned. This behavior is turned on by setting \fBnospoof on\fR.
.IP
.IP \fBalert\fR\ 
This option takes \fBon\fR or \fBoff\fR as arguments.
If it is turned on, any spoof attempts (see above) will cause the
resolver to log a message to the \fBsyslog\fR facility.
.IP
.IP \fBtrim\fR\ 
This option takes a domain name as an argument, which will be removed
from hostnames before lookup. This is useful for \fB/etc/hosts\fR
entries, where you might only want to specify hostnames sans local
domain.
A lookup of a host with the local domain name appended will have this
removed, thus allowing the lookup in \fB/etc/hosts\fR to succeed.
.IP
\&\fBtrim\fR options accumulate, making it possible to consider 
your host as being local to several domains.
.PP
A sample file for \fBvlager\fR is shown below:
.PP
.QP
.nh
.DS
.ft CW
# /etc/host.conf
# We have named running, but no NIS (yet)
order   bind hosts
# Allow multiple addrs
multi   on
# We have no one to spoof us
nospoof on
# Trim local domain (not really necessary).
trim    linus.lxnet.org.
 
.DE
.ft R
\&\&
.PP
.NH 4
Resolver\ Environment\ Variables
.br
.PP
.PP
The settings from \fBhost.conf\fR may be overridden using a number
of environment variables. These are
.PP
.IP \fBRESOLV_HOST_CONF\fR\ 
This specifies a file to be read instead of \fB/etc/host.conf\fR.
.IP \fBRESOLV_SERV_ORDER\fR\ 
Overrides the \fBorder\fR option given in \fBhost.conf\fR. Services
are given as \fBhosts\fR, \fBbind\fR, and \fBnis\fR, separated
by a space, comma, colon, or semicolon.
.IP \fBRESOLV_SPOOF_CHECK\fR\ 
Determines the measures taken against spoofing. It is turned off using
\&\fBoff\fR. The values \fBwarn\fR and \fBwarn off\fR enable spoof
checking, but turn logging on and off, respectively. A value of
\&\fB*\fR turns on spoof checks, but leaves the logging facility as
defined in \fBhost.conf\fR.
.IP \fBRESOLV_MULTI\fR\ 
A value of \fBon\fR or \fBoff\fR may be used to override the \fBmulti\fR
options from tt host.conf.
.IP \fBRESOLV_OVERRIDE_TRIM_DOMAINS\fR\ 
This environment specifies a list of trim domains which override the
one given in \fBhost.conf\fR.
.IP \fBRESOLV_ADD_TRIM_DOMAINS\fR\ 
This environment specifies a list of trim domains which are added
to those given in \fBhost.conf\fR.
.PP
.NH 3
What\ \fB/etc/hosts\fR\ looks\ like
.br
.PP
.PP
Originally, all resolving information on Internet hosts was
kept in a \fBHOSTS\fR file that was generated regularly from
a centrally maintained file named \fBHOSTS.TXT\fR. For small
Un*x systems that are not on the Internet, using static host tables
is still standard procedure. Data linking IP addresses to hostnames
is kept in a file called \fB/etc/hosts\fR.
.PP
It contains one entry per line which consists of an IP address,
a hostname, and an optional list of aliases for the hostname. The
hostname field must begin in column one. The fields
are separated by spaces or tabs. Anything between a hash sign
(`\fB#\fR') and the next newline is regarded as a comment and is ignored.
The numbers of the IP address may be given using the standard C
format for decimal, octal, or hexadecimal numbers. Octal numbers
are denoted by a prefix of \fB0\fR, hexadecimal numbers have a prefix
of \fB0x\fR.
.PP
Hostnames may either be local (i.e. without any domain name
qualification at all), or fully qualified by a domain name. To
enable the resolver to find local hosts independently of whether
their name is given fully qualified, or in its local form,
one usually enters both in the hosts file. Alternatively,
one might only enter the local name, and include 
``\fBtrim \fBlocaldomain\fR\fR'' in \fBhost.conf\fR (see
section See section resolv.conf. below), where \fB\fBlocaldomain\fR\fR
is the local domain name. Note that the \fBdomain\fR statement
in \fBresolv.conf\fR has no effect on lookups in \fB/etc/hosts\fR.
.PP
This is an example how a hosts file at the virtual Brewery might look:
.PP
.QP
.nh
.DS
.ft CW
#
# Virtual Brewery Ethernet.
#
# IP            local       fully qualified domain name
192.72.1.1      vlager      vlager.linus.lxnet.org
192.72.1.2      vstout      vstout.linus.lxnet.org
192.72.1.3      vale        vale.linus.lxnet.org
#
# Virtual Winery Ethernet
#
192.72.2.1      vlager       vlager.linus.lxnet.org
192.72.2.2      vbeaujolais  vbeaujolais.linus.lxnet.org
192.72.2.3      vbardolino   vbardolino.linus.lxnet.org
192.72.2.4      vchianti     vchianti.linus.lxnet.org
 
.DE
.ft R
\&\&
.PP
.NH 3
The\ \fB/etc/networks\fR\ file
.br
.PP
.PP
Analoguously to the hosts file, there is a file for mapping network
names to IP network addresses. It is called \fB/etc/networks\fR,
and was already mentioned above.
.PP
Since the network names refer to the physical organization of
the network, they are generally not domain names, but anything
like ``\fBbrew-lan\fR'' or ``\fBloopback\fR''. Entries in the
file begin in column one, and contain the network name, followed
by the network's IP address, and an optional list of aliases.
The numbers of the IP address may be given using either of
decimal, octal, or hexadecimal numbers in the standard C 
format.
The fields are separated by spaces or tabs.
Comments are introduced by a hash sign (`\fB#\fR') and extend to
the next newline.
.PP
A sample file for the Virtual Brewery is given below:
.PP
.QP
.nh
.DS
.ft CW
#
# /etc/networks for the Virtual Brewery.
#
# The loopback network
loopback        127
#
# The brewery's Ethernet
brew-lan        192.72.1.0     brew-net
wine-lan        192.72.2.0     wine-net
 
.DE
.ft R
\&\&
.PP
.NH 3
Configuring\ Name\ Server\ Lookups\ ---\ \fBresolv.conf\fR
.br
.PP
.PP
When configuring the resolver library to use BIND name service for
host lookups, you have to tell it which name servers to use, etc.
There is a separate file for this, called \fBresolv.conf\fR.
If this file does not exist or is empty, the resolver assumes the
name server is on your local host.
.PP
If you run a name server on your local host, you have to set it up
separately, as will be explained in section See section Configuring named. below.
If your are on a local network and have the opportunity to use an
existing nameserver, this shoud always be preferred.
.PP
You may set the following options in \fBresolv.conf\fR:
.PP
.IP \fBnameserver\fR\ 
This gives the IP address of a name server to the resolver.
\&\fBnameserver\fR options accumulate. For BIND lookups, 
they are tried in the order in which they appear in the
configuration file. Currently, up to three name servers
are supported.
.IP
If no \fBnameserver\fR option is given, the resolver attempts
to connect to the name server on the local host.
.IP \fBdomain\fR\ 
This specifies a domain name to be tacked onto all hostnames
if BIND fails to resolve it with the first query. This is to allow
to resolve hostnames specified relative to the local domain.
.IP
If no \fBdomain\fR option is present, the resolver
obtains it from the local hostname through \fBgethostname(2)\fR.
If no domain part is present in the local hostname, the
root domain is assumed.
.IP \fBsearch\fR\ 
This is an alternative to the \fBdomain\fR option: they are mutually
exclusive. \fBsearch\fR may be used to specify a list of domains
to be tacked onto a hostname after a query fails. The items
in the list are separated by spaces or tabs.
.IP
By default, this list contains the local domain, followed by
the list of all parent domains up to the root. For any host at the
brewery, this would contain \fBlinus.lxnet.org\fR, \fBlxnet.org\fR,
and \fBorg\fR. Any attempt to resolve \fBfoo\fR would result in
the lookup of \fBfoo\fR, \fBfoo.linus.lxnet.org\fR,
\&\fBfoo.lxnet.org\fR, and \fBfoo.org\fR.
.PP
.LP
The following gives a sample \fBresolv.conf\fR file for the Virtual
Brewery:
.PP
.QP
.nh
.DS
.ft CW
# /etc/resolv.conf
# Our domain
domain         linux.lxnet.org
#
# If no nameserver is specified, the resolver will query
# the local server.
# To use vlager as central nameserver, uncomment the line below:
#nameserver     192.72.1.1
 
.DE
.ft R
\&\&
.PP
.NH 3
Resolver\ Robustness
.br
.PP
.PP
If you are running a LAN inside a larger network, you will most certainly
use central name servers if they are available. The advantage of this is
that these will develop rich caches, since all queries are forwarded
to them. This scheme, however has a drawback: when a fire recently
destroyed the backbone cable at our university,
no more work was possible on our department's LAN, because the
resolver couldn't reach any of the name servers anymore. There
was no logging in on X terminals anymore, no printing, etc.
.PP
Although it is not very common for campus backbones to go down in 
flames, one might want to take precautions against cases like these.
.PP
Three options deal with setting up a local name server. This may 
either be a caching-only name server that has little but a
\&\fBcache\fR and a \fBforwarders\fR statement in its boot file,
or a secondary server for the campus zone.
The drawback of these schemes are that the local name server still needs
the central servers at boot time. This can be circumvented by
creating a zone of authority for your domain. The administrative
overhead involved with setting up a zone may forbid this option.
.PP
A fourth option, which lies somewhere in the middle of all these,
is to maintain a backup host table for your domain or LAN in
\&\fB/etc/hosts\fR. In \fB/etc/host.conf\fR you would then
include ``\fBorder bind hosts\fR'' to make the resolver fall
back to the hosts file if the central name server is down.
.PP
.NH 2
Running\ \fBnamed\fR
.br
.PP
.PP
The program that provides domain name service on Un*x machines
is usually called \fBnamed\fR (pronounced \fIname-dee\fR). This is a server
program originally developed for BSD, that provides name service to clients,
and possibly to other name servers.
It is usually started at system boot time, and runs until the machine goes
down again.
.PP
It takes its information from a configuration file called \fBnamed.boot\fR,
and various files that contain data mapping domain names to addresses and
the like. The latter are called \fIzone files\fR.
The formats and semantics of these files will be explained in the 
following section.
.PP
To run \fBnamed\fR, simply enter 
.PP
.QP
.nh
# /etc/named
.PP
at the prompt. \fBnamed\fR will come up, read the \fBnamed.boot\fR file and any
zone files specified therein. It writes its
process id to \fB/etc/named.pid\fR in ASCII, downloads any
zone files from primary servers, if necessary, and starts listening
on port \fB53\fR for DNS queries.
.PP
At startup, \fBnamed\fR reads a configuration file called
\&\fB/etc/named.boot\fR. This file is generally very small and
contains little else but pointers to master files containing
zone information, and pointers to other name servers.
Comments in the boot file start with a semicolon (`\fB;\fR')
and extend to the next newline.
.PP
The following options are available:
.IP \fBdirectory\fR\ 
 
This specifies a directory local to which the names of
zone files may be given. Different directories may
be specified by repeatedly using \fBdirectory\fR.
.IP \fBprimary\fR\ 
This takes a \fB\fBdomain name\fR\fR and a \fB\fBfile name\fR\fR
as an argument,
declaring the local server authoritative for the named
domain. As a primary server, \fBnamed\fR loads the zone's
information from the given \fB\fBfile\fR\fR.
.IP
Generally, there will always be at least one \fBprimary\fR entry
in every boot file, namely for reverse mapping of network
\&\fB127.0.0.0\fR, which is the local loopback network.
.IP \fBsecondary\fR\ 
This statement takes a \fB\fBdomain name\fR\fR, an \fB\fBaddress
list\fR\fR, and a \fB\fBfile name\fR\fR as an argument. It declares the
local server a secondary master server for the domain specified.
.IP
A secondary server holds authoritative data on the domain,
too, but it doesn't gather it from files, but tries
to download it from the primary server. The IP address of
at least one primary server must thus be given to
\&\fBnamed\fR in the address list. The local server will
contact each of them in turn until it successfully transfers
the zone database. The data received is stored in the file
given in the last argument and retrieved at the next nameserver
boot. This provides the nameserver with a complete (although 
probably outdated) copy of the master
files, even if none of the primary servers could be reached.
.IP \fBcache\fR\ 
This takes a \fB\fBdomain\fR\fR and a \fB\fBfile name\fR\fR as arguments.
The local server's cache is initialized from this file. Generally,
this is used to load the information on the name servers
for the root domain, so the \fB\fBdomain\fR\fR argument
is generally the root domain ``\fB.\fR''. The file
is generally called \fB/etc/named.ca\fR.
.IP
If this statement does not occur in the boot file, \fBnamed\fR
will not develop a local cache at all. This will severely
degrade performance and increase network load if the 
next server queried is not on the local net.
.IP \fBforwarders\fR\ 
This statement takes an \fB\fBaddress list\fR\fR as argument.
The IP addresses in this list specify a list of servers to
\&\fBnamed\fR that may be queried if it fails to resolve a
query from its local cache. They are tried in order until
one of them responds to the query.
.IP
Two things have to be considered before adding a forwarder
to the list. Above all, you have to be sure all listed
servers are willing and able to perform recursive queries for you.
Secondly, the more hosts use a name server, the faster its cache grows.
You should experiment with the number of forwarders you
install on your local network.
.IP \fBslave\fR\ 
This statement makes the name server a \fIslave\fR server. That is,
it will never perform recursive queries itself, but only queries the
forwarders specified with the \fBforwarders\fR statement.
.PP
Two more options are available whose use is no longer recommended.
These are \fBsortlist\fR and \fBdomain\fR. We will not describe them here.
.PP
An example \fBnamed.boot\fR file for \fBvlager\fR is given in
figure See section Configuring named..
.PP
[htbp]
.QP
.nh
.DS
.ft CW
;
; /etc/named.boot file for vlager.linus.lxnet.org
;
directory     /etc/domains
;
cache         .                        named.ca
primary       linus.lxnet.org.         named.hosts
primary       0.0.127.in-addr.arpa.    named.local
primary       72.192.in-addr.arpa.     named.rev
  
.DE
.ft R
\&\&
.PP
	Figure: 
The \fBnamed.boot\fR file for \fBvlager\fR.
The commands \fBcache\fR and \fBprimary\fR mentioned above
load information into \fBnamed\fR. These files contain textual
representations of DNS resource records, which we will look at
below.
Additionally, there are two directives that may be used
inside these files. These are \fB$INCLUDE\fR and \fB$ORIGIN\fR.
Since they are rarely needed, we will not describe them here.
.PP
Files included by \fBnamed\fR, like \fBnamed.hosts\fR, always have a domain
associated with them, which is called the \fIorigin\fR. This allows
the administrator to specify domain and host names relative to this domain.
A name given in a configuration file is considered \fIabsolute\fR if it
ends in a single dot, otherwise it is considered relative to the origin.
The origin all by itself may be referred to using ``\fB@\fR''.
The first resource record (RR for short) in most master files is
a \fBSOA\fR record. An exception from this is the cache file that
contains the addresses of the root name servers.
.PP
Resource record representations in the master files share a
common format, which is
.QP
.nh
\&\fB
[\fBdomain\fR] [\fBttl\fR] [\fBclass\fR] \fBtype\fR \fBrdata\fR
\&\fR
.PP
.PP
Fields are separated by spaces or tabs. An entry may be continued
across several lines if an opening brace occurs before the first newline,
and the last field is followed by a closing brace. Anything
between a semicolon and a newline is ignored.
.PP
.IP \fB\fBdomain\fR\fR\ 
This is the domain name to which the entry applies. If
no domain name is given, the RR is assumed to apply to
the domain of the previous RR.
.IP \fB\fBttl\fR\fR\ 
In order to force resolvers to discard information after
a certain time, each RR is associated a ``\fItime to live\fR'',
or \fIttl\fR for short. The \fB\fBttl\fR\fR field specifies the
time in seconds the information is valid after it has been
retrieved from the server. It is a decimal number at most eight
digits wide.
.IP
If no \fB\fBttl\fR\fR value is given, it defaults to the value
of the \fB\fBminimum\fR\fR field of the preceding \fBSOA\fR record.
.IP \fB\fBclass\fR\fR\ 
This is an address class, like \fBIN\fR for IP addresses,
or \fBHS\fR for objects in the Hesiod class. For TCP/IP
networking, you have to make this \fBIN\fR.
.IP
If no \fB\fBclass\fR\fR field is given, the class of the
preceding RR is assumed.
.IP \fB\fBtype\fR\fR\ 
This describes the type of the RR. The most common types are
\&\fBA\fR, \fBSOA\fR, \fBPTR\fR, and \fBNS\fR.  The following
sections describe the various types of RR's.
.IP \fB\fBrdata\fR\fR\ 
This holds the data associated with the RR. The format of this
fields depends on the type of the RR. Below, it will be described
for each RR separately.
.PP
.LP
The following is an incomplete list of RRs to be used in DNS master
files. There are a couple more of them, which we will not explain.
They are experimental, and of little use generally.
.PP
.IP \fBSOA\fR\ 
This describes a zone of authority (\fBSOA\fR means ``Start of
Authority''). It signals that the records following the \fBSOA\fR
RR contain authoritative information for the domain. The resource
data contains the following fields:
.RS
.IP \fB\fBorigin\fR\fR\ 
This is the canonical hostname of the primary name server
for this domain. It is usually given as an absolute name.
.IP \fB\fBcontact\fR\fR\ 
This is the email address of the person responsible for
maintaining the domain, with the `\fB@\fR' sign replaced
by a dot.
.IP \fB\fBserial\fR\fR\ 
This is the version number of the zone file, expressed as a
a single decimal number. Whenever data is changed in the
zone file, this number should be incremented.
.IP
The serial number is used by secondary name servers to
discern when zone information has changed. To stay up to date,
secondary servers request the primary server's \fBSOA\fR
record at certain intervals, and compare the serial
number to that of the cached \fBSOA\fR record.
If the number has changed, the secondary servers transfers
the whole zone database from the primary server.
.IP \fB\fBrefresh\fR\fR\ 
This specifies the interval in seconds that the secondary servers
should wait between checking the \fBSOA\fR record of the
primary server. Again, this is a decimal number at most eight
places wide.
.IP
Generally, the network topology doesn't change too often, so
that this number should specify an interval of roughly a
day for larger networks, and even more for smaller ones.
.IP \fB\fBretry\fR\fR\ 
This number determines the intervals at which a secondary
server should retry contacting the primary server if
a request or a zone refresh fails. It must not be too low,
or else a temporary failure of the server or a network problem
may cause the secondary server to waste network resources.
One hour, or perhaps one half hour, might be a good choice.
.IP \fB\fBexpire\fR\fR\ 
This specifies the time in seconds after which the server should finally
discard all zone data if it hasn't been able to contact
the primary server. It should normally be very large.
Craig Hunt ([??]) recommends 42 days.
.IP \fB\fBminimum\fR\fR\ 
This is the default ttl value for resource records
that do not explicitly specify one. This requires other
name servers to discard the RR after a certain amount of time.
It has however nothing to do with the time after which a 
secondary server tries to update the zone information.
.IP
\&\fB\fBminimum\fR\fR should be a large value, especially
for LANs where the network topology almost never changes.
A value of around a week or a month is probably a good
choice. In the case that single RRs may change more frequently,
you can still assign them different ttl's.
.RE
.IP
.IP \fBA\fR\ 
This associates an IP address with a hostname. The resource data
field simply contains the address in dotted quad notation.
.IP
.IP \fBNS\fR\ 
This points to a master name server of a subordinate zone. For an
explanation of the need to have \fBNS\fR records, see
section See section The Domain Name System.. The resource data field contains
the hostname of the name server. To resolve the hostname,
an additional \fBA\fR record is needed, the so-called \fIglue
record\fR which gives the name server's IP address.
.IP
.IP \fBCNAME\fR\ 
This associates an alias for a hostname with its \fIcanonical
hostname\fR. The canonical hostname is the one the master file
provides an \fBA\fR record for; aliases are simply linked to that
name by a \fBCNAME\fR RR, but don't have any other records of their own.
.IP
.IP \fBPTR\fR\ 
This type of record is used to associate names in the \fBin-addr.arpa\fR
domain with hostnames. This is used for reverse mapping of IP addresses
to hostnames.
.IP
.IP \fBMX\fR\ 
This RR announces a \fImail exchanger\fR for a domain. The reasons
to have mail exchangers are discussed in section See section Mail routing..
.IP
The syntax of an \fBMX\fR record is
.QP
.nh
\&\fB
[\fBdomain\fR] [\fBttl\fR] [\fBclass\fR] MX \fBpreference\fR \fBhost\fR
\&\fR
.PP
.IP
\&\fB\fBhost\fR\fR names the mail exchanger for \fB\fBdomain\fR\fR. Every
mail exchanger has a \fB\fBpreference\fR\fR associated with it. A mail
transport agent who desires to deliver mail to \fB\fBdomain\fR\fR
will try all hosts who have an \fBMX\fR record for this domain
until it succeeds. The one with the lowest preference value is
tried first, then the others in order of increasing preference
value.
.IP
.IP \fBWKS\fR\ 
This RR advertises \fIwell known services\fR offered by the host.
The syntax is
.QP
.nh
\&\fB
[\fBdomain\fR] [\fBttl\fR] [\fBclass\fR] WKS \fBaddress protocol services\fR
\&\fR
.PP
.IP
\&\fB\fBaddress\fR\fR is the host's IP address written in dotted quad notation.
The protocol used by the service, which must either be TCP or UDP,
is named in the \fB\fBprotocol\fR\fR field. There may be only one
\&\fBWKS\fR record per protocol. Finally, \fBservices\fR is a list of
service names as found in the \fB/etc/services\fR file (see
section See section The services file.). The service names are separated
by blanks or tabs, and may be continued across newlines using
braces.
.IP
.IP \fBHINFO\fR\ 
This record provides information on the system's hardware
and software. Its syntax is
.QP
.nh
\&\fB
[\fBdomain\fR] [\fBttl\fR] [\fBclass\fR] HINFO \fBhardware software\fR
\&\fR
.PP
.IP
The \fB\fBhardware\fR\fR field identifies the hardware used by this host.
There are special conventions to specify this, a list of valid
names is given in the ``Assigned Numbers'' RFC1060. If the
field contains any blanks, it must be enclosed in quotes
(`\fB"\fR'). The \fB\fBsoftware\fR\fR field names the operating
system software used by the system. Again, a valid name from the
``Assigned Numbers'' RFC should be chosen.
.PP
Figures See section Configuring named., See section Configuring named.,
See section Configuring named., and See section Configuring named.
give sample files for a name server at
the brewery, located on \fBvlager\fR. Owing to the nature of the
network discussed (a single LAN), the example is pretty straightforward.
If your requirements are more complex, and you can't get \fBnamed\fR
going, get Craig Hunt's ``TCP/IP Network Administration'' ([??]).
He has an extensive example for setting up a network of a couple of LANs
and an Internet link.
.PP
[htbp]
.QP
.nh
.DS
.ft CW
;
; /etc/domain/named.ca          Cache file for the brewery.
;                We're not on the Internet, so we don't need
;                any root servers.
;
; Example entry (note loooong expiry interval)
; A.ISI.EDU.    99999999   IN    A   26.3.0.103
;                          IN    NS  A.ISI.EDU.
  
.DE
.ft R
\&\&
.PP
	Figure: 
The \fBnamed.ca\fR file.
[htbp]
.QP
.nh
.DS
.ft CW
;
; /etc/domain/named.local       Local hosts at the brewery
;                               Origin is linus.lxnet.org
;
@                   IN  SOA   vlager.linus.lxnet.org. (
                              janet.linus.lxnet.org.
                              16         ; serial
                              86400      ; refresh: once per day
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              604800     ; minimum: 1 week
                              )
                    IN  NS    vlager.linus.lxnet.org.
;
; local mail is distributed on vlager
                    IN  MX    10 vlager
;
; loopback address
localhost.          IN  A     127.0.0.1
; brewery Ethernet
vlager              IN  A     192.72.1.1
; vlager is also news server
news                IN  CNAME vlager
vstout              IN  A     192.72.1.2
vale                IN  A     192.72.1.3
; winery Ethernet
vbeaujolais         IN  A     192.72.2.1
vbardolino          IN  A     192.72.2.2
vchianti            IN  A     192.72.2.3
  
.DE
.ft R
\&\&
.PP
	Figure: 
The \fBnamed.hosts\fR file.
[htbp]
.QP
.nh
.DS
.ft CW
;
; /etc/domain/named.local       Reverse mapping of 127.0.0
;                               Origin is 0.0.127.in-addr.arpa.
;
@                   IN  SOA   vlager.linus.lxnet.org. (
                              joe.linus.lxnet.org.
                              1          ; serial
                              360000     ; refresh: 100 hrs
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              360000     ; minimum: 100 hrs
                              )
                    IN  NS    vlager.linus.lxnet.org.
1                   IN  PTR   localhost.
  
.DE
.ft R
\&\&
.PP
	Figure: 
The \fBnamed.local\fR file.
[htbp]
.QP
.nh
.DS
.ft CW
;
; /etc/domain/named.rev         Reverse mapping of our IP addresses
;                               Origin is 72.192.in-addr.arpa.
;
@                   IN  SOA   vlager.linus.lxnet.org. (
                              joe.linus.lxnet.org.
                              16         ; serial
                              86400      ; refresh: once per day
                              3600       ; retry:   one hour
                              3600000    ; expire:  42 days
                              604800     ; minimum: 1 week
                              )
                    IN  NS    vlager.linus.lxnet.org.
; brewery
1.1                 IN  PTR   vlager.linus.lxnet.org.
1.2                 IN  PTR   vstout.linus.lxnet.org.
1.3                 IN  PTR   vale.linus.lxnet.org.
; winery
2.1                 IN  PTR   vbeaujolais.linus.lxnet.org.
2.2                 IN  PTR   vbardolino.linus.lxnet.org.
2.3                 IN  PTR   vchianti.linus.lxnet.org.
  
.DE
.ft R
\&\&
.PP
	Figure: 
The \fBnamed.rev\fR file.
.NH 3
Verifying\ the\ Resolver\ Setup
.br
.PP
.PP
There's a fine tool for checking the operation of your name server
setup. It is called \fBnslookup\fR, and may be used both interactively
and from the command line. In the latter case, you simply invoke it
as
.PP
.QP
.nh
nslookup \fBhostname\fR
.PP
and it will query the name server specified in \fB/etc/resolv.conf\fR.
(If this file names more than one server, it will choose one at random).
.PP
The interactive mode, however, is much more exciting. Besides looking
up individual hosts, you may query for any type of DNS record, and
transfer the entire zone information for a domain.
.PP
When invoked without argument, \fBnslookup\fR will display the name
server it uses, and enter interactive mode. At the `\fB>\fR' prompt,
you may type any domain name it should query for. By default, it
asks for class \fBA\fR records, those containing the IP address relating
to the domain name. You may change this type by issuing ``\fBset type=\fBtype\fR\fR'',
where \fB\fBtype\fR\fR is one of the resource record names described above
in section See section Configuring named., or \fBANY\fR.
.PP
For example, you might have the following dialogue with it:
.QP
.nh
.DS
.ft CW
$ nslookup
Default Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60
\&\&
> sunsite.unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60
\&\&
Non-authoritative answer:
Name:    sunsite.unc.edu
Address:  152.2.22.81
\&\&
> unc.edu
*** No address (A) records available for unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60
\&\&
> set type=MX
> unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60
\&\&
Non-authoritative answer:
unc.edu preference = 10, mail exchanger = lambada.oit.unc.edu
\&\&
Authoritative answers can be found from:
UNC.EDU nameserver = SAMBA.ACS.UNC.EDU
UNC.EDU nameserver = NS.BME.UNC.EDU
UNC.EDU nameserver = NCNOC.CONCERT.NET
lambada.oit.unc.edu     internet address = 152.2.22.80
SAMBA.ACS.UNC.EDU       internet address = 128.109.157.30
NS.BME.UNC.EDU          internet address = 128.109.155.1
NS.BME.UNC.EDU          internet address = 152.2.100.1
NCNOC.CONCERT.NET       internet address = 192.101.21.1
NCNOC.CONCERT.NET       internet address = 128.109.193.1
> set type=SOA
> unc.edu
Name Server:  rs10.hrz.th-darmstadt.de
Address:  130.83.56.60
\&\&
Non-authoritative answer:
unc.edu
        origin = ns.unc.edu
        mail addr = shava.ns.unc.edu
        serial = 930408
        refresh = 28800 (8 hours)
        retry   = 3600 (1 hour)
        expire  = 1209600 (14 days)
        minimum ttl = 86400 (1 day)
\&\&
Authoritative answers can be found from:
[same as above]
> exit
$
 
.DE
.ft R
\&\&
.PP
The complete set of commands available with \fBnslookup\fR may be
obtained by the \fBhelp\fR command.
.PP
.bp
.NH
Various\ Network\ Applications
.br
.PP
.PP
After successfully setting up IP and the resolver, you have to turn
to the services you want to provide over the network.
This chapter lists the configuration options and requirements
for several services. Some, however, require more space, and are thus
explained in a separate chapter. This certainly applies to electronic
mail and netnews, which are also not specific to TCP/IP networking.
.PP
There are other network applications as well, which only need little
attendance when setting them up; please refer to their respective
manual pages for details.
.PP
Generally, services are performed by \fIdaemons\fR. A daemon is a
program that opens a certain port, and waits for incoming connections.
If one occurs, it creates a child process which accepts the connection,
while the parent continues to listen for further requests. The
daemon providing the service is generally called the \fIserver\fR,
and the program requesting it is called the \fIclient\fR.
.PP
Support of NIS (``Network Information System'', a.k.a. ``Yellow Pages'')
is under way. Once it is released, I will add a section on its
configuration.
.PP
.PP
.NH 2
The\ \fB/etc/services\fR\ file
.br
.PP
.PP
As noted before in section See section The Transport Layer., the port
numbers on which certain ``standard'' services are offered are
laid down in the ``Assigned Numbers'' RFC. To enable server
and client programs to convert service names to these numbers,
at least a part of the list is kept on each host; it is stored in
a file called \fB/etc/services\fR.
.PP
It contains single lines, each describing a service. An entry
is made like this:
.PP
.QP
.nh
\&\fBservice\fR \fBport\fR/\fBproto\fR   [\fBaliases\fR]
.PP
Here, \fB\fBservice\fR\fR specifies the service name, \fB\fBport\fR\fR
and \fB\fBproto\fR\fR define the port the service is offered on, and which
transport protocol is used. Commonly, this is either \fBudp\fR or
\&\fBtcp\fR. It is possible for a service to be offered for more
than one protocol, as well as offering different services on the
same port, as long as the protocols are different. The \fB\fBaliases\fR\fR
field allows to specify alternative names for the same service.
.PP
Usually, you don't have to change the services file that comes along
with the network software on your Linux system. Nevertheless, we will
give a small excerpt from the file in figure See section The services file..
.PP
[hbtp]
.QP
.nh
.DS
.ft CW
# The services file:
#
# well-known services
echo           7/tcp                 # Echo
echo           7/udp                 #
discard        9/tcp  sink null      # Discard
discard        9/udp  sink null      #
systat        11/tcp  users          # Active Users
daytime       13/tcp                 # Daytime
daytime       13/udp                 #
chargen       19/tcp  ttytst source  # Character Generator
chargen       19/udp  ttytst source  #
ftp-data      20/tcp                 # File Transfer Protocol (Data)
ftp           21/tcp                 # File Transfer Protocol (Control)
telnet        23/tcp                 # Virtual Terminal Protocol
smtp          25/tcp                 # Simple Mail Transfer Protocol
domain        53/tcp  nameserver     # Domain Name Service
domain        53/udp  nameserver     #
nntp         119/tcp  readnews       # Network News Transfer Protocol
#
# UNIX services
biff         512/udp  comsat         # mail notification
exec         512/tcp                 # remote execution, passwd required
login        513/tcp                 # remote login
who          513/udp  whod           # remote who and uptime
shell        514/tcp  cmd            # remote command, no passwd used
syslog       514/udp                 # remote system logging
printer      515/tcp  spooler        # remote print spooling
talk         517/udp                 # conversation
ntalk        518/udp                 # new talk, conversation
route        520/udp  router routed  # routing information protocol
  
.DE
.ft R
\&\&
.PP
	Figure: 
A sample \fB/etc/services\fR file.
Note that, for example, the \fBecho\fR service is offered on
port 7 for both TCP and UDP, and that port 512 is used for two different
services, namely the COMSAT daemon (which notifies users of newly
arrived mail, see \fBxbiff(1x)\fR), using UDP, and for remote
execution (\fBrexec(1)\fR), using TCP.
.PP
.NH 2
The\ \fB/etc/protocols\fR\ file
.br
.PP
.PP
Similar to the services file, the networking library needs a way
to translate protocol names --- for example, those used in the services
file --- to protocol numbers understood by the IP layer on other hosts.
This is done by looking up the name in the \fB/etc/protocols\fR file.
It contains one entry per line, each containing a protocol name, and
the associated number. Having to touch this file is even more unlikely
than having to muddle with \fB/etc/services\fR. A sample file
is given in figure See section The protocols file..
.PP
[hbtp]
.QP
.nh
.DS
.ft CW
#
# Internet (IP) protocols
#
ip      0       IP              # internet protocol, pseudo protocol number
icmp    1       ICMP            # internet control message protocol
igmp    2       IGMP            # internet group multicast protocol
ggp     3       GGP             # gateway-gateway protocol
tcp     6       TCP             # transmission control protocol
egp     8       EGP             # exterior gateway protocol
pup     12      PUP             # PARC universal packet protocol
udp     17      UDP             # user datagram protocol
raw     255     RAW             # RAW IP interface
  
.DE
.ft R
\&\&
.PP
	Figure: 
A sample \fB/etc/protocols\fR file.
.NH 2
The\ \fBinetd\fR\ Super-Server
.br
.PP
.PP
The concept of servers and clients described above has one drawback:
for every service offered, a daemon has to run that listens on
the port for a connection to occur. Since, however, on many installation
not all services are required at all times, this means a waste of
system resources (swap space).
.PP
Thus, almost all Un*x installations run a ``super-server'' that
creates sockets for a number of services, and listens on all of them
simultaneously. When a remote host requests one of the services,
the super-server notices this and spawns the server specified for
this port.
.PP
The super-server commonly used is \fBinetd\fR, the Internet Daemon.
It is started at system boot time, and takes the list of services
it is to manage from a startup file named \fB/etc/inetd.conf\fR.
In addition to those servers invoked, there are a number of trivial
services which are performed by \fBinetd\fR itself, these are called
\&\fIinternal services\fR. They include \fBchargen\fR which simply generates
a string of characters, \fBdaytime\fR which returns the system's idea
of the time of day.
.PP
An entry in this file consists of a single line in the following
format:
.PP
.QP
.nh
 \fB
service type proto wait user server cmdline
\&\fR
.PP
.PP
The meaning of the fields is as follows:
.IP \fB\fBservice\fR\fR\ 
Gives a service name as specified in \fB/etc/services\fR.
.IP \fB\fBtype\fR\fR\ 
Specifies a socket type, either \fBstream\fR (for connection-oriented
protocols) or \fBdgram\fR (for datagram protocols).
TCP-based services should therefore always use \fBstream\fR, while
UDP-based services should always use \fBdgram\fR.
.IP \fB\fBproto\fR\fR\ 
The transport protocol used by the service. Must be a valid
protocol name found in \fB/etc/protocols\fR.
.IP \fB\fBwait\fR\fR\ 
This option only applies to \fBdgram\fR sockets. It may
be either \fBwait\fR or \fBnowait\fR. If \fBwait\fR is
specified, \fBinetd\fR will only execute one server for
the specified port at any time. Otherwise, it will immediately
continue to listen on the port after executing the server.
.IP
This is useful for ``single-threaded'' servers that read all incoming
datagrams until no more arrive, and then exit. Most RPC servers
are of this type and should therefore specify \fBwait\fR.
The opposite type, ``multi-threaded'' servers,
allow an unlimited number of instances to run concurrently;
\&\fBnamed\fR is of this type. These servers should specify \fBnowait\fR.
.IP
\&\fBstream\fR sockets should always use \fBnowait\fR.
.IP \fB\fBuser\fR\fR\ 
This is the login id of the user the process is executed under.
Generally, this will be \fBroot\fR, but some services may use different
accounts. For example, the NNTP news server will run as \fBnews\fR,
while services that may pose a security threat (such as \fBtftp\fR
or \fBfinger\fR) are often run as \fBnobody\fR.
.IP \fB\fBserver\fR\fR\ 
This gives the full path name of the server program to be executed.
Internal services are marked by the keyword \fBinternal\fR.
.IP \fB\fBcmdline\fR\fR\ 
This is the command line to be passed to the server. This includes
argument 0, that is the command name. Usually, this will be
the program name of the server, unless the program behaves
differently when invoked by a different name.
.IP
This field is empty for internal services.
.PP
A sample \fBinetd.conf\fR file is shown in figure See section The inetd Super Server..
We see that \fBtftp\fR and \fBfinger\fR are commented out, so that
they are not available. This is often done for security reasons,
because these services are prime targets for intruders.
.PP
[hbtp]
.QP
.nh
.DS
.ft CW
# 
# inetd services
ftp          stream tcp nowait root /etc/ftpd     ftpd -l
telnet       stream tcp nowait root /etc/telnetd  telnetd -b/etc/issue
#tftp         dgram  udp wait   root /etc/tftpd    tftpd
#finger       stream tcp nowait bin /etc/fingerd  fingerd
login        stream tcp nowait root /etc/rlogind  rlogind
shell        stream tcp nowait root /etc/remshd   remshd
exec         stream tcp nowait root /etc/rexecd   rexecd
#
#       inetd internal services
#
daytime      stream tcp nowait root internal
daytime      dgram  udp nowait root internal
time         stream tcp nowait root internal
time         dgram  udp nowait root internal
echo         stream tcp nowait root internal
echo         dgram  udp nowait root internal
discard      stream tcp nowait root internal
discard      dgram  udp nowait root internal
chargen      stream tcp nowait root internal
chargen      dgram  udp nowait root internal
  
.DE
.ft R
\&\&
.PP
	Figure: 
A sample \fB/etc/inetd.conf\fR file.
.NH 2
The\ \fBtcpd\fR\ access\ control\ facility
.br
.PP
.PP
Since opening a computer to network access involves many security risks,
applications are designed to guard against several types of attacks.
Some of these, however, may be flawed (most drastically demonstrated
by the RTM Internet worm), or do not allow to differentiate between
secure hosts from which requests for a particular service will be accepted,
and insecure hosts whose requests should be rejected. The \fBfinger\fR
and \fBtftp\fR services, for example, pose such a risk because they allow
potential intruders to gather login names from users on the system. Thus,
one would want to limit access to these services to ``trusted hosts''
only, which is impossible with the usual setup, where \fBinetd\fR either
provides this service to all clients, or not at all.
.PP
The NET-2 release contains \fBtcpd\fR,
.FS 
Written by Wietse Venema, \fBwietse@wzv.win.tue.nl\fR.
.FE
 a so-called daemon wrapper. For
TCP services you want to monitor or protect, it is invoked instead of
the server program, logs the request to the \fBsyslog\fR daemon,
performs optional host access control, and only if this succeeds, executes
the real server program. Note that is does not work with UDP-based
services, most notably not RPC.
.PP
For example, to wrap the \fBfinger\fR daemon,
you have to change the corresponding line in \fBinetd.conf\fR to
.PP
.QP
.nh
.DS
.ft CW
# wrap finger daemon
finger  stream  tcp     nowait  root    /usr/etc/tcpd   in.fingerd
 
.DE
.ft R
\&\&
.PP
Without adding any access control, this will appear to the client
just as a usual \fBfinger\fR setup, except that any requests are logged
to \fBsyslog\fR.
Access control is implemented by means of two files located in the
\&\fB/etc\fR directory; these are \fBhosts.allow\fR and \fBhosts.deny\fR.
They contain entries allowing and denying access, respectively, to
certain services and hosts. If \fBtcpd\fR has to handle a request for
a service, say \fBfinger\fR, from a client host named \fBbiff.foobar.com\fR,
it scans \fBhosts.allow\fR and \fBhosts.deny\fR (in this order) for
an entry matching both the service and client host. If a matching entry
is found in \fBhosts.allow\fR, access is granted, regardless of any entry in
\&\fBhosts.deny\fR. If a match is found in \fBhosts.deny\fR, the request
is rejected by closing down the connection. If no match is found at all,
the request is accepted, too.
.PP
Entries in the access files look like this:
.PP
.QP
.nh
\&\fBservicelist\fR: \fBhostlist\fR [:\fBshellcmd\fR]
.PP
\&\fB\fBservicelist\fR\fR is a list of service names from \fB/etc/services\fR,
or the keyword \fBALL\fR. To match all services except \fBfinger\fR, use
``\fBALL\fR \fBEXCEPT\fR \fBfinger\fR''.
.PP
\&\fB\fBhostlist\fR\fR is a list of hostnames or IP addresses, or the keywords
\&\fBALL\fR, \fBLOCAL\fR, or \fBUNKNOWN\fR. \fBALL\fR matches any host,
while \fBLOCAL\fR matches hostnames not containing a dot.
.FS 
Usually local hostnames obtained from lookups in \fB/etc/hosts\fR.
.FE
 \fBUNKNOWN\fR matches any hosts whose name or address lookup failed.
A name starting with a dot matches all hosts whose domain is equal to this
name. For example, \fB.foobar.com\fR matches \fBbiff.foobar.com\fR.
There are also provisions for IP network addresses and subnet numbers.
Please refer to the \fBhosts_access(5)\fR manual page for details.
.PP
To deny access to the \fBfinger\fR and \fBtfpd\fR services to all but
the local hosts, put the following in \fB/etc/hosts.deny\fR, and leave
\&\fB/etc/hosts.allow\fR empty:
.PP
.QP
.nh
.DS
.ft CW
in.ftpd, in.fingerd: ALL EXCEPT LOCAL, .your.domain
 
.DE
.ft R
\&\&
.PP
The optional \fB\fBshellcmd\fR\fR field may contain a shell command
to be invoked when the entry is matched. This is useful to set up
traps that may expose the attacker:
.PP
.QP
.nh
.DS
.ft CW
in.ftpd: ALL EXCEPT LOCAL, .your.domain : \e
        finger -l @h | /usr/bin/mail -s d-h root
 
.DE
.ft R
\&\&
.PP
The \fBh\fR and \fBd\fR arguments are expanded by \fBtcpd\fR
to the client host name and service name, respectively. Please refer to
the \fBhosts_access(5)\fR manual page for details.
.PP
.NH 2
Configuring\ the\ \fBr\fR\ commands
.br
.PP
.PP
There are a number of commands for executing commands on remote
hosts. These are \fBrlogin\fR, \fBrsh\fR, \fBrcp\fR
and \fBrcmd\fR.
They all spawn a shell on the remote host and allow the user
to execute commands. Of course, the client needs to have an account
on the host where the commmand is to be executed, thus all these commands
perform an authorization procedure. Usually, the client will tell
the user's login name to the server, which in turn requests a password
that is validated in the usual way.
.PP
However, for reasons of convenience, you may facilitate access to
these services within a network by overriding authorization checks.
However, this is only advisable for a small number of hosts whose
password databases are synchronized, or for a small number of
privileged users who need to access many machines for administrative
reasons. Whenever you want to allow people to log into your host
without having to specify a login id or password, make sure 
that you don't accidentally grant access to anybody else.
.PP
There are two ways to disable authorization checks for the \fBr\fR
commands. One is for the super user to allow certain or all
users on certain or all hosts (the latter definitely being a bad
idea) to log in without being asked for a password. This access
is controlled by a file called \fB/etc/hosts.equiv\fR, which
defines a list of \fIequivalent\fR hosts and users. The second option
is for a user to grant other users on certain hosts access to her
account. These may be listed in the file \fB.rhosts\fR in the
user's home directory. If this file is not owned by the user
or the super user, or if it is a symbolic link, it is
ignored.
.FS 
In an NFS environment, you may need to give it a protection of
\&\fB444\fR, because the super user is often very restricted in accessing
files on disks mounted via NFS.
.FE
.PP
When a client requests an \fBr\fR service, her host and
user name are searched in the \fB/etc/hosts.equiv\fR file, 
and then in the home directory of the local user with the same 
name as the client, if one exists. Thus, if \fBjanet\fR executes
.PP
.QP
.nh
$ rlogin -l joe euler
.PP
on \fBgauss\fR to login as \fBjoe\fR on \fBeuler\fR, the server will
first search \fB/etc/hosts.equiv\fR
.FS 
Note that the \fBhosts.equiv\fR file is \fInot\fR
searched when someone attempts to log in as \fBroot\fR.
.FE
 for an entry matching \fBgauss\fR
and \fBjanet\fR, and if this fails, try to look it up in \fB.rhosts\fR
in \fBjoe\fR's home directory.
.PP
Both files contain lines that describe accounts on remote hosts.
They may be used to allow or deny access to these users. However,
their interpretation of the entries differ slightly.
.PP
An entry consists of a hostname, optionally followed by a login name. 
Each hostname in turn is compared to the client's canonical hostname.
If it matches, and if the entry contains a user name, it is compared
to the client's user name (on the system she is calling from).
If the entry does not give a user name, the client's name is checked
against the login name she tries to log in as.
.PP
Note that the client's hostname is obtained by reverse mapping the address
to a name, so that this feature will fail with hosts unknown to
the resolver. The client's hostname is considered to match the
name in the hosts files in one of the following cases:
.PP
.IP \(bu\ 
The client's canonical hostname (not an alias) literally
matches the hostname in the file.
.IP \(bu\ 
If the client's hostname is a fully qualified domain name
(such as returned by the resolver when you have DNS
running), and it doesn't literally match the hostname in
the hosts file, it is compared to that hostname
expanded with the local domain name.
Now, let's look what happens Janet's attempt to log into Joe's
account on \fBeuler\fR. Suppose the \fB/etc/hosts.equiv\fR file
contains the following line
.PP
.QP
.nh
.DS
.ft CW
# Allow access to users from gauss
gauss
 
.DE
.ft R
\&\&
.PP
This entry allows users on \fBgauss\fR to log into \fBeuler\fR without
specifying a password as long as they log into their \fIown\fR
account.
.FS 
Except for \fBroot\fR.
.FE
 That is, Janet would be allowed to log in as \fBjanet\fR, but \fInot\fR
as \fBjoe\fR. No luck so far. Now, assume that the \fB.rhosts\fR file
in \fBjoe\fR's home directory contains
.PP
.QP
.nh
.DS
.ft CW
# Allow janet to log in from gauss
gauss   janet
 
.DE
.ft R
\&\&
.PP
Finally, this entry matches, and \fBrlogind\fR lets Janet log in
as Joe without asking for a password.
.PP
.NH 2
Configuring\ RPC
.br
.PP
.PP
RPC, or \fIremote procedure call\fR, is a service that allows clients
to access a network-based service the same way they call a subroutine.
It was originally developed by Sun Mircosystems, Inc., but is now present
on most Un*x systems.
.FS 
For a specification of RPC, see RFC 1057.
.FE
 A RPC server registers a number of routines with the so-called
\&\fIportmapper\fR, which may be accessed over TCP/IP, with data being
passed in a system-independent fashion. The protocol it uses is
called the \fIexternal data representation\fR (XDR) protocol.
.FS 
XDR is a good example of a session layer protocol as described in
section See section The Upper Layers..
.FE
.PP
The transport protocol used by most RPC services is the
user datagram protocol, because most requests are simple
queries and replies, with only small amounts of data being
transferred. However, some services also use TCP when transferring
larger amounts of data that do not fit into a single datagram.
.PP
Services that use RPC are the network filesystem, NFS, and the
network information system, NIS.
.FS 
This is a successor to the \fIyellow pages\fR, or yp, service.
However, yp is often used to refer to NIS now.
.FE
 The naming convention used throughout the NET-2 release has it that
RPC-based server programs reside in \fB/usr/etc\fR, their name being
prefixed with ``\fBrpc.\fR''. In this section, we will use the unadorned
name (like \fBnfsd\fR) and supply the prefix only when using the full
path name (as in \fB/usr/etc/rpc.nfsd\fR).
.PP
Each server is assigned a program number, and each procedure it offers
is assigned a procedure number. The program number 
is registered with the portmapper, together with the port the server
listens to for requests. (Thus the name portmapper, because it maps
program numbers to port numbers). Again, the program numbers for
a list of standard services may be found in the ``Assigned Numbers''
RFC. When a client wants to access a
procedure, it first inquires the portmapper on the remote host for
the port it should direct its request at, and then contacts the server.
Alternatively, it may ask the portmapper to forward its request
to the appropriate server.
.PP
The portmapper is a program started at system boot time, namely 
\&\fB/etc/rpc.portmap\fR. It must be invoked before the \fBinetd\fR
super server, because some RPC servers are managed by \fBinetd\fR.
.PP
The portmapper does not require any configuration files,
because any RPC servers will register themselves with \fBportmap\fR
once they start up. The advantage of this is that you may write
distributed applications that use RPC without having to have
access to a configuration file. The drawback is that in case the
portmapper should crash, all servers have to be restarted.
.PP
However, there is an RPC configuration file that may be used
by some clients to find the program number corresponding to
a certain service. This is the \fB/etc/rpc\fR file, which is very
similar in function to the \fB/etc/services\fR file. Each line 
has the following information:
.PP
.QP
.nh
\&\fBname program_number\fR [\fBaliases\fR]
.PP
where \fB\fBname\fR\fR is the service name, \fB\fBprogram_number\fR\fR
is the service's program number, and \fB\fBaliases\fR\fR is an optional
list of alternative names for the service. An example file is
shown in figure See section Configuring RPC..
.PP
[htbp]
.QP
.nh
.DS
.ft CW
#
# rpc 88/08/01 4.0 RPCSRC; from 1.12   88/02/07 SMI
#
portmapper      100000  portmap sunrpc
rstatd          100001  rstat rstat_svc rup perfmeter
rusersd         100002  rusers
nfs             100003  nfsprog
ypserv          100004  ypprog
mountd          100005  mount showmount
ypbind          100007
walld           100008  rwall shutdown
yppasswdd       100009  yppasswd
bootparam       100026
ypupdated       100028  ypupdate
  
.DE
.ft R
\&\&
.PP
	Figure: 
A sample \fB/etc/rpc\fR file.
.NH 2
Configuring\ NIS
.br
.PP
.PP
Currently (as of July 2, 1993), there is no NIS support publicly available.
Someone is working on this, however.
.PP
.NH 2
Configuring\ FTP
.br
.PP
.PP
.PP
.PP
The most widely known use of FTP (File Transfer Protocol) is to
provide users from any host with access to publicly available data.
This is generally called anonymous FTP. However, it may be used
for file transfers from and to local user accounts as well. The FTP
server, \fBftpd\fR, performs the usual authorization procedure using
the \fB/etc/passwd\fR database.
.FS 
The \fBfptd\fR in SLS was compiled to use the \fB/etc/shadow\fR file.
.FE
 Accounts without password are ignored.
.PP
After passing this procedure, a client is allowed access to any files
and directories accessible to the user she logged in as.
Certain users may be denied access to FTP by listing them in the file
\&\fB/etc/ftpusers\fR. This file contains one user name per line, without
any white space allowed.
.PP
I am aware that there is another FTP daemon called \fBftpd-diku\fR,
which has enhanced functionality.
.FS 
Some people were wondering what the \fB/etc/ftpaccess\fR file in
the SLS release is good for. It is used by \fBftpd-diku\fR only.
.FE
 Since it is not part of the ``official'' networking release, I
do not describe it here. Please refer to the documentation that comes
with it.
.PP
.NH 3
Anonymous\ FTP
.br
.PP
.PP
Anonymous FTP requires tough security measures to prevent
clients from accessing any important information on
your system. 
.PP
To set up an anonymous FTP account, you have to create a user
named \fBftp\fR. It should be member of a group with very limited access
only, for example \fBguest\fR, have a login shell of \fB/bin/false\fR,
and a password of ``\fB*\fR'' to prevent anyone from actually logging
in as \fBftp\fR. The home directory should be something like \fB/usr/ftp\fR,
have proper ownership (namely \fBftp\fR and \fBguest\fR) and have a
protection mode of \fB555\fR.
.PP
If a client specifies a user name of \fBftp\fR or \fBanonymous\fR when
asked by \fBftpd\fR, the server performs a \fBchroot(2)\fR to the
home directory of the \fBftp\fR account. The effect of this is that this
home directory appears to the client as the root of the directory hierarchy,
thus denying it access to any files outside the home directory.
.FS 
When you merely change the working directory, you may access files
outside of it by either using absolute pathnames or `\f(CW\`..\'\fR' to access
files not below the working directory. When doing a \fBchroot\fR, all
absolute pathnames are interpreted as starting from the new directory,
and its parent directory is inaccessible.
.FE
 Any files (such as the \fBls\fR command) accessed after this \fBchroot\fR
must thus be available beneath this directory.
.PP
In addition, you may allow sub-logins of users whom you have
granted special access to your FTP area. These first
log in as an anonymous FTP user, and after that access the sub-login
by specifying a user name and password using the \fBUSER\fR command
of \fBftp\fR. For these, you have to set up a home directory, which is
owned by the user and has mode \fB700\fR. Remember that the home directory's
name has the \fB ftp\fR directory as its root.
.PP
.LP
The following files directories need to be present:
.IP \fB\ ftp/bin\fR\ 
This directory should be owned by \fBroot\fR and have mode \fB555\fR.
It should contain a copy of the \fBls\fR command, which is needed
by \fBftpd\fR to list directories. It should be mode \fB111\fR.
If \fB ftp\fR is on the same file system as \fB/bin\fR, this may
also be a hard link to \fB/bin/ls\fR; however, you can not make a symbolic
link.
.IP \fB\ ftp/lib\fR\ 
This directory should be owned by \fBroot\fR and have mode \fB555\fR.
It must contain a copy of the current version of the \fBlibc\fR jumptable
image, \fB/lib/libc.so.\fBX\fR\fR. This is needed for \fBls\fR, which is
linked with the jumptable libraries. As with \fB ftp/bin/ls\fR, this may
be a hard link to the jumptable image, if possible, but not a symbolic link.
It should be owned by \fBroot\fR and have mode \fB111\fR.
.IP \fB\ ftp/etc\fR\ 
This directory should be owned by \fBroot\fR and have mode \fB555\fR.
It should contain versions of the \fBpasswd\fR, \fBgroup\fR, and
\&\fBshadow\fR files from \fB/etc\fR. These are needed to map user id's
to login names when listing files. They should not be complete
copies of the files from \fB/etc\fR, nor should they be hard links,
since this would provide intruders with a list of all accounts
on your system.
.IP
Accounts other than sub-logins should be denied access by specifying
a password of ``\fB!\fR'' in \fB ftp/etc/shadow\fR.
.IP \fB\ ftp/incoming\fR\ 
This directory should be owned by \fBftp\fR. It either should
have mode \fB733\fR to allow users to deposit files, but
preventing others to retrieve them before you have moved them
to the proper location (or thrown them away, for that matter),
or should have mode \fB777\fR if you want to allow them to
be retrieved.
.IP \fB\ ftp/pub\fR\ 
Under this directory, you keep all files you want to make available
to users of your anonymous FTP service. The directory should be owned
by \fBftp\fR and have mode \fB555\fR. Files below this should have
mode \fB444\fR to prevent FTP users to remove or modify them.
.IP
If you allow sub-logins of people who have taken over responsibility
for part of your FTP area, you should make sure to set permissions
properly for these directories.
.PP
If your \fB ftp/\fR directory is not on the same partition as your
shared libraries, you will almost assuredly be better off to make
staticly linked copies of your executables, as the shared library is
quite large, and would take up more disk space than simply making a
few staticly-linked executables.  Another possibility is installing
the ``lite'' shared library, which is available in the GCC/library
distribution, and is quite a bit smaller.
.PP
.NH 3
\&\fBftpd\fR\ Options
.br
.PP
.PP
Usually, \fBftpd\fR is invoked by the \fBinetd\fR super-server. On the command line
passed to \fBftpd\fR, you may specify the following options:
.IP \fB-l\fR\ 
Enable logging of FTP sessions.
.IP \fB-d\ \fBdbglvl\fR\fR\ 
Enable logging of debug messages. 
.IP \fB-t\ \fBtimeout\fR\fR\ 
This causes \fBftpd\fR to close down sessions after the client has
been inactive for the specified amount of time. By default, this
value is set to 15 minutes.
.IP \fB-u\ \fBumask\fR\fR\ 
Sets the file creation mask used by \fBftpd\fR to \fB\fBumask\fR\fR.
It defaults to \fB027\fR.
.PP
When logging is enabled, \fBftpd\fR logs messages to the
\&\fBdaemon\fR facility of \fBsyslogd\fR. FTP sessions are logged
at the \fBinfo\fR level; debug messages are logged at the
\&\fBdebug\fR level. To send these messages to a file, enter
the following line to \fB/etc/syslogd.conf\fR:
.PP
.QP
.nh
.DS
.ft CW
daemon.info:    /usr/adm/daemon.log
 
.DE
.ft R
\&\&
.PP
.bp
.NH
Configuring\ NFS
.br
.PP
.PP
NFS, the network filesystem, is one of the most prominent network
services using RPC. Unlike conventional file systems that write
blocks to and read them from physical media, NFS does not use any
special device, or deals with block allocation, file system
consistency, and the like. Instead, the basic unit of information 
with NFS is a file. This file access is completely transparent
to the client, and works across a variety of server and host
architectures. 
.PP
.PP
.PP
.IP \(bu\ 
Data accessed by all users can be kept on a central
host, with clients mounting this directory at boot
time. For example, this may be the disk 
containing \fB/home\fR, so that users don't have
to remember the host where they keep the most up-to-date
version of their current project.
.IP \(bu\ 
Data consuming large amounts of disk space may be kept
on a single host.
For example, all files and program relating to
LaTeX and METAFONT could be kept and maintained
in one place, reducing administrative overhead.
.IP \(bu\ 
Administrative data may be kept on a single host.
No need to use \fBrcp\fR anymore to install the same
stupid file on 20 different machines.
However, before you start to weep with joy, let me tell you
that the Linux implementation of NFS is not yet perfect. Although
it is now possible
to run binaries from NFS-mounted file systems, it is still
a bit slow. This is due to the fact that the kernel is
currently lacking a generalized form of the \fBmmap(2)\fR call, which
allows a program to map files to a process' address space.
.PP
Let's have a look now at how NFS works:
A client may request to mount a directory from a remote host
on a local directory, just the same way it does with physical devices.
However, the syntax used to specify the remote directory is
different. For example, to mount \fB/home\fR from host \fBvlager\fR
to \fB/users\fR on \fBvale\fR, the administrator would
issue the following command on \fBvale\fR:
.FS 
Note that you can omit the \fB-t nfs\fR argument, because
\&\fBmount\fR sees from the colon that this specifies an NFS
volume.
.FE
.PP
.QP
.nh
# mount -t nfs vlager:/home /users
.PP
\&\fBmount\fR will then try to connect to the \fBmountd\fR mount
daemon on \fBvlager\fR via RPC. The server will check if
\&\fBvale\fR is permitted to mount the directory in question, and
if so, return it a file handle. This file handle will be used
in all subsequent requests to files below \fB/users\fR.
.PP
When accessing files over NFS, an RPC call is made
to \fBnfsd\fR (the NFS daemon) on the server machine, in which 
\&\fBnfsd\fR is passed the file handle, the name of the file to be accessed,
and the user's user and group id. These are used in determining access
rights to the specified file. In order to prevent unauthorized
users from reading or modifying files, user and group ids on
both hosts must be synchronized.
.PP
On most Un*x implementations, the RPC call is made by a daemon
running on the client host. This is the \fIBlock I/O Daemon\fR,
\&\fBbiod\fR. It is used to improve throughput 
by performing asynchronous I/O (read-ahead and write-behind).
Linux NFS, however, does not use \fBbiod\fR; the kernel
NFS layer places the RPC call itself instead. It is
(currently) lacking read-ahead and write-behind, so that performance
comparisons with other NFS clients are not favorable.
The biggest problem with the Linux NFS code is that
the Linux UDP driver currently does not support datagram
fragmentation, and that it has a datagram size limit of 1K.
This means that for NFS mounts from systems that use large UDP
datagrams (e.g., 8K on SunOS) by default, it needs to be downsized
artificially. This, of course, further decreases transfer speed due
to the increase in the RPC-imposed overhead.
.PP
The syntax for reducing both read and write transfer sizes to
1K varies among different operating systems,
but to mount a volume from your Linux machine to SunOS or a
BSD-derived system you can use mount options like this:
.PP
.QP
.nh
# mount -t nfs \fBlinux-host\fR:\fBremote-dir local-dir\fR -o rsize=1024,wsize=1024
.PP
.NH 2
Mounting\ an\ NFS\ Volume
.br
.PP
.PP
NFS volumes
.FS 
One doesn't say file system, because these are not proper file systems.
.FE
 are mounted very much the way usual file systems are mounted. You invoke
\&\fBmount\fR using the following syntax
.PP
.QP
.nh
# mount -t nfs \fBnfs_volume local_dir options\fR 
.PP
\&\fB\fBnfs_volume\fR\fR is given as \fB\fBremote_host\fR:\fBremote_dir\fR\fR.
Since this notation is unique to NFS file systems, you can leave out
the \fB-t nfs\fR option.
.PP
There are a number of additional options that you may specify to \fBmount\fR
upon mounting an NFS volume. These may either be given following the \fB-o\fR
switch on the command line, or in the options field of the \fB/etc/fstab\fR
entry for the volume. In both cases, multiple options are separated
from each other by commas.
.PP
A sample entry in \fB/etc/fstab\fR might be
.PP
.QP
.nh
.DS
.ft CW
news:/usr/spool/news  /usr/spool/news   nfs   timeo=14,intr
 
.DE
.ft R
\&\&
.PP
This volume may then be mounted using
.PP
.QP
.nh
.DS
.ft CW
mount news:/usr/spool/news
 
.DE
.ft R
\&\&
.PP
An alternative command to be used in the absence of a \fBfstab\fR entry
would be
.PP
.QP
.nh
.DS
.ft CW
mount -t nfs news:/usr/spool/news /usr/spool/news -o timeo=14,intr
 
.DE
.ft R
\&\&
.PP
There are a number of options that control the client's behavior when
mounting an NFS volume, as well as options that configure the way
the server treats mount requests for a certain directory.
.PP
Server options are given to the \fBnfsd\fR daemon in a file called
\&\fBexports\fR, which is described in the following section.
Client options are given to the \fBmount\fR command in one of the two
ways described above, i.e. either on the command line using the \fB-o\fR
switch, or in the \fBfstab\fR file. Options specified on the command line
always override those given in the \fBfstab\fR file.
.PP
The list of all valid options is described in its
entirety in the \fBnfs(5)\fR manual page that comes with Rick Sladkey's NFS
server distribution.
The following is an incomplete list of those you would probably want to use:
.PP
.IP \fBrsize=\fBn\fR\fR\ and\ \ \fBwsize=\fBn\fR\fR\ 
These specify the datagram size used by the NFS clients on
read and write requests, respectively. They currently default
to 1024 bytes, due to the limit on UDP datagram size described
above.
.IP \fBtimeo=\fBn\fR\fR\ 
This sets the time (in thenths of a second) the NFS client will
wait for a request to complete. The default values is 0.7 seconds.
If no confirmation is received within this time, the
client will retry the operation with the timeout interval doubled.
After reaching a maximum timeout of 60
seconds, a \fImajor\fR timeout occurs. By default, a major
timeout will cause the client to print a message to the
console and start all over again, this
time with an initial timeout interval twice that of the
previous cascade. Potentially, this may go on forever. Volumes
that show this kind of behaviour are called \fIhard-mounted\fR.
.IP \fBhard\fR\ 
Explicitly mark this volume as hard-mounted. This is on
by default.
.IP \fBsoft\fR\ 
Soft-mount the driver (as opposed to hard-mount). This causes
the client to return an I/O error to the calling process
whenever a major timeout occurs.
.IP \fBintr\fR\ 
Allow signals to interrupt an NFS call. Useful for aborting
when the server doesn't respond.
.PP
Whether you hard- or soft-mount a volume is not simply a question of
taste, but also has to do what sort of information you want to access
from this volume. For example, if you mount your X11 programs by NFS,
you sure would not want you X session to go berserk just because someone
brought the network to a grinding halt by firing up seven copies of
\&\fBxv\fR at the same time, or by pulling out the Ethernet plug for a moment.
By hard-mounting these, you make sure that you computer will wait until
it is able to re-establish contact with you NFS-server.
On the other hand, any data that is not that critical may as well be
soft-mounted, so it doesn't hang you session in case the remote machine
should be temporarily unreachable, or down. In case your network connection
to the server is flakey, you may either increase the initial timeout
using the \fBtimeo\fR option, or hard-mount the volumes, but allow 
for signals interrupting the NFS call so that you may still abort
any hanging file access.
.PP
.NH 2
The\ \fB/etc/exports\fR\ File
.br
.PP
.PP
By default, \fBmountd\fR will not allow anyone to mount direcories
from the local host.
The directories that may be mounted by remote hosts must be defined in
a file called \fB/etc/exports\fR (because \fBmountd\fR views this
as ``exporting'' them to the client). Entries take the following
form:
.PP
.QP
.nh
\&\fBdirectory\fR \fBhost\fR[(\fBflag\fR,\&...)] \fBhost\fR
[(\fBflag,\&...\fR)] \&...
.PP
Each line defines a directory, and the hosts allowed to mount it.
A host name is usually a fully qualified domain name, but may
additionally contain the `\fB*\fR' wildcard. For example, \fBlab*.foo.com\fR
will apply to \fBlab01.foo.com\fR as well as \fBlab02.foo.com\fR.
An optional list specifies the flags pertaining to it. 
Blank lines are ignored, and a \fB#\fR introduces a comment to the end of
the line.
.PP
The NFS daemon honors a number of flags:
.IP \fBinsecure\fR\ 
Permit non-authenticated access from this machine.
.IP \fBunix-rpc\fR\ 
Require UNIX-domain RPC authentication from this
machine.  This simply requires that requests
originate from a reserved internet port (i.e. the port number
has to be less than 1024).
This option is on by default.
.IP \fBroot_squash\fR\ 
This is a security feature that denies 
the super user on the specified hosts any special
access rights by mapping requests from uid 0 on
the client to uid 65534 (-2) on the server.
This uid should be associated with the user \fBnobody\fR.
.IP \fBno_root_squash\fR\ 
Don't map requests from uid 0.
This option is on by default.
.IP \fBro\fR\ 
Mount file hierarchy read-only.
This option is on by default.
.IP \fBrw\fR\ 
Mount file hierarchy read-write.
.IP \fBlink_relative\fR\ 
Convert absolute symbolic links (where the link
contents start with a slash) into relative links
by prepending the necessary number of \fB../\fR's to get
from the directory containing the link to the root
on the server.  This has subtle, perhaps
questionable, semantics when the file hierarchy is
not mounted at its root.
.IP
This option is on by default.
.IP \fBlink_absolute\fR\ 
Leave all symbolic link as they are (the normal
behavior for Sun-supplied NFS servers).
.IP \fBmap_identity\fR\ and\ \fBmap_daemon\fR\ 
The ownership information of files a NFS daemon provides to its
clients usually only contains numerical user and group id's.
If these numerical id's have the same user and group names
associated, client and server are said to share the same
uid/gid space. The \fBmap_identity\fR option tells the server
to assume this is the case. This option is on by default.
.IP
The \fBmap_daemon\fR option tells the NFS software to assume these
are not identical. This may be the case if users on the two hosts
have been assigned the same user names, but numerical ids do not
match. The NET-2 release includes a \fBugidd(8)\fR daemon
which performs mapping between the two uid/gid spaces. The 
\&\fBmap_daemon\fR option tells \fBnfsd\fR to use this.
.PP
An error parsing the \fBexports\fR file is reported to syslogd's
\&\fBDAEMON\fR facility at level \fBNOTICE\fR whenever \fBnfsd\fR or
\&\fBmountd\fR is started up.
.PP
Note that host names are obtained from the client's IP address by reverse
mapping, so you have to have the resolver configured properly.
If you use BIND and are very security-conscious, you should use
enable spoof checking in your \fB/etc/host.conf\fR file (see
section See section resolv.conf.).
.PP
.NH 2
The\ NFS\ daemon
.br
.PP
.PP
Requests from client hosts to files in a directory mounted
via NFS are served by the NFS daemon, \fBnfsd\fR, via RPC.
You will not want to run \fBnfsd\fR on your host unless you export
directories to other hosts via NFS.
.PP
The server is generally not started by \fBinetd\fR, but at
system boot time. It is a single-threaded server, in that it
does not create an arbitrary number of instances of itself,
one per request.
Instead, a single process is started at sytem boot time, which listens
on the NFS port (usually port 2049) for UDP packets.
Packets which cannot be served immediately because the server is busy
will be queued by the kernel.
Note that it is important to start \fBnfsd\fR after \fBportmap\fR
is running, because it has to register its RPC services. To start
and NFS server on you machine, include the following in your 
network boot script (\fB/etc/rc.d/rc.inet2\fR):
.QP
.nh
/usr/etc/rpc.nfsd
.PP
.bp
.NH
Setting\ up\ the\ Serial\ Hardware
.br
.PP
.PP
There are rumors that there are some people out there in netland who
only own one PC and don't have the money to spend on an Internet link.
To get their daily dose of news and mail nevertheless, they are said to
rely on bulletin board systems (BBS's) and UUCP networks that utilize
pblic telephone networks.
.PP
This chapter is intended to help all those people who rely on
modems to maintain their link.
.PP
.PP
.NH 2
Communication\ Software\ for\ Modem\ Links
.br
.PP
.PP
There are a number of communction packages available for Linux. Many
of them are \fIterminal programs\fR which allow a user to dial into
another comupter as if she was sitting in from of a simple terminal.
The traditional terminal program for Un*ces is \fBkermit\fR. It is,
however, slightly spartanic. There are more comfortable programs
available that support a dictionary of telephone numers, script languages
for calling and logging into remote computer systems, etc. One of them
is \fBminicom\fR, which is close to some terminal programs former
DOS users might be accustomed to. There is also an X-based communications
package called \fBseyon\fR.
.PP
For people that run a bulletin board system, there is also a BBS package
available for Linux. It is called XXX.
.PP
Apart from terminal programs, there is also software that uses
a serial link non-interactively to transport data to or from your
computer. The advantage of this technique is that it takes much less
time to download a few dozen kilobyte automatically, than it might take
you to read your mail on-line in some mailbox, or browse 
a bulletin board for interesting articles. On the other hand, this
requires more disk storage because of the loads of useless information
you usually get.
.PP
The prototype of this sort of communications software is UUCP. It is
a program suite that allows to copy file from one host to another,
execute programs on a remote host, etc. It is frequently used
to transport mail or news in private networks. A port of Ian Taylor's
UUCP packages to Linux is described in the following chapter.
Other non-interactive communication software is, for example,
used throughout Fidonet, although I haven't heard of a Linux port
yet.
.PP
.NH 2
Introduction\ to\ Serial\ Devices
.br
.PP
.PP
The devices a Un*x kernel provides for accessing serial
devices are typically called \fIttys\fR. This is an abbreviation for
\&\fITeletype\fR(tm)e
.FS 
Teletype used to be one of the major manufacturers of terminals in
the early days of Unix. I don't know if it still is.
.FE
, and is nowadays used for any character-based data terminal.
Throughout this chapter, we will use the term exclusively to refer
to the kernel devices.
.PP
Linux distinguishes three classes of ttys: (virtual) consoles,
pseudo-terminals (similar to a two-way pipe, used by application such as
X11), and serial devices.
The latter are also counted as ttys, because they permit interactive
sessions over a serial connection; be it from a hard-wired terminal or
a remote computer over a telephone line.
.PP
Ttys have a number of configurable parameters which can be set using
the \fBioctl(2)\fR system call. Many of them only apply to serial
devices, since they need a great deal more flexibility to
handle varying types of connections.
.PP
Among the most prominent line parameters are the line speed, and parity.
But there are also flags for the conversion between upper and lower case
characters, of carriage return into line feed, etc. The tty driver may also
support various \fIline disciplines\fR which make the device driver behave
completely different. For example, the SLIP driver for Linux is
implemented by means of a special line discipline.
.PP
There is a bit ambiguity about how to measure a line's speed. Sometimes
it is given in Baud, and therefore called the \fIBaud rate\fR. You also
frequently hear the term \fBBit rate\fR, which is related to the
line's transfer speed measured in bits per second (or bps for short).
These two terms are however not interchangeable. The Baud rate refers
to a physical characteristic of some serial device, namely the
clock rate at which it drives its port. The bit rate rather denotes
a current state of an existing serial connection between two points,
namely the average number of bits transferred per second. It is
important to know that these two values may deviate from each other.
.PP
For example, look at two computers communicating with each other
over a telephone line using two modems. Then each computer communicates
with its modem at a given Baud rate, as do the modems among themselves.
If the modems now use a compression technique, like V.42bis, the
computers may send more data over the line, i.e. the bit rate
measured between them may increase by a factor of up to three.
This of course requires that the computers' Baud rates are high enough
to handle this.
.PP
.NH 2
Accessing\ Serial\ Devices
.br
.PP
.PP
Like all devices in Un*x system, serial ports are also accessed
through device special files, located in the \fB/dev\fR directory.
Until release 0.99.5 of the Linux kernel, all tty devices used
to have major number \fB4\fR, and were named \fB/dev/ttyS0\fR,
\&\fB/dev/ttyS1\fR, etc.
.FS 
Or \fB/dev/ttys0\fR, etc, for earlier SLS releases.
.FE
 At 0.99.5, Theodore T'so added a second tty device type supporting
modem control.
.FS 
That is, monitoring of modem control lines, as well as \fBioctl(2)\fR
calls for reading and manipulating them.
.FE
 These modem devices have major number \fB5\fR, and are called
\&\fB/dev/cua0\fR, etc.
.PP
You may access a serial device both as a conventional tty, as well as a
modem port, depending on the major number you access it by.
Identical minor numbers for both device classes refer to the same port.
If you have your modem
on one of \fBCOM1\fR through \fBCOM4\fR, its minor number will be
the \fBCOM\fR port number plus \fB63\fR. If your setup is different from
that, for example when using a board supporting multiple serial lines,
please refer to section See section Serial Hardware. below.
.PP
For use with a modem, you have to use a modem device, while the `ordinary'
serial devices are for direct serial connections, for example between
a terminal and a computer, or between two computers. The latter is also
called a \fIdirect\fR connection.
.PP
Assume your modem is on \fBCOM2\fR. Thus its minor number will be
\&\fB65\fR, while its major number will be \fB5\fR for modem
functionality.
There should be a device \fB/dev/cua0\fR which has these
numbers. List the serial ttys in the \fB/dev\fR directory.
Columns 5 and 6 should show major and minor numbers, respectively:
.PP
.QP
.nh
.DS
.ft CW
$ ls -l /dev/cua*
crw-rw-rw-   1 root     root       5,  64 Nov 30 19:31 /dev/cua0
crw-rw-rw-   1 root     root       5,  65 Nov 30 22:08 /dev/cua1
crw-rw-rw-   1 root     root       5,  66 Oct 28 11:56 /dev/cua2
crw-rw-rw-   1 root     root       5,  67 Mar 19  1992 /dev/cua3
 
.DE
.ft R
\&\&
.PP
If there is no such device, you will have to create one: become
super-user and type
.PP
.QP
.nh
.DS
.ft CW
# mknod -m 666 /dev/cua1 c 4 65
# chown root.root /dev/cua1
 
.DE
.ft R
\&\&
.PP
Some people suggest making \fB/dev/modem\fR a symbolic link to your modem
device, so that casual users don't have to remember the somewhat unintuitive
\&\fB/dev/cua1\fR. This works well with most terminal-based communication
programs, like \fBkermit\fR or \fBminicom\fR.
In UUCP configuration files, however, you should always
use the real device name, because Taylor UUCP does not seem to follow
symbolic links.
.PP
.NH 2
Serial\ Hardware
.br
.PP
.PP
Linux currently supports a wide variety of serial boards which use the RS-232
standard.
.FS 
This is the same as CCITT's V.24 standard. Well, nearly\&...
.FE
 RS-232 is currently the most common standard for serial communcications in
the PC world. It uses a number of circuits for transmitting single bits
as well as for synchronization. Additional lines may be used for signaling
the presence of a carrier (used by modems), and handshake.
.PP
Although hardware handshake
is optional, it is very useful. It allows either of the two stations
to signal whether it is ready to receive more data, or if the other station
should pause until the receiver is done processing the incoming data.
The lines used for this are called ``Clear to Send'' (CTS) and ``Ready to
Send'' (RTS), respectively, which accounts for the colloquial name
of hardware handshake, namely ``RTS/CTS''.
.PP
In PCs, the RS-232 interface is usually driven by a UART chip derived from
the National Semiconductor 16540 chip, or newer versions thereof,
the NSC 16550 or NSC 16550A. Some brands (most notably internal modems
equipped with the Rockwell chipset) also use completely different
chips that have been programmed to behave as if they were 16550's.
.PP
The main difference between 16540's and 16550's that the latter have a FIFO
buffer of 16 Bytes, while the other only have a 1-Byte buffer.
.FS 
You wouldn't say FIFO here\&...
.FE
 This makes them suitable for speeds up to 9600 Baud, while higher
speeds require a 16550-compatible chip.
Besides these chips, Linux also supports the 8250 chip.
.FS 
\&\fBWhat sort of a beast is this? Anybody please enlighten me.
\&\fR
.FE
.PP
In the defalt configuration, the kernel looks for four standard serial
boards on \fBCOM1\fR through \fBCOM4\fR. These will be assigned
minor numbers \fB64\fR through \fB67\fR, as described above.
.PP
If you want to configure your serial ports properly, you should install
Ted Tso's \fBsetserial\fR command along with the \fBrc.serial\fR
script.
.FS 
You best install this script in \fB/etc/rc.d\fR. Make sure to add
a line to \fB/etc/rc\fR that invokes this script.
.FE
e
.FS 
To my knowledge, the \fBsetserial\fR package is not yet part of the
SLS release. You may have to obtain it separately from \fBtsx-11.mit.edu\fR
below \fB/pub/linux/ALPHA/serial\fR.
.FE
 This script should be invoked from \fB/etc/rc\fR at system boot time.
It uses \fBsetserial\fR to configure the kernel serial devices.
A typical \fBrc.serial\fR script looks like this:
.PP
.QP
.nh
.DS
.ft CW
# /etc/rc.d/rc.serial - serial line configuration script.
#
# Do wild interrupt detection
/etc/setserial -W /dev/cua*
\&\&
# Configure serial devices
/etc/setserial /dev/cua0 auto_irq skip_test autoconfig
/etc/setserial /dev/cua1 auto_irq skip_test autoconfig
/etc/setserial /dev/cua2 auto_irq skip_test autoconfig
/etc/setserial /dev/cua3 auto_irq skip_test autoconfig
\&\&
# Display serial device configuration
/etc/setserial -bg /dev/cua*
 
.DE
.ft R
\&\&
.PP
If your serial card is not detected, or the \fBsetserial -bg\fR command
shows an incorrect setting, you will have to force the configuration
by explicitly supplying the correct values. Users with internal modems equipped
with the Rockwell chipset are reported to experience this problem. If,
for example, a the UART chip is reported to be a NSC 16450, while in fact
it is NSC 16550-compatible, you have to change the configuration command
for the offending port to
.PP
.QP
.nh
.DS
.ft CW
/etc/setserial /dev/cua1 auto_irq skip_test auto_config uart 16550
 
.DE
.ft R
\&\&
.PP
Similar options exist to force IRQ, \fBCOM\fR port, and base address
setting. Please refer to the \fBsetserial(8)\fR manual page.
.PP
If your modem supports hardware handshake, you should make sure to enable
it. Surprisingly as it is, communication progams do not attempt to enable
this by default; you have to set this manually instead. This is best
performed in the \fBrc.serial\fR script, using the \fBstty\fR command.
.PP
.QP
.nh
.DS
.ft CW
stty crtscts < /dev/cua1
 
.DE
.ft R
\&\&
.PP
.NH 2
Multiport\ Boards
.br
.PP
.PP
Beside the usual four serial ports, Linux supports
a number of multiport cards. These may be configured into the kernel
by editing \fBkernel/chr_drv/serial.c\fR in your kernel source directory
(look into this file for which flags you might have to define),
and recompiling the kernel. Note that this only means the kernel will
attempt to locate them automatically at boot time. You may, however,
force auto configuration after booting by using the \fBsetserial\fR command.
For example, if you have an AST Fourport on address \fB0x1A0\fR, you may
do this by executing
.PP
.QP
.nh
.DS
.ft CW
# setserial /dev/cua4 auto_irq autoconfig
# setserial /dev/cua5 auto_irq autoconfig
# setserial /dev/cua6 auto_irq autoconfig
# setserial /dev/cua7 auto_irq autoconfig
 
.DE
.ft R
\&\&
.PP
Alternatively, you may force the setting of ports and IRQ by using the
following commands:
.PP
.QP
.nh
.DS
.ft CW
# setserial /dev/cua4 uart 16450 port 0x1A0 irq 9 fourport
# setserial /dev/cua5 uart 16450 port 0x1A8 irq 9 fourport
# setserial /dev/cua6 uart 16450 port 0x1B0 irq 9 fourport
# setserial /dev/cua7 uart 16450 port 0x1B8 irq 9 fourport
 
.DE
.ft R
\&\&
.PP
A list of multiport boards and their default locations can
always be found in the file \fBserial.c\fR and the documentation
for the \fBsetserial\fR package. Currently, the following
boards are supported, listed together with the minor numbers they may
be found on:
.PP
.IP \fB64\fR\ 
 \fBCOM1\fR (port \fB0x3F8\fR)
.IP \fB65\fR\ 
 \fBCOM2\fR (port \fB0x2F8\fR)
.IP \fB66\fR\ 
 \fBCOM3\fR (port \fB0x3E8\fR)
.IP \fB67\fR\ 
 \fBCOM4\fR (port \fB0x2E8\fR)
.IP \fB68-71\fR\ 
 An AST Fourport on port \fB0x1A0\fR
.IP \fB72-75\fR\ 
 Another AST Fourport on port \fB0x2A0\fR
.IP \fB76-77\fR\ 
 The third an fourth port of an Accent Async card
on port \fB0x330\fR.
.IP \fB78-79\fR\ 
 Two spare ports.
.IP \fB80-95\fR\ 
 16 ports starting at \fB0x100\fR, for any
of the following boards: Usenet Serial Board II,
Boca 1004, Boca 1008, Boca 2016, or Bell Technologies
HUB16. You may also use a combination of up to
four Boca 1004, or two Boca 1008's.
.PP
Note that the port number given is the default port for that board.
This may be changed using the \fBsetserial\fR command.
.PP
.NH 2
Setting\ up\ your\ Modem
.br
.PP
.PP
Okay, there you sit, your modem hooked to your machine. By now
you should have configured your serial boards according to the
previous sections.
.PP
Now you may try to access your modem using \fBkermit\fR (\fB<Ctrl-\e>\fR
means that you hold down the `Ctrl' key and press `\e').
Your input is marked like \fB\fBthis\fR\fR:
.PP
.QP
.nh
.LP
$ \fB\fBkermit\fR\fR				
.br
\&\&
C-Kermit 5A(188), 23 Nov 92, POSIX		
.br
\&\&
Type ? or HELP for help				
.br
\&\&
C-Kermit>\fB\fBset line /dev/cua1\fR\fR		
.br
\&\&
C-Kermit>\fB\fBset speed 9600\fR\fR		
.br
\&\&
/dev/cua1, 9600 bps				
.br
\&\&
C-Kermit>\fB\fBconnect\fR\fR			
.br
\&\&
Connecting to /dev/cua1, speed 9600.		
.br
\&\&
The escape character is Ctrl-\e(ASCII 28, FS)	
.br
\&\&
Type the escape character followed by C to get back,	
.br
\&\&
or followed by ? to see other options.		
.br
\&\&
\&\fB\fBATZ\fR\fR					
.br
\&\&
OK						
.br
\&\&
\&\fI\&...more chatting with the modem\&...\fR	
.br
\&\&
\&\fB\fB<Ctrl-\e>C\fR\fR				
.br
\&\&
.br
(Back at local UNIX system)			
.br
\&\&
C-Kermit>\fB\fBquit\fR\fR				
.br
\&\&
$
.PP
Next, you may have to configure it specifically. There are a number of
options you can set with your modem,
.FS 
Usually, there are some 40 switches or more that may be set, allowing
three different settings on the average. This makes up for roughly
1.8 billion ways to set up your modem. The manual has 70 pages.
.FE
 like whether it may answer the phone
(you really should turn this off when you use the modem on the same line
as your telephone \fB:-)\fR), what dialling mode to use (touch-tone
or pulse), or V.42bis error correction. These options are usually set
by talking to the modem using special command sequences that are
are listed in your modem's manual. I usually configure my modem using
\&\fBkermit\fR, and write the configured values to the modem's non-volatile
memory from where they are picked up when resetting it. Of course you
can use any other terminal program, like \fBminicom\fR, for example.
.PP
.NH 2
Setting\ up\ your\ System\ for\ Dialing\ in
.br
.PP
.PP
When setting up a serial line for use as a dialin port, you have
to enable \fBgetty\fR on that line. Its name stands for \fIget tty\fR.
.PP
There's a \fBgetty\fR program available for Linux from
the \fBgetty_ps\fR suite.
.FS 
Originally written by Paul Sutcliffe, and currently maintained by
Kris Gleason (\fBgleasokr@rtt.colorado.edu\fR). As of this writing,
\&\fBgetty_ps\fR is at version 2.07b.
.FE
 Some older SLS releases used to have another \fBgetty\fR program
that uses a somewhat different command line syntax, and does not
use configuration files as described below. If you are not sure
which one you have, look for \fBuugetty\fR in your \fB/etc\fR directory.
If there is no such command, you are using the older version.
\&\fBgetty_ps\fR may be obtained it from \fBtsx-11.mit.edu\fR as either
binary or source.
.PP
There are quite a number of parameters for tuning \fBgetty\fR. I will
not describe them in detail here, but merely give sample configuration 
files.
.PP
Assume your modem is on \fB/dev/cua1\fR. You will then have to create
a file named \fBgetty.ttyS1\fR in the \fB/etc/default\fR directory.
For a Hayes compatible modem, it might look as follows:
.PP
.QP
.nh
.DS
.ft CW
# Sample getty configuration file for a Hayes compatible modem to allow
# incoming modem connections.
\&\&
# Line to use to do initialization.
INITLINE=cua1
\&\&
# Timeout to disconnect if idle...
TIMEOUT=60
\&\&
# modem initialization string... Sets the modem to disable auto-answer
# format: <expect> <send> ... (chat sequence)
INIT="" \ed+++\edAT\er OK\er\en ATH0\er OK\er\en AT\esM0\esE1\esQ0\esV1\esX4\esS0=0\er OK\er\en
\&\&
# Waitfor string. If this sequence of characters is received over the line,
# a call is detected.
WAITFOR=RING
\&\&
# This line is the connect chat sequence.  This chat sequence is performed
# after the WAITFOR string is found.  The \eA character automatically sets
# the baudrate to the characters that are found, so if you get the message
# CONNECT 2400, the baud rate is set to 2400 baud.
#
# format: <expect> <send> ... (chat sequence)
CONNECT="" ATA\er CONNECT\es\eA
\&\&
# this line sets the time to delay before sending the login banner
DELAY=1
\&\&
# Send short message instead of the whole /etc/issue file.
ISSUE=\et\etWelcome to @S!\enLogin as guest and retrieve README.\en
 
.DE
.ft R
\&\&
.PP
Basically, this makes \fBgetty\fR initialize the modem, especially
turning off auto-answer mode by setting \fBS0\fR to zero. It then waits
for the phone to ring, to which Hayes compatible modems usually react
by sending \fBRING\fR to the computer. \fBgetty\fR will then pick
up the phone and wait for the \fBCONNECT\fR string generated by
the modem when the connection has been established. It is worth
noting that with this setup, \fIautobauding\fR will be performed:
the \fBCONNECT\fR message always includes the speed at which the
connection has been established, and this value is used to set the line
speed. However, this is a bit problematic with modems that perform
compression, since the \fBCONNECT\fR message usually contains the
\&\fIBaud\fR rate, while the effective line speed may be much higher.
An alternative setup will be discussed below.
.PP
For direct serial lines, the setup is much simpler:
.PP
.QP
.nh
.DS
.ft CW
# Sample getty configuration file for a direct line.
# Timeout to disconnect if idle...
TIMEOUT=60
\&\&
# Waitchar: do not claim the line until a character has arrived.
WAITCHAR=yes
\&\&
# this line sets the time to delay before sending the login banner
DELAY=1
\&\&
# Send short message instead of the whole /etc/issue file.
ISSUE=\et\etWelcome to @S!\enLogin as guest and retrieve README.\en
 
.DE
.ft R
\&\&
.PP
The line speed used in initializing the serial line will be used as
an index into the \fB/etc/gettydefs\fR file. This file is used by \fBgetty\fR
and \fBgetty\fR to set line parameters and the like when displaying
the login prompt.
.FS 
For more information, please refer to the \fBgettydefs(5)\fR manual page.
.FE
 You should
make sure that if you expect your modem to operate at, say 19200bps,
there has to be an entry like this:
.PP
.QP
.nh
.DS
.ft CW
# Modem line locked at 19200 Baud
19200# B19200 CS8 CRTSCTS # B19200 SANE -ISTRIP CRTSCTS#@S login: #B19200
 
.DE
.ft R
\&\&
.PP
Finally, to enable \fBgetty\fR on the serial line, add the following
entry to your \fB/etc/sysvinittab\fR file:
.FS 
Assuming that you are using Miquel van Smoorenburg's System V-compatible
\&\fBinit\fR. Other \fBinit\fR programs may use a different format.
.FE
.PP
.QP
.nh
.DS
.ft CW
# inittab entry for dialup line
s1:12:respawn:/etc/getty ttyS1 19200 vt100
 
.DE
.ft R
\&\&
.PP
A final word on autobauding (someone please correct me if I'm wrong):
If you are using a modem which performs compression, like MNP-5 or
V.42bis, you should disable autobauding, else the slow modem-computer
link would throttle the connection to the same speed achieved without
any compression. A better way is to lock the modem at the maximum speed
that it may achieve (e.g. 9600bps for a V.42bis modem), and let the
the modem slow down the serial driver using hardware handshake. Of course,
this requires to enable hardware handshake with your modem.
.PP
.bp
.NH
Managing\ Taylor\ UUCP
.br
.PP
.PP
.PP
.PP
.PP
.NH 2
Preliminary\ Remarks
.br
.PP
.PP
UUCP was designed in the late seventies by Mike Lesk at AT&T Bell
Laboratories to provide a simple dial-up network over public telephone lines. 
Since serial connections through modems are still the main electronic
transport medium for private sites, UUCP has become a standard for
networking software. Although there are many implementations running on a
wide variety of hardware platforms and operating systems, they are compatible
to a high degree.
.PP
The implementation of UUCP currently distributed with Linux is Taylor
UUCP Version 1.03.
.FS 
Written and copyrighted by Ian Taylor, 1992.
.FE
 It is included in SLS as well as Ed Carp's \fBmailpak\fR, which can be
obtained separately from most Linux FTP sites.
.PP
The purpose of this chapter is not to give you an exhaustive description of
what the command line options for the UUCP commands are and what they do,
but to give you an introduction on how to set up a working UUCP node.
The first section gives a hopefully gentle introduction into how UUCP implements
remote execution and file transfers. If you are not entirely new to UUCP,
you might want to skip this and move on to section See section UUCP Configuration files.,
on page ??uucp.config.files, which explains
the various files used to set up UUCP.
.PP
During the following chapter we will however assume that you are familiar
with the user programs of the UUCP suite. These are
\&\fBuucp\fR and \fBuux\fR. For a description,
please refer to the on-line manual pages.
.PP
For those who don't find everything they need in this chapter, there is a
very good book, ``Managing UUCP and Usenet'', written by Tim O'Reilly and
Grace Todino.
.FS 
O'Reilly & Associates, Inc., \fI10th ed,\fR 1992. Email nuts@ora.com
for more information, or to order.
.FE
 I find it very useful.
.PP
The latest package of UUCP binaries compiled by Vince Skahan (also included
in SLS) understands the new-style --- a.k.a. ``Taylor'' ---
configuration files as well as BNU configuration files. If you want to use
them, you should read the documentation that comes along with the package.
This is a set of texinfo files that may be converted to GNU info files.
However, they are quite readable without any further processing, too.
Depending on popular demand, I may one day add a description of Taylor
configuration options to this chapter.
.PP
.NH 2
Introduction
.br
.PP
.PP
.PP
.NH 3
History
.br
.PP
As with most software that has somehow become ``standard'' over
the years, there is no UUCP which one would call \fIthe\fR UUCP.
It has undergone a steady process of evolution since the first
version which was implemented in 1976. Currently, there are two
major species which differ mainly in their support of hardware
and their configuration.
Of these, various implementations exist, each varying slightly
from its siblings.
.PP
One species is the so-called ``Version 2 UUCP'', which dates back to
a 1977 implementation by Mike Lesk, David A. Novitz, and Greg Chesson.
Although it is fairly old, it is still in frequent use. Recent
implementations of Version 2 provide much of the comfort of the newer
UUCP species.
.PP
The second species was developed in 1983, and is commonly referred
to as either BNU (Basic Networking Utilities), HoneyDanBer UUCP
(being a combination of the authors' names
.FS 
P. Honeyman, D. A. Novitz, and B. E. Redman.
.FE
), or HDB for short.
It was conceived to eliminate some of Version 2
UUCP's deficiencies, for example new transfer protocols were added, and
the spool directory was split so that now there is one directory for each site
you have UUCP traffic with.
.PP
Taylor UUCP Version 1.03 was released in March 1992. As distributed with
Linux, it is configured to be BNU compatible. Therefore, this document
describes the setup of a UUCP node running BNU. Most of what
is said throughout the document applies to BNU in general; features
specific to Taylor UUCP will be marked accordingly.
.PP
Taylor UUCP 1.03 supports serial connections (either direct or via
modem) and TCP/IP connections, and has drivers for protocols
\&\fBg\fR, \fBe\fR, \fBf\fR, and \fBt\fR, which will be discussed later in
this chapter.
.PP
.NH 3
Commands\ of\ the\ UUCP\ Suite
.br
.PP
Besides the publicly accessible programs, \fBuux\fR and \fBuucp\fR,
the UUCP suite contains
a number of commands used for administrative purposes only. They
are used to monitor UUCP traffic across your node, remove old
log files, or compile statistics. None of these will be described.
Also, Taylor UUCP 1.03 as distributed with Linux  doesn't have many
of these, and they're fairly easy to understand. However, there is
a third category, which comprises the actual UUCP ``work horses''.
They are called \fBuucico\fR (where \fBcico\fR stands for copy-in
copy-out), and \fBuuxqt\fR, which executes jobs sent from remote
systems. Their command line options are described below.
.PP
.NH 3
Command\ Line\ Options
.br
.PP
Below the command line options are listed as supported by \fBuucico\fR.
Many may not be perfectly clear to you before reading the next section
about how everything works.
.PP
.IP \fB-s\ \fBsystem\fR\fR\ 
Call the named \fB\fBsystem\fR\fR.
.IP \fB-f\fR\ 
Causes \fBuucico\fR to override access and retry time
restrictions.
.IP \fB-c\fR\ 
Don't log an error message when a call is not permitted
at the current time.
.IP \fB-S\ \fBsystem\fR\fR\ 
Same as \fB-fs \fBsystem\fR\fR.
.IP \fB-r1\fR\ 
Start \fBuucico\fR in master mode. This is the default when
\&\fB-s\fR or \fB-S\fR is given. All by itself, the \fB-r1\fR option
causes \fBuucico\fR to try to call all systems in \fBSystems\fR,
unless prohibited by call or retry time restrictions.
.IP \fB-q\fR\ 
After calling out, do not start \fBuuxqt\fR.
.IP \fB-w\fR\ 
After calling out, enter an endless loop accepting calls.
See \fB-e\fR.
.IP \fB-p\ \fBport\fR\fR\ 
Specifies a port to call out or listen to. In slave mode,
this implies use of \fB-e\fR.
.IP \fB-r0\fR\ 
Start \fBuucico\fR in slave mode. This is the default when
no \fB-s\fR or \fB-S\fR is given.
In slave mode, either standard input/output are assumed
to be connected to a serial port, or the TCP port specified by
\&\fB-p\fR is used.
.IP \fB-l\fR\ 
Perform own authorization. \fBuucico\fR displays a login and
password prompt to either standard output or the port specified
by \fB-p\fR. Login ids and passwords are not checked against
the usual \fB/etc/passwd\fR but \fB/usr/local/lib/uucp/passwd\fR.
.IP \fB-e\fR\ 
Given this option, \fBuucico\fR enters an infinite loop waiting for
connections, either on standard input, or a TCP port
specified by the \fB-p\fR option. With this option, \fBuucico\fR
executes its own authorization procedures.
.IP \fB-I\ \fBfile\fR\fR\ 
Use \fB\fBfile\fR\fR as configuration file. This option is only
available when it is compiled to use Taylor configuration files.
.IP \fB-u\ \fBlogin\fR\fR\ 
A no-op included for compatibility with some versions of \fBuucpd\fR.
.IP \fB-D\fR\ 
Do not detach from the controlling terminal. Normally, \fBuucico\fR
detaches from the terminal and runs in the background.
.IP \fB-x\ \fBtype,\ \fB-X\ \fBtype\fR\fR\fR\fR\ 
Turn on debugging of the specified type. Several types may be
given as a comma-separated list. The following types are valid:
abnormal, chat, handshake, uucp-proto, proto, port, config, spooldir,
execute, incoming, outgoing. Using \fBall\fR turns on all options.
.IP
For compatibility with other UUCP implementations, a number may
be specified instead, which turns on debugging for the first
\&\fB\fBn\fR\fR items in the above list.
.IP
Debugging messages will be logged to
\&\fB.Admin/audit.local\fR below \fB/usr/spool/uucp\fR.
.PP
.LP
The following options are recognized by \fBuuxqt\fR.
.IP \fB-s\ \fBsystem\fR\fR\ 
Only execute requests originating from \fB\fBsystem\fR\fR.
.IP \fB-c\ \fBcommand\fR\fR\ 
Only execute requests for the given command.
.IP \fB-x\ \fBtype\fR\fR\ 
Same as for \fBuucico\fR.
.IP \fB-I\ \fBfile\fR\fR\ 
Same as for \fBuucico\fR.
.PP
.NH 3
Layout\ of\ UUCP\ Transfers\ and\ Remote\ Execution
.br
.PP
.PP
Vital to the understanding of UUCP is the concept of \fIjobs\fR.
Every transfer a user initiates with \fBuucp\fR or \fBuux\fR is
called a job. It is made up of a \fIcommand\fR to be executed on
a remote system, and a collection of \fIfiles\fR to be transferred
between sites. One of both parts may be missing.
.PP
Since UUCP does not generally call the remote system immediately
to execute a job (else you could make do with kermit), it temporarily
stores the job description away. This is called \fIspooling\fR.
The directory tree under which jobs are stored is therefore
called the \fIspool directory\fR. It is generally located in
\&\fB/usr/spool/uucp\fR. In addition to the job description,
UUCP might have to store input files.
.PP
Likewise, incoming jobs will not be executed immediately, but only
after the connection terminates.
.PP
The exact location and naming of spool files may vary, depending
on some compile-time options. HDB-compatible UUCP's generally store
spool files in a directory named \fB/usr/spool/uucp/\fBsite\fR\fR,
where \fB\fBsite\fR\fR is the name of the remote site.
.PP
When a connection to the remote machine is established, UUCP
transfers the files describing the job, plus any input files.
On the remote machine, UUCP forwards or executes the job, depending
on whether it is designated for another site or not.
.PP
To differentiate between important and less important jobs, UUCP
associates a \fIgrade\fR with each job. This is a single letter,
ranging from \fB0\fR through \fB9\fR, \fBA\fR though \fBZ\fR, and
\&\fBa\fR through \fBz\fR, in decreasing precedence. Mail is customarily
spooled with grade \fBC\fR, while news are spooled with grade \fBN\fR.
However, this may vary. During connections to a remote site,
jobs with higher grade are transferred earlier. 
Grades are assigned using the \fB-g\fR flag when invoking \fBuucp\fR
or \fBuux\fR.
.PP
It is also possible to disallow transfer of jobs below a given
grade at certain times.
This is also called the \fImaximum spool grade\fR allowed during
a conversation and defaults to \fBz\fR. Note the terminological
ambiguity here --- a file is only transferred if it is \fIequal
or above\fR the maximum spool grade.
.FS 
I can hear you: "He's a mathematician, right?" :-)
.FE
.PP
.NH 3
The\ inner\ workings\ of\ \fBuucico\fR
.br
.PP
.PP
<>
To understand why \fBuucico\fR needs to know certain things, a
quick description of how it actually connects to a remote system
might be in order here.
.PP
When you execute \fBuucico -s \fBsystem\fR\fR
from the command line, it first has to connect physically. The actions
taken depend on the type of connection to open --- e.g. when using
a modem, it has to find a modem, and dial out. Over TCP, it has
to call \fBgethostbyname()\fR to convert the name to a network address,
find out which port to open, and bind the address to the corresponding
socket. 
.PP
After this connection has been established, an authorization procedure
has to be passed. It generally consists of the remote
system asking for a login name, and possibly a password. This
is commonly called the \fIchat\fR. The authorization procedure
is either performed by
the usual \fBgetty\fR/\fBlogin\fR suite, or --- on TCP sockets ---
by \fBuucico\fR itself.
.FS 
Taylor UUCP does it this way. There are many implementations
of the \fBuucpd\fR service.
.FE
 If authorization succeeds, the remote end fires up a
\&\fBuucico\fR. The local copy of \fBuucico\fR which initiated the
connection is referred to as \fImaster\fR, the remote copy as
\&\fIslave\fR.
.PP
Next follows the \fIhandshake phase\fR:
The master now sends its hostname, plus several
flags. The hostname is usually what \fBhostname()\fR returns,
although you can override this (see section See section The Permissions file.).
The slave checks this hostname for permission to log in, send and
receive files, etc.  The flags describe (among other things) the
maximum grade of spool files to transfer. If enabled, a conversation
count, or \fIcall sequence number\fR 
check takes place here. With this feature, both sites maintain
a count of successful connections, which are compared. If they do
not match, the handshake fails. See
section See section Call sequence checks. on enabling this.
.PP
Finally, the two \fBuucico\fR's try to agree on a common \fItransfer
protocol\fR. This protocol governs the way files are transferred,
checked for consitency, and retransmitted in case of an error. There is
a need for different protocols because of the differing types of
connections supported. For example, telephone lines require a ``safe''
protocol which is pessimistic about errors, while TCP transmission is
inherently reliable and does not need this.
.PP
After the handshake is complete, the actual transmission phase begins.
Both ends turn on the selected protocol driver. The drivers possibly
perform a protocol-specific initialization sequence.
.PP
First, the master sends all files queued for the remote system whose
spool grade is high enough. When it has finished, it informs the slave
that it it is done, and that the slave may now hang up. The slave now
can either agree to hang up, or take over the conversation.
This is a change of roles: now the remote system becomes master,
and the local one becomes slave. The new master now sends its files.
When done, both \fBuucico\fR's exchange termination messages,
and close the connection.
.PP
We will not go into this in greater detail: please refer to either the
sources or any good book on UUCP for this. There is also a really
antique article floating around the net, written by David
A. Novitz, which gives a detailed description of the UUCP protocol.
.PP
.NH 3
What\ UUCP\ needs\ to\ know
.br
.PP
.PP
After setting up your hardware as explained in chapter See section Serial.,
you have to gather the information UUCP needs to know.
.PP
First, you will have to figure out at what speed your modem and Linux 
will communicate. Note that although your modem may only have a \fIBaud\fR
rate of say 2400 Baud, various compressions done by your modem may result
in effective transfer rate of up to 9600 Baud on the computer-modem link.
In the following, your transfer rate will be referred to as the line's
\&\fIspeed\fR, measured in bits per seconds (bps).
.PP
Of course, if UUCP is to do anything, you will need the phone
number of a system to call.
Also, you will need a valid login id and possibly a password for the
remote machine.
.FS 
If you're just going to try out UUCP, get the number
of an archive site near you. Write down the login and password --- they're
public to make anonymous downloads possible. In most cases, they're
something like \fBuucp/uucp\fR or \fBnuucp/uucp\fR.
.FE
.PP
You will also have to know \fIexactly\fR how to log into the system.
E.g., do you have to press the \fBBREAK\fR key before the login
prompt appears? Does it display \fBlogin:\fR or \fBuser:\fR? This is
necessary for composing the \fIchat script\fR, which is a recipe
telling \fBuucico\fR how to log in. If
you don't know, or if the usual chat script fails, try to call the
system with a terminal program like \fBkermit\fR, and write down
exactly what you have to do. Of course you can use any other
terminal program, like \fBminicom\fR, for example, which many
former DOS users might find more comfortable.
.PP
.NH 3
Site\ naming
.br
.PP
.PP
In order to identify a machine in a network --- be it local, in a
given domain, or even world-wide --- it has to have a name
Due
.FS 
Due to limitations in some implementations of UUCP, the length of
your your host name should not exceed 7 characters. The
fully qualified domain name, of course, may be longer. Thus,
\&\fBminas-tirith\fR is too long, but \fBminas.tirith.me\fR is
OK.
.FE
. As long as you simply want to use UUCP for file transfers to
or from sites you dial up directly, or on a local network, this name
does not have to meet any standards. However, if you want to 
be able to send and receive mail or news, you will have to
participate in a domain. Within this domain, you will have to
coordinate your sitename with the domain administrator.
For a discussion of domain and site naming, see chapter See section Electronic Mail..
.PP
Note that \fIname\fR here refers to your site's \fIUUCP name\fR as opposed
to your domain address. Suppose your mail address is
\&\fBfinn@swim.two.birds\fR, then your site's domain address will be
\&\fBswim.two.birds\fR, while your UUCP host name is only \fBswim\fR.
Think of UUCP sites as knowing each other on a first-name basis.
.PP
Your first task as UUCP administrator is to set your site's
name. You do this by logging in as \fBroot\fR and executing
.PP
.QP
.nh
# hostname \fBsitename
\&\fR
.PP
.PP
A convenient (and customary) way to do this is from the
\&\fB/etc/rc.local\fR script.
.PP
.NH 2
UUCP\ Configuration\ files
.br
.PP
.PP
.PP
All by itself, UUCP won't know anything about how to call a remote
system. In contrast to a terminal program, UUCP was made to be able
to do all jobs automatically. Once it is set up properly, interference
by the administrator should not be necessary during daily routine.
.PP
In order to make the necessary information easily configurable,
it is kept in a couple of \fIconfiguration files\fR. They
all reside in the directory \fB/usr/local/lib/uucp\fR. Most
of these files are only used when dialling out.
.PP
.PP
The Taylor UUCP package shipped with Linux, configured to be BNU
compatible, gets its information from the following files:
.PP
.IP \fBSystems\fR\ 
 This file describes all sites known to you.
For each site, it specifies its name, at what times to call it,
which number to dial (if any), what type of device to use, and
how to log on.
.IP \fBDevices\fR\ 
 Contains entries describing each device available,
together with baud rate and initialization strings.
.IP \fBDialcodes\fR\ 
 Contains expansions for symbolic dialcodes.
.IP \fBDialers\fR\ 
 Describes dialers used to establish a telephone
connection.
.IP \fBPermissions\fR\ 
 This file controls permissions for file access
and command execution on a per-system basis.
.IP \fBPoll\fR\ 
 On systems that run \fBuupoll\fR or 
the \fBuudemon.poll\fR script from
\&\fBcron\fR, this file controls when systems should be polled.
However, this script is currently not part of Linux  UUCP.
.IP \fBMaxuuxqts\fR\ 
 This file contains a decimal number, specifying
how many copies of \fBuuxqt\fR may run at the same time.
.PP
UUCP configuration files are generally made up of one entry per line.
An entry always has to begin in column 1 of the line.
It may be continued across newlines with a backslash (`\fB\e\fR'); the
continuation need not begin in column 1.
Fields within an entry are separated by white space (either spaces or tabs).
A hash sign (`#') starts a comment, which extends to the next line feed.
Lines that begin with white space and that are not continuation lines
are ignored, too.
.PP
.NH 3
How\ to\ tell\ UUCP\ about\ other\ Systems\ ---\ the\ \fBSystems\fR\ File
.br
.PP
.PP
The \fBSystems\fR file describes the systems your machine knows
about, one per line. It consists of the following fields:
.PP
.IP \fB\fBsysname\fR\fR\ 
This is the UUCP name of the remote system this entry
describes.
.IP \fB\fBschedule\fR\fR\ 
This field lays out a timetable when the remote system
may be called, how long to wait before retrying after a
failure, and which jobs may be transferred.
.IP \fB\fBdevice\ type\fR\fR\ 
This describes the type of device to be used for
placing the call. This is a keyword naming an entry in the \fBDevices\fR
file. It may be followed directly by a protocol selection, separated
from it with a comma.
.IP \fB\fBspeed\fR\fR\ 
The speed at which to connect to the remote system. This is
the serial line speed as described above
in See section UUCP configuration parameters.. It
is measured in bits per second (bps for short).
.IP \fB\fBphone\fR\fR\ 
Specifies the telephone number to use if the system
is called via an automatic dialing unit. Otherwise, a hyphen (`\fB-\fR').
.IP \fB\fBchat\ script\fR\fR\ 
This field contains a sequence of tokens, separated
by white space. They contain text expected from and sent to the remote
machine in order to log in.
.PP
.LP
Below, we will discuss each of these fields in somewhat greater
detail.
.PP
  
.IP \fB\fBSysname\fR\fR\ 
    This must be the name of the remote system. You should not
specify an alias you invented, because \fBuucico\fR will check it against
the remote system's name when it logs on.
.FS 
Older Version 2 UUCP's don't broadcast their name when being called;
however, newer implementations often do, and so does Taylor UUCP.
.FE
A system name may appear more than once. To call this system, the
entries are tried in the order given; if one fails, \fBuucico\fR moves
on to the next.
.IP \fB\fBschedule\fR\fR\ 
    The \fIschedule\fR field contains a string which describes at what 
times it is allowed to call the remote system. This may be either
due to limitations the remote host places on its services during
business hours, or simply a question of telephone cost. 
.IP
The field consists of a string made up of a \fIday\fR and a \fItime\fR
subfield. \fIDay\fR may be any of \fBMo, Tu, We, Th, Fr, Sa, Su\fR combined,
or \fBAny, Never, Wk\fR. \fITime\fR consists of a pair of clock values,
separated by a dash (`\fB-\fR'). They specify the range within calls may be
placed. Any combination of these tokens is written without white space
inbetween. Any number of \fIday/time\fR specifications may be grouped
together with commas. For example, \fBMoWe0300-0730,Fr1805-2000\fR allows
calls on Monday and Wednesdays from 3 a.m. to 7.30, and on Fridays
between 18.05 and 20.00. When a time field spans midnight, say Mo1830-0600,
it actually means Monday, the time between midnight and 6 a.m., and
the time between 6.30 p.m. and midnight.
.IP
The special day fields \fBAny\fR and \fBNever\fR mean what they say:
Calls may be placed at any or no time, respectively. \fBAny\fR may
be modified by a time subfield. \fBWk\fR is a shorthand for \fBMoTuWeThFr\fR.
.IP
Taylor UUCP also has two special schedule tokens, namely \fBNonPeak\fR and
[4] \fBNight\fR.
They are shorthand for \fBAny2300-0800,SaSu0800-1700\fR and
\&\fBAny1800-0700,SaSu\fR, respectively.
.IP
In Taylor UUCP, one can also attach a maximum spool grade to a schedule.
This is done by appending a slash (`/') and the spool grade character
to the schedule field.
This determines the maximum grade of spool files to be transferred during
a connection initiated by your UUCP. For example, you can use the following
schedule field to allow only transfer of mail during peak hours,
while news and UUCP transfers are deferred until the evening:
.QP
.nh
swim Any/C,NonPeak ACU 9600 \&...
.PP
However, a caveat is in order here:
First, the grade flag is not checked when a remote system calls in, so
any jobs queued for the calling system will be sent.
.FS 
This is probably a feature; you normally don't have to pay for
incoming calls.
.FE
It is also possible that the remote site runs some version of UUCP that
ignores your request only to transfer files of certain grade, even
when you call in. So, before relying on this feature, check
if the neighboring site supports this. If it does, check with the
administrator to attach appropriate spool grade specifications to his
schedule.
.IP
You may also give a retry interval to \fBuucico\fR. This determines how long
\&\fBuucico\fR should wait before calling this host again after a failed
connection. The time is given in minutes and is offset by a semicolon.
By default, Taylor UUCP uses a retry time which increases exponentially
with each failure.
.IP \fB\fBdevice\ type\fR\fR\ 
    The \fIdevice type\fR is a name of a device specified in the \fBDevices\fR
file. It may be immediately followed by a comma and a protocol specification.
This is a list of letters, each naming a protocol to be offered the remote
site in the order given. It is expected that the remote site selects
from this list the first protocol known to it. If no protocols are
specified, \fBuucico\fR chooses from a set of protocols suitable
for the device.
.IP
For a discussion of protocols available, see
section See section UUCP line protocols..
.IP \fB\fBspeed\fR\fR\ 
    The \fIspeed\fR field specifies a speed or a range of speeds at which
we want to connect to the remote system. A speed is given as a
decimal number, a range as two numbers separated by a dash.
The entries ``\fB-\fR'' and \fBAny\fR match any speed.
.IP
You can also combine this with a modem class.
This may be any alphabetic string preceding the speed specification.
For example, some modems only support the HST protocol for high-speed
connections, while others only understand V32.bis. Their greatest
common denominator is 9600 bps.
Assume you own both a HST and a V32.bis modem, and poll a machine being
equipped with one HST modem. Then you sure would want \fBuucico\fR
to use the HST modem. Therefore, your \fBSystems\fR entry for this site
should contain \fBHST38400\fR in the speed field, and the HST modem
would have a \fBDevices\fR entry with a speed field of
\&\fBHST19200-38400\fR.
.IP
For TCP connections, the \fIspeed\fR field should contain a dash.
.IP \fB\fBphone\ number\fR\fR\ 
    If the remote system is to be reached over a telephone line, the
\&\fIphone number\fR field contains the number the modem should dial.
It may contain
several tokens interpreted by \fBuucico\fR's dialing procedure.
An equals sign (`\fB=\fR') means to wait for a secondary dial tone, 
and a dash generates a one-second pause. Any embedded alphabetic
string may be used to hide site-dependent information like area
codes. Any such string is translated to a dialcode using the \fBDialcodes\fR
file.
.IP
If the remote system is connected directly, the phone 
number field should contain a dash (`\fB-\fR'). If this
is a TCP connection, this field should contain a hostname
that can be resolved by the name server, or an IP address.
.IP \fB\fBchat\ script\fR\fR\ 
    The \fIchat script\fR occupies the remainder of the line. It is a list
of tokens, specifying strings expected and sent by the local \fBuucico\fR
process. The intention is to make \fBuucico\fR wait until
the remote machine sends a login prompt, then return the login id, wait for
the remote system to send the password prompt, and send the
password. Expect and send strings are given in alternation.
Note that \fBuucico\fR automatically appends a carriage return character
(`\er') to any send string. Thus, a simple chat script would look like
.IP
.QP
.nh
ogin: pablo ssword: catch22
.PP
You may note that the expect fields don't contain the whole prompts. 
This is to make sure that the login succeeds even if the remote system
broadcasts \fBLogin:\fR instead of \fBlogin:\fR.
.IP
However, \fBuucico\fR also allows for the case that the remote machine's
\&\fBgetty\fR needs to be reset before sending a prompt. For this, you can specify
a substring, separated from the expect field by dashes. This is 
a list of send/expect pairs executed only if the main expect fails
(i.e. a timeout occurs). One use of this feature is to send a \fBBREAK\fR
if the remote site doesn't send a login prompt. The following example
gives an allround chat script that should also work in case you have
to hit return before the login appears. \fB""\fR designates
the empty expect string.
.QP
.nh
\&\&
"" \en\er\ed\er\en\ec ogin:-BREAK-ogin: pablo ssword: catch22
.PP
          There are a couple of special strings and escape characters which may
occur in the chat script. Note that not all characters are recognized
by all BNU UUCP's.
The following are legal characters in expect strings:
.RS
.IP \fB""\fR\ 
 A pair of double qoutes designates the empty string
(expect nothing).
.IP \fB\eb\fR\ 
 Backspace character.
.IP \fB\et\fR\ 
 Tab character.
.IP \fB\eN\fR\ 
 NUL character.
.IP \fB\er\fR\ 
 Carriage return character.
.IP \fB\es\fR\ 
 Space character (` ').
.IP \fB\en\fR\ 
 Newline character.
.IP \fB\e\e\fR\ 
 Backslash character (`\fB\e\fR').
.IP \fB\eddd\fR\ 
 Character in octal digits \fBddd\fR.
.IP \fB\exdd\fR\ 
 Character in hexadecimal digits \fBdd\fR.
.RE
.IP
.LP
On send strings, the following escape characters and strings are legal
in addition to the above:
.RS
.IP \fBEOT\fR\ 
    End of transmission character (`\fB^D\fR').
.IP \fBBREAK\fR\ 
  End of transmission character (may not work on all
systems).
.IP \fB\ec\fR\ 
 Suppress sending of carriage return at end of string.
.IP \fB\ed\fR\ 
 Delay sending for 1 second.
.IP \fB\ee\fR\ 
 Disable echo checking.
.IP \fB\eE\fR\ 
 Enable echo checking (wait for echo before continuing).
.IP \fB\eK\fR\ 
 Same as \fBBREAK\fR.
.IP \fB\ep\fR\ 
 Pause for fraction of a second.
.RE
.IP
.PP
.NH 3
Hiding\ dialcodes\ ---\ the\ \fBDialcodes\fR\ file
.br
.PP
To make the phone numbers given in the \fBSystems\fR file more
legible, as well as easier to maintain within large communities,
you may replace parts of it with alphabetic strings. When dialing
the number, the string is translated back to numbers.
Common practice is to replace area codes with names.
.PP
The \fBDialcodes\fR file is for translating these strings back
into telephone numbers. An entry in this file consists of
two fields: The first is the alphabetic string, the second is
the phone number to substitute.
.PP
.NH 3
What\ devices\ there\ are\ ---\ the\ \fBDevices\fR\ file
.br
.PP
This section describes the \fBDevices\fR file. It contains information
about the devices available to UUCP.
.PP
An entry consists of the following fields:
.IP \fItype\fR\ 
 The device type. It must be one of the following
keywords:
.RS
.IP \fBACU\fR\ 
 The device is a modem. \fBACU\fR
stands for ``automatic call unit''.
.IP \fBDirect\fR\ 
 This specifies a direct line.
.IP \fBTCP\fR\ 
 The connection is established via
a TCP/IP socket.
.RE
.IP
It may be followed by a comma-separated list of
protocols supported. It overrides those possibly specified
in the \fBSystems\fR file.
.IP \fIport\fR\ 
 This is the device name. For direct serial links or modems,
this will be the name of the special file in the \fB/dev\fR
directory. Note that you should specify the real device file
(i.e. \fB/dev/cua\fBn\fR\fR), and not a symbolic link like
\&\fB/dev/modem\fR.
.IP
For a TCP/IP connection, either use a service name to
be looked up in \fB/etc/services\fR, or a services number.
The service name will usually be \fBuucpd\fR or \fBuucp\fR.
If \fBuucico\fR cannot determine a service number, port
540 is used.
.IP \fIdialer\fR\ 
 This names a dialer device file.
This is primarily useful for modems. For other connections,
you should use a dash (`\fB-\fR'). In case of several direct
connections, you may have to use this field for some sort
of trickery (see See section Direct UUCP connections.).
.IP \fIspeed\fR\ 
 The speed the device supports (direct or a phone lines only).
This entry is matched against the speed field from the
\&\fBSystems\fR file.
.IP
The string may be either a number, or two numbers separated by
a dash (`\fB-\fR'), specifying a speed or a speed range in bits per
second, respectively. A single dash or the keyword \fBAny\fR
matches any speed. 
.IP
You can also precede this with a modem class. See the explanation
of the \fIspeed\fR field in See section The Systems file. for an example
why one would want to use this.
.IP
In conjunction with a TCP connection, use a dash.
.IP
If the entry describes a direct line (type is \fBDirect\fR),
you may not specify a speed range.
.IP \fIdialer-token\ pairs\fR\ 
A dialer-token pair is a dialer type, followed by a token
to be sent to the dialer. The token may either be \fB\eD\fR
or \fB\eT\fR. Both denote the phone number as specified in
the \fBSystems\fR file, where \fB\eT\fR implies dialcode
translation, and \fB\eD\fR doesn't.
.IP
The dialer type is matched against an entry in the
\&\fBDialers\fR file.
.IP
Under normal circumstances, you will only have one modem
wired to the device directly. Then, you should give only one
dialer-token pair. However, if you access several modems
over a switch, you will have a dialer-token pair for
each. In this case, the token will be the string given
to the switch in order to access the modem.
.IP
If the entry describes a direct line (type is \fBDirect\fR),
this field is not used.
.PP
The device type specified in the \fBSystems\fR file is matched
against the device types in the \fBDevices\fR file. The same
device type may be used several times. If you have several
modems connected to your machine, you will give at least
one entry named \fBACU\fR for each of them. You may
even give several entries for the same modem, each at a
different speed or with a different modem initialization.
.PP
.NH 3
How\ to\ dial\ a\ number\ ---\ the\ \fBDialers\fR\ file
.br
.PP
The \fBDialers\fR file describes the way dialers are used. Each modem
or dialer type has exactly one entry.
.PP
Any entry consists of the following fields:
.IP \fIdialer\fR\ 
 This is the name of the dialer. It must match the \fIdialer\fR
part of a \fIdialer-token\fR pair in the \fBDevices\fR file entry.
.IP \fIsubst\fR\ 
 String of character translations. The first of each
pair of characters is translated into the second when dialling
the telephone number. This is generally used to substitute
the `\fB=\fR' and `\fB-\fR' characters in the phone number.
.IP \fImodem-chat\fR\ 
 Organized simliarily to the chat script in
the \fBSystems\fR file, it consists of pairs of expect/send
strings used to initialize the dialer (or modem) and dial
the phone number.
.IP
The following ecape characters are understood:
.RS
.IP \fB\eD\fR\ 
 Send phone number without dialcode translation.
.IP \fB\eT\fR\ 
 Send phone number with dialcode translation.
.IP \fB\eM\fR\ 
 Do not require carrier.
.IP \fB\em\fR\ 
 Require carrier and fail if not present.
.RE
.IP
Apart from these, all escape characters specified for the
\&\fBSystems\fR file chat script are understood.
.PP
.NH 3
The\ Do\'s\ and\ Dont\'s\ ---\ The\ \fBPermissions\fR\ File
.br
.PP
.PP
The \fBPermissions\fR file controls access \fIyou\fR grant to
\&\fIother\fR systems. Each entry is one line, possibly continued
across a newline using a backslash (``\fB\e\fR''). It consists of a list
of assignments, separated by white space. An assignment is a
token-value pair, separated by an equals sign (\fB=\fR), and should
not contain white space. They may occur in any order. Any but
the \fBLOGNAME\fR and \fBMACHINE\fR options have default values.
.PP
You may give different permissions to remote systems, based on whether
they call you, or you call them. The first type is described by 
an entry containing \fBLOGNAME=\fBlogin\fR\fR which specifies the
login id under which the remote system logs in. 
An entry containing \fBMACHINE=\fBsystem\fR\fR describes permissions
for the remote system when we call it. You may also merge both
entries for \fB\fBsystem\fR\fR into one entry by specifying both
\&\fBLOGNAME\fR and \fBMACHINE\fR.
.PP
An entry specifying \fBMACHINE=other\fR applies to any machine calling
in. This can be used to set permissions for any machine not explicitly
mentioned.
.PP
Some options only apply when calling out, others only when
a remote system calls in.
The following entries may be used with both \fBLOGNAME\fR and \fBMACHINE\fR
entries:
.PP
.IP \fBREQUEST\fR\ 
If set to \fByes\fR, the remote system may request
files from you. Defaults to \fBno\fR.
.IP \fBPUBDIR\fR\ 
The directory for public local access.
Defaults to \fB/usr/spool/uucppublic\fR.
.IP \fBREAD\fR\ 
A colon-separated list of directories the remote system may
request files from, and any subdirectories thereof.
Defaults to \fBPUBDIR\fR.
.IP \fBWRITE\fR\ 
A colon-separated list of directories the remote system may
send files to, and any subdirectories thereof.
Defaults to \fBPUBDIR\fR.
.IP \fBNOREAD\fR\ 
A colon-separated list of directories excepted from
\&\fBREAD\fR.
.IP \fBNOWRITE\fR\ 
A colon-separated list of directories excepted from
\&\fBWRITE\fR.
.IP \fBSENDFILES\fR\ 
If set to \fByes\fR, jobs are transferred to the
remote system when it calls. Otherwise, when set
to \fBcall\fR, your system will only transfer queued
jobs when it calls out. If set to \fBno\fR, no
jobs will be transferred at all.
.FS 
This is specific to Taylor UUCP 1.03. In version
1.04, \fBno\fR is equivalent to \fBcall\fR.
.FE
 Defaults to \fBcall\fR.
.IP \fBMYNAME\fR\ 
If you want to hide your system name when calling another
machine, set \fBMYNAME\fR to your alias.
.IP
This option is very useful. Assume your machine is
the gateway to a net called \fBdaveg\fR, but its hostname is
\&\fBcuxE91\fR. However, the site you call expects your
name to be \fBdaveg\fR. Instead of ripping apart your
whole net, you can put \fBMYNAME=daveg\fR in your
\&\fBPermissions\fR file, and \fBuucico\fR will report your
hostname as \fBdaveg\fR to the remote machine.
.PP
The following options are available for \fBLOGNAME\fR entries only:
.PP
.IP \fBVALIDATE\fR\ 
This field is interpreted differently under versions 1.03
and 1.04. In UUCP 1.03, it specifies a
colon-separated list of systems allowed to log
in under this logname.
.FS 
This is also the way the O'Reilly book has it. According
to Ian Taylor, this is wrong.
.FE
 If this list is empty, any system name is valid.
.IP
In version 1.04, however, if a site is listed in
the \fBVALIDATE\fR field, then it is \fIrequired\fR to use
the corresponding \fBLOGNAME\fR. Other systems are still
permitted to use this login. If you set up your system
for dialup and allow anonymous UUCP, this option will
come very handy. See section See section Dialing into your UUCP Node..
.IP \fBCALLBACK\fR\ 
If set to \fByes\fR, your system will hang up when
the remote system calls you, and return the call.
Defaults to \fBno\fR.
.PP
The following option is available for \fBMACHINE\fR entries only:
.IP \fBCOMMANDS\fR\ 
A colon-separated list of commands the remote system may
execute on our machine. Defaults to \fBrnews:rmail\fR.
.PP
.NH 3
Be\ Paranoid\ ---\ Call\ Sequence\ Checks
.br
.PP
.PP
Call sequence checks are used to prevent and detect impostors.
Imagine somebody else finds out the password you use to log into
your mail feed. He or she could now call your feed, posing as
you, and receive all your mail.
.PP
To guard against this, you can enable call sequence checks. For
this, both machines keep track of the number of connections
established so far. It is incremented with each connection.
At login, the caller sends its call sequence number,
and the callee checks it against its own number. If they don't
match, the connection attempt will be rejected. 
.PP
Even if some very clever person should detect your call sequence
number as well as your password, you will find this out:
the next time you try to log in, the remote \fBuucico\fR will refuse
you, because the numbers don't match anymore! However, depending
on the implementation of the remote \fBuucico\fR, it may still be
possible for the impostor to log in.
.PP
With BNU-compatible UUCP's, this number is kept in the file
\&\fB.Sequence\fR in the remote site's spool directory. It \fImust\fR
be owned by \fBuucp\fR, and must be mode \fB600\fR (i.e. readable
and writeable only by its owner). Call sequence checks are enabled by
creating this file:
.PP
.QP
.nh
# cd /usr/spool/uucp/\fBsitename\fR
# echo "4316" > .Sequence
# chmod 600 .Sequence
# chown uucp.uucp .Sequence
.PP
It is best to initialize this file with an arbitrary, agreed-upon start value.
Otherwise, someone might manage to guess the number by trying out all
smaller than, say, 20.
.PP
.NH 3
How\ to\ Specify\ a\ Direct\ Connection
.br
.PP
.PP
Assume you use a direct line connecting your system \fBpablo\fR
to \fBtiny\fR. How would you sepcify the device to use?
Having read the above, you would certainly think: ``Why, 
I use \fBDirect\fR in \fBDevices\fR, and\&...''. But wait, 
what if you have \fIanother\fR direct line, the second
connecting you to \fBwalt\fR? Which line is \fBuucico\fR assumed
to pick? There is no way for it to see from an entry in \fBDevices\fR
what system it is connected to.
.PP
There are several ways around this dilemma.
.PP
The first is to use a different name for each direct entry in
\&\fBDevices\fR, e.g. one could take the name of the site at the other end
of the wire instead of \fBDirect\fR. This method is widely used.
However, this has a disadvantage: \fBuucico\fR decides by the entry's
name if it is a direct line (\fBDirect\fR), a TCP connection (\fBTCP\fR),
or a modem (anything else).
Thus, using a name other than \fBDirect\fR causes \fBuucico\fR
to assume that the line has a modem dangling off it. Since it might
handle direct lines and modems differently, this could get you
in trouble. However, you \fIshould\fR do it this way if the
connection is over a leased line (for which one generally uses modems on
both ends).
.PP
Note, that since the line is not recognized as being direct, \fBuucico\fR
will expect a dialer-token pair at the end of the entry. It is
best to add a do-nothing entry named \fBdirect\fR to the \fBDialers\fR
file, if the connection is a simple wire. When using a leased line,
you will need a separate entry to access the modem, anyway.
.PP
The second way is to prepend any system identification to the
speed, in effect defining a ``modem class''. You can now use
\&\fBDirect\fR as the entry's name, making sure that the device is
recognized as a direct line indeed. Since modem classes may not
be implemented in all UUCP's, you may have problems using
this method with \fBuucico\fR's other than Ian Taylor's.
.PP
An example for both methods is given in the section below.
.PP
.NH 2
From\ System\ Name\ to\ Connect\ ---\ How\ all\ this\ Works
.br
.PP
.PP
After giving you an overview of what files UUCP uses, we now explain
the process of accessing a system in greater detail, giving an extensive
example.
.PP
.PP
.NH 3
Sample\ Files
.br
.PP
Assume the sample files given in Fig. See section Sample UUCP configuration files.
through See section Sample UUCP configuration files..
.PP
[hbtp]
.DS
.ft CW
# /usr/local/lib/uucp/Systems
#
# This is our news/mail feed.
swim   Any/C,NonPeak  ACU,g  9600   Town=123456   ogin: joe ssword: Jabba
# alternate number, slow modem.
swim   Any/C,NonPeak  ACU,g  2400   Town=555555   ogin: joe ssword: Jabba
#
# The server for local distribution
server Any            TCP,e  -      srv.abc.com  ogin: joe ssword: ScrBlX
#
# A local machine with direct connection: using method #1
pablo  Any      pablo,g  38400      -            ogin: joe ssword: Catch22
#
# A local machine with direct connection: using method #2
tiny   Any      Direct,g tiny38400  -            ogin: joe ssword: iTsMe
  
.DE
.ft R
.PP
	Figure: 
The \fBSystems\fR file
[htbp]
.DS
.ft CW
# /usr/local/lib/uucp/Devices
#
# TCP. Use service 'uucp' in /etc/services
TCP     uucp            -       -
#
# Hayes Modem on /dev/cua1
ACU     /dev/cua1       -       2400    hayes \eT
ACU     /dev/cua1       -       9600    hayesv42 \eT
#
# The direct connection to pablo, using dialer 'direct'
pablo   /dev/cua2       -       38400   direct
#
# The direct connection to tiny, no dialer
Direct  /dev/cua3       -       tiny38400
  
.DE
.ft R
.PP
	Figure: 
The \fBDevices\fR file
[hbtp]
.DS
.ft CW
# /usr/local/lib/uucp/Dialers
#
# Hayes Modem at 2400 Baud, no compression
hayes     =,-,    "" AT OK ATZ OK AT\e\eN0M3E0Q1 OK \eEATDT\eT CONNECT
# Hayes Modem at 2400 Baud, V42bis
hayesv42  =,-,    "" AT OK ATZ OK AT\e\eN6M3E0Q1 OK \eEATDT\eT CONNECT
# Do-nothing dialer for direct lines
direct
  
.DE
.ft R
.PP
	Figure: 
The \fBDialers\fR file
[hbtp]
.DS
.ft CW
# /usr/local/lib/uucp/Permissions
#
# server: may do almost everything 
LOGNAME=server MACHINE=server VALIDATE=server\e
	READ=/ SEND=/	\e
	REQUEST=yes SEND=yes\e
	COMMANDS=rnews:rmail:rsmtp:lpr:uux
# Ordinary mail and news accounts
LOGNAME=swim MACHINE=swim VALIDATE=swim\e
	REQUEST=yes SEND=yes\e
	COMMANDS=rnews:rmail
LOGNAME=pablo MACHINE=pablo VALIDATE=pablo\e
	REQUEST=yes SEND=yes\e
	COMMANDS=rnews:rmail
# mail-only link
LOGNAME=tiny MACHINE=tiny VALIDATE=tiny\e
	REQUEST=yes SEND=yes\e
	COMMANDS=rmail
# anon UUCP account.
LOGNAME=uucp MACHINE=other\e
        COMMANDS=rmail REQUEST=yes SENDFILES=no
  
.DE
.ft R
.PP
	Figure: 
The \fBPermissions\fR file
.NH 3
Building\ up\ the\ Connection
.br
.PP
<>
If \fBuucico\fR is called with the \fB-s \fBsysname\fR\fR option, 
it will check the \fBSystems\fR file for \fB\fBsysname\fR\fR.
All entries for \fB\fBsysname\fR\fR are tried in the order given, until 
either a call succeeds, or there are no entries left.
.FS 
Alternate entries are also retried when the failure occured during the
chat script, the handshake, or even during the transfer phase.
.FE
 First, the entry's schedule field is checked whether the call may be
placed at the current time. No check of the maximum spool grade is done. 
.PP
However, if \fBuucico\fR is invoked with flag \fB-r1\fR,
it will loop over all entries in the \fBSystems\fR file. For each entry,
the spool directory is scanned for jobs queued for
this system. If there are no jobs, the respective system will not be called.
If there are, the maximum grade of all jobs is compared against the spool
grade specification in the schedule field. If there is no matching time/grade
combination for the current entry, \fBuucico\fR continues scanning the system
file; otherwise it tries to call the system.
.PP
If the entry matches, \fBuucico\fR will first check if there's
already a connection open to this machine. This is signalled by a lock file
in the spool directory. If there is one, the call fails. Otherwise,
\&\fBuucico\fR will proceed and create a lock file itself.
.PP
Next, the device type is extracted from field 4 of the \fBSystems\fR file, 
and the \fBDevices\fR file is searched for a device matching the desired
type. If it finds one, the speed fields are checked against each other, too.
If the speed ranges specified in the \fBSystems\fR file entry and the
\&\fBDialers\fR file entry overlap, the highest common speed is selected.
An entry containing \fBAny\fR or ``\fB-\fR'' matches any speed.
Then, \fBuucico\fR will open the device file or the TCP/IP socket.
If the device is a modem, the dialer chat script specified in
the \fBDialers\fR file is executed first. Following this, the
chat script from the \fBSystems\fR file is executed.
.PP
.NH 3
Calling\ out\ via\ Modem
.br
.PP
Assume that you issued the command
.QP
.nh
$uucico -sswim
.PP
on the command line to connect to \fBswim\fR. Since \fBuucico\fR has been
invoked with \fB-s\fR, it is satisified by the first entry which specifies
\&\fBAny\fR as call time. If no lock file for \fBswim\fR exists, it will
create one. 
.PP
Then, \fBuucico\fR searches \fBDevices\fR for entries of type ACU
at 9600 bps. It finds the modem on \fB/dev/cua1\fR, one entry using
it at 2400 bps, and another at 9600 bps.
The first entry doesn't match the transfer rate, but the second does.
If \fBcua1\fR is not locked, a lock file is created, and the call proceeds.
.PP
Next, \fBuucico\fR extracts the dialer-token
pair from the entry. Since the token is \fB\eT\fR, \fBTown\fR in
the phone number will be substituted, using the \fBDialcodes\fR file.
.PP
The dialer type, \fBhayesv42\fR, is matched against the dialer names
in the \fBDialers\fR file.
A matching entry is found, and the ``\fB=\fR'' from the phone number
is translated to the Hayes(tm)-specific pause command ``\fB,\fR''.
.PP
Next, the modem is initialized using the modem chat script, and
dials out. After receiving \fBCONNECT\fR from the modem, \fBuucico\fR
executes the login chat script given in \fBSystems\fR: it waits for
\&\fBogin:\fR, then sends \fBjoe\fR, waits for \fBssword:\fR and sends
\&\fBJabba\fR. The remote end should now fire up its own \fBuucico\fR,
and initial handshake between the two takes place
(see See section The inner workings of uucico.).
.PP
Note that in this example, a single modem is set up so that it can be
used at different speeds.
.FS 
This is done by the \fB\e\eN0\fR and \fB\e\eN6\fR command in the
modem chat script, respectively. I don't know if that's standard Hayes,
but my modem does it that way.
.FE
.PP
.NH 3
Calling\ out\ via\ TCP
.br
.PP
Assume that you issued the command
.PP
.QP
.nh
$ uucico -sserver
.PP
Exactly as in the above example, \fBuucico\fR searches \fBSystems\fR,
now finding an entry describing \fBserver\fR. The device field
now specifies a TCP connection, and the phone number field contains
the name the remote site responds to.
.PP
For TCP/IP connections, any \fBTCP\fR type device matches. Hence,
you will only need one entry in your \fBDevices\fR file, just like
in the example above.
.PP
\&\fBuucico\fR will now resolve the host name into an IP address
using \fBgethostbyname()\fR. For this to work, you either have to
have a \fBnamed\fR Domain Name Server installed, or \fBresolv.conf\fR
and \fBhosts.equiv\fR set up correctly. Please refer to the networking
FAQ.
.PP
Then the port number through which to reach the UUCP
daemon on the remote host is determined from the 
second field in the \fBDevices entry\fR. This can either
contain the port number itself, or a service name that is translated
using \fBgetservbyname()\fR.
.PP
Finally, the socket is bound to the address, and the login chat script
is executed.
.PP
.NH 2
Setting\ up\ your\ System\ for\ Dialing\ in
.br
.PP
.PP
If you want to set up your site for dialing in, you have to
permit logins on your serial port, and customize some system files
to provide UUCP accounts. This will be explained throughout this
section.
.PP
.PP
.NH 3
Setting\ up\ \fBuugetty\fR
.br
.PP
.PP
When setting up a serial line for use as a dialin
port, you have to enable some \fBgetty\fR program on this port.
However, for ports you wantto use for both dialling in and out,
the usual \fBgetty\fR program is not enough, because it does not
allow other programs to access the device. Instead, you have to
use a companion program called \fIuugetty\fR that implements
line sharing.
.PP
There's a \fBuugetty\fR program available for Linux from
the \fBgetty_ps\fR suite.
If you are running a recent SLS release, you will already have
it --- check this out in your \fB/etc\fR directory. Otherwise, you may
obtain it from \fBtsx-11.mit.edu\fR as either binary or source.
.PP
Line sharing between \fBuugetty\fR and other programs like \fBuucico\fR,
\&\fBkermit\fR or \fBseyon\fR is implemented using UUCP lock files.
When being invoked on serial line, say \fB/dev/ttyS1\fR, \fBuugetty\fR
checks if there is a lock file named \fBLCK..cua1\fR in \fB/usr/spool/uucp\fR.
If there is one, it puts itself to sleep for a minute. Otherwise, it
initializes the line, and waits for an incoming connection. When
accepting an incoming connection, it creates the lock file \fBLCK..cua1\fR
itself, thus barring any other program from accessing the line.
When another program tries to call out while \fBuugetty\fR is still
waiting for an incoming connection, \fBuugetty\fR recognizes this and
puts itself to sleep.
.PP
\&\fBuugetty\fR may be set up just the way you would configure \fBgetty\fR
for a serial port, except that the configuration file should now be
called \fBuugetty.ttyS1\fR instead of \fBgetty.ttyS1\fR. Everything
else should go as described in section See section Dialin..
.PP
.NH 3
Providing\ UUCP\ Accounts
.br
.PP
.PP
Next, you need one or more login names under which people may log
into your system to do UUCP. Generally,
this will be something like \fBuucp\fR for anonymous downloads,
and a separate login for every site that polls you.
.PP
You should give all UUCP accounts a distinct group which has no
special rights, for example \fBguest\fR. As shell,
you enter \fB/usr/local/lib/uucp/uucico\fR.
For example, if you have the shadow password suite installed,
you may do this by invoking the \fBuseradd\fR command with the
following arguments:
.PP
.QP
.nh
.DS
.ft CW
# useradd -d /usr/spool/uucppublic -G guest	\e
		-s /usr/local/lib/uucp/uucico monad
# useradd -d /usr/spool/uucppublic -G guest	\e
		-s /usr/local/lib/uucp/uucico uucp
 
.DE
.ft R
\&\&
.PP
Afterwards, set the passwords for these accounts using the \fBpasswd\fR
command.
.PP
For UUCP, you should put the following lines into \fBPermissions\fR:
.PP
.QP
.nh
.DS
.ft CW
LOGNAME=uucp\e
	READ=/usr/spool/uucppublic\e
	NOREAD=/usr/spool/uucppublic/incoming\e
	WRITE=/usr/spool/uucppublic/incoming\e
        COMMANDS=rmail REQUEST=yes SENDFILES=yes
LOGNAME=monad MACHINE=monad VALIDATE=monad\e
        READ=/usr/spool/uucppublic WRITE=/usr/spool/uucppublic\e
        COMMANDS=rnews:rmail:rsmtp REQUEST=yes SENDFILES=yes
 
.DE
.ft R
\&\&
.PP
The \fBVALIDATE\fR entry is necessary to prevent intruders from
sneaking on \fBmonad\fR's mail: Assume a system logs in as \fBuucp\fR
and pretends its name is \fBmonad\fR. If validation is not in effect,
it is sent all jobs that are queued for \fBmonad\fR!
.FS 
This also seems to be a problem with various version 2 implementations.
Amiga-UUCP is one of them.
.FE
.PP
Directories for any UUCP accounts are created by \fBuucico\fR as needed.
.PP
If you wish to prohibit interactive logins from the dialup port, possibly
for security reasons, or because this would disrupt mail and news services,
you may use the \fIporttime\fR feature of the shadow login suite. In
\&\fB/etc/login.defs\fR, you set \fBPORTTIME_CHECKS_ENAB\fR to \fByes\fR,
and put the following into your \fB/etc/porttime\fR file:
.PP
.QP
.nh
.DS
.ft CW
# /etc/porttime
# Allow registered UUCP users, but throw out everybody else
ttyS1:uucp,monad:Al0000-2400
ttyS1:*:
 
.DE
.ft R
\&\&
.PP
This only allows the UUCP accounts \fBmonad\fR and \fBuucp\fR to be
accessed over the serial port, while everyone else will fail to log in.
Details on the \fBportttime\fR file can be found in the corresponding
section 4 manual page.
.PP
Note that anonymous UUCP in Taylor UUCP is currently somewhat broken.
If you have enabled support for both HDB and Taylor-style configuration
files --- as is the case with the SLS UUCP ---, \fBuucico\fR will
fail to allow unkown systems to log in. This seems to be a deliberate
lack of feature. If you want to provide anonymous UUCP, you either have to 
use Taylor-style configuration files, or recompile \fBuucico\fR
with HDB support exclusively.
.PP
.NH 3
Accepting\ UUCP\ logins\ over\ TCP/IP
.br
.PP
.PP
If you want to use Taylor UUCP to service requests over TCP/IP, you have to
add the following to the file \fB/etc/services\fR:
.QP
.nh
.DS
.ft CW
uucpd   540/tcp
 
.DE
.ft R
\&\&
.PP
To make \fBinetd\fR service requests for it, add the following to
\&\fB/etc/inetd.conf\fR:
.QP
.nh
.DS
.ft CW
uucpd   stream tcp nowait root /usr/local/lib/uucp/uucico uucico -l
 
.DE
.ft R
\&\&
.PP
Instead of using inetd, you may also start \fBuucico\fR at boot time with
the \fB-e\fR Option. This makes \fBuucico\fR sit in a loop, listen
to the port specified, and wait for requests.
.PP
If a connection via TCP occurs, \fBuucico\fR will prompt for login and
password. However, it will not use \fB/etc/passwd\fR for authorization,
but rather its private \fB/usr/local/lib/uucp/passwd\fR file.
.PP
Of course you can select any other port number than 540, although this
is the default used by \fBuucico\fR.
.PP
.NH 2
Miscellaneous
.br
.PP
.PP
.PP
.PP
.PP
.NH 3
Troubleshooting
.br
.PP
.PP
This section describes what may go wrong with your UUCP connection,
and makes suggestions where to look for the error.
.FS 
This amounts to a short UUCP-FAQ. I would be glad if someone took this as a
basis for a real FAQ.
.FE
 However, the questions were compiled by the author off the top of
his head. There's much more that can go wrong.
.PP
In any case, enable debugging with \fB-xall\fR, and take a look at
the output in \fB.Admin/audit.local\fR in the spool directory.
It helps you quickly recognize where the problem lies.
Also, I have always found it helpful to turn on my modem's speaker when
it didn't connect. With Hayes(tm)-compatible modems, this is accomplished
by adding ``\fBATL1M1 OK\fR'' to the modem chat in the \fBDialers\fR file.
.PP
\&\fBSomething is wrong\fR:
The first check always should be if all file permissions are set correctly.
\&\fBuucico\fR should be setuid \fBuucp\fR, and all files in
\&\fB/usr/local/lib/uucp\fR,
\&\fB/usr/spool/uucp\fR and \fB/usr/spool/uucppublic\fR should be owned by
\&\fBuucp\fR. Remember to check the hidden files in the spool directory.
.PP
\&\fBI can connect to the remote site, but the chat script fails\fR:
Look at the text you receive from the
remote site. If it's garbled, this might be a speed-related problem.
Otherwise, confirm if it really agrees with what your chat script expects.
Remember the chat script starts with an expect string. If you receive
the login prompt, then send your name, but never get the password prompt,
insert some delays before sending it, or even in-between the letters. You
might be too fast for your modem.
.PP
\&\fBMy modem does not dial\fR:
If your modem doesn't indicate that the \fBDTR\fR line has been raised when
\&\fBuucico\fR calls out, you possibly haven't given the right device
to \fBuucico\fR. Check \fBDevices\fR. Also, see See section Serial Hardware.
on how to find out the device. If your modems recognizes \fBDTR\fR, check
with \fBkermit\fR that you can write to it. If this works, turn on
echoing with \fB\eE\fR at the start of the modem chat. If it doesn't
echo your commands during the modem chat, check if your
line speed is too high or low for your modem. If you see the echo,
check if you have disabled modem responses, or set them to number codes.
Verify that the chat script itself is correct. Remember that you have
to write two backslashes to send one to the modem.
.PP
\&\fBMy modem tries to dial, but doesn't get out\fR:
Insert a delay into the phone number. This is especially useful when
dialling out from a company's internal telephone net.
For people in Europe, who usually dial pulse-tone: try touch-tone.
In some countries, postal services
have been upgrading their nets recently. Touch-tone sometimes helps.
.PP
\&\fBI have extremely high packet loss rates\fR:
This looks like a speed problem. Maybe the link between computer
and modem is too slow (remember to adapt it to the highest effective
rate possible)? Or it is your hardware that is too slow to service
interrupts in time. With a NSC 16550 chipset on your serial port, 38kbps
are said to work reasonably well; however, without FIFOs (like 16450 chips),
9600 bps is the limit.
.PP
\&\fBI can log in, but handshake fails\fR:
Well, there can be a number of problems. The output in the log
file should tell you a lot. Look at what protocols the remote site
offers (It sends a string \fBP\fBprotlist\fR\fR during handshake).
Maybe they don't have any in common (did you select any protocols
in \fBSystems\fR or \fBDevices\fR?).
.PP
If the remote system sends \fBRLCK\fR, there is a stale lockfile
for you on the remote system. If it's not because you're already connected
to the remote system on a different line, ask to have it removed.
.PP
If it sends \fBRBADSEQ\fR, the other site has conversation count checks
enabled for you, but numbers didn't match. If it sends 
\&\fBRLOGIN\fR, you were not permitted to login under this id.
(Possibly you forgot to set \fBMYNAME\fR in \fBPermissions\fR?)
.PP
.NH 3
Log\ files
.br
.PP
When compiling the UUCP suite to be HDB-compatible, there are several
places where log files may go. Most commands will always generate
some amount of informational information. This is logged to files
below \fB/usr/spool/uucp/.Log\fR. This directory contains three
more directories, named \fBuucico\fR, \fBuuxqt\fR, and \fBuux\fR.
They contain the logging output generated by each of the corresponding
commands, sorted into different files for each site. Thus, output from
\&\fBuucico\fR when calling site \fBswim\fR will go into
\&\fB.Log/uucico/swim\fR, while the subsequent \fBuuxqt\fR run will
write to \fB.Log/uuxqt/swim\fR.
.PP
When enabling debugging output, this will go to the \fB.Admin\fR
directory below \fB/usr/spool/uucp\fR. When calling out, debugging
information will be sent to \fB.Admin/audit.local\fR, while
the output from \fBuucico\fR when someone calls in will go
to \fB.Admin/audit\fR.
.PP
.NH 3
Available\ line\ protocols
.br
.PP
.PP
To negotiate session control and file transfers with the remote end,
\&\fBuucico\fR uses a set of standardized messages. This is often referred
to as the high-level protocol. During the initialization phase and the hangup
phase these are simply sent across as strings. However, during the
real transfer phase, a low-level protocol is employed which is mostly
transparent to the higher levels. This is to make error checks 
possible when using telephone lines, among other things.
.PP
This low-level protocol can be chosen from among a set of protocols,
depending on the nature of the connection used. However, not every
implementation of \fBuucico\fR knows every protocol, so during
initialization phase, both processes have to agree on a common protocol.
As described in section See section The inner workings of uucico., you can select a list
of protocols to be offered to the remote \fBuucico\fR when your UUCP
calls out. You can do this by appending a string of protocol names to
the device field in \fBSystems\fR, offset by a comma.
A protocol name is a single letter.
.FS 
Note that protocol names are case-sensitive. Some implementations
of \fBuucico\fR have a \fIG\fR protocol, for
example, which is a slightly modified \fIg\fR protocol.
.FE
.PP
The following protocols are available with Taylor UUCP 1.03:
.IP \fIg\fR\ 
 This is the most common protocol and should be understood by
virtually all \fBuucico\fR's. It does thorough error
checking and is therefore well-suited for noisy telephone
links. \fIg\fR requires an eight-bit clean connection.
.IP
It is a packet-oriented protocol which uses a slide-window
technique (See below for an explanation of these
verbal monsters).
.IP
Because of the overhead involved, \fIg\fR is not considered
efficient for reliable links such as TCP connections.
.IP \fIt\fR\ 
 This is a protocol intended for use over a TCP connection.
It is only for use with truly error-free networks.
It uses packets of 1024 bytes and requires an eight-bit
clean connection.
.IP \fIe\fR\ 
 This should basically do the same as \fIt\fR. The main
difference is that \fIe\fR is a streaming protocol.
.IP \fIf\fR\ 
 It is intended for use with reliable X.25 connections.
.FS 
X.25 is a standard issued by CCITT, describing the lower
three layers (i.e. physical, data link, and networking) for
digital connections over public phone lines. Special equipment
is needed for X.25, namely a so-called \fIPAD\fR, meaning
Packet-Assembler-Disassembler.
.FE
It is a streaming protocol and expects a seven-bit data path;
eight-bit characters are quoted, which can make it very
inefficient.
.PP
Protocols can be divided into two categories: streaming and packet-oriented
protocols. The first type transfers a file as a whole, possibly computing
a checksum over it. This is nearly free of any overhead,
but requires a reliable connection, because any error will cause the whole
file to be retransmitted. These protocols are not suitable for use over
telephone lines. Although modern modems do quite a good job at error
checking, there is no such thing as error detection between your computer
and the modem.
.PP
On the other hand, packet protocols split up the file into several chunks
of equal size. Each packet is sent and received separately.
With the \fIg\fR protocol, a checksum is calculated for each packet,
and the recipient has to acknowledge its correct transmission.
To make this more efficient, sliding-window
protocols were invented, which allow for a limited number (a window)
of outstanding acknoledgements at any time. This greatly reduces the
amount of time \fBuucico\fR has to wait during a transmission.
.PP
Packet sizes are generally powers of 2. The \fIg\fR protocol has a
maximum window size of 7, and packet sizes ranging from 64 through 4096.
With BNU configuration files, these parameters cannot be set by the
user.
.FS 
This is possible when compiling Taylor UUCP to use ``Taylor
configuration files''. You are basically on your own doing this. However,
the sources contain \fBtexinfo\fR files describing their format.
.FE
 Taylor UUCP currently comes with a pre-compiled default of 
7 windows and 64 byte packets.
.FS 
You can't get above this. During the \fIg\fR protocol startup,
both processes exchange their preferred packet and window sizes,
and settle for the smaller of each.
.FE
.PP
The width of the data path also makes a difference. When transmitting
eight-bit characters over a seven-bit connection, they have to be
quoted. Under worst-case assumptions, this doubles the amount of
data to be transmitted, although compression done by the hardware
may compensate for this. On the other hand, if you use a modem, an
eight-bit clean connection forbids software handshake between modem
and computer.  In this case, make sure that both modems perform
hardware handshaking.
.PP
Taylor UUCP version 1.04 adds a couple of new protocols. These are
.IP \fIi\fR\ 
 This is a bidirectional protocol which can
send and receive files at the same time. It requires
a full-duplex connection and an eight bit data path.
You will only recognize an advantage over the \fIg\fR protocol
if you are sending about as much as you are receiving.
.IP \fIG\fR\ 
 This is the System V Release 4 version of the \fIg\fR protocol.
It is also understood by some other versions of UUCP.
.IP \fIa\fR\ 
 Similiar to ZMODEM. Requires an eight bit connection, but quotes
certain control characters like \fBXON\fR and \fBXOFF\fR.
.PP
All these are also packet protocols with many parameters. When using Taylor
configuration files, they can be tuned by the user. With HDB, defaults are
provided.
.PP
.NH 3
Notes
.br
.PP
Taylor UUCP is covered by the GNU public license, which is reproduced
in appendix See section The GNU License..
The latest version is always available as
\&\fBprep.ai.mit.edu:/pub/gnu/COPYING\fR.
.PP
There is a mailing list for users of Taylor UUCP. To subscribe (or leave),
send mail to 
.QP
.nh
taylor-uucp-request@gnu.ai.mit.edu
.PP
Please note that this mail is handled by a human being.
To write a message to the list, simply send it to
\&\fBtaylor-uucp@gnu.ai.mit.edu\fR. Bug reports should also be directed
to this list.
.PP
.PP
.PP
.bp
.NH
Electronic\ Mail
.br
.PP
.PP
One of the most prominent uses of networking is electronic mail,
and has been so since the first networks were devised. It started
as a simple service that copied a file from one machine to another,
and appended it to the recipient's \fImailbox\fR file. Basically, this
is still what email is all about, although an ever growing net
with its complex routing requirements and its ever increasing load
of messages transported has made a more elaborate scheme necessary.
.PP
Various standards of mail exchange have been devised. Sites
on the Internet adhere to one laid out in RFC 822, augmented
by some RFCs that describe a machine-independent way of transferring
special characters, and the like. Much thought has also been given
recently to ``multi-media mail'', which deals with including
pictures and sound in mail messages. Another standard, X.400, has
been laid down by CCITT.
.PP
In this chapter, we will deal with what email is and what issues you
as an administrator will have to deal with.  Actual configuration
details are covered throughout the next chapter.
.PP
.PP
.NH 2
What\ is\ a\ Mail\ Message?
.br
.PP
.PP
A Mail message generally consists of a message body, which
is the text the sender wrote, and special data specifying
recipients, transport medium, etc., very much like what
you see when you look at a letter's envelope.
.PP
This administrative data falls into two categories; in the first
category is any data that is specific to the transport medium, and
which may be regenerated by the transport software as the message is
passed along. In UUCP networks, the \fIroute\fR belongs here. 
In its entirety, this data is generally referred to as the \fIenvelope\fR.
.PP
The second variety is any data necessary for handling the mail message,
which is not particular to any transport mechanism. It is often used
to generate the envelope data, or to determine the message's sender.
In most networks, it has
become standard to prepend this data to the mail message.
This is the so-called \fImail header\fR. It is offset from the \fImail body\fR
by an empty line.
.FS 
It is customary to append \fIsignature\fR or \fB.sig\fR to a mail message,
usually containing information on the author, along with a joke or a
motto. It is offset from the mail message by a line containing
``\fB-- \fR''.
.FE
.PP
Most mail transport software in the Un*x world uses a header format
outlined in a document named RFC 822.
.FS 
There are other standards, of course. One more I know of is X.400,
which was issued by the CCITT.
.FE
 Its original purpose was to specify a standard for use in the ARPA Internet,
but since it was designed to be independent from any environment, it has been
easily adapted to other networks, including many UUCP-based networks.
.PP
RFC 822 however is only the greatest common denominator. More recent
standards have been conceived to cope with growing needs as, for example,
data encryption, international character support, and ``multi-media mail''.
.PP
All these standards have in common that the header consists of
several lines, separated by newline characters. A line is made
up of a field name, beginning in column one, and the field itself,
offset by a colon and white space. The format and semantics of each
field vary depending on the field name. A header field may be continued
across a newline, if the next line begins with a \fBTAB\fR.
They may appear in any order.
.PP
Usually, all necessary header fields are generated by the mailer interface
you use, like \fBelm\fR, \fBmush\fR, or \fBmailx\fR. Some however
are optional, and may be added by the user. \fBElm\fR, for example,
allows to edit part of the message header. Others are added by
the mail transport software.
.PP
Typical header field names and their meaning are:
.IP \fBFrom:\fR\ 
This contains the sender's email address,
and possibly the ``real name''. A complete zoo
of formats is used here.
.IP \fBTo:\fR\ 
This is the recipient's email address. 
.IP \fBSubject:\fR\ 
Describes the content of the mail in a few words. At least
that's what it \fIshould\fR do.
.IP \fBDate:\fR\ 
 
The date the mail was sent.
.IP \fBReply-To:\fR\ 
Specifies the address the sender wants the recipient's
reply directed to. This may be useful if you have several accounts,
but want to receive the bulk of mail only on the one you
use most frequently. This field is optional.
.IP \fBOrganization:\fR\ 
The organization that owns the machine from which the mail
originates. If your machine is owned by you privately,
either leave this out, insert ``private'' or some complete
nonsense. This field is optional.
.IP \fBMessage-ID:\fR\ 
A string generated by mail transport on the originating system. It is
unique to this message. An example is
\&\fB<199301111938.AA08057@jti.com>\fR.
.IP \fBReceived:\fR\ 
Every site that processes your mail (including the machines
of sender and recipient) inserts such a field into the header,
giving its site name, a message id, time and date it received
the message, from which site and using which transport software.
This is so that you can trace which route the message took,
and can complain to the person responsible if something
went wrong.
.IP \fBX-\fBanything:\fR\fR\ 
No mail-related programs should complain about any header
which starts with \fBX-\fR. It is used to implement additional features
that have not yet made it into an RFC, or never will.
This is used by the \fBlinux-activists\fR mailing list, for example,
where the channel is selected by the \fBX-Mn-Key:\fR header field.
.PP
The one exception to this structure is the very first line. It starts with the
keyword \fBFrom\fR which is followed by a blank instead of a colon.
It contains the route the message has taken in UUCP
bang-path style, time and date when it was received by the last machine
having processed it, and an optional part specifying which host it was
received from. This field is there for backward compatibilty with some
older mailers, but is not used very much anymore, except by
mail user interfaces that rely on it to mark the beginning of a
message in the user's mailbox. To avoid potential trouble with lines
in the message body that begin with ``\fBFrom \fR'', too, it has become
standard procedure to escape any such occurence by preceding it with
``\fB>\fR''.
.PP
.NH 2
How\ is\ Mail\ Delivered?
.br
.PP
.PP
Generally, you will compose mail using a mailer interface like
\&\fBmail\fR or \fBmailx\fR; or more sophisticated ones like
\&\fBelm\fR, \fBmush\fR, or \fBzmailer\fR. These programs are called
\&\fImail user agents\fR, or MUA's for short. If you send a mail message,
the interface program will in most cases hand it to another
program for delivery. This is called the \fImail transport agent\fR,
or MTA. On some systems, there are different mail transport agents
for local and remote delivery; on others, there is only one.
The command for remote delivery is usually called \fBrmail\fR,
the other \fBlmail\fR.
.FS 
The local mail transfer agent in the SLS distributions of Linux
is Fred van Kempen's \fBwmail\fR.
.FE
.PP
The transport software used depends on the nature of the link.
If the mail must be delivered over a network using TCP, SMTP
is commonly used. SMTP stands for Simple Mail Transfer Protocol.
It is defined in RFC 788 and RFC 821.
.PP
Over UUCP links, one will generally invoke \fBuux\fR to execute
\&\fBrmail\fR on the remote system. However, it is also possible to
produce a batch file that contains the SMTP commands that would normally
be issued when a direct SMTP connection was used. This is called
BSMTP, or \fIbatched\fR SMTP. Then, \fBuux\fR is invoked to execute
a command named \fBrsmtp\fR or \fBbsmtp\fR on the remote system, giving
it this data as input. This program will process the input
as if a normal SMTP connection had occurred.
.PP
The benefit of the latter method is that \fBrmail\fR takes the
envelope on the command line, while \fBrsmtp\fR takes it from
the mail batch. This effectively keeps the shell from misinterpreting
characters as special shell characters when invoking \fBuux\fR or
\&\fBrmail\fR.
.FS 
.PP
Some may recall that this was exactly the problem with \fBsmail-2.5\fR,
which used the \fBsystem()\fR library call to execute \fBuux\fR.
On Linux systems, this caused big trouble since \fBbash\fR's
history mechanism tried to expand any occurences of \fB!user\fR,
so that exclamation marks had to be escaped before sending them to
the shell.
.FE
.PP
.NH 2
Email\ Addresses
.br
.PP
.PP
To send a message to another person, you have to have some way to identify
her to the person or organization delivering the message. This identification
is commonly called an address.
For electronic mail, an address is made up of at least the name of a
machine handling the person's mail, and a user identification recognized
by this system. This may be the recipient's login name, but may also
be anything else. Other mail addressing schemes, like X.400, use a
more general set of ``attributes'' which are used to look up the
recipient's host in an X.500 directory server.
.PP
.PP
.NH 3
Various\ Address\ Formats
.br
.PP
.PP
The way a machine name is interpreted, i.e. at which site your message
will finally wind up, and how to combine this name with the recipient's
user name greatly depends on the network you are on. In the original UUCP
environment, the prevalent form was \fB\fBpath\fR!\fBhost\fR!\fBuser\fR\fR,
where \fB\fBpath\fR\fR described a sequence of hosts the message had to travel
before reaching the destination \fB\fBhost\fR\fR. This construct is called the
\&\fIbang path\fR notation.
.PP
Internet sites adhere to the
RFC 822 standard, which uses a notation of \fB\fBuser\fR@\fBhost.domain\fR\fR,
where \fB\fBhost.domain\fR\fR is the host's fully qualified domain name. The
middle thing is called an ``at'' sign. Because this notation does not
involve a route to the destination host, but gives the (unique) hostname
instead, this is called an \fIabsolute\fR address.
Today, many UUCP-based networks have adopted RFC 822, and will understand
this type of address.
.PP
Now, these two types of addressing don't mix too well. Assume an address
of \fBhostA!user@hostB\fR. It is not clear whether the `\fB@\fR' sign
takes precedence over the path, or vice versa: Do we have to send the
\&\fBhostB\fR, which mails it to \fBhostA!user\fR, or should it be sent to 
message to \fBhostA\fR, which fowards it to \fBuser@hostB\fR?
.PP
Addresses that mix different types of address operators are called
\&\fIhybrid addresses\fR. Most notorious is the above example. It is usually
resolved by giving the path precedence over the `\fB@\fR' sign. In the
above example, this means sending the message to \fBhostA\fR first.
.PP
However, there is a way to specify routes in RFC 822-conformant ways:
\&\fB<@hostA,@hostB:user@hostC>\fR denotes the address of \fBuser\fR on
\&\fBhostC\fR, where \fBhostC\fR is to be reached through \fBhostA\fR
and \fBhostB\fR (in that order). This type of address is freqeuently
called a \fIroute-addr address\fR.
.PP
Then, there is the `\fB\fR' address operator:
\&\fBuserhostB@hostA\fR will first be sent to \fBhostA\fR, which
expands the rightmost (in this case, only) percent sign to an `\fB@\fR'
sign. The address is now \fBuser@hostB\fR, and the mailer will happily forward
your message to \fBhostB\fR which delivers it to \fBuser\fR.
This type of address is sometimes referred to as
``Ye Olde ARPANET Kludge''. It was used on the ARPANET to reach hosts who
were not registered officially with the Network Information Center, so that
messages had to be sent via a mail relay that was known to handle mail for
these ``hidden'' sites.
.PP
Other networks have still different means of addressing. DECnet-based networks,
for example, use two colons as an address separator, yielding an address
of \fB\fBhost\fR::\fBuser\fR\fR.
.FS 
When trying to reach a DECnet address from an RFC 822-environment, you
may use \fB"\fBhost\fR::\fBuser\fR"@\fBrelay\fR\fR, where \fB\fBrelay\fR\fR
is a known Internet-DECnet relay.
.FE
 Lastly, the X.400 standard uses an entirely
different scheme, by describing a recipient's by a set of attribute-value
pairs, like country and organization.
On FidoNet, each user is identified by a code consisting of four numbers,
denoting country, node, point, and user.
.FS 
Is this correct?
.FE
.PP
There are some implications to using these different types of addressing
which will be described throughout the following sections. In a
RFC 822 environment, however, you will rarely use anything
else than absolute addresses like \fBuser@host.domain\fR.
.PP
.NH 3
Bang\ Path\ Addresses
.br
.PP
.PP
When sending mail to a host in a UUCP environment, simply knowing the
user and hostname might not be enough: When you are in Europe
and want to send a message to a person in the United States --- how
should the intermediate sites know where to forward the message to?
In earlier times, the solution was the so-called \fIbang path\fR, being a list
of hosts through which to forward the message, separated by exclamation
marks (`\fB!\fR') and followed by the user's name.
To send a letter to Janet User on a machine named
\&\fBmoria\fR, you would have used the path \fBeek!foo!bar!swim!moria!janet\fR.
This would have sent the mail from your host to \fBeek\fR, from there on
to \fBfoo\fR, and so on, until it finally reached \fBmoria\fR.
The number of machines to traverse before reaching the destination
host is usually referred to as the number of \fInetwork hops\fR.
.PP
This technique is called \fIsource routing\fR, because it leaves the
responsibility of finding a route to the recipient with the sender.
.FS 
Actually, the term \fIsource routing\fR is a bit ambiguous. A different
use of it is to denote a routing scheme that takes the sender address
into account when determining how to process a message. For example,
a mail hub might handle mail for several domains, some of which have
bought IP service, while others have not. Messages originating from a host
in one of the latter domains should not be forwarded over the Internet,
while the others definitely should.
.FE
 This is very different from the way we have seen IP handle routing, where
the actual routing decisions are made by the forwarding
host.
.PP
The obvious drawback of source routing is that it requires you to remember
much about the network topology, fast links, etc.
Second, changes in the network topology ---
like links being deleted or hosts being removed --- may cause messages to
fail simply because you weren't aware of the change. And finally, in case
you move to a different place, you will most likely have to update all these
routes.
One thing, however, that made the use of source routing necessary was
the presence of ambiguous hostnames: For example, if there are two sites
named \fBmoria\fR, one in the U.S., and one in France. Which site now
does \fBmoria!janet\fR refer to? This can be made clear by specifying
what path to reach \fBmoria\fR through.
.PP
The first step in disambiguating hostnames was the founding of
\&\fIThe UUCP Mapping Project\fR. It is located at Rutgers University, and
registers all official UUCP hostnames, along with information on their
UUCP neighbors and their geographic location, making sure no hostname is
used twice. The information gathered by the Mapping Project is published
as the \fIUsenet Maps\fR, which are distributed regularly through Usenet.
.PP
Using the connectivity information provided in the maps,
smart mail software relieves the sender of the message from finding a
path to the recipient host. You only give it the destination address as
\&\fBmoria!janet\fR or \fBjanet@moria.uucp\fR, and using the maps, it is
able to construct a path from your site to \fBmoria\fR.
.PP
This is only a slight variation of source routing, and is sometimes
called \fIsystem routing\fR. Now, the only effect of changes in the
network is that the host's mail routing databases have to be updated.
Usually, they are kept up-to-date by rebuilding them every time
updated UUCP maps are published.
.PP
It is important to know that the bang path routes used by the mail
software do not have to be \fIstrict\fR, that is \fBeek\fR and 
\&\fBfoo\fR from the above example are not required to be direct UUCP
neighbors. This is called \fIloose source routing\fR, and only
requires that the mail transport software on \fBeek\fR is able to
find a route to \fBfoo\fR. For example, \fBeek\fR might have a
UUCP neighbor, \fBernie\fR, which has a link to \fBbert\fR, which
in turn is a neighbor of \fBfoo\fR. The mailer on \fBeek\fR will
then amend the path, so that after processing on \fBeek\fR, the message
would be sent to \fBernie\fR with a new recipient address of
\&\fBbert!foo!bar!swim!moria!janet\fR.
.PP
A benefit of loose routing is that instead of complete paths,
a path from a well-known site to the recipient site suffices. Well-known
means, of course, that all hosts know how to route messages to this site.
For example, \fBuunet\fR is frequently given as a starting
point of routes. When you specify a path starting with
\&\fBuunet\fR, the mail software will try to get the message to \fBuunet\fR,
which will then route your message (or probably no-one will).
For example, you could send your mail to
\&\fBuunet!moria!janet\fR, and leave it to \fBuunet\fR to find a route to
\&\fBmoria\fR. Unnecessary to say that this method is highly inefficient.
.PP
.NH 3
Addresses\ in\ the\ Domain\ Name\ System
.br
.PP
.PP
However, the scheme described above is not really perfect.
Since the beginning of the eighties, the numbers
of sites and computer networks have exploded, so that it is virtually
impossible to keep routing information up to date. Also, many
of the central sites are on the Internet now, where routing is
completely different from a UUCP network. Last but not least, site
names on UUCP networks are generally limited to seven, or at most
eight characters, so there is some shortage of names.
.FS 
For example, forget about any names from `folklore' books, like
\&\fIThe Lord of the Rings\fR, or \fIThe Hitchhiker's Guide to the Galaxy\fR.
.FE
.PP
Therefore, host names have been organized in a hierarchy of \fIdomains\fR,
as described in section See section The Domain Name System.:
A domain is a collection of sites that are related in some sense ---
be it because they form a proper network (e.g. all machines on a
campus, or all hosts on BITNET), because they all belong
to a certain organization (like the U.S. government), or because
they're simply geographically close. Such a domain may itself be part
of a larger domain, which is in turn part of an even larger domain.
This relationship is described as being a \fIsubdomain\fR of the
larger domain. To produce a unique address for each machine,
names inside a domain must be unique. Assume the owners of \fBmoria\fR
join a small non-profit organization, say Orcs And Thugs Association,
running a network of UUCP sites and paying to other organizations for
access to internation mail services. The network run by them may be
called \fBorcnet\fR, and because they are a some unspecified sort 
of organization, they are located below the \fBorg\fR top-level
domain. Thus, \fBmoria\fR's proper name would be \fBmoria.orcnet.org\fR.
This is called its \fIfully qualified domain name\fR, and
uniquely determines the site.
.PP
Now, Janet's address would be \fBjanet@moria.orcnet.org\fR.
However, most sites also understand it when you use domain names 
in bang paths, like \fBswim.two.birds!moria.orcnet.org!janet\fR.
Note that there are still UUCP sites that are not part of any domain.
These are considered part of the pseudo-domain \fB.uucp\fR.
.PP
The domain name system brings another type of routing to UUCP-based
networks. A domain, say \fBfoobar.com\fR, may decide to publish only a
number of its UUCP sites, and hide the internal network. Now these public
sites may be used as gateways to the internal network: any message to an
unknown site below the domain \fB.foobar.com\fR will be sent to one of the
gateways, which is assumed to forward the message properly.
.PP
This method is called \fIdomain-based routing\fR. It is primarily useful
for large domains, because this allows it to change its internal
routing strategy without updating any map entry at the UUCP Mapping Project.
New routing information only has to be propagated to the member sites of the
domain, which makes it much more flexible. Inside the domain, any routing
scheme may be used: through maps distributed inside the domain, a
routing scheme based on the subdomain name, or some sort of geographically
based routing.
.PP
.NH 2
How\ does\ Mail\ Routing\ Work?
.br
.PP
.PP
The process of directing a message to the recipient's host is
called \fIrouting\fR. Apart from finding a path from the sending site to
the destination, it involves error checking as well as speed and
cost optimization.
.PP
There is a big difference between the way a UUCP site handles
routing, and the way an Internet site does. On the Internet,
the main job of directing data to the recipient host (once it is known
by it's IP address) is done by the networking layer (usually running
the IP protocol), while in the UUCP zone, it has to be supplied by the user,
or must generated by the mail transfer agent.
.PP
.PP
.NH 3
Mail\ Routing\ in\ UUCP\ networks
.br
.PP
.PP
Compared to the Internet, routing in UUCP-based networks is rather
static. It generally happens by means of a so-called
\&\fIpaths\fR file. This is a file that translates host or domain names
to UUCP bang paths.
.PP
On larger systems, this database is often generated
from the UUCP maps distributed through Usenet.
.FS 
Maps for sites registered with The UUCP Mapping Project are distributed
through the newsgroup \fBcomp.mail.maps\fR; other organizations may publish
separate maps for their network.
.FE
 There is a tool for converting these maps, called \fBpathalias\fR. For
this reason, the paths file is also sometimes referred to as the pathalias
database.
.PP
A map is simply a file containing a list of UUCP systems, for each site
listing its location, any aliases or fully qualified domain names, and the
sites it is linked to. Links
are weighted with a certain \fIcost\fR. This is a symbolic cost computed from
the speed and frequency of the connection (see section See section Pathalias.).
From the map files, a program called \fBpathalias\fR creates a list
of paths from your site to each system in the maps.
.PP
If you are a small leaf site and you're only connected to one site that
provides you with mail and news, no paths file will be necessary at all.
That is, the only routing you do is to accept any mail that is
destined for you, and send anything else to your feed, which will route it
for you. Therefore, there is no need to maintain any routing information
from UUCP maps, because your feed will take care of that.
.PP
But even on most sites that do routing, not all addresses can be known.
Therefore, messages to an unknown address are passed on to a site that is
supposedly ``smarter'' and might know how to get the message to the
recipient.  This is called \fIsmart host routing\fR.
.FS 
One can view smart host routing as a variant of domain-based
routing, namely for the root domain ``\fB.\fR''. In fact, this is the way
it is implemented in some mailers, e.g. Fred van Kempen's \fBumail\fR.
.FE
 Of course this does not apply to addresses you know you should be able
to resolve. For example, if your site has complete routing information
on the domain \fBorcnet.org\fR, and there is no site named
\&\fBbush.orcnet.org\fR, you will certainly return any mail for that
address instead of routing it to the smart host. One says
that your site is \fIauthoritative\fR for the domain \fBorcnet.org\fR.
.PP
Therefore, if you need to do routing for a small number of sites, a
hand-written paths file (or one generated from a hand-written maps file)
that handles mail for them but sends everything else to a smart host,
may still be a safe bet.
.PP
.NH 3
Mail\ Routing\ on\ the\ Internet
.br
.PP
.PP
On the Internet, little static routing information is
available locally because of the overhead distributing this 
information would involve. Instead, the Internet Domain Name Service
(or DNS for short) is used, which is a distributed database describing
the net topology.
.FS 
This is described in section See section The Domain Name System..
For more information on the Internet domain name system,
refer to RFC 1034 and RFC 1035, and documentation on \fBnamed\fR.
.FE
 A host name is \fIresolved\fR (i.e. converted to an IP address) by a
query to the local \fIname server\fR, usually called \fBnamed\fR on Un*x
systems.  Given a fully qualified domain name, it tries to find the
corresponding IP address
using the information it has in its cache. If it doesn't, it may
pass on the query to another name server that may have more information.
.PP
Many Internet service providers also offer mail and news transport services
to sites and networks that are not on the Internet. To make this fact known,
they publish a so-called \fBMX\fR record for these sites or domains.
.FS 
\&\fBMX\fR stands for Mail Exchanger. It is a resource record type
in the DNS database.
.FE
 It basically states that this site is willing to act as a mail
forwarder for these sites. \fBMX\fR records may also be used by
large organizations that want to have all their mail traffic handled
by a limited number of special hosts only (i.e. \fIgateways\fR). These
will have \fBMX\fR records for the whole domain.
.PP
An organization, say Foobar Inc., won't allow most of their machines to be
on the Internet directly because of security reasons.
Hence a message from \fBjanet@groucho.edu\fR
to \fBjoe@missile-lab.foobar.com\fR cannot be delivered directly, because
the host \fBmissile-lab\fR may be shut off from any IP-traffic to outside
of \fBfoobar.com\fR. But another of Foobar's hosts, say
\&\fBgateway.foobar.com\fR, will be on the Internet, and it will have
an \fBMX\fR record set for the domain \fBfoobar.com\fR.
A mail transport agent on \fBgroucho.edu\fR will therefore send the
message to the gateway, which will deliver it to
\&\fBjoe@missile-lab\fR.
.FS 
Note that the mailer might generate an envelope address that specifies
the route the message should take. In our example it would look
something like
\&\fB<@gateway.foobar.com:joe@missile-lab.foobar.com>\fR.
Specifying a path in this syntax is called \fIsource routing\fR,
or \fIroute-addr address\fR.
These expressions can be made arbitrarily complex.
.FE
 \fBMX\fR records also have a \fIpreference\fR associated with them.
This is a positive integer. If several mail exchangers exist for one
host, the mailer will try to transfer the message to the exchanger with
the lowest precedence value, and only if this fails will it try a host with
a higher value.
.PP
Another type of resource record that is of interest to mail routing is
the \fBWKS\fR, or \fIwell-known service\fR record. On TCP/IP-based
networks, peer processes generally connect to each other by attaching
to a \fIport\fR on the remote host. The default port
.FS 
There are a number of widely-used Internet services that have default
numbers; they are called \fIwell-known services\fR. The assignment
of numbers is regularly relased as an RFC, titled ``Assigned Numbers''.
The latest release is RFC 1060.
The assignment of serives to port numbers on your machine is stored in 
a file name \fB/etc/services\fR.
.FE
 for SMTP connection is port 25. If however a site is using a different
port number for SMTP, it may make this (as well as other ports to well-known
services) known using the \fBWKS\fR record.
.FS 
For more information on the way mail routing in the Internet works,
please refer to RFC 974.
.FE
.PP
.NH 2
Pathalias\ and\ Map\ File\ Format
.br
.PP
 
A pathalias database is used to map site names to UUCP bang paths.
This provides the main routing information in UUCP-based networks.
A typical entry qould look like this (site name and path are
separated by a TAB):
.PP
.QP
.nh
.DS
.ft CW
uunet           moria!ernie!bert!s
uunet.uu.net    moria!ernie!bert!s
 
.DE
.ft R
\&\&
.PP
This makes any message to \fBuunet\fR be delivered via \fBmoria\fR,
\&\fBernie\fR and \fBbert\fR. Both \fBuunet\fR's fully qualified name
and its UUCP name have to be given if the mailer does not have a
seperate way to map between these name spaces.
.PP
If you want to direct all messages to hostnames below a certain domain 
to a given relay, you may also specify a path in the pathalias database,
giving the domain name as target, preceded by a dot. For example, if
Fidonet may be reached through \fBswim!fidogate\fR, a pathalias entry
might look like this:
.PP
.QP
.nh
.DS
.ft CW
\&\&.fidonet        swim!fidogate!s
 
.DE
.ft R
\&\&
.PP
Writing a pathalias file is only acceptable when you are running
a very small site that does not have to do much routing. A better way
is to create a pathalias file from so-called map files using the
\&\fBpathalias\fR tool.
.PP
A map file mainly consists of a list of systems, for each
of them listing the sites it polls or is polled by.
The system name begins in column one, and is followed
by a comma-separated list of links. The list may be continued
across newlines if the next line begins with a tab. Each link
consists of the name of the site, followed by a cost given in
brackets. The cost is an arithmetic expression, made up of
numbers and symbolic costs. Lines beginning with a hash sign
(`#') are ignored.
.PP
Routing information for all sites registered with the UUCP Mapping
Project is regularly posted to \fBcomp.mail.maps\fR, and allows you to
produce a pathalias database for all systems listed therein. However,
this information is rarely accurate or complete, so that you should
either leave routing to major sites, or rely on special maps
distributed by your network providers.
.PP
As an example, consider the site \fBmoria\fR. It polls site
\&\fBswim.two.birds\fR twice a day, \fBmordor.orcnet.org\fR hourly,
and once per week \fBsnorkel.com\fR. Moreover, the link to \fBsnorkel\fR
only uses a slow 2400 Baud modem, while the link to \fBmordor\fR
is at 14400. Then its map entry would be something like
.PP
.QP
.nh
.DS
.ft CW
moria.orcnet.org
        swim.two.birds(DAILY/2),
        mordor.orcnet.org(HOURLY+FAST),
        snorkel.com(WEEKLY+LOW)
\&\&
moria.orcnet.org = moria
 
.DE
.ft R
\&\&
.PP
The last line would make it known under its UUCP name, too.
Note that it must be \fBDAILY/2\fR, because calling twice a day actually
halves the cost for this link.
.PP
Using the information from such map files, \fBpathalias\fR is able
to calculate ``optimal'' routes to any destination site listed in the
paths file, and produce a pathalias database from this which can then
be used for routing to these sites.
.PP
\&\fBpathalias\fR provides a couple of other features like site-hiding
(i.e. making sites only accessible through a gateway) etc. See the manual
page for \fBpathalias\fR for details, as well as a complete list of
link costs.
.PP
The comments in the map file generally contain additional
information on the sites described in it. There is a rigid format
in which to specify this, so that it can be retrieved from the maps.
E.g., there is a program called \fBuuwho\fR, which uses a database
created from the map files to display this information nicely formatted.
.PP
When you register your site with an organization that distributes map files
to its members, you generally have to fill out such a map entry.
.PP
Below is given an example for a map entry (in fact, it's the one for my site):
.PP
.QP
.nh
.DS
.ft CW
#N      monad, monad.swb.de, monad.swb.sub.org
#S      AT 486DX50; Linux 0.99
#O      private
#C      Olaf Kirch
#E      okir@monad.swb.de
#P      Kattreinstr. 38, D-64295 Darmstadt, FRG
#L      49 52 03 N / 08 38 40 E
#U      brewhq
#W      okir@monad.swb.de (Olaf Kirch); Sun Jul 25 16:59:32 MET DST 1993
#
monad   brewhq(DAILY)
# Domains
monad = monad.swb.de
monad = monad.swb.sub.org
 
.DE
.ft R
\&\&
.PP
The white space after the first two characters is a \fBTAB\fR.
The meaning of most of the fields is pretty obvious; you will receive
a detailed description from whichever domain you register with.
The \fBL\fR field is the most fun to find out: it gives your geographical
position in latitude/logitude and is used to draw the postscript maps
that show all sites for each country, as well as world-wide.
.FS 
They are posted regularly in \fBnews.lists.ps-maps\fR. Beware. They're
HUGE.
.FE
.PP
.NH 2
Message\ Grading
.br
.PP
.PP
To distinguish between important and less important mail, it is
possible to assign a \fIgrade\fR to the message. The mail
transport software may (or may not) evaluate this information,
and probably use different transports depending on its value. For example,
very urgent mail might be forwarded immediately, while ordinary
mail is queued until the next regular contact is established. Also,
treatment in case of an error may vary: normally, an undeliverable
message will ``bounce'' and be returned to the sender in its entirety.
Junk mail, on the other hand, could be thrown away without notice.
.PP
Normally, the message grade is extracted from a header field named
\&\fBPrecedence:\fR. It may contain a number of predefined tokens;
if it doesn't exist, or contains an unknown token, the mailer will
generally assume a default grade.
.PP
The tokens most widely used (because \fBsendmail\fR understands them)
are, in decreasing order: \fBspecial-delivery\fR, \fBfirst-class\fR,
and \fBjunk\fR. Other mailers, like \fBsmail\fR, add more tokens, or 
even allow for the definition of your own set of tokens. However, it
is up to the administrator's whim what treatment she assigns to these
tokens. She may even decide to give all of them equal precedence.
.PP
In the UUCP zone, message grades may be used easily to assign 
different service quality, by mapping them onto UUCP spool grades
(see section See section UUCP Transfers and Remote Execution.). The UUCP spool grade
determines at what times the message may be transferred, and hence
how fast it travels to the next node. It is, however, up to the
next node what level of service it assigns to the message's precedence.
.PP
.NH 2
Mail\ Software\ Configuration
.br
.PP
.PP
There are a number of mail transport agents that have been implemented
for Un*x systems. One of the best-known is the University of Berkeley's
\&\fBsendmail\fR, which is used on a number of platforms. The list of people
having contributed to it is very long, and there isn't one single author.
There are two ports of \fBsendmail-5.56c\fR to Linux available, one of which
will be described below.
.PP
The mail agent commonly used with Linux is \fBsmail-3.1.28\fR, written
and copyright by Curt Landon Noll and Ronald S. Karr. This is the one
included in the SLS release and Ed Carp's mailpak package.
In the following, we will refer to it simply as \fBsmail\fR, although
there are other versions of it which we don't describe here.
.FS 
Most noticeably, version 2.5 has been in Ian Taylor's official distribution
of the source code of Taylor UUCP 1.03. The only thing it has in common
with \fBsmail-3.1.28\fR is the name.
.FE
.PP
Compared to \fBsendmail\fR, \fBsmail\fR is rather young. When handling mail
for a small site without complicated routing requirements (say, between
networks using different addressing schemes), their capabilities are pretty
close. For large sites, however, \fBsendmail\fR always wins, because it
supports addressing formats like DECnet, etc.
.PP
Both \fBsmail\fR and \fBsendmail\fR support a set of configuration files
that have to be customized. Apart from the information that is required to
make the mail subsystem run (such as the local hostname), there are many
more parameters that may be tuned.
.PP
\&\fBsendmail\fR's main configuration file is \fBsendmail.cf\fR. It looks
as if your cat had taken a nap on you keyboard while pressing the shift
key.
.FS 
There's a saying that you aren't a real programmer if you haven't
hacked a \fBsendmail.cf\fR file once; but if you've done it twice,
you must be crazy.
.FE
 However, there's an extension to \fBsendmail\fR, called \fBIDA\fR,
that provides for easier configuration. This is a tool based on the
\&\fBm4\fR macro processor that turns simple configuration files into
complex \fBsendmail.cf\fR files. One of the \fBsendmail\fR ports
comes with support of IDA configuration files, which is why I describe
it here.
\&\fBsmail\fR configuration files are more structured and easier to
understand than \fBsendmail\fR's, but don't give the user as much
power in tuning the mailer's behavior.
However, for small UUCP sites the work required in setting up any of them
is roughly the same.
.PP
The next two chapters will describe a simple setup for both mailers.
It will however not give a full treatment of all options, but will focus
on the options the ``average'' Linux site will need. These will be sites
running UUCP as transport software, as well as sites on a LAN.
There are many more options, and you can spend many happy hours
in front of your computer configuring the fanciest features.
.PP
In chapters See section Configuring smail. and See section sendmail., we will give instructions on
setting up \fBsmail\fR and \fBsendmail\fR for the first time.
The information provided there should suffice to get a UUCP-only leaf site
operational.
.FS 
A \fIleaf site\fR is a site having only one link, without any
foreign mail being routed through it.
.FE
 The remainder of the current chapter will give you a short introduction
to setting up \fBelm\fR, the common mail user agent on many Un*xish
systems, including Linux.
.PP
.NH 2
Configuring\ \fBelm\fR
.br
.PP
.PP
\&\fBelm\fR apparently stands for ``electronic mail'' and is one of the
more reasonably named Un*x tools. It provides a full-screen interface
with a good help feature, so we won't discuss here how to use \fBelm\fR,
but will only dwell on its configuration options.
.PP
.PP
.PP
Theoretically, you can run \fBelm\fR unconfigured, and everything 
works well --- if you are lucky. There are however a few options
that must be set, although only required on occasions.
.PP
When started, \fBelm\fR reads a set of configuration variables from
the \fBelm.rc\fR file in \fB/usr/local/lib/elm/\fR. Then, it will attempt to read the
file \fB.elm/elmrc\fR in your home directory. This file usually does not
exist, but is created when you choose ``save options'' from \fBelm\fR's
options menu.
.PP
In both files, the same 
The set of options for the private \fBelmrc\fR file is also available
in the global \fBelm.rc\fR file. Settings in your private \fBelmrc\fR
file override those of the global file.
.PP
.NH 2
Global\ \fBelm\fR\ Options
.br
.PP
.PP
In the global \fBelm.rc\fR file, you must set the options that pertain
to your host's name. For example, at the Virtual Brewery, the file
for \fBvlager\fR would contain the following:
.PP
.QP
.nh
.DS
.ft CW
#
# The local hostname
hostname = vlager
#
# Domain name
hostdomain = .linus.lxnet.org
#
# Fully qualified domain name
hostfullname = vlager.linus.lxnet.org
 
.DE
.ft R
\&\&
.PP
These options set \fBelm\fR's idea of the local hostname. Although this
information is rarely used, you should set these opzions nevertheless.
Note that these options only take effect when giving them in the global
configuration file; when found in your private \fBelmrc\fR, they will
be ignored.
.PP
.NH 2
\&\fBelm\fR\ and\ National\ Character\ Sets
.br
.PP
.PP
Recently, there have been proposals to amend the RFC 822 standard
to support various types of messages, such as plain text, binary
data, Postscript files, etc.
.FS 
Detailed in RFC 1049 (Content-Type: header field) and RFC 1154
(Encoding header field).
.FE
 This also allows to notify the recipient if a character set other
than standard ASCII has been used when writing the document,
for example using French accents, or German umlauts.
This is supported by \fBelm\fR to some extent.
.PP
The character set used by Linux internally to represent characters
is usually referred to ISO-8859-1, although this is the name of the
corresponding standard. Any message using characters from this character
set should have the following line in its header:
.PP
.QP
.nh
Content-Type: text/plain; charset=iso-8859-1
.PP
The receiving system should recognize this field and take appropriate
measures when displaying the message. The default for \fBtext/plain\fR
messages is a \fBcharset\fR value of \fBus-ascii\fR.
.PP
To be able to display messages with character sets other than ASCII,
\&\fBelm\fR must know how to print these characters. By default, when
\&\fBelm\fR receives a message with a \fBcharset\fR field other than
\&\fBus-ascii\fR
.FS 
Or a content type other than \fBtext/plain\fR, for that matter.
.FE
, it tries to display the message using a command called
\&\fBmetamail\fR. Messages that require \fBmetamail\fR to be displayed
are shown with an `\fBM\fR' in the very first column in the overview
screen.
.PP
Since Linux' native character set is ISO-8859-1, however,
calling \fBmetamail\fR is not necessary to display messages using this
character set. If \fBelm\fR is told
that the display understands ISO-8859-1, it will not use
\&\fBmetamail\fR and display the message directly instead. This can be
done by setting the following option in the global \fBelm.rc\fR:
.PP
.QP
.nh
displaycharset = iso-8859-1
.PP
Note that you should set this option even when you are never going to
send or receive any messages that actually contain characters other than
ASCII. This is because people who do send such messages usually configure
their mailer to put the proper \fBContent-Type:\fR field into the
mail header by default, whether or not sending ASCII-only messages.
.PP
Secondly, please note that this does not work. Tough luck, isn't it?
The problem is that when dislaying the message with its builtin
pager, \fBelm\fR calls a library function for each character to be
printed to determine whether it is printable or not. By default,
this function will only recognize ASCII characters as printable, and
display all other characters as ``\fB^?\fR''.
Usually, this function's behavior can be changed by setting the
\&\fBLC_TYPE\fR environment variable to your national language.
E.g. setting it to \fBfrench\fR will cause the function to recognize
all french special characters as printable. This feature, however,
has not been implemented in the standard C library yet.
.FS 
As of this writing, \fBlibc\fR is at release 4.4.1.
.FE
.PP
When sending messages that contain special characters from ISO-8859-1,
you should make sure to set some more variables in the \fBelm.rc\fR file:
.PP
.QP
.nh
charset = iso-8859-1
textencoding = 8bit
.PP
This makes \fBelm\fR report the character set as ISO-8859-1 in the
mail header, and send it as an 8 bit value (the default is 7 bit).
.PP
Of course, any of these options can also be set in the private \fBelmrc\fR
file instead of the global one.
.PP
.PP
.PP
.PP
.PP
.bp
.NH
Getting\ \fBsmail\fR\ Up\ and\ Running
.br
.PP
.PP
.PP
.PP
.NH 2
Introduction
.br
.PP
.PP
This chapter will give you a quick introduction to setting up \fBsmail\fR,
and an overview of the functionality it provides. Being mainly
compatible to sendmail in its behaviour, its configuration
files are completely different.
.PP
The main configuration file is the \fB/usr/local/lib/smail/\fR/\fBconfig\fR.
You always have to edit this file to
reflect values specific to your site. If you are only a UUCP leaf site,
you will have relatively little else to do, ever.
.PP
Other configuration files that allow to configure routing and
transport options may also be used; section See section Mail Delivery with smail.
below will shortly dwell on this.
.PP
\&\fBsmail\fR is able to handle both UUCP-based mail as well as 
delivery over SMTP using TCP/IP services. Depending on the amount
of traffic you expect to have, you may also consider to queue all
incoming mail and process it at regular intervals, or always
deliver it immediately. If you choose to queue messages, \fBsmail\fR
will store away incoming mails below \fB/usr/spool/smail/\fR and not process
them until you explicitly tell it to. Refer to section See section More config variables.
on how to enable spooling.
.PP
Even when delivering immediately,
\&\fBsmail\fR will occasionally put messages into the queue when it
finds immediate delivery fails for a transient reason. For SMTP
connections, this may be an unreachable host; but messages may
also be deferred when the file system is found to be full.
.PP
If you want to further dig into this topic, please refer to the
manual page \fBsmail(5)\fR. If it isn't included in the SLS or the
\&\fBmailpak\fR distribution, get the source to \fBsmail\fR.
.FS 
Maybe I will also release an earlier version of this chapter as a
stand-alone reference to \fBsmail\fR that has detailed information
on writing the \fBrouters\fR, \fBdirectors\fR and \fBtransports\fR
configuration files.
.FE
.PP
.NH 2
UUCP\ Setup
.br
.PP
.PP
In the SLS \fBsmail\fR distribution, you will find a file named
\&\fBconfig.sample\fR in \fB/usr/local/lib/smail/\fR.  Make a copy called \fBconfig\fR and edit
it. It contains three statements:
.QP
.nh
.DS
.ft CW
#
# visible_domain list the domains (primary first) we say we're in
#
visible_domain=sea.wa.us:uucp
#
# next is the name in our headers
#
visible_name=victrola.sea.wa.us
#
# this is the path to our smarthost (this could be sysa!sysb!sysc etc.)
#
smart_path=quick
 
.DE
.ft R
\&\&
.PP
This is a sample file from Vince Skahan's site. You must change these
values, or else Vince will receive all replies to your mail.
.PP
The first statement tells \fBsmail\fR about the domains your site belongs to.
Insert their names here, separated by colons. If your site name is
registered in the UUCP maps, you should also add \fBuucp\fR.
When being handed a mail message, \fBsmail\fR determines your
host's name using the \fBhostname(2)\fR system call, and checks the
recipient's address against this hostname, tacking on all names
from this list in turn. If the address matches either one of these names, or
the unadorned hostname, the recipient is considered local. Otherwise,
the recipient is considered remote.
.PP
\&\fBvisible_name\fR should contain a single, fully qualified domain name
of your site that you want to use on outgoing mails. This name
is used when generating the sender's address on all outgoing mail.
You must make sure to use a name that \fBsmail\fR recognizes as
local (e.g. the hostname with one of the domains listed in the
\&\fBvisible_domain\fR attribute). Otherwise, replies to your mails will
bounce off your site.
.PP
The last statement sets the path used for smart-host routing (described
in See section Mail routing.). With this sample setup, \fBsmail\fR will forward
any mail for remote addresses to the smart host. The path specified in the
\&\fBsmart_path\fR attribute will be used as a route to the smart host.
Messages will be delivered via UUCP, therefore the attribute must specify
a system known to your UUCP software. Please refer to chapter See section Managing UUCP.
on making a site known to UUCP.
.PP
Assume your site is named \fBswim.two.birds\fR, and is registered
with the maps as \fBswim\fR. Your smarthost is \fBulysses\fR.
Then your config file should look like this:
.PP
.QP
.nh
.DS
.ft CW
# Our domain names
visible_domain=two.birds:uucp
# Our name on outgoing mails
visible_name=swim.two.birds
# Use this as uucp-name as well
uucp_name=swim.two.birds
# Our smarthost
smart_host=ulysses
 
.DE
.ft R
\&\&
.PP
There's one option used in the above file that we haven't explained yet;
this is \fBuucp_name\fR. The reason to use this option is this:
By default, \fBsmail\fR uses the value returned by \fBhostname(2)\fR
for UUCP-specific things such as the return path given in the ``\fBFrom \fR''
header line. If your hostname is \fInot\fR registered with the UUCP
mapping project, you should tell \fBsmail\fR to use your fully qualified
domain name instead.
.FS 
The reason is this: Assume your hostname is \fBmonad\fR, but is not
registered in the maps. However, there is a site in the maps called
\&\fBmonad\fR, so every mail to \fBmonad!root\fR, even sent from a direct
UUCP neighbor of yours, will wind up on the other \fBmonad\fR. This is
a nuisance for everybody.
.FE
 This can be done by adding the \fBuucp_name\fR option to
the \fBconfig\fR file.
.PP
There is another file in \fB/usr/local/lib/smail/\fR, called \fBpaths.sample\fR. It
is an example what a \fBpaths\fR file might look like. However, you
will not need one unless you have a mail link to more than one site.
If you do, however, you will have to write one yourself, or generate one
from the Usenet maps (see section See section Pathalias.). Please refer
to section See section paths. for an explanation of the \fBpaths\fR
file. 
.PP
.NH 2
Setup\ for\ a\ LAN
.br
.PP
.PP
If you are running a site with two or more hosts connected by a LAN,
you will have to select one host that handles your UUCP connection
with the outside world. Between the hosts on your LAN, you will most
probably want to exchange mail via SMTP. Assume we're back at the
Virtual Brewery again, and \fBvstout\fR is set up as the UUCP
gateway. This section will show you an example how to set up the
configuration files. To make your setup work, you should also read
the following section See section Invoking smail..
.PP
The configuration files used for the different hosts are as follows:
on all hosts except for the UUCP gateway (\fBvstout\fR), the \fBsmart_path\fR
attribute should point to \fBvstout\fR. On \fBvstout\fR itself, it should point
to the real smart host that routes the Brewery's mail, \fBmoria\fR.
.PP
In a networked environment, it is best to keep all user mailboxes on a single
file system, which is NFS-mounted on all other hosts. This allows users
to move from machine to machine, without having to move their mail around
(or even worse, check some three or four machines for newly-arrived mail
each morning). Therefore, one might also want to make sender addresses
independent from the machine the mail was written on. Janet User, for
example, could now specify \fBjanet@linus.lxnet.org\fR instead of 
\&\fBjanet@vale.linus.lxnet.org\fR. To achieve this, 
all hosts use the domain name as \fBvisible_name\fR attribute,
instead of their proper hostnames. Of course, one of the machines on
\&\fBlinus.lxnet.org\fR will have to recognize the domain's
name as one of its own names. One will naturally choose the UUCP
gateway for this.
.PP
The standard \fBconfig\fR file for hosts other than \fBvstout\fR looks
like this:
.QP
.nh
.DS
.ft CW
# Our domain:
visible_domain=linus.lxnet.org
# What we name ourselves
visible_name=linus.lxnet.org
# Smart-host routing: via SMTP to vstout
smart_path=vstout
smart_transport=smtp
 
.DE
.ft R
\&\&
.PP
On the UUCP mail gateway \fBvstout\fR, the \fBconfig\fR file would
look like this:
.PP
.QP
.nh
.DS
.ft CW
# Our hostnames:
hostnames=linus.lxnet.org:vstout.linus.lxnet.org:vstout
# What we name ourselves
visible_name=linus.lxnet.org
# in the uucp world, we're known as linus.lxnet.org
uucp_name=linus.lxnet.org
# Smart transport: via uucp to moria
smart_path=moria
smart_transport=uux
# we're authoritative for our domain
auth_domains=linus.lxnet.org
 
.DE
.ft R
\&\&
.PP
This \fBconfig\fR file uses a different scheme to tell \fBsmail\fR
the list of local hostnames. Instead of giving it a list of domains
and letting it find the hostname with a system call, it gives an
explicit list. This is because we want to include the domain name
in the list. Now, \fBjanet@linus.lxnet.org\fR is a valid address,
provided there is a user account for \fBjanet\fR (or an alias).
.PP
The \fBauth_domains\fR variable names the domains for which
\&\fBvstout\fR is considered to be authoritative. That is, if \fBsmail\fR
receives any mail addressed to \fB\fBhost\fR.linus.lxnet.org\fR, but
\&\fBhost\fR is not a local machine, it rejects the message and returns
it to the sender.
If this entry isn't present, any such message will be sent to
the smart-host, who will return it to \fBvstout\fR, and so on
until it is discarded for exceeding the maximum hop count.
.PP
.NH 2
Invocation\ and\ Command\ Line\ Options
.br
.PP
.PP
To be able to send and receive mails, you should first make sure
you have a command named \fBrmail\fR. When using \fBsmail\fR, you
should make this a link to the \fBsmail\fR binary. For example,
if you keep the latter in \fB/usr/local/bin\fR, go to the \fB/bin\fR
directory and type
.PP
.QP
.nh
# ln /usr/local/bin/smail rmail
.PP
When composing and sending a mail message with a user agent like
\&\fBelm\fR, the message will be piped into \fBrmail\fR for delivery,
with the recipient list on the command line. The same happens with
mail coming in viaa UUCP link.
.PP
There are, however, a number of other names \fBsmail\fR may be linked
to. Among them are \fBrsmtp\fR, which is analoguous to \fBrmail\fR, but
is for receiving SMTP batches, and \fBsmtpd\fR which makes it
act as SMTP server when invoked from the \fBinetd\fR server.
.PP
For queue operation, it may also be invoked as \fBmailq\fR, which displays
the mail queue, and \fBrunq\fR, which makes it process the queue.
.PP
Finally, it may be linked to \fBsendmail\fR, which makes it behave
in a way compatible to the original Berkeley \fBsendmail\fR.
.PP
All of these commands accept a common set of command line options;
only \fBrmail\fR and \fBrsmtp\fR are restricted in what they accept.
The list below does not attempt to be complete.
.PP
.IP \fB-bd\fR\ 
Run in daemon mode. With this option, \fBmail\fR will put itself
in the background, and wait for a connection to occur on the
\&\fBsmtp/tcp\fR port. When a connection occurs, it forks and
conducts an SMTP conversation with the peer process.
.IP
.IP \fB-bp\fR\ 
List information about the messages currently in \fBsmail\fR's
queue directories. This option is on by default for \fBmailq\fR.
.IP
.IP \fB-bS\fR\ 
Accept SMTP commands on standard input, but don't produce
SMTP replies. This option is on by default for \fBrsmtp\fR.
.IP
.IP \fB-v\fR\ 
Be verbose. The option may be followed by a number, indicating
the level of verbosity. This option is equivalent to \fB-d\fR.
.IP
.IP \fB-q\fBinterval\fR\fR\ 
When running \fBsmail\fR in daemon mode (\fB-bd\fR option),
this specifies the intervals at which \fBsmail\fR will run
the queue.
.IP
If \fB\fBinterval\fR\fR is a single number, it is
taken to be the interval in seconds. You may, however, also
use values like \fB2h30m\fR, which denotes 2 and a half hours.
If \fB\fBinterval\fR\fR is omitted altogether, a single queue run
is performed, which is equivalent to invokig \fBrunq\fR.
.IP
.IP \fB-bR\fR\ 
The manpage says on this option: ``Enter the hostile domain
of giant mail messages, and RFC standard scrolls. Attempt to
make it down to protocol level 26 and back.'' If you know what
Rogue is, this will probably sound familiar to you.
.IP
.PP
For delivering mail over UUCP link, the above is almost enough. You
should only make sure to run the queue once or twice a day to flush out
any deferred messages. For example, you may add an invocation of
\&\fBrunq\fR to the super-user's crontab.
.PP
For SMTP to work, you should make sure you have
the following entry in your \fB/etc/services\fR file:
.PP
.QP
.nh
.DS
.ft CW
smtp            25/tcp          # Simple Mail Transfer Protocol
 
.DE
.ft R
\&\&
.PP
To serve incoming SMPT requests, you either need to set up \fBinetd\fR
to manage the \fBsmtp\fR port, or run \fBsmail\fR in daemon mode. 
If you want to use \fBinetd\fR, your \fB/etc/inetd.conf\fR file
should contain
.PP
.QP
.nh
.DS
.ft CW
smtp    stream  tcp nowait  root  /usr/bin/smtpd smtpd
 
.DE
.ft R
\&\&
.PP
Remember you have to make \fBinetd\fR re-read this file by sending
a \fBHUP\fR signal to \fBinetd\fR after making these changes.
.PP
If mail traffic inside your LAN is high, you may instead start \fBsmail\fR
in daemon mode (you should then make sure any \fBsmtp\fR entry in
\&\fB/etc/inetd.conf\fR is commented out). To start a \fBsmail\fR daemon,
you invoke it from \fB/etc/rc.d/rc.inet2\fR by
.PP
.QP
.nh
.DS
.ft CW
/usr/local/bin/smail -bd -q15m
 
.DE
.ft R
\&\&
.PP
Note that you have to configure SMTP on each system one way or other;
you may also mix these two methods for different hosts.
.PP
.NH 2
Miscellaneous\ \fBconfig\fR\ Options
.br
.PP
.PP
There are quite a number of options you may set in the \fBconfig\fR file,
which, although useful, are not essential to running \fBsmail\fR, and
which we will not discuss here. Instead, we will only mention a
few that might be especially useful:
.PP
.IP \fBerror_copy_postmaster\fR\ 
If this boolean variable is set, any error will generate
a message to the postmaster.
Usually, this is only done for errors that are considered
to be due to a faulted configuration.
The variable can be turned on by putting it in the \fBconfig\fR
file, preceded by a plus (`\fB+\fR').
.IP \fBmax_hop_count\fR\ 
If the hop count for a message (i.e. the number of hosts
already traversed) equals or exceeds this number, attempts to
remote delivery will result in an error message being returned
to the sender. This is used to prevent messages from looping
forever. The hop count is generally computed from the number
of \fBReceived:\fR fields in the mail header, but may also
be set manually using the \fB-h\fR option on the
command line.
.IP
The variable defaults to \fB20\fR.
.IP \fBdelivery_mode\fR\ 
\&\fBsmail\fR knows of three different modes of delivery; being in
the foreground (immediate processing of incoming messages), in the
background, (message is delivered by a child of the receiving process,
with the parent process exiting immediately after forking), and
queued. In this mode, the message is moved to the queue directory
(generaly \fB\fB/usr/spool/smail/\fR/messages\fR), from where it is picked up and
processed further during a later queue run. This behavior can be
determined by setting the variable \fBdelivery_mode\fR to one of
\&\fBforeground\fR, \fBbackground\fR, or \fBqueued\fR.
Incoming mail will always be queued
regardless of this option if the boolean variable \fBqueue_only\fR is
set.
.IP
If you turn on queuing, you have to make sure the queues are
checked regularly; probably every 10 or 15 minutes. If you run
\&\fBsmail\fR as daemon, you have to add the option \fB-q10m\fR.
		
.IP
There is also a tool for checking the queue; this is called
\&\fBmailq\fR and is a link to \fBsmail\fR, too.
.PP
.NH 2
Mail\ Delivery
.br
.PP
.PP
\&\fBsmail\fR splits up mail delivery into three different tasks:
.PP
.IP router\ 
This is the task that resolves anything looking like
an address into something else looking like an address.
The difference is that after the router does its
job, it is known to which host the message must be sent and
which transport must be used. The destination
may also be the local host.
.IP director\ 
Local addresses are given to directors which resolve any
forwarding or aliasing. For example, the address might be an
alias, a mailing list, or the user might want to forward
her mail to another address.
This may require additional routing.
.IP transport\ 
If a router has decided that a given address is remote,
the message must be forwarded to the respective site.
Depending on the nature of the links, different kinds
of transport software are needed.
.IP
Local addresses have to be delivered accordingly.
.PP
With \fBsmail\fR, one can configure these tasks in many ways.
For each of them, a number of drivers are available, from
which you can choose those you need. You describe them to \fBsmail\fR
in a couple of files, namely \fBrouters\fR, \fBdirectors\fR, and
\&\fBtransports\fR located in \fB/usr/local/lib/smail/\fR. If these files do not exist,
reasonable defaults are assumed that should be suitable for
many sites that either use SMTP or UUCP for transport. If you want to
change \fBsmail\fR's routing policy, or modify a transport, you should
get the sample files from the \fBsmail\fR source distribution,
.FS 
The default configuration files can be found in \fBsamples/generic\fR
below the source directory.
.FE
 copy the sample files to \fB/usr/local/lib/smail/\fR, and modify them according to your
needs. Possibly, some future releases of \fBsmail\fR binaries may include
these files.
.PP
.NH 2
Routing\ Messages
.br
.PP
.PP
To find out which host to forward a message to, \fBsmail\fR hands
the destination address to a number of router drivers. These may
be specified using the \fBrouters\fR file; if this file does not
exist, a set of default routers are used.
.PP
Before giving the address to the routers, it is split up into a
\&\fItarget\fR, which is the machine to send the message
to, and the \fIremainder\fR. For an address like \fBfoo!bar!user\fR, the
target would be \fBfoo\fR, and \fBbar!user\fR the remainder.
.PP
If a match is found by a router, a new target and remainder
are generated, which are given to the transport. The target
(also \fInext host\fR) is the address the transport is to deliver
the message to, and the rmainder (also \fInext address\fR) is
the envelope address to be given to the mail software on the
remote host. In the above example, \fBsmail\fR might find out
that \fBfoo\fR is to be reached through the path \fBernie!bert\fR,
using UUCP. It will then generate a target of \fBernie\fR, and
a remainder of \fBbert!foo!bar!user\fR.
.PP
When using the default setup, \fBsmail\fR performs the following
actions to determine how to deliver a message:
.PP
.IP \(bu\ 
If the target host address is one of the local hostnames
recognized by \fBsmail\fR, the message is handed to the
director module, see section See section Local Delivery..
.IP \(bu\ 
Next, the router module checks if it can resolve the
destination host address using the \fBgethostbyname(3)\fR or
\&\fBgethostbyaddr(3)\fR library call. This will match
any hostnames found by the resolving routines, either
through lookups in \fB/etc/hosts\fR, or by querying the
nameserver. (Refer to section See section Resolver Configuration. on how
to configure the resolver.)
.IP
IP addresses matched may be written as either a dotted quad,
or enclosed in square brackets (e.g. \fB[192.72.2.1]\fR).
.IP
If a host address is matched by this router, the message will
be delivered over SMTP, unless the address is found to refer
to the local host (for example \fB127.0.0.1\fR). In this
case, it is handed to the director module.
.IP
If your machine is on the Internet, these routers are
not what you are looking for, because they do not support
MX records.
.IP \(bu\ 
Next, \fBsmail\fR will try to look up the target host (minus
any trailing \fB.uucp\fR) in the pathalias database, if this
exists. \fBsmail\fR expects this in the \fBpaths\fR file in
\&\fB/usr/local/lib/smail/\fR.
.IP
Mail to an address matched by this router will be
delivered using UUCP, using the path found in the database.
.IP \(bu\ 
The host address (minus any trailing \fB.uucp\fR) will be
compared to the output of the \fBuuname\fR command to check
if the target host is in fact a UUCP neighbor. If this is
the case, the message will be delivered using the UUCP
transport.
.IP
For two reasons, however, it is not generally a good idea to
use this driver. For one, this used to fail occasionally with
an error message that \fBuuname\fR returned a result code of 255.
I do not know the reason for this. The second is that you may
have more sites listed in your \fBSystems\fR file than you
actually have mail links with. These may be sites you only exchange
news with, but even more likely is that it contains information
on sites you occasinally download files from via anonymous UUCP,
but have no traffic with otherwise.
.IP
To work around this, you may add specific paths for these
sites to your \fBpaths\fR file, or, if you have a \fBrouters\fR
file in \fB/usr/local/lib/smail/\fR, comment out this driver altogether.
.IP \(bu\ 
If the address has not been matched by any of the above
routers, it will be delivered to the smart host. The path
to the smart host as well as the transport to be used are
set in the \fBconfig\fR file.
As described above, the default settings of \fBsmail\fR are not
really suitable for use on the Internet. You might want
to use \fBsendmail\fR instead, but if you do want to use \fBsmail\fR,
you have to recompile it yourself. 
You may use the configuration files from Vince Skahan's \fBnewspak\fR
distribution. To compile in the BIND driver, you have to set the
\&\fBDRIVER_CONFIGURATION\fR macro in the \fBEDITME\fR file to
\&\fBarpa-network\fR. To make use of this driver,
edit the \fBrouters\fR file, commenting out the \fBinet_hosts\fR
router that uses the \fBgethostbyname(3)\fR driver, and
uncomment the one that uses the BIND driver instead.
.PP
.NH 2
The\ pathalias\ database
.br
.PP
.PP
\&\fBsmail\fR expects to find the pathalias database in the \fBpaths\fR
file below \fB/usr/local/lib/smail/\fR. This must be a sorted ASCII file that contains
entries which map destination site names to UUCP bang paths. The
file has to be sorted because \fBsmail\fR uses binary search for
looking up a site. You may not insert comments in this file, and
the site name must be separated from the path using a TAB.
Pathalias databases are discussed in somewhat greater detail in
sectionSee section Pathalias..
.PP
If you generate this file by hand, you should make sure that
you include all legal names for a site. For example, if a
site is known by both a plain UUCP name and a fully qualified
domain name, you have to add an entry for each of them.
You best sort this file by piping it through the \fBsort(1)\fR
command.
.PP
If your site is only a leaf site, however, then no \fBpaths\fR
file should be necessary at all: just set up the smart host
attributes in your \fBconfig\fR file, and leave routing to
your mail feed.
.PP
.NH 2
Delivering\ Messages\ to\ Local\ Addresses
.br
.PP
.PP
This section covers the addressing modes available for local addresses.
.PP
The standard case is where a local address names a user on the machine
to whose mailbox the message is to be delivered. But a local address
may also be resolved to one or more remote ones if the user wants to
have his mail forwarded to another site, or if the address was that of a
mailing list.
.PP
.PP
Apart from ``normal'' addresses of local users, \fBsmail\fR
can handle other types of local message destinations, which will
also be called addresses.
For example, some directors will produce file names, pipe commands,
and file inclusions.
.PP
The \fBlocal\fR driver 
Messages for local users that have not been redirected otherwise (for
example through forwarding) will be appended to the user's mailbox,
\&\fB/var/spool/mail/\fR\fB\fBuser\fR\fR.
This file must be writable by group \fBmail\fR.
If it does not exist, it is created with mode \fB660\fR, owned by
the user with a group of \fBmail\fR.
.PP
A \fIfile name\fR is anything that begins with a slash (`\fB/\fR') or
a tilde (`\fB \fR)'.
The latter, of course, is only possible if the filename was taken from a
\&\fB.forward\fR file, or a forwarding entry in the mailbox.
When delivering to a file, \fBsmail\fR appends the messages to the file,
creating it if necessary.
.PP
A \fIpipe command\fR may be any Un*x command, preceeded by
the pipe symbol (`\fB|\fR'). This causes the message to be piped into
the command. If the invocation contains white space, it has to be enclosed
in double quotes (`\fB"\fR'). Due to the security issues involved,
care is taken not to execute the command if the address has
been obtained in a somewhat dubious way (for example, if the alias
file from which the address was taken was writable by everyone).
.PP
When delivering to a pipe command, \fBsmail\fR gives the command along
with the arguments to the shell (minus the leading `\fB|\fR'),
and passes it the message on standard input.
.PP
The environment passed to the child process consists
of the \fBTZ\fR variable as obtained from the calling process,
and the following variables defined by \fBsmail\fR:
.PP
.IP \fBSENDER\fR\ 
contains the sender's address.
.IP \fBBASENAME\fR\ and\ \fBSPOOL_FILE\fR\ 
contain the base and file name of the spool file.
.IP \fBGRADE\fR\ amd\ \fBMESSAGE_ID\fR\ 
contain the message grade and the message id, respectively.
.IP \fBPATH\fR\ and\ \fBSHELL\fR\ 
contain ``\fB/usr/bin\fR'' and ``\fB/bin/sh\fR'', respectively.
.IP \fBPRIMARY_NAME\fR,\ \fBUUCP_NAME\fR,\ and\ \fBVISIBLE_NAME\fR\ 
contain the values of the corresponding variables as
defined in the \fBconfig\fR file.
.PP
A \fIfile inclusion\fR is an address of the form
\&\fB:include:\fBfilename\fR\fR, and may be used in the \fBaliases\fR
database and mailing list. A file inclusion will cause \fBsmail\fR to take
the contents of the file as a comma-separated list of addresses
to deliver the message to. The file may contain comments wherever
white space is allowed; a comment starts with a hash sign (`\fB#\fR')
and is terminated by the next new-line.
.PP
.NH 3
Local\ Users
.br
.PP
.PP
The most common case for a local address is to denote a user's
mailbox. This mailbox is located in \fB/var/spool/mail/\fR and has
the name of the user. It is owned by her, with a group of \fBmail\fR,
and is mode \fB660\fR.
.PP
She may, however, redirect her mail by having it forwarded
to an alternative address (see below). To skip these checks, the user
name may be prefixed with \fBreal-\fR, in which case the message
is delivered to the mailbox directly.
.PP
There are two addresses \fBsmail\fR relies on to exist. These are
\&\fBMAILER-DAEMON\fR and \fBPostmaster\fR. To secure delivery to these
addresses, smail contains two implicit aliases which are
used as a last resort. These map \fBMAILER-DAEMON\fR to
\&\fBPostmaster\fR, and \fBPostmaster\fR to \fBroot\fR, respectively.
You may override this by supplying aliases for them in the \fBaliases\fR
file.
.PP
.NH 3
Alias\ Files
.br
.PP
.PP
\&\fBsmail\fR is able to handle alias files compatible to
those known by Berkeley's \fBsendmail\fR. Entries in the
alias file may have the form
.PP
.QP
.nh
\&\fBalias\fR: \fBrecipient\fR,\&...
.PP
\&\fB\fBrecipients\fR\fR is a comma-separated list of addresses. These may
be local and remote addresses, as well as those described above.
A recipient list may be continued across newlines if the next line begins with
a TAB.
.PP
There is a special feature that allows to handle mailing lists from
the alias file: if you specify ``\fB:include:\fBfilename\fR\fR''
as recipient, \fBsmail\fR will read the file specified, and substitute
its contents as a list of recipients. 
.PP
The main aliases file is \fB/usr/lib/aliases\fR. If you choose to
make this file world-writable, \fBsmail\fR wil not deliver any
messages to shell commands given in this file. A sample file is
given below:
.PP
.QP
.nh
.DS
.ft CW
# linus.lxnet.org Aliases file
usenet: phil
netadmin: janet
postmaster: janet
mailer-daemon: janet
# The development mailing list.
development: joe, sue, mark, biff
        /usr/local/lib/log/development
owner-development: joe
# Announcements of general interest are mailed to all
# of the staff
announce: :include: /usr/local/lib/smail/staff,
        /usr/local/lib/log/announce
owner-announce: root
# Send facsimiles
fax: "|/usr/local/bin/sendfax"
 
.DE
.ft R
\&\&
.PP
If an error occurs while delivering to an address generated from 
the \fBaliases\fR file, \fBsmail\fR will attempt to send a copy
of the error message to the ``alias owner''. For example, if delivery
to \fBbiff\fR fails when delivering a message to the \fBdevelopment\fR
mailing list, a copy of the error message will be mailed to
the sender, as well as to \fBpostmaster\fR and \fBowner-development\fR.
If the address does not exist, no additional error message will be
generated.
.PP
.NH 3
Mailing\ Lists
.br
.PP
.PP
Instead of using the \fBaliases\fR file,
mailing lists may also be managed by means of files in the \fBlists\fR
directory below \fB/usr/local/lib/smail/\fR. A mailing list named \fBnag-bugs\fR
is described by the file \fBlists/nag-bugs\fR, which should
contain the member's addresses, separated by commas. The list
may be given on multiple
lines, with comments being introduced by a hash sign (`\fB#\fR').
.PP
For each mailing list, a user (or alias) named \fBowner-\fBmlist\fR\fR
should exist; any errors occurring when resolving an address are
reported to this user. Also, it is used as the sender's address
on the outgoing messages. (In the \fBSender:\fR header field.)
.PP
.NH 3
Forward\ Files
.br
.PP
.PP
\&\fBsmail\fR supports two ways a user may request to have her mail
forwarded to a different address. This may be done by putting 
.PP
.QP
.nh
Forward to \fBrecipient\fR,\&...
.PP
in her mailbox file (i.e. \fB/var/spool/mail/\fR\fB\fBuser\fR\fR). Of this
file, only the first line will be inspected.
Alternatively, she might create a \fB.forward\fR file in her home
directory which contains a comma-separated list of recipients,
too. Unlike the first variety, all lines are read and interpreted.
.PP
Note that any type of address may be used. Thus, a practical example
of a \fB.forward\fR file for vacations might be
.PP
.QP
.nh
.DS
.ft CW
real-janet, "|vacationreply"
 
.DE
.ft R
\&\&
.PP
The address \fBreal-janet\fR delivers the incoming message to \fBjanet\fR's
mailbox nevertheless, while the \fBvacationreply\fR command may return
a short notification to the sender (taking the sender's address from the
\&\fBSENDER\fR environment variable).
.PP
.NH 2
UUCP-based\ Transports
.br
.PP
.PP
There are a number of transports compiled into \fBsmail\fR that
utilize the UUCP suite. Usually, this results in an invocation of
\&\fBrmail\fR on the next host in the path giving it the message on
standard input and the envelope address on the command line.
.PP
When handing a message to the UUCP transport, \fBsmail\fR converts
the target address to a UUCP bang path. For example, 
\&\fBuser@host\fR will be transformed to \fBhost!user\fR. Use of
the `\fB\fR' address operator is preserved, so \fBuserhost@gateway\fR
will become \fBgateway!userhost\fR. However, \fBsmail\fR will never
generate such addresses itself.
.PP
Alternatively, \fBsmail\fR can produce SMTP batches to be fed
to the \fBrsmtp\fR command on the remote site. These contain the commands
the local mailer would issue if a real SMTP connection had be established.
It is used in store-and-forward (e.g. UUCP-based) networks
to protect the mail envelope from being garbled by the shell
(see footnote See section Mail delivery. in
section See section Mail delivery.).
.PP
The BSMTP transport is not available by default, but may be enabled
for some UUCP links using so-called \fImethod\fR files (please refer
to the \fBsmail(5)\fR manual page for details). If you only have one
UUCP link, and use the smart host router to get your mail over this link,
you enable sending SMTP batches by setting the \fBsmart_transport\fR
configuration variable to \fBuusmtp\fR instead of \fBuux\fR.
.PP
To receive SMTP batches over UUCP, you must make sure that you have
the unbatching command the remote site sends its batches to. If the remote
site uses \fBsmail\fR, too, you need to make \fBrsmtp\fR a link to 
\&\fBsmail\fR. If the remote site runs \fBsendmail\fR, you should additionally
have a shell script named \fBbsmtp\fR that does a simple ``\fBexec\fR
\&\fBrsmtp\fR''.
.PP
.NH 2
SMTP-based\ Transports
.br
.PP
.PP
\&\fBsmail\fR currently supports a SMTP driver to deliver mail over
TCP connections.
.FS 
The authors call this support ``simple''. For a future
version of \fBsmail\fR, they advertise
a complete backend which will handle this more efficiently.
.FE
 It is capable of delivering a message to any number of addresses
to one single host, with the hostname being specified as either a 
fully qualified domain name that can be resolved by the networking
software, or in dotted quad notation enclosed in square brackets.
Generally, addresses resolved by the gethostbyname and gethostbyaddr
router drivers, respectively, will be delivered to the TCPSMTP transport.
.PP
The SMTP driver will attempt to connect to the remote host immediately
through the \fBsmtp\fR port as listed in \fB/etc/services\fR.
If it cannot be reached, or the connection times out, delivery
will be reattempted at a later time.
.PP
Delivery on the Internet requires that routes to the destination
host be specified in the \fIsource routing\fR format
described in See section Mail routing., rather than as a bang path.
.FS 
However, the use of routes in the Internet is discouraged altogether.
.FE
 \fBsmail\fR will therefore transform \fBuserhost@gateway\fR, where
\&\fBgateway\fR is reached via \fBhost1!host2!host3\fR, into the
source-route address \fB<@host2,@host3:userhost@gateway>\fR which
will be sent as the message's envelope address to \fBhost1\fR.
.PP
.NH 2
Hostname\ Qualification
.br
.PP
.PP
Sometimes it is desirable to catch unqualified hostnames (i.e. those
that don't have a domain name) specified in
sender or recipient addresses, for example when gatewaying between
two networks, where one requires use of fully qualified domain names.
This is necessary on the Internet (where unqualifed hostnames
should be mapped to the \fB.uucp\fR domain by default), but may also
be also useful in the UUCP zone when users are known to use the bare
hostname, although the site in question is only known by a qualified name.
.PP
The \fBqualify\fR file contains information used by \fBsmail\fR
to convert any addresses containing bare hostnames to fully qualified
domain names by mapping host names onto their default domain.
Qualification is performed on all addresses of the form
\&\fB\fBuser\fR@\fBhost\fR\fR and \fB\fBuser\fR\fBhost\fR@\fBgateway\fR\fR
for locally generated mail.
.PP
Entries in the \fBqualify\fR file are single lines, consisting of
.PP
.QP
.nh
\&\fBhostname     domain
\&\fR
.PP
.PP
where \fB\fBhostname\fR\fR begins in column one. Such an
entries states that \fB\fBhostname\fR\fR should be considered
part of \fB\fBdomain\fR\fR.
A line containing a hash sign (`\fB#\fR') as its first
non-white character is considered a comment line.
Entries are searched in the order they appear in.
.PP
A special hostname of ``\fB*\fR'' matches any hostnames, thus
enabling to map all hosts not mentioned before into a
\&\fBdefault\fR domain. It should only be used as the last entry.
.PP
The virtual brewery will not have a very big \fBqualify\fR file.
It qualifies their local hosts, and maps any remaining hostnames
to the \fB.uucp\fR domain. This is to make
sure no mailer rejects their mail on the ground that the
recipient's address contain an unqualified name.
.PP
.QP
.nh
.DS
.ft CW
# The Virtual Brewery 
# /usr/local/lib/smail/qualify, last changed Feb 12, 1993 by okir
#
vstout       .linus.lxnet.org
lager        .linus.lxnet.org
vale         .linus.lxnet.org
vchianti     .linus.lxnet.org
vbardolino   .linus.lxnet.org
\&\&...
*            .uucp
 
.DE
.ft R
\&\&
.PP
.bp
.NH
Installing\ and\ Using\ \fBsendmail\fR
.br
.PP
.PP
.PP
.PP
.NH 2
Introduction
.br
.PP
.PP
As already described above, \fBsendmail\fR relies on a configuration
file named \fBsendmail.cf\fR, which is located in \fB/etc\fR.
Writing such a file, or even adapting such a file by hand,
is not really easy. To levitate the situation for sites that want
to run \fBsendmail\fR but don't have a real \fBsendmail\fR buff handy,
there have been various solutions that supply a set of configuration
files for several standard setups, which may be modified more or
less easily.
.PP
In 1998, Lennard Lovstrand developed a kit to produce \fBsendmail.cf\fR
using the \fBm4\fR macro processor, and added a few features to
\&\fBsendmail\fR. This has become known as the IDA \fBsendmail\fR
enhancement kit, named after the Linkoping University's Computer 
Science Institute he was working at then.
.PP
There is a \fBsendmail\fR port available for Linux that includes
IDA support. This port is due to Rich Braun.
.FS 
To be reached at \fBrichb@jti.com\fR.
.FE
 and can be found at \fBtsx-11.mit.edu\fR as
.PP
.QP
.nh
sendmail-5.56c+IDA-1.4.4-beta.tar.Z
.PP
Another \fBsendmail\fR port is available, too, which uses a different
setup procedure than IDA.
.PP
IDA is a very sophisticated configuration package that provides a variety
of mail routing and gatewaying facilities. It is not the intention of this
book to cover all aspects of IDA, let alone \fBsendmail\fR itself. If you
are interested in details, please refer to the original IDA documentation.
A good place to look is also the \fBsendmail.cf\fR file itself. Extra
comments may be included into the file by defining \fBM4COMMENTS\fR in the
IDA file (see below). There is also a Postscript description included,
which describes all options and extensions. A good place to start 
if you are interested in \fBsendmail\fR itself is probably Craig
Hunt's ``TCP/IP Network Administration'' (see [??]); it has
a separate chapter on \fBsendmail\fR.
.PP
.NH 2
Installing\ \fBsendmail\fR
.br
.PP
.PP
To install \fBsendmail\fR, unpack the tar file in some safe place, and
move the files to their proper places. To preserve ownership and mode,
which is critical for most files, do this as \fBroot\fR, and either use
the \fBmv(1)\fR command, or give the \fB-p\fR option to \fBcp(1)\fR.
Do not throw awawy the source tree (\fBusr/local/src\fR), because you
will still need it.
.PP
Then create the directories \fB/usr/spool/mqueue\fR, which is
to hold the mail queue, and \fB/usr/local/lib/mail\fR, which we will refer
to as the ``lib'' directory below. Both should be
owned by \fBroot\fR, and should have a mode of \fB755\fR.
Go to the \fBida/lib\fR below the source directory, and copy
\&\fBsendmail.hf\fR to the lib directory. The other files serve as
examples of IDA support files, which will be explained below.
.PP
If you want your \fBsendmail\fR installation to act as SMTP server, too,
you have to decide whether you want it to be managed by \fBinetd\fR,
or run as a separate daemon. The latter is ony advisable in case of
considerable traffic.
.PP
To run \fBsendmail\fR as a daemon, put the following into
\&\fB/etc/rc.d/rc.inet2\fR:
.PP
.QP
.nh
.DS
.ft CW
if [ -x /usr/lib/sendmail ]; then
        /usr/lib/sendmail -bd -bq15m
fi
 
.DE
.ft R
\&\&
.PP
This will start \fBsendmail\fR as a daemon process, which processes the
mail queue every 15 minutes. Make sure you do not have any \fBsmtp\fR
service defined in your \fBinetd.conf\fR file.
.PP
If you want \fBsendmail\fR to be managed by \fBinetd\fR instead,
you have to make sure to define a \fBsmtp\fR service in \fBinetd.conf\fR:
.PP
.QP
.nh
.DS
.ft CW
smtp   stream  tcp  nowait  daemon  /usr/lib/sendmail sendmail -bs
 
.DE
.ft R
\&\&
.PP
With this setup, you still have to make sure the mail queue is processed
periodically. This can be done by adding the following line to \fBroot\fR's
crontab:
.PP
.QP
.nh
.DS
.ft CW
10   *    *    *    *    /usr/lib/sendmail -q >/dev/null
 
.DE
.ft R
\&\&
.PP
The next step is the most important one: creating the sendmail configuration
file, which is explained in the following section.
.PP
.NH 2
Creating\ \fBsendmail.cf\fR
.br
.PP
.PP
The IDA configuration set consists of a bunch of master files, 
located in \fBida/cf\fR below the \fBsendmail\fR source directory.
(When untarring the distribution from the root directory, this should
go somewhere below \fB/usr/local/src\fR). 
.PP
To produce a configuration file for your site, you have to go to this
directory, and create a \fBm4\fR macro file that sets a few macros
to reflect your site's requirement. The best way to start is to
copy the file \fBlocal.m4\fR to \fB\fByoursite\fR.m4\fR, where you
replace \fB\fByoursite\fR\fR with you site's name (what else), and
edit it. Below, a sample IDA file is shown for the site
\&\fBswim.two.birds\fR, which has a single link to a host named
\&\fBulysses\fR:
.PP
.QP
.nh
.DS
.ft CW
# Sendmail configuration file for swim.two.birds
define(ALIASES, LIBDIR/aliases)
define(LOCAL_MAILER_DEF, mailers.sco)
dnl ### Postmaster gets copy of bounced mail. ###
define(POSTMASTERBOUNCE)
define(PSEUDODOMAINS, BITNET UUCP)
define(PSEUDONYMS, swim.two.birds localhost.two.birds)
define(DEFAULT_HOST, swim.two.birds)
dnl ############# Local UUCP names ##############
define(UUCPNAME, swim)
define(UUCPNODES, |uuname|sort|uniq)
define(BANGIMPLIESUUCP)
define(BANGONLYUUCP)
dnl ########## Our smart relay system ###########
define(RELAY_HOST, ulysses)
define(RELAY_MAILER, UUCP-A)
dnl ######### Define dbm lookup tables ##########
dnl ## pathalias database
dnl define(PATHTABLE, LIBDIR/pathtable)dnl
dnl ## target-transport mapping
dnl define(MAILERTABLE, LIBDIR/mailertable)dnl
dnl ## Mapping between DNS and UUCP zone
dnl define(DOMAINTABLE, LIBDIR/domaintable)dnl
dnl define(UUCPXTABLE, LIBDIR/uucpxtable)dnl
dnl ########## Define this for verbose #########
dnl ########## comments in sendmail.cf #########
dnl # define(M4COMMENTS)dnl
include(Sendmail.mc)
 
.DE
.ft R
\&\&
.PP
The file mainly consists of a number of \fBdefine\fR statements.
These do what they say:
They define a macro (the first argument), giving it the optional second
argument as value. Note that, depending on the version of \fBm4\fR
you are using, the macro processor might issue wrnings about \fBdefine\fR
statements with only one argument.
The second important command is \fBdnl\fR, which means ``delete to new
line'', and starts a comment. Thus, hash signs have no special meaning
to \fBm4\fR, so that they will also appear in the output file.
The last statement in the IDA file must be the \fBinclude\fR statement,
which includes the \fBsendmail\fR master file.
.PP
Looking at the file, you may find that a macro named \fBLIBDIR\fR is used
in filename definitions, without the macro itself being defined anywhere.
This macro is passed to \fBm4\fR on the command line when being invoked
from the \fBMakefile\fR, and is given a value of \fB/usr/local/lib/mail\fR.
If you feed the IDA file to \fBm4\fR manually,
you should either pass it a value for \fBLIBDIR\fR, else the
\&\fBSendmail.mc\fR file will assume a default value.
.PP
The meaning of most of the other macros will be discussed below. If you need
more information about the facilities offered by IDA, either refer to the
Poscript documentation enclosed in the package, or read the comments
in the \fBSendmail.mc\fR.
.PP
Once you have adapted all macros to reflect the settings of your system,
you build the \fBsendmail.cf\fR file from it by doing
.PP
.QP
.nh
# make \fByoursite\fR.cf			
.br
\&\&
# install -o root -g root -m 644 \fByousite\fR.cf /etc/sendmail.cf
.PP
This creates the file \fB\fByoursite\fR.cf\fR, which you then copy
to \fB/etc/sendmail.cf\fR.
For performance reasons, \fBsendmail\fR processes this
file only once, and then stores an internal representation in a file
called \fBsendmail.fc\fR in the \fB/etc\fR directory. This is called
the \fIfrozen\fR configuration file. It is built by issuing
.PP
.QP
.nh
# sendmail -bz
.PP
.NH 2
Invocation\ and\ Command\ Line\ Options
.br
.PP
.PP
Unlike \fBsmail\fR, \fBsendmail\fR comes along with a couple of binaries
required for it to work. One of these is the \fBlmail\fR binary, the
local mailer used to deliver messages to a user's mailbox. It is
located in \fB/usr/bin\fR.
Another is \fBrmail\fR, which is needed when receiving mail via UUCP.
It does little more than executing \fBsendmail\fR itself. You can find
it in \fB/bin\fR.
.PP
The \fBsendmail\fR binary itself is located in \fB/usr/lib\fR. Which may
seem a bit odd, but this has been the standard for roughly the last few
million years or so.
.PP
In the sections above, you have already come across the most important
command line options you need for day-to-day operations. We will
sum them up here again. There are also a number of ``alias'' names
\&\fBsendmail\fR may be linked to, which turn on some specific mode of
operation. They will be mentioned alongside with the equivalent
command line options.
.PP
.IP \fB-bd\fR\ 
Start up in daemon mode. This puts \fBsendmail\fR in the background,
where it listens to the SMTP port, and periodically runs the mail
queue when given the \fB-q\fR option.
.IP \fB-bq\fBinterval\fR\fR\ 
Run the mail queue every \fB\fBinterval\fR\fR. The argument is made up
of a number and a unit: \fBh\fR for hour, and \fBm\fR for minute.
You may also combine this to \fB1h30m\fR.
.IP \fB-bq\fR\ 
If specified all by itself, \fBsendmail\fR will unconditionally run
the mail queue once and exit. This is equivalent to invoking
\&\fBsendmail\fR as \fBrunq\fR.
.IP \fB-bs\fR\ 
Perform an SMTP session over standard input.
.IP \fB-bb\fR\ 
Process standard input as a BSMTP batch. This is equivalent
to invoking \fBsendmail\fR as \fBbsmtp\fR.
.IP \fB-bi\fR\ 
Build the aliases \fBdbm\fR database. See
section See section IDA Alias Options. below.
This is equivalent to invoking \fBsendmail\fR as \fBnewaliases\fR.
.IP \fB-bz\fR\ 
Build the frozen configuration file, \fB/etc/sendmail.fc\fR.
.IP \fB-bp\fR\ 
Print all jobs currently in the mail queue and exit.
This is equivalent to invoking \fBsendmail\fR as \fBmailq\fR.
.PP
.NH 2
Routing\ with\ \fBsendmail\fR
.br
.PP
.PP
To be able to configure \fBsendmail\fR properly, you first have to
know a little about how it routes a message.
.PP
Routing in sendmail is essentially performed by a set of
rewriting rules in the \fBsendmail.cf\fR file. These rules perform
some sort of text matching on the recipient address, look up
the address in various tables, and try to associate a suitable
\&\fImailer\fR with it. ``Mailer'' is the generic term for a delivery
or forwarding service in all \fBsendmail\fR documentation, analogous to
``transport'' for \fBsmail\fR. There's some wizardry involved in
parsing the address etc., but we will nevertheless explain what it
basically does. The various tables being used will be explained in detail
below, as are the different mailers chosen by the routing alogrithm.
.PP
Please note that the description \fIonly applies to IDA 1.4.4\fR included
in the \fBsendmail\fR distribution by Rich Braun; other \fBsendmail\fR or
IDA versions may have entirely different configuration files, and hence
might have a completely different approach to address resolution.
Also note that this does not discuss the various resolving procedures
for DECnet and XNS, which are also supported.
.PP
When resolving an address \fBsendmail\fR takes the following steps:
.PP
.IP 1.\ 
If the target hostname is a name of the local host, the
user name is checked against the \fBaliases\fR file. If it is
aliased to one or more other addresses, the process is repeated
with these new addresses. Otherwise it is delivered locally.
.IP 2.\ 
If the entire address, including the remote hostname, is found
in the \fBaliases\fR file, it is replaced by the aliased address,
and the whole process is repeated with the new address.
.IP 3.\ 
The target host is now definitely remote. \fBsendmail\fR will
look it up in the mailer table, a file that
maps domain names to mailer-host pairs. If a match is
found, the message is delivered to the host specified, using the
associated mailer.
.IP 4.\ 
The resolver library will then be called to resolve the hostname,
unless it is in one of the pseudo-domains \fB.uucp\fR or
\&\fB.BITNET\fR.
This may be configured to either look up the name in \fB/etc/hosts\fR,
or query the name server, taking \fBMX\fR records into account.
For details, please refer to section See section IDA Resolver Options..
.IP
If the hostname could be resolved to an IP address, the message will
be delivered via the \fBTCP\fR mailer, using the canonical 
hostname as returned by the name server as the envelope address. 
.IP 5.\ 
Failing this,
the target name is looked up in the UUCP translation table that
maps fully qualified domain names to (possibly different) UUCP
names. If the resulting UUCP name (or the original name if no match
was found) is a direct UUCP neighbor, it will be sent through the
\&\fBUUCP\fR mailer.
.IP 6.\ 
If the target is found in the pathalias database, the message will
be sent to the first node in the path. The mailer to be used will be
determined by repeating the whole process with the new target host.
.IP 7.\ 
If the message could not be routed using one of the above 
schemes, it is sent to the smart host, if defined.
.NH 2
Setting\ the\ Site\ Name
.br
.PP
.PP
First, let's start with the macros that set your site's names:
\&\fBDEFAULT_HOST\fR gives your host's site name, as should be used as the
sender host name on all outgoing mail. Any other names your site is known
by --- except your UUCP name --- should be given in the \fBPSEUDONYMS\fR
macro. Host names are separated by space or tabs. Note that this list
should also include \fBlocalhost\fR, possibly qualified by your site's
domain.
.PP
If your site is registered in the UUCP maps, set \fBUUCPNAME\fR to
its official UUCP name (sans trailing \fB.uucp\fR domain). If
you are not a registered UUCP site, uncomment the \fBdefine\fR statement
by preceding it with \fBdnl\fR.
.PP
.NH 2
Routing\ Options
.br
.PP
.PP
IDA offers a number of options to control the different routing schemes
described above in section See section Routing with sendmail..
We will describe them below, each in a different subsection.
.PP
.PP
.NH 3
Alias\ Options
.br
.PP
.PP
Alias lookups are enabled by giving setting the \fBALIASES\fR macro
to the \fBaliases\fR file name. Please refer to
section 
below for information of the file format.
.PP
.NH 3
Mailer\ Table\ Options
.br
.PP
.PP
Mapping of target hostnames to mailers is enabled by defining the
\&\fBMAILERTABLE\fR macro in the IDA configuration file. It must be set
to the name of the mailer table file.
We will not describe the use
of mailer tables in this document; please refer to the original IDA
documentation.
.PP
.NH 3
Address\ Resolution
.br
.PP
.PP
If you want to deliver mail over a TCP/IP network, be it on the
Internet, or in an isolated network, you have to make sure the
resolver library is set up properly. You may have done this already
when setting up services like the printer daemon, but we will go through
the necessary steps nevertheless.
.PP
When trying to resolve a hostname to an IP address, \fBsendmail\fR
uses the \fBgethostbyname(3)\fR and \fBres_search(3)\fR library calls.
Depending on the options selected in the files \fBhost.conf\fR and
\&\fBresolv.conf\fR,
.FS 
Described in section See section Resolver Configuration..
.FE
 they get their information from either one or more
name servers, or from the local \fB/etc/hosts\fR file.
.PP
When a name server is in use at your network, or even on your local
machine, you should enable DNS lookups in \fBhost.conf\fR using
the option
.PP
.QP
.nh
order bind hosts
.PP
The IP address of the name server(s) to be queried must
be given in \fBresolv.conf\fR, using the \fBnameserver\fR statement.
For example, assuming a name server has been installed on \fBvlager\fR
at the Virtual Brewery, this file would read
.PP
.QP
.nh
.DS
.ft CW
# /etc/resolv.conf for the Virtual Brewery
domain       linus.lxnet.org
nameserver   192.72.1.1
 
.DE
.ft R
\&\&
.PP
If your machine is a standalone site in terms of TCP/IP networking, or
you are in an isolated network without Internet connectivity, you
may probably not run a name server. To be able to run \fBsendmail\fR
nevertheless, you must configure the resolver library accordingly.
First, the \fBorder\fR statement in \fB/etc/host.conf\fR should only
use the \fB/etc/hosts\fR file:
.PP
.QP
.nh
order hosts
.PP
Second, to keep \fBsendmail\fR from searching for unknown name servers
when looking for \fBMX\fR records, you also have to make sure there is
no \fBnameserver\fR statement in \fBresolv.conf\fR.
.PP
.NH 3
UUCP\ Routing
.br
.PP
.PP
If your site has several UUCP links, you should configure the
appropriate UUCP options. To enable pathalias routing, the location of
the pathalias database must be given using the \fBPATHTABLE\fR macro.
If this macro is not set, no pathalias routing will be used.
.PP
To give \fBsendmail\fR a list of all your neigboring UUCP sites,
use the \fBUUCPNODES\fR macro. The default value in the sample file,
``\fB|uuname|sort|uniq\fR'', uses the sorted output of the \fBuuname\fR
command to obtain this list. Note that if you use this setting, you
have to update \fBsendmail\fR's frozen configuration file every time
you add or delete system from your UUCP configuration files (see
section See section Creating sendmail.cf.).
.PP
As said before in section See section Routing with smail., use
of the \fBuuname\fR output is debatable, so you might either
hard-code a list of all your UUCP neighbors here, or define
the macro to the (absolute) name of a file where you keep a list of
all UUCP neighbors you exchange mail with.
.PP
There are a couple of other options that control mapping of UUCP names 
to the \fB.uucp\fR domain (\fBBANGONLYUUCP\fR and \fBBANGIMPLIESUUCP\fR),
as well as the treatment of hybrid addresses mixing `\fB!\fR' and 
`\fB@\fR'. We will not discuss them here; please refer to the IDA
documentation for details.
.PP
By default, any messages routed using the pathalias database will be
delivered using the \fBUUCP\fR mailer. If you prefer to use a different
mailer, for example \fBUUCP-A\fR, you may change this by setting
the \fBUUCPMAILER\fR macro to \fBUUCP-A\fR
.FS 
See section See section UUCP Delivery. below.
.FE
 or any other UUCP-based mailer.
.PP
.NH 3
Smart\ Host\ Routing
.br
.PP
.PP
To enable smart host routing, you have to set the macros \fBRELAY_HOST\fR
and \fBRELAY_MAILER\fR, respectively.
\&\fBRELAY_HOST\fR specifies the name of the mail relay you use for smart host
routing. This may either be a fully qualified domain name or a UUCP name,
depending on the transport you use. The transport is selected using the
\&\fBRELAY_MAILER\fR macro. For a UUCP link, you should enter \fBUUCP-A\fR
here, and \fBTCP\fR for a TCP/IP link.
.PP
.NH 2
\&\fBsendmail\fR\ Support\ Files
.br
.PP
.PP
This section describes the various tables used by the \fBsendmail\fR
configuration described above. These files reside in
\&\fB/usr/local/lib/mail\fR, and all of them are so-called \fBdbm\fR
databases.
.PP
All these files are optional, except for the alias database. Some of
them will rarely be used by minor sites, so we will only mention them
shortly.
.PP
.PP
.NH 3
Creating\ \fBdbm\fR\ Databases
.br
.PP
.PP
\&\fBdbm\fR is a database
format that allows fast lookups due to hashing techniques.
.FS 
In fact, there is not one single \fBdbm\fR format, but every
implementation --- and there are several --- use a slightly incompatible
variant.
.FE
 It consists of a list of key-value pairs, both usually being ASCII
strings.
.PP
A \fBdbm\fR database is created from some master file, usually a
human-readable ASCII file, and stored in two files, one for the data, the other for
hashing information. They are usually called \fB\fBdbase\fR.pag\fR and
\&\fB\fBdbase\fR.dir\fR, respectively.
.PP
It is very important to remember that whenever you edit the master database,
the changes do not take effect unless you update the \fBdbm\fR files as well.
For easier maintenance, you should keep a small \fBMakefile\fR around
that updates the the databases.
.PP
The \fBdbm\fR files are built using the \fBdbm(1)\fR command, except for
the \fBaliases\fR database, which is given special treatment. For example, 
to build the \fBmailertable\fR database from the master file, issue
the command:
.PP
.QP
.nh
.DS
.ft CW
# dbm -d mailertable load mailertable
 
.DE
.ft R
\&\&
.PP
This reads the file \fBmailertable\fR and produces both \fBmailertable.pag\fR
and \fBmailertable.dir\fR.
.PP
.NH 3
The\ \fBaliases\fR\ file
.br
.PP
.PP
Most important among the \fBsendmail\fR support files is the \fBaliases\fR
file. It is used to map addresses to a list of other addresses, which allows
for mailing lists, mail forwarding, etc. Unlike \fBsmail\fR, \fBsendmail\fR
not only allows to introduce aliases for local users, but also for
addresses of users on other sites.
.PP
A sample \fBaliases\fR file might look like this:
.PP
.QP
.nh
.DS
.ft CW
# linus.lxnet.org alias file
# set of standard addresses
MAILER-DAEMON: postmaster
postmaster: root
# disallow mail to ftpmailer@decwrl.dec.com
ftpmailer@decwrl.dec.com: /dev/null
# local echo of Linux-Activists
linux-activists: sue, mark, al, anne, 
        jeff@ziggy.uucp, /v/pub/linux/maillog
owner-linux-activists: al
 
.DE
.ft R
\&\&
.PP
When setting up a mail site, you should make sure the addresses
\&\fBpostmaster\fR and \fBMAILER-DAEMON\fR are defined. The easiest
way to do so is using an \fBaliases\fR entry as above.
.PP
The third alias is a rather drastic way to prevent users from using the
\&\fBftpmailer\fR service, which allows you to conduct FTP sessions by sending
the list of commands to \fBdecwrl\fR, which will connect to the target
server for you. In small UUCP networks, having people use such services can
be a real nuisance. However, I'm not sure if the alias really prevents this;
it's just an example.
.PP
For more effective use, the \fBaliases\fR file must be converted to a
\&\fBdbm\fR database for \fBsendmail\fR to be able to use it. However, this is
not done using the standard \fBdbm(1)\fR command, but by invoking
\&\fBsendmail\fR with the \fB-bi\fR option:
.PP
.QP
.nh
.DS
.ft CW
# sendmail -bi
 
.DE
.ft R
\&\&
.PP
This is due to the fact that a slightly different \fBdbm\fR format
is used for the \fBaliases\fR database. While the \fBdbm\fR files are
rebuilt, \fBsendmail\fR will notice this and wait for the update to
complete.
.PP
.NH 3
The\ \fBpathtable\fR\ File
.br
.PP
.PP
\&\fBsendmail\fR's pathalias database is usually called \fBpathtable\fR.
The plain-text file has the usual format produced by the 
\&\fBpathalias(1)\fR tool. A sample file is given in
section See section Pathalias..
.PP
.NH 3
Miscellaneous\ \fBdbm\fR\ Files
.br
.PP
.PP
There are a couple of support files we will not discuss in this
book. The one you probably would want to use is the \fBmailertable\fR
database, which maps destination sites or domains onto
a gateway and a transport (mailer). For example, to be able to
send mail to hosts on BITNET, you either have to rely on a smart host,
or explicitly name a BITNET gateway to send all messages for BITNET
addresses to.
.PP
There is also a pair of databases to map UUCP site names onto fully
qualified domain names and vice versa. These are \fBuucpxtable\fR
and \fBdomaintable\fR. Closely related to this is the list of
well-known UUCP relays, which may be given to \fBsendmail\fR in
yet another \fBdbm\fR database (The database name is given in the
IDA configuration file in the \fBUUCPRELAYS\fR macro). Paths through
any of these relays will have the path leading up to the relay removed,
and have it replaced by the ``optimal'' path.
.PP
For use with other networks, like XNS or DECnet, there are also 
a couple of databases that may be used. If you do need these options,
please refer to the original documentation.
.PP
.NH 2
\&\fBsendmail\fR\ Mailers
.br
.PP
.PP
.PP
.PP
.NH 3
Local\ Addresses
.br
.PP
.PP
When \fBsendmail\fR receives a message for a local address, and the
user name is not found in the \fBaliases\fR file, it goes on to
check if there is a local user matching this name.
.PP
First, it checks if the recipient name is indeed a valid account name
on the local system. If it is, the user's home directory is extracted
from the \fB/etc/passwd\fR password file and checked for a \fB.forward\fR
file. If one exists, the message is delivered to the list of comma-separated
addresses specified in this file.
Messages to local users which have not been aliased to some other
address are delivered by invoking the \fBlmail\fR program.
Note that an \fBlmail\fR program is part of the \fBsendmail\fR package,
which does little more than appending the message to the recipient's
mailbox file.
.PP
\&\fBsendmail\fR allows you to deliver mail to programs and files as well.
Any address beginning with a slash (`\fB/\fR') is assumed to be a file
name, and the message is appended to this file.
The address syntax for delivering to a command is
.PP
.QP
.nh
|\fBcommand\fR1cm\fIor\fR1cm 	|"\fBcommand arguments\fR"
.PP
The second form is needed whenever the command takes arguments. Note that
opposed to \fBsmail\fR, \fBsendmail\fR will not pass on any environment
variables to the program invoked.
.PP
.NH 3
SMTP\ Delivery
.br
.PP
.PP
There are also a number of SMTP-based mail services. The generic SMTP mailer
is \fBTCP\fR, which is automatically chosen when the target hostname has
been resolved by the name server.
.PP
Some variations of this exist, which may be used to appease mailers that
need special address formatting of, for example, relative UUCP addresses.
For these, some additional rewriting of the recipient's envelope address
is done, which is described in the \fBsendmail.cf\fR file.
To use any of these mailers, you should specifiy them explicitly in the
\&\fBmailertable\fR file.
.PP
.NH 3
UUCP-based\ mailers
.br
.PP
.PP
As configured, \fBsendmail\fR offers support for three varieties
of mailer delivery over UUCP. The first two, \fBUUCP\fR and \fBUUCP-A\fR,
both deliver messages to the \fBrmail\fR command on the remote site.
The only difference is that \fBUUCP-A\fR is a bit smarter in that it
tries to format addresses as close to RFC 822 as possible.
.PP
The \fBUUCP-B\fR mailer may be used to deliver messages using batched SMTP.
It produces a BSMTP file (as explained in section See section Mail delivery.)
and sends it to the \fBbsmtp\fR program on the remote host. In this 
respect it is different from \fBsmail\fR, who sends the files to
the \fBrsmtp\fR program. If you expect to receive mail in BSMTP
batches, make sure to link \fBsendmail\fR to \fBbsmtp\fR; when invoked
as \fBbsmtp\fR, it will eat the batch and process it accordingly.
.PP
Note that for \fBsendmail\fR to receive BSMTP batches created by \fBsmail\fR,
you have to have a \fBrsmtp\fR program.
However, a shell script like the following might do:
.PP
.QP
.nh
.DS
.ft CW
#!/bin/bash
exec /usr/local/bin/bsmtp
 
.DE
.ft R
\&\&
.PP
The default to use for delivering mail over a UUCP link is to
use the dumb \fBUUCP\fR mailer. If you want to override this for
specific mail links, you have to do so in the \fBmailertable\fR file.
For example, if you want to use the
\&\fBUUCP-A\fR mailer for mail forwarded to \fBswim.two.birds\fR because
you know their mailer speaks RFC 822, while for your link to
\&\fBmoria.orcnet.org\fR, you prefer BSMTP,
your \fBmailertable\fR would contain lines like these:
.PP
.QP
.nh
.DS
.ft CW
swim.two.birds        UUCP-A!swim
moria.orcnet.org      UUCP-B!moria
 
.DE
.ft R
\&\&
.PP
.PP
.PP
.PP
.PP
.bp
.NH
Netnews
.br
.PP
.PP
.PP
.PP
.PP
.PP
.NH 2
Usenet\ History
.br
.PP
.PP
.PP
The idea of network news was born in 1979 when two graduate students, Tom
Truscott and Jim Ellis, thought of using UUCP to connect machines for the 
purpose of information exchange among Un*x users. They set up
a small network of three machines in North Carolina.
.PP
Initially, traffic was handled by a number of shell scripts (later
rewritten in C), but they were never released to the public. They
were quickly replaced by ``A'' news, the first public release of news
software.
.PP
It was however not designed to handle more than a few articles
per group and day. When volume continued to grow, it was rewritten
by Mark Horton and Matt Glickman, who called it the ``B'' release
(a.k.a. Bnews). The first public release of Bnews was version 2.1
in 1982. It was expanded continuously, with several new features 
being added. Its current version is Bnews 2.11.
.PP
Another rewrite was done and released in 1987 by Geoff Collyer and Henry
Spencer; this is release ``C'', or Cnews. In the meanwhile there have
been a number of patches to Cnews, the most prominent
being the Cnews Performance Release. On sites that carry a large number
of groups, the overhead involved in frequently invoking 
the \fBrelaynews\fR command is significant. (\fBrelaynews\fR is
responsible for dispatching incoming articles to the hosts
that request news from the specified groups.) The performance release
adds an option to \fBrelaynews\fR that allows to run it in 
\&\fIdaemon mode\fR, in which the program puts itself in the background
once and for all times.
.FS 
Until the system is brought down, that is.
.FE
.PP
The Performance Release is the Cnews version currently included in SLS
and \fBnewspak\fR.
.PP
All news releases up to ``C'' are primarily targeted for UUCP networks,
although they may be used in other environments as well. Though,
efficient news transfer over networks like TCP/IP, DECNet, or
related requires a new scheme. This was the reason why, in 1986, 
the ``Network News Transfer Protocol'', NNTP, was introduced. It
is based on network connections, and specifies a number of commands
to interactively transfer and retrieve articles.
.PP
.NH 2
How\ Does\ Usenet\ Handle\ News?
.br
.PP
.PP
Today, Usenet has grown to enormous proportions. Sites that carry
the whole of netnews usually transfer something like a trifle 
fourty megabytes a day.
.FS 
Wait a moment: 40 Megs at 2400 bps, that's 40 million by 300,
that is\&...mutter, mutter,\&...Hey! That's 37 hours!
.FE
 Of course this requires much more than pushing around files.
So let's take a look at the way most Un*x systems handle Usenet
news.
.PP
The basic unit of Usenet news is the article. This is a message a
user writes and ``posts'' to the net. In order to enable news sytems
to deal with it, it is prepended with administrative information,
the so-called article header. It is very similar to the mail header
format laid down in RFC 822, in that it consists of several lines
of text, each beginning with a field name terminated by a colon,
which is followed by the field's value.
.FS 
The format of Usenet news messages is specified in RFC 1036,
``Standard for interchange of USENET messages''.
.FE
.PP
Articles are submitted to one or more \fInewsgroups\fR.
One may view a newsgroup as a forum for articles relating
to a common topic. All newsgroups are organized in a hierarchy, with
each group's name indicating its place in the hierarchy. This often makes
it easy to see what a group is all about. For example, anybody can
see from the name \fBcomp.os.linux\fR that it refers to a computer
operating system named Linux.
.PP
News are distributed through the net by various transports. The
historical medium used to be UUCP, but today the main traffic
is carried by Internet sites. The algorithm used is \fIflooding\fR:
Each site maintains a number of links (\fInews feeds\fR) to other 
sites. Any article received by the local news system is forwarded
to them, unless it has already been seen at the local site, in which
case it is discarded. The same applies to articles injected into
the news stream by a local user.
.PP
To distinguish articles and recognize duplicates, Usenet articles
have to carry a message id (specified in the \fBMessage-Id:\fR header
field), which combines the posting site's name and a serial number
into ``\fB<\fBserial\fR@\fBsite\fR>\fR''. For each article processed,
the news system logs this id into a \fIhistory\fR file against which
all newly arrived articles are checked.
.FS 
This used to be one of the worst problems with B news, because it
searched the history file linearly. The time required for this is
proportional to the square of the number of articles. C news
generally uses \fBdbm\fR databases which support hash tables.
.FE
.PP
This algorithm is modified in that the flow between any two sites may be
limited by two criteria: for one, an article is assigned a distribution
(in the \fBDistribution:\fR header field) which may be used to confine
it to a certain group of sites. On the other hand, the newsgroups
transmitted may be limited by either the sending or receiving system,
depending on the transport used.
The set of newsgroups and distributions allowed for transmission to a
site are usually kept in the \fBsys\fR file.
.PP
The sheer number of articles usually requires that improvements be made
to the above scheme. On UUCP networks, the natural thing to do is
to collect articles over a period of time, and combine them into a single
file, which is compressed and sent to the remote site. This is called
\&\fIbatching\fR.
.FS 
The golden rule of netnews, according to Geoff Collyer: ``Thou shalt
batch thine articles.''
.FE
.PP
An alternative technique is the \fIihave/sendme\fR protocol that prevents
duplicate articles from being transferred in the first place, thus saving
net bandwidth. Instead of putting all articles in batch files and sending them
along, only the message ids of all articles that would otherwise be batched
are combined into a giant ``ihave'' message and sent to the remote site.
It reads this message, compares it to its history file, and returns
the list of articles it wants in a ``sendme'' message. Only these articles
are then sent.
Of course, ihave/sendme only makes sense if it involves two big sites that
receive news from several independent feeds each, and who poll each other
often enough for an efficient flow of news.
Sites that are on the Internet generally rely on TCP/IP-based software
that uses the Network News Transfer Protocol, NNTP.
.FS 
Described in RFC 977.
.FE
 It allows to transfer news between feeds and provides Usenet access to
single users on remote hosts.
.PP
NNTP knows three different ways to transfer news. One is ihave/sendme, also
referred to as \fIpushing\fR news. The second technique is called
\&\fIpulling\fR news, in which the client requests a list of articles in a
given newsgroup or hierarchy that have arrived at the server's site after
a specified date, and chooses those it cannot find in its history file.
The third mode is for
interactive newsreading, and allows to retrieve articles from specified
newgroups, as well as posting article with incomplete header information.
.PP
At each site, news are kept in a directory hierarchy below \fB/usr/spool/news\fR,
each article in a separate file, and each newsgroup in a separate directory.
The directory name is made up of the newsgroup name, with the components being
the path components. Thus, \fBcomp.os.linux\fR articles are kept in
\&\fB\fB/usr/spool/news\fR/comp/os/linux\fR. The articles in a newsgroup are assigned
numbers in the order they arrive. This number serves as the file's name.
The range of numbers of articles currently online is kept in a file called
\&\fBactive\fR.
.PP
Since disk space is a finite resource only,
.FS 
Some people claim that Usenet is a conspiracy by modem and hard disk
vendors. This is of course ridiculous.
.FE
 one has to start throwing away articles after some time. This is called
\&\fIexpiring\fR. Usually, articles from certain groups and hierarchies
are expired at a fixed number of days after they arrive. This may be
overridden by the poster by specifying a date of expiry in the \fBExpires:\fR
field of the article header.
.PP
.NH 2
A\ Description\ of\ Cnews
.br
.PP
.PP
One of the most popular software packages for Netnews is Cnews. It was
designed for sites that carry news over UUCP links. Its main component
is \fBrelaynews\fR, which takes incoming  articles, stores it
on the local host, and forwards it to the appropriate sites.
.PP
Cnews stores its configuration files in \fB/usr/local/lib/news\fR, and most of
its binaries in the \fB/usr/local/lib/news/bin\fR directory.
Articles are kept below \fB/usr/spool/news\fR. You should make sure
virtually all files in these directories are owned by user \fBnews\fR,
group \fBnews\fR. Most problems arise from files inaccessible to
Cnews. Make it a rule for you to become user \fBnews\fR using \fBsu\fR
before you touch anything in there.
.FS 
The only exceptions is \fBsetnewsids\fR, which is used to
set the real user id of some news programs. It must be
owned by \fBroot\fR and must have the setuid bit set.
 
.FE
.PP
In the following, we describe all Cnews configuration files in detail,
and show you what you need to do to keep your site running.
.PP
.PP
.NH 3
Delivering\ News
.br
.PP
.PP
Articles may be fed to Cnews in several ways. When a local user posts
an article, the newsreader usually hands it to the \fBinews\fR command,
which completes the header information. News from remote sites, be it
a single article or a whole batch, is given to the \fBrnews\fR command,
which stores it in the \fB/usr/spool/news\fR\fBin.coming\fR direcotry, from where
it will be picked up at a later time by \fBnewsrun\fR. With any of these
two techniques, however, the article will eventually be handed to
the \fBrelaynews\fR command.
.PP
For each article, \fBrelaynews\fR first checks if the article has already
been seen at the local site by looking up the message id in the \fBhistory\fR
file. Duplicate articles will be dropped. Next, \fBrelaynews\fR 
looks at the \fBNewsgroups:\fR header line to find out if the local site
requests articles from any of these groups.
If it does, \fBrelaynews\fR tries to store the article in the
corresponding directory in the news spool area, and the article's
message id will be logged to the \fBhistory\fR file. Otherwise, it
drops the article.
.PP
If \fBrelaynews\fR fails to store an incoming article because a group
it has been posted might not exist, the article will be moved to the
\&\fBjunk\fR group.
.FS 
Note that there may be a difference between the groups that exist at your
site, and those that your site is willing to receive. For example, the
subscription list may specify \fBcomp.all\fR, which means all newsgroups
below the \fBcomp\fR hierarchy, but at your site, you have only created
spool directories for a number of \fBcomp\fR groups.
.FE
 \fBrelaynews\fR will also check for stale or misdated articles
and reject them. Incoming batches that
fail for any other reason are moved to \fB/usr/spool/news\fR\fB/in.coming/bad\fR,
and an error message is logged.
.PP
After this, the article will be relayed to all other sites that
request news from these groups, using the transport specified for
each particular site. To make sure it isn't sent to a site that
already has seen it, each destination site is checked against the
article's \fBPath:\fR header field, which contains the list of
sites the article has traversed so far.
.FS 
It is in fact a bang path style return address of the poster.
It is not wise to use this, though, since not all systems that 
exchange news do exchange mail. Better use the address given in
\&\fBFrom:\fR.
.FE
 Only if the destination site's name does not appear in this list will
the article be sent to it.
.PP
Cnews is commonly used to relay news between UUCP sites, altough it is
also possible to use it in a NNTP environment. To deliver news to
a remote site --- either single articles or whole batches --- \fBuux\fR
is used to execute the \fBrnews\fR command on the remote site, and
feed the article or batch to it on standard input.
.PP
When batching is enabled for a given site, Cnews does not send any
incoming article immediately, but appends its path name
to a file, usually \fBout.going/\fBsite\fR/togo\fR.
Periodically, a \fIbatching\fR program is executed from a crontab
entry,
.FS 
Note that this should be the crontab of \fBnews\fR, in order not
to mangle file permissions.
.FE
 which puts the articles in one or more files, optionally
compresses them, and sends them to \fBrnews\fR at the remote site.
The configuration options that apply to batching are described below
in section See section Article Batching.
.PP
Figure ?? shows the news flow through
\&\fBrelaynews\fR. Articles may be relayed to the local site
(denoted by \fBME\fR), to some site named \fBponderosa\fR via email,
and a site named \fBmoria\fR, for which batching is enabled.
.PP
.PP
.NH 3
Installation
.br
.PP
To install Cnews, untar the files into their proper places if you
haven't done so yet, and edit the configuration files listed below.
They are all located in \fB/usr/local/lib/news\fR.
Their formats will be described in the following sections.
.PP
.IP \fBsys\fR\ 
You probably have to modify the \fBME\fR line that describes
your system, although using \fBall/all\fR is always
a safe bet. You also have to add a line for each site
you feed news to.
.IP
If you are a leaf site, only a line that
returns any locally generated articles to your feed is needed.
Assume your feed is \fBmoria\fR, then your \fBsys\fR file
should look like this:
.IP
.QP
.nh
.DS
.ft CW
ME:all/all::
moria/moria.orcnet.org:all/all:f:
         
.DE
.ft R
\&\&
.PP
.IP \fBorganization\fR\ 
Put your organization's name here. For example,
``\fBVirtual Brewery, Inc.\fR''.
.IP
.IP \fBmailname\fR\ 
Your site's mail name, e.g. \fBlinus.lxnet.org\fR.
.IP
.IP \fBwhoami\fR\ 
Your site's name for news purposes. Quite often, the
UUCP site name is used, for example \fBlinus\fR.
.IP
.IP \fBexplist\fR\ 
You should probably edit this file to reflect your preferred
expiry times for some special newsgroups. Space considerations
may play an important role in it.
.PP
To create an initial hierarchy of newsgroups, proceed as follows:
Create the following newsgroups using the \fBaddgroup\fR command:
\&\fBto.\fBmysite\fR\fR, \fBto.\fBfeedsite\fR\fR, \fBjunk\fR, and \fBcontrol\fR.
You should create the \fBto.*\fR groups regardless of whether you plan
to use ihave/sendme or not.
.PP
Then ask the site that feeds
you to send you a \fBcheckgroups\fR message. They can do this by composing
an article that contains their \fBnewsgroups\fR file, and has a header
line of ``\fBControl: checkgroups\fR''. They should then post it to
\&\fBto.\fBmysite\fR\fR (and make sure no other site gets it). When this
article arrives at your site, Cnews will put the article's contents in
its \fBnewsgroups\fR file, and compose a shell script that contains the
necessary \fBaddgroup\fR commands to create all groups, which it sends
to the newsmaster. You should then save this to a file, remove the
mail header, and feed it to a shell. Voil`a!
.PP
Cnews requires a user to send error messages and status reports to. By default,
this is \fBusenet\fR. If you use the default, you have to set up an account
for it, probably forwarding all of its mail to one or more responsible
persons. (Chapters See section Configuring smail. and See section sendmail. explain how to do so for
\&\fBsmail\fR and \fBsendmail\fR). You may also override this behavior by setting
the environment variable \fBNEWSMASTER\fR to the appropriate name.
You have to do so in \fBnews\fR' crontab file, as well as every time you
invoke an administrative tool manually.
.PP
While you're hacking \fB/etc/passwd\fR, make sure that every user has 
her real name in the \fBpw_gecos\fR field of the password file (this
is the fourth field). It is a question of Usenet netiquette that the
sender's real name appears in the \fBFrom:\fR field of the article.
Of course, you will want to do so anyway when you use mail.
.PP
.NH 3
The\ \fBsys\fR\ file
.br
.PP
.PP
The \fBsys\fR file, located in \fB/usr/local/lib/news\fR, controls which
hierarchies you receive and forward to other sites. Although there
are a maintenance tools named \fBaddfeed\fR and \fBdelfeed\fR, I think
it's better to maintain these files by hand.
.PP
The file contains entries for each site you forward news to, as
well as a description of the groups you will accept.
An entry looks as follows:
.PP
.QP
.nh
\&\fBsite\fR[/\fBexclusions\fR]:\fBgrouplist\fR[/\fBdistlist\fR][:\fBflags\fR[:\fBcmds\fR]]
.PP
Entries may be continued across newlines using a backslash (`\fB\e\fR').
A hash sign (`\fB#\fR') denotes a comment.
.PP
.IP \fB\fBsite\fR\fR\ 
This is the name of the site the entry applies to. One
usually chooses the site's UUCP name for this.
There has to be an entry for your site in the \fBsys\fR file, too,
else you will not receive any articles yourself.
The special site name \fBME\fR denotes your site.
.IP
Since Cnews checks \fB\fBsite\fR\fR against the site names in
the \fBPath:\fR header field, you have to make sure they really
match. Some sites use their fully qualified domain name in this
field, or an alias like \fBnews.\fBsite.domain\fR\fR. To prevent
any articles from being returned to these sites, you have to add
these to the exlusion list, separated by commas.
.IP
.IP \fB\fBgrouplist\fR\fR\ 
This is a comma-separated subscription list of groups and
hierarchies for that particular site. A hierarchy may be specified
by giving either the hierarchy's prefix (such as \fBcomp.os\fR
for all groups whose name starts with this prefix), or by
giving the prefix with \fBall\fR appended (e.g. \fBcomp.os.all\fR).
A hierarchy or group is excluded from forwarding by preceding it
with an exclamation mark (`\fB!\fR'). If a newsgroup is checked
against the list, the longest match applies. For example, if
\&\fB\fBgrouplist\fR\fR contains 
.IP
.QP
.nh
!comp,comp.os.linux,comp.folklore.computers
.PP
.LP
no groups from the \fBcomp\fR hierarchy except
\&\fBcomp.folklore.computers\fR and all groups below
\&\fBcomp.os.linux\fR will be fed to that site.
.IP
If the site requests to be forwarded all news
you receive yourself, enter \fBall.all\fR as \fB\fBgrouplist\fR\fR.
.IP
.IP \fB\fBdistlist\fR\fR\ 
is offset from the \fB\fBgrouplist\fR\fR by
a slash, and contains a list of distributions to be forwarded.
Again, you may exclude certain distributions by preceding them 
with an exclamation mark. All distributions are denoted by
\&\fBall\fR. Omitting \fB\fBdistlist\fR\fR implies a list of \fBall\fR.
.IP
For example, you may use a distribution list of \fBall,!local\fR
to prevent news for local use only from being sent to remote sites.
.IP
There are usually at least two distributions: \fBworld\fR, which is
often the default distribution used when none is specified by the
user, and \fBlocal\fR. There may be other distributions that apply to
a certain region, state, country, etc. Finally, there are two
distributions used by Cnews only; these are \fBsendme\fR and
\&\fBihave\fR, and are used for the sendme/ihave protocol.
.IP
The use of distributions is a subject of debate. For one, some
newsreaders (most notorius is a Mac newsreader) create bogus
distributions by simply using the top level hierarchy, for
example \fBcomp\fR when using to \fBcomp.os.linux\fR.
Distributions that apply to regions are often questionable, too,
because news may travel outside of your region when sent across
the Internet.
.FS 
It is not impossible for an article posted in, say Hamburg,
to go to Frankfurt via \fBreston.ans.net\fR.
.FE
 Distributions applying to an organization, however, are very
well meaningful, for example to prevent confidential information
from leaving the company network. This purpose, however, is
generally served better by creating a separate newsgroup
or hierarchy.
.IP
.IP \fB\fBflags\fR\fR\ 
This describes certain parameters for the feed. It may be
empty, or a combination of the following:
.IP
.RS
.IP \fBF\fR\ 
This flag is used to enable batching of articles.
The \fB\fBcmds\fR\fR field contains a pathname for placing
the article lists.
.IP \fBf\fR\ 
This is almost identical to the \fBF\fR flag, but allows 
Cnews to calculate the size of outgoing batches more
precisely.
.IP \fBL\fR\ 
This tells Cnews only to transmit articles posted at your
site. This flag may be followed by a decimal number
\&\fB\fBn\fR\fR, which makes Cnews only transfer articles
posted within \fB\fBn\fR\fR hops from your site. Cnews
determines the number of hops from the length of the
\&\fBPath:\fR field.
.IP \fBI\fR\ 
This flag makes Cnews produce an article list suitable
for use by ihave/sendme.
.IP \fBn\fR\ 
This creates batch files for use with the active NNTP transfer
client, \fBnntpxmit\fR
(see section See section nntpxmit.).
The batch files contain the articles filename along with
its message id.
.IP \fBu\fR\ 
This tells Cnews only to batch articles from unmoderated
groups. 
.IP \fBm\fR\ 
This tells Cnews only to batch articles from moderated
groups. 
.RE
.IP
You may use at most one of \fBF\fR, \fBf\fR, \fBI\fR, or \fBn\fR.
.IP
.IP \fB\fBcmds\fR\fR\ 
This field contains a command to be executed for each article,
unless batching is enabled. This should only be used for very
small feeds; otherwise the load on both systems will be too high.
.IP
If batching is enabled using either of the \fBF\fR or \fBf\fR flags,
Cnews expects to find a directory name in this field rather than
a command. The same applies when using NNTP or ihave/sendme.
(For batching and delivery, it uses the batcher and
transport specified in the \fBbatchparms\fR file,
see section See section Article Batching.). This directory is used
to create various batching-related files in it, among other the
list of all articles queued for this site.
.FS 
This list is kept in the file \fBtogo\fR.
.FE
.IP
The directory must be given as relative to \fB/usr/spool/news\fR\fBout.going\fR.
If the field is empty, the directory name defaults to the
site name.
.IP
.PP
When setting up Cnews, you will most probably have to write your own
\&\fBsys\fR file. To help you with it, we give a sample file for
\&\fBlinus.lxnet.org\fR below, from which you might copy what you need.
.PP
.QP
.nh
.DS
.ft CW
# We take whatever they give us.
ME:all/all::
\&\&
# We send everything we receive to moria, except for local and
# brewery-related articles.
moria/moria.orcnet.org:all,!to,to.moria/all,!local,!brewery:f:
\&\&
# We mail comp.security to jack@ponderosa.uucp
ponderosa:comp.security/all::rmail jack@ponderosa.uucp
\&\&
# swim gets a minor feed
swim/swim.two.birds:comp.os.linux,rec.humor.oracle/all,!local:f:
 
.DE
.ft R
\&\&
.PP
.NH 3
The\ \fBactive\fR\ file
.br
.PP
.PP
The \fBactive\fR file is also located in \fB/usr/local/lib/news\fR and
lists all groups known at your site,
and the articles currently online. You will rarely have to touch
it, but we explain it nevertheless for sake of completeness.
Entries take the following form:
.PP
.QP
.nh
\&\fBnewsgroup\fR: \fBhigh\fR \fBlow\fR \fBperm\fR
.PP
\&\fB\fBnewsgroup\fR\fR is, of course, the group's name. \fB\fBlow\fR\fR
and \fB\fBhigh\fR\fR are the lowest and highest numbers of articles
currently available. These are 6-digit decimal numbers. If no articles
are currently available, they take the values \fB1\fR and \fB0\fR,
respectively.
.PP
\&\fB\fBperm\fR\fR is a parameter detailing the access users are
granted to the group. It takes one of the following values:
.PP
.IP \fBy\fR\ 
Users are allowed to post to this group.
.IP \fBn\fR\ 
Users are not allowed to post to this group. However,
the group may still be read.
.IP \fBx\fR\ 
This group has been disabled locally. This happens
sometimes when news admininistrators (or their superiors)
take offense in articles posted to certain groups.
.IP
Articles received for this group are not stored locally,
although they are forwarded to the sites that request
them.
.IP \fBm\fR\ 
This denotes a moderated group. When a user tries to
post to this group, an intelligent newsreader will notify
her of this, and send the article to the moderator
instead. The moderator's address is taken from 
the \fBmoderators\fR file in \fB/usr/local/lib/news\fR.
.IP \fB=\fBreal-group\fR\fR\ 
This marks \fB\fBnewsgroup\fR\fR as being a local alias for
another group, namely \fB\fBreal-group\fR\fR. All articles
posted to \fB\fBnewsgroup\fR\fR will be redirected to it.
.PP
In Cnews, you will generally not have to access this file directly.
Groups may be added or deleted locally using \fBaddgroup\fR and
\&\fBdelgroup\fR (see below in section See section Cnews Maintenance.).
When groups are added or deleted for the whole of Usenet, this
is usually done by sending a \fBnewgroup\fR or \fBrmgroup\fR
control message, respectively.  Never send such a message yourself!
For instructions on how to create a newsgroup, read the monthly
postings in \fBnews.announce.newusers\fR.
.PP
A file closely related to \fBactive\fR is \fBactive.times\fR. Whenever
a group is created, Cnews logs a message to this file, containing
the name of the group created, the date of creation, whether it
was done by a \fBnewgroup\fR control message or locally, and who did it.
This is for the convenience of newsreaders who may notify the user
of any recently created groups. It is also used by the \fBNEWGROUPS\fR
command of NNTP.
.PP
.NH 3
Article\ Batching
.br
.PP
.PP
Article batching is performed by \fBsendbatches\fR, located in
\&\fB/usr/local/lib/news/bin\fR\fB/batch\fR. It should be executed once per hour
or even more frequently, depending on the volume of traffic.
.PP
Its operation is controlled by the \fBbatchparms\fR file in \fB/usr/local/lib/news\fR.
This file describes the maximum batch size allowed for each site, the
batching and optional compression program to be used, and the transport
for delivering it to the remote site.
Unless you have special requirements for one of your feeds, you will
not have to touch this file. Entries take the following format:
.PP
.QP
.nh
\&\fBsite\fR \fBsize\fR \fBmax\fR \fBbatcher\fR \fBmuncher\fR \fBtransport\fR
.PP
The meaning of these fields is as follows:
.PP
.IP \fB\fBsite\fR\fR\ 
This is the name of the site the entry applies to. A default
entry may be given, using the special site name \fB/default/\fR.
.IP
\&\fBsendbatches\fR extracts the site name from the entry, and checks
the \fBout.going/\fBsite\fR/togo\fR file for any batched articles.
.IP
.IP \fB\fBsize\fR\fR\ 
This is the maximum size of article batches created (before
compression). An exception from this are articles whose size
exceeds \fB\fBsize\fR\fR; these are put in a single batch nevertheless.
.IP
.IP \fB\fBmax\fR\fR\ 
is the maximum number of batches created and scheduled
for transfer before batching stalls for this particular site. This
is useful in case the remote site should be down for a longer time,
because it prevents Cnews from cluttering your UUCP spool directories 
with zillions of newsbatches.
Cnews determines the number of queued batches using the
\&\fBqueulen\fR script in \fB/usr/local/lib/news/bin\fR. Vince Skahan's
newspak release should contain a script for BNU-compatible UUCPs.
If you use a different flavor of spool directories, for example,
Taylor UUCP, you might have to get a different script from
the Cnews source, or write your own.
.FS 
The current source of Cnews does not contain a \fBqueuelen\fR script
for a Taylor-style spool hierarchy.
.FE
e
.FS 
If you don't care about the number of spool files (because
you're the only person using your computer, and you don't
write articles by the megabyte), you may replace the script's
content by a simple \fBexit 0\fR statement.
.FE
.IP
.IP \fB\fBbatcher\fR\fR\ 
This field contains the command used for producing a batch from
the list of articles in the \fBtogo\fR file. For regular feeds,
this is usually \fBbatcher\fR. For other purposes, alternative
batchers may be provided. For example, the ihave/sendme protocol
requires to turn the article list into ihave or sendme control
messages, which are posted to the newsgroup \fBto.\fBsite\fR\fR.
This is performed by \fBbatchih\fR and \fBbatchsm\fR.
.IP
.IP \fB\fBmuncher\fR\fR\ 
The \fB\fBmuncher\fR\fR field specifies the command used for compression.
Usually, this is \fBcompcun\fR, a script that produces a compressed
batch.
.FS 
As shipped with Cnews, \fBcompcun\fR uses \fBcompress\fR with the
12 bit option, since this is the least common denominator for most
Un*x sites. You may produce a copy of it, say \fBcompcun16\fR,
where you use 16 bit compression. The improvement is not too
impressive, though.
.FE
 Alternatively, you might provide a muncher that uses \fBgzip\fR,
say \fBgzipcun\fR (to be clear: you have to write it yourself).
You have to make sure that \fBuncompress\fR on the remote site 
is patched to recognize files compressed with \fBgzip\fR.
.IP
If the remote site is not have an \fBuncompress\fR command,
you may specify \fBnocomp\fR which does not do any compression.
.IP
.IP \fB\fBtransport\fR\fR\ 
The last field describes the transport to be used.
A number of standard commands for different transports are available
whose names begin with \fBvia\fR. They are given the site name as
an argument on the command line. This is derived from the \fB\fBsite\fR\fR
field by stripping of anything after and including the first dot
or slash.
.IP
There are two commands for use of \fBuux\fR to execute \fBrnews\fR
on the remote system; \fBviauux\fR and \fBviauuxz\fR. The latter
sets the \fB-z\fR flag for (older versions of) \fBuux\fR to keep it
from returning success messages for each article delivered. Another
two commands are for mail transport; both send the article to the
user \fBenews\fR on the remote system, they are called \fBviaemail\fR
and \fBviapmail\fR, with the latter protecting the article against
stupid mailers by prepending `\fBN\fR' to each line.
For a complete list of these transports, refer to the
\&\fBnewsbatch(8)\fR manual page.
.PP
All commands from the last three fields must be located in
\&\fB/usr/local/lib/news/bin\fR\fB/batch\fR.
Most of them are scripts, so that you may easily tailor new
tools for your personal needs. They are invoked as a pipe, with the
list of articles fed to the batcher on standard input, which
produces the batch on standard output. This piped into the muncher,
and so on.
.PP
When \fBsendbatches\fR is invoked without an argument, it handles all
batch queues. The interpretation of ``all'' depends on the presence
of a \fB/default/\fR entry in \fBbatchparms\fR. If one is found,
all directories in \fB/usr/spool/news\fR\fB/out.going\fR are checked, otherwise,
it cycles through all entries in \fBbatchparms\fR.
.PP
A sample file is given below.
.PP
.QP
.nh
.DS
.ft CW
# batchparms file for the brewery
# site        | size   |max    |batcher  |muncher    |transport
#-------------+--------+-------+---------+-----------+-----------
/default/       100000  22      batcher   compcun     viauux
swim             10000  10      batcher   nocomp      viauux
 
.DE
.ft R
\&\&
.PP
.NH 3
Expiring\ News
.br
.PP
.PP
In Bnews, expiring used to be performed by a program called \fBexpire\fR,
which took a list of newsgroups as argument, together with a time
specification after which articles had to be expired.
To have different hierarchies expired at different times, you had
to write a script that invoked \fBexpire\fR for each of them separately.
Cnews offers a more convenient solution to this: in a file called
\&\fBexplist\fR, you may specify newsgroups and expiration intervals.
A command called \fBdoexpire\fR is usually run once a day from 
\&\fBcron\fR, which processes all groups according to this list.
.PP
Additionally, you may want to retain articles from certain groups 
even after they have been expired; for example, you might want to
keep programs posted to \fBcomp.sources.unix\fR. This is called
\&\fIarchiving\fR. \fBexplist\fR permits to mark groups for archiving.
.PP
An entry in \fBexplist\fR looks like this:
.QP
.nh
\&\fB\fBgrouplist\fR\fR \fB\fBperm\fR\fR \fB\fBtimes\fR\fR \fB\fBarchive\fR\fR
.PP
.IP \fB\fBgrouplist\fR\fR\ 
\&\fB\fBgrouplist\fR\fR is a comma-separated list of newsgroups to which
the entry applies. Hierarchies may be specified by giving the group
name prefix, optionally appended with \fBall\fR. For example, for
an entry applying to all groups below \fBcomp.os\fR, you might
either enter \fBcomp.os\fR or \fBcomp.os.all\fR in
\&\fB\fBgrouplist\fR\fR.
.IP
When expiring news from a group, the name is checked against all
entries in \fBexplist\fR in the order given. The first matching entry
applies. For example, to throw away the majority of \fBcomp\fR after
four days, except for \fBcomp.os.linux.announce\fR which you want
to keep for a week, you simply have an entry for the latter,
which specifies a seven-day expiry period, followed by that for
\&\fBcomp\fR, which specifies four days.
.IP
.IP \fB\fBperm\fR\fR\ 
The \fB\fBperm\fR\fR field details if the entry applies to moderated,
unmoderated, or any groups. It may take the values \fBm\fR,
\&\fBu\fR, or \fBx\fR, which denote moderated, unmoderated, or any
type.
.IP
.IP \fB\fBperm\fR\fR\ 
The third field, \fB\fBtimes\fR\fR, usually only contains a single number,
being the number of days after which articles will be expired if
not assigned an artificial expiry date due to an \fBExpires:\fR field
in the article header. Note that this is the number of days counting
from its \fIarrival\fR at your site, not the date of posting.
.IP
The \fB\fBtimes\fR\fR field may, however, be more complex than that.
It may be a combination of up to three numbers, separated from each
other by a dash. The first denotes the number of days that have to
pass before the article is considered a candidate for expiry. It is
rarely useful to use a value other than zero. The second field is
the above-mentioned default number of days after which it will be
expired. The third is the number of days after which an article will
be expired unconditionally, regardless of whether it has an
\&\fBExpires:\fR field or not. If only the middle number is given, the
other two take default values. They may be specified using the special
entry \fB/bounds/\fR, which is described below.
.IP
.IP \fB\fBperm\fR\fR\ 
The fourth field, \fB\fBarchive\fR\fR, denotes whether the newsgroup is
to be archived, and where. If no archiving is intended, a dash 
should be used.
Otherwise, either a full path name (pointing to a directory) is used,
or an at sign (`\fB@\fR'). The at sign denotes the default archive
directory which must then be given to \fBdoexpire\fR by using the
\&\fB-a\fR flag on the command line.
An archive directory should be owned by \fBnews\fR. When \fBdoexpire\fR
archives an article from, say \fBcomp.sources.unix\fR, it stores it
in the directory \fBcomp/sources/unix\fR below the archive directory,
creating it if not existent. The archive directory itself, however,
will not be created.
.PP
There are two special entries in your \fBexplist\fR file that \fBdoexpire\fR
relies on to exist.
Instead of a list of newsgroups, they have the keywords \fB/bounds/\fR
and \fB/expired/\fR. The \fB/bounds/\fR entry contains the default values
for the three values of the \fB\fBtimes\fR\fR field described above.
.PP
The \fB/expired/\fR field determines how long Cnews will hold on to
lines in the \fBhistory\fR file. This is needed because Cnews will not
remove a line from the history file once the corresponding article(s)
have been expired, but hold on to it in case a duplicate should arrive
after this date. If you are fed by only one site, you can keep this
value small, otherwise a couple of weeks is advisable on UUCP networks,
depending on the delays you experience with articles from these sites.
.PP
A sample \fBexplist\fR file is reproduced below:
.PP
.QP
.nh
.DS
.ft CW
# keep history lines for two weeks. Nobody gets more than three months
/expired/                       x       14      -
/bounds/                        x       0-1-90  -
\&\&
# groups we want to keep longer than the rest
comp.os.linux.announce          m       10      -
comp.os.linux                   x       5       -
alt.religion.kibology           u       10      -
rec.humor.oracle                m       10      -
soc.feminism                    m       10      -
\&\&
# Archive *.sources groups
comp.sources,alt.sources        x       5       @
\&\&
# defaults for tech groups
comp,sci                        x       7       -
\&\&
# enough for a long weekend
misc,talk                       x       4       -
\&\&
# throw away junk quickly
junk                            x       1       -
\&\&
# control messages are of scant interest, too
control                         x       1       -
\&\&
# catch-all entry for the rest of it
all                             x       2       -
 
.DE
.ft R
\&\&
.PP
With expiring in Cnews, there are a number of potential troubles looming.
One is that your newsreader might rely on the third field of the
active file, which contains the number of the lowest article on-line.
When expiring articles, Cnews does not update this field. If you need
(or want) to have this field represent the real situation, you need to
run a script called \fBupact\fR regularly.
.PP
Second, Cnews does not expire by scanning the newsgroup's directory,
but simply checks the \fBhistory\fR file if the article is due for
expiry.
.FS 
The article's date of arrival is kept in the middle field of the
history line, given in seconds since January 1, 1970.
.FE
 If your history file somehow gets out of sync, articles may be
around on your disk infinitely, because Cnews has literally forgotten
them.
.FS 
I don't know \fIwhy\fR this happens, but it does from time to time.
.FE
 You can repair this using the \fBaddmissing\fR script in \fB/usr/local/lib/news/bin\fR\fB/maint\fR,
which will add missing articles to the \fBhistory\fR file, or
\&\fBmkhistory\fR, which re-builds the file from scratch.
Don't forget to become \fBnews\fR before invoking it, else you will
wind up with a \fBhistory\fR file unreadable by Cnews.
.PP
.NH 3
Miscellaneous\ Files
.br
.PP
.PP
There are a number of files that control Cnews' behavior, but are not
essential to its functioning. All of them reside in \fB/usr/local/lib/news\fR. We
will describe them shortly.
.PP
.IP \fBorganization\fR\ 
This file contains a single line that identifies your organization.
If the machine is owned by Foobar, Inc., put this name in the file.
If it is privately owned, enter ``private site'', or anything else
you like.
Most people will not call your site properly configured if you
haven't customized this file.
.IP \fBnewsgroups\fR\ 
This is a companion file of \fBactive\fR which contains a list of
newsgroups names, along with a one-line description of its charter.
This file is automatically updated when Cnews receives a \fBchecknews\fR
control message (see section See section Control Messages.).
.IP \fBlocalgroups\fR\ 
If you have a number of local groups that you don't want Cnews
to complain about every time you receive a \fBchecknews\fR
message, put their names and descriptions in this file, just like
they shall appear in \fBnewsgroups\fR.
.IP \fBmailpaths\fR\ 
This file contains the moderator's address for each moderated
group. Each line contains the group name, followed by the
moderator's email address (offset by a tab).
.IP
Two special entries are provided as default. These are
\&\fBbackbone\fR and \fBinternet\fR. Both provide --- in bang-path
notation --- the path to the nearest backbone site, and the site
that understands RFC 822-style addresses (\fBuser@host\fR).
The default entries are
.IP
.QP
.nh
.DS
.ft CW
internet        s
backbone        s
         
.DE
.ft R
\&\&
.PP
You will not have to change the \fBinternet\fR entry if you have
\&\fBsmail\fR or \fBsendmail\fR installed, because they understand
RFC 822-addressing. 
.IP
The \fBbackbone\fR entry is used whenever a user posts to a
moderated group whose moderator is not listed explicitly.
If the newsgroup's name is \fBalt.sewer\fR, and the \fBbackbone\fR
entry contains \fB\fBpath\fR!s\fR, Cnews will mail the article
to \fB\fBpath\fR!alt-sewer\fR, hoping that the backbone
machine is able to forward the article.
.IP \fBwhoami\fR\ and\ \fBmailname\fR\ 
These files contain the site's name as used in locally generated
articles (\fBwhoami\fR) and mail sent by Cnews (\fBmailname\fR),
respectively. Cnews may send mail to the news gurus, indicating
errors, or in reply to a \fBsendsys\fR control message.
.IP
If these files do not exist, Cnews tries to obtain the hostname
from various sources, with \fBhostname(1)\fR being the
last resort.
.IP
These files are provided in case you want to use a host alias
instead of your (canonical) host name. This is useful to hide
the physical location of your news system, so that you may
move it easily from one machine to another.
.IP \fBserver\fR\ 
You need this file if you are running a cluster of machines,
with articles kept on a central node, whose spool area is
mounted by the other hosts via NFS. It contains the name of
the machine that acts as the ``news server'', in that every article
may only be posted by this machine. Cnews takes care of this in
the following way: When posting an article through \fBinews\fR,
it checks if \fBserver\fR exists, and if the name contained in it
is its own hostname. If so, it proceeds by giving the article to
\&\fBrelaynews\fR; otherwise, it passes it on to \fBinews\fR on
the central host by executing \fBrsh\fR.
.IP
Note that this requires that you have an equivalent account on
the server machine that lets you in without asking for a password.
You therefore have to have an \fB.rhosts\fR file set up properly
in \fBnews\fR' home directory, or an entry in \fB/etc/hosts.equiv\fR
on the server. Please refer to section See section Cnews and NFS. for
details.
.IP \fBdistributions\fR\ 
This file is not really a Cnews file, but it is used by some
newsreaders, and \fBnntpd\fR. It contains the list of 
distributions recognized by your site, and a desciption of
its (intended) effect. For example, my site has the following
file:
.IP
        
.IP
.QP
.nh
.DS
.ft CW
world           evrywhere in the world
local           Only local to this site
nl              Netherlands only
mugnet          MUGNET only
fr              France only
de              Germany only
orcnet          All *.orcnet.org sites
brewery         Virtual Brewery only
         
.DE
.ft R
\&\&
.PP
.IP \fBlog\fR\ 
This file contains a log of all Cnews activities. It is culled
regularly by running \fBnewsdaily\fR; copies of the old logfiles
are kept in \fBlog.o\fR, \fBlog.oo\fR, etc.
.IP \fBerrlog\fR\ 
This is a log of all error messages created by Cnews. These do not
include articles junked due to wrong group, etc. This file is mailed
to the newsmaster (\fBusenet\fR by default) automatically by
\&\fBnewsdaily\fR if it is found to be non-empty. 
.IP
\&\fBerrlog\fR is cleared by \fBnewsdaily\fR, old copies are kept in
\&\fBerrlog.o\fR and companions.
.IP \fBbatchlog\fR\ 
This logs all runs of \fBsendbatches\fR. It is usually of scant interest
only. It is also maintained by \fBnewsdaily\fR.
.IP \fBwatchtime\fR\ 
This is an empty file created each time \fBnewswatch\fR is run.
.PP
.NH 3
Control\ Messages
.br
.PP
.PP
The Usenet news protocol knows a special category of articles which evoke
certain responses or actions by the news system. These are called
\&\fIcontrol\fR messages. They are recognized by the presence of
a \fBControl:\fR field in the article header. There are several types
of them, all of which are dealt with by shell scripts located in
\&\fB\fB/usr/local/lib/news\fR/ctl\fR.
Most of these will perform their action automatically at the time
the article is processed by Cnews, without notifying the newsmaster.
By default, only \fBcheckgroups\fR messages will be handed to the
newsmaster,
.FS 
There's a lovely typo in RFC 1036 (p.12):
.QP
.nh
3.  Control Messages
\&\&
.LP
[\&...] Implementors and administrators may choose to allow control
messages to be carried out automatically, or to queue them for annual
processing.
.PP
.FE
 but you may change this by editing the scripts.
.PP
The one most widely known is the \fBcancel\fR message, with which a user
may cancel an article sent by her earlier. This effectively removes
the article from the spool directories, if it exists. The \fBcancel\fR
message is forwarded to all sites that receive news from the groups
affected, regardless of whether the article has been seen already or
not. This is to take into account that the original article has been
delayed over the cancellation message. Some news systems allow users
to cancel other person's messages; this is of course a definite no-no.
.PP
Two messages dealing with creation or removal of newsgroups are the
\&\fBnewgroup\fR and \fBrmgroup\fR message. Newsgroups below the
``usual'' hierarchies may only be created after a discussion and
voting has been held among Usenet readers. The rules applying to
the \fBalt\fR hierarchy allow for something close to anarchy.
For more information, see the regular postings in
\&\fBnews.announce.newusers\fR.
Never send a \fBnewgroup\fR ar \fBrmgroup\fR message yourself
unless you definitely know that you are allowed to.
.PP
The \fBcheckgroups\fR message mentioned above is sent by ``central
authority'' (a non-entity on Usenet) to synchronize
a site's \fBactive\fR file with the realities of Usenet. When
Cnews receives a \fBcheckgroups\fR message, it rewrites the \fBnewsgroups\fR
file, adding the groups in \fBlocalgroups\fR. If there are mismatches
between the \fBcheckgroups\fR list and the \fBactive\fR file, it sends
a message to the netnews administrator (usually \fBusenet\fR) that
contains a list of control commands to bring your site up to
date.
.FS 
Note that the message, depending on the organization that expedits
it, need not contain all Usenet newsgroups. Make sure you don't remove
any groups accidentally by believing the message blindly.
.FE
.PP
Finally, there are three messages that may be used to find out
something about the network's topology. These are \fBsendsys\fR,
\&\fBversion\fR, and \fBsenduuname\fR. They cause Cnews to
return to the sender the \fBsys\fR file, a software version string,
and the output of \fBuuname(1)\fR, respectively. Cnews is very
laconic about \fBversion\fR messages, it returns a simple, unadorned
``C''.
.PP
Again, you should \fInever\fR issue such a message, unless you have made
sure that it cannot leave a your (regional) network. Replies to
\&\fBsendsys\fR messages can quickly bring down a UUCP network.
.FS 
I wouldn't try this on the Internet, either.
.FE
.PP
.NH 3
Cnews\ in\ an\ NFS\ Environment
.br
.PP
.PP
A simple way to distribute news within a local network is to
keep all news on a central host, and export the relevant directories
via NFS, so that newsreaders may scan the articles directly.
.PP
The advantage of this method over NNTP is that the overhead involved
in retrieving and threading articles is significantly lower. NNTP,
on the other hand, wins in a heterogeneous network where equipment
varies widely among hosts, or where users don't have equivalent
accounts on the server machine.
.PP
When using NFS, of course, articles posted on a host have to be forwarded
to the central machine, because accessing adminstrative files (like
\&\fBactive\fR) might otherwise expose the system to race-conditions. Also,
you might want to protect your news spool area by exporting it read-only, which
necessitates forwarding to the central machine, too.
Cnews handles this transparently. When posting an article, the newsreader
software usually invokes \fBinews\fR. This is a script which runs a number
of checks on the article, completes the header, and checks
the file \fBserver\fR in \fB/usr/local/lib/news\fR if the host it's running on is
indeed the server. Otherwise, it invokes \fBinews\fR on the server host
via \fBrsh\fR. Note that this setup requires that the client hosts
have a standard Un*x environment (including a working \fBawk\fR,
\&\fBsed\fR, and Bourne shell). The \fBinews\fR script also uses
a number of binary commands from the Cnews distribution (e.g.
\&\fBgetdate\fR), so that you have to have different sets of binaries
for different architectures.
.PP
For the \fBrsh\fR invocation to work properly, the user needs to have an
equivalent account on the remote system, i.e. one to which she can login
without being asked for a password. How this can be achieved is explained
in section See section The r commands..
.PP
Make sure that the hostname given in \fBserver\fR literally matches the
output of the \fBhostname(1)\fR command on the server machine, else
Cnews will be looping forever when trying to deliver the article.
.PP
.NH 3
Maintenance\ Tools\ and\ Tasks
.br
.PP
.PP
Despite of the complexity of Cnews, a news administrator's life
can be fairly easy, because Cnews provides you with a wide variety
of maintenance tools. Unless stated otherwise, they are located
in \fB/usr/local/lib/news/bin\fR\fB/maint\fR. Note that you must become user \fBnews\fR
before invoking these commands. Running them as super-user may render
these files inaccessible to Cnews.
.PP
.IP \fBadddirs\fR\ 
Creates directories for all groups in the \fBactive\fR file
which do not yet have a spool directory.
.IP \fBaddfeed\fR\ 
Add a feed to your \fBsys\fR file. It is invoked as
follows:
.IP
.QP
.nh
addfeed [-L] [-f \fBfeedtype\fR] \fBsite\fR \fBgrouplist\fR
.PP
\&\fB\fBsite\fR\fR is the name of the site to be added; \fB-L\fR
signals if the \fBL\fR flag should be set on the feed ---
that is, only locally generated news is returned. The \fB-f\fR
option may be used to specify a batching flag (\fBf\fR or
\&\fBF\fR); it defaults to \fBf\fR. \fB\fBgrouplist\fR\fR is the list
of newsgroups you are willing to send to \fB\fBsite\fR\fR, optionally
followed by a list of distributions. If none are given, \fBaddfeed\fR
assumes all distributions are sent to that site.
.IP
A special \fB\fBgrouplist\fR\fR of \fB=\fBothersite\fR\fR may be used
to copy another feed's group list.
.IP
.IP \fBaddgroup\fR\ 
Adds a group to your site locally. The proper invocation is
.IP
.QP
.nh
addgroup \fBgroupname\fR y|n|m|=\fBrealgroup\fR
.PP
The second argument has the same meaning as the flag in the
\&\fBactive\fR file, meaning that anyone may post to the group (\fBy\fR),
no-one (\fBn\fR), that it is moderated (\fBm\fR), or that it is an
alias for another group (\fB=\fBrealgroup\fR\fR).
.IP
You might also want to use \fBaddgroup\fR when the first articles
in a newly created group arrive earlier than the \fBnewgroup\fR
control message that is intended to create it.
.IP \fBdelgroup\fR\ 
Allows you to delete a group locally. Invoke it as
.IP
.QP
.nh
delgroup \fBgroupname\fR
.PP
You still have to delete the articles that still reside in the
newsgroup's spool directory. Alternatively, you might leave
it to the natural course of events (a.k.a. \fBexpire\fR) to
make them go away.
.IP \fBaddmissing\fR\ 
Adds missing articles to the \fBhistory\fR file. Run this script
when there are articles that seem to hang around forever.
.FS 
Ever wondered how to get rid of that ``Help! I can't get X11 to
work with 0.97.2!!!'' article?
.FE
.IP \fBnewsdaily\fR\ 
The name already says it: runs this once a day.
It is an important script that helps you keep log files
small, retaining copies of each from the last three runs.
It also tries to sense any anomalies, like stale batches
in the incoming and outgoing directories, postings to unkown
or moderated newsgroups, etc. Resulting error messages will
be mailed to the newsmaster.
.IP \fBnewswatch\fR\ 
This is a script that may be run regularly to look for 
anomalies in the news system. It is intended to detect
problems that will have immediate effect on the operability
of your news system, like stale lock files that don't get removed,
unattended input batches, and disk space shortage.
It is invoked as
.QP
.nh
newswatch \fBminfree\fR \fBmaxbatch\fR
.PP
.IP \fBnewsboot\fR\ 
This script should be run at system boot time. It removes any lock files
left over when news processes were killed at shutdown, and closes
and executes any batches left over from NNTP connections that were
terminated.
.IP \fBnewsrunning\fR\ 
This resides in \fB/usr/local/lib/news/bin\fR\fB/input\fR, and may be used to disable
unbatching of incoming news. This may be desirable during work
hours. You may turn off unbatching by invoking 
.QP
.nh
\&\fB/usr/local/lib/news/bin\fR/input/newsrunning off
.PP
It is turned on by using \fBon\fR instead of \fBoff\fR.
.PP
.NH 2
A\ Description\ of\ NNTP
.br
.PP
.PP
.PP
.PP
.PP
Due to the different network transport used, NNTP provides for a vastly 
different approach to news exchange.
NNTP stands for ``Network News Transfer Protocol'', and is not a particular
software package, but an Internet Standard.
.FS 
Formally specified in RFC 977.
.FE
 It is based on a stream-oriented connection --- usually over TCP ---
between a client anywhere in the network, and a server on a host
that keeps netnews on disk storage. The stream connection allows
to interactively negotiate article transfer with nearly no turnaround delay,
thus keeping the number of duplicate articles low. Together with
the Internet's high transfer rates, this adds up to a news transport that
surpasses the original UUCP networks by far. While some years ago it was
not uncommon for an article to take two weeks or more before it arrived in
the last corner of Usenet, this is now often less than two days; on the
Internet itself, it is even within the range of minutes.
.PP
Various commands allow clients to retrieve, send and post articles.
The difference between sending and posting is that the latter may
involve articles with incomplete header information.
.FS 
NNTP always adds at least one header field, which is
\&\fBNntp-Posting-Host:\fR. It contains the client's host name.
.FE
 Article retrieval may be used by news transfer clients
as well as newsreaders.
.PP
NNTP provides for an active and a passive way of news transfer,
colloquially called
``pushing'' and ``pulling''. Pushing is basically the same as the Cnews
ihave/sendme protocol. The client offers an article to the server through
the ``\fBIHAVE <\fBmsgid\fR>\fR'' command, and the server returns a
response code that indicates whether it already has the article, or
if it wants it. If so, the client sends the article, terminated by a
single dot on a separate line.
.PP
Pushing news has the single disadvantage that it places a heavy load on
the server system, since it has to search its history database for every
single article.
.PP
The opposite technique is pulling news, in which the client requests a list
of all (available) articles from a group that have arrived after a specified
date. This query is performed by the \fBNEWNEWS\fR command. From the
returned list of message ids, the client selects those articles it does
not yet have, using the \fBARTICLE\fR command for each of them in turn.
.PP
The problem with pulling news is that it needs tight control by the server
over which groups and distributions it allows a client to request. For
example, it has to make sure that no confidential material from newsgroups
local to the site are sent to unauthorized clients.
.PP
There is also a number of convenience commands for newsreaders that permit
to retrieve the article header and body separately, or even single header
lines from a range of articles. This allows to keep all news on a central
host, with all users on the (presumably local) network using NNTP-based
client programs for reading and posting. (Alternatively, you could
export the news directories to the clients, so that they may directly
access the spool area. This eliminates the overhead introduced by the
NNTP session layer.
.PP
An overall problem of NNTP is that it allows the knowledgeable to insert
articles into the news stream with false sender specification. This is
called \fInews faking\fR.
.FS 
The same problem exists with SMTP.
.FE
 An extension to NNTP allows to require a user authenticication for
certain commands.
.PP
There are a number of NNTP packages available. One of the more widely
known is the NNTP daemon by Brian Barber and Phil Lapsley. It's most
recent version is \fBnntpd-1.5.11\fR, which will be described below.
You may either get the sources and compile it yourself, or use the
\&\fBnntpd\fR from Fred van Kempen's \fBnet-std\fR binary package, which
as it as \fB/etc/in.nntpd\fR.
.PP
There is also a package called ``Internet News'', or INN for short.
It provides both NNTP and UUCP-based news transport, and is said to be
more suitable for large news hubs.
It is currently at version 1.4. Since I don't know much about it,
there won't be a section on this (yet). It is said to compile with
some patches, which should be available from \fBsunsite.unc.edu\fR.
.PP
The \fBnntpd\fR package consists of a server and two clients for
pulling and pushing news, respectively, as well as an \fBinews\fR
replacement. They live in a Bnews environment,
but with a little tweaking, they will be happy with a Cnews environment,
too.
We will have a look at these components and their interaction with Cnews
below.
.PP
.NH 3
\&\fBnntpd\fR
.br
.PP
.PP
The NNTP server is called \fBnntpd\fR, and may be compiled in two ways,
depending on the expected load on the news system. It may be configured as
either a standalone server that is started at system boot time from
\&\fB/etc/rc.d/rc.net2\fR, or as a daemon managed by \fBinetd\fR.
.FS 
The \fBnntpd\fR from Fred van Kempen's \fBnet-std\fR package is
configured for \fBinetd\fR service.
.FE
 In the latter case you have to have the following entry in
\&\fB/etc/inetd.conf\fR:
.PP
.QP
.nh
.DS
.ft CW
nntp    stream  tcp nowait      news    /etc/in.nntpd    nntpd
 
.DE
.ft R
\&\&
.PP
If you configure \fBnntpd\fR as standalone, make sure there's no such
line in \fBinetd.conf\fR, and if there is, comment it out. In both cases,
you have to make sure there's the following line in \fB/etc/services\fR:
.PP
.QP
.nh
.DS
.ft CW
nntp    119/tcp   readnews untp    # Network News Transfer Protocol
 
.DE
.ft R
\&\&
.PP
.NH 3
NNTP\ Access.
.br
.PP
.PP
Access to NNTP resources is governed by the file \fBnntp_access\fR in
\&\fB/usr/local/lib/news\fR. Lines in the file describe the access rights granted to systems.
They have the following format:
.PP
.QP
.nh
\&\fBsite\fR   read|xfer|both|no    post|no      [!\fBexceptgroups\fR]
.PP
If a client connects to the NNTP port, \fBnntpd\fR attempts to obtain the
host's fully qualified domain name through reverse mapping
(see section See section The Domain Name System. on ??tcpip.dns).
Note that this returns the host's canonical
name. The client's hostname and IP address are checked against the \fB\fBsite\fR\fR
field. Matches may be partial or exact. If an entry matches exactly, the
entry's information applies; if it is partial, it only applies if there is no
other match following which is at least as good.
\&\fB\fBsite\fR\fR may be one of the following:
.PP
.IP hostname\ 
This is a fully qualified domain name of a host. If this matches
the client's canonical hostname literally, the entry applies,
and all following entries are ignored.
.IP IP\ address\ 
This is an IP address in dotted quad notation.  If the client's
IP address matches this, the entry applies,
and all following entries are ignored.
.IP domain\ name\ 
This is a domain name, specified as \fB*.\fBdomain\fR\fR. If the
client's hostname matches the domain name, the entry matches.
.IP network\ name\ 
This is the name of a network as specified in \fB/etc/networks\fR.
If the network number of the client's IP address matches the
network number associated with the network name, the entry matches.
.IP subnet\ name\ 
This is the name of a subnet of the local network as specified in
the \fB/etc/networks\fR file. The subnet mask is obtained by querying
the network interfaces.
.FS 
This option is only enabled if \fB-DSUBNET\fR has been defined as
compile-time option.
.FE
If the network number of the client's IP address matches the
network number associated with the network name, the entry matches.
.IP \fBdefault\fR\ 
If the entry's name is \fBdefault\fR, it matches any client.
.PP
Entries with more general site specification should be specified earlier,
because any matches by these will be overridden by later, more exact
matches.
.PP
The tokens from the second and third field describe the access rights granted
to the client. The first details the permissions the read news, and transmit
news (using ihave/sendme). A value of \fBboth\fR enables both, \fBno\fR denies
access altogether. The third field grants the client posting rights (the
difference between sending articles and postiong was described above).
If the second field contains \fBno\fR, the third field is ignored.
.PP
Capitalization of these tokens causes \fBnntpd\fR to require
authenticication for read, transfer, and post commands.
.PP
The fourth field is optional, and contains a comma-separated list of groups
the client matched by this entry may is denied access to.
.PP
.NH 3
NNTP\ Authorization
.br
.PP
.PP
As described above, \fBnntpd\fR allows for authorization procedures for
certain clients. This is implemented by means of a new NNTP command
named \fBAUTHINFO\fR. Using this command, the client may transmit a user name
and a password to the NNTP server, which will validate these.
.PP
\&\fBnntpd\fR will check user name and password against the
\&\fB/etc/passwd\fR database, and verify that the user belongs to the
\&\fBnntp\fR group.
.PP
The NNTP clients included in the \fBnntpd\fR package expect to find the
authorization data in a file called \fB/etc/nntp.sys\fR which
contains triples of hostnames, user names, and passwords. These describe
the user name and password to be used on a per-server basis. Note that
the passwords are not encrypted, so that you must set the file's modes
to \fB600\fR and make it owned by \fBnews\fR.
.PP
A sample \fBnntp.sys\fR file might look like this:
.PP
.QP
.nh
.DS
.ft CW
news.fubar.edu nntpclnt Fr0b0zz
flap.jack.cookie.com intnews hurz
 
.DE
.ft R
\&\&
.PP
This tells the NNTP clients to identify themselves as user \fBnntpclnt\fR
when, for example, connecting to \fBnews.fubar.edu\fR, and to provide
\&\fBFr0b0zz\fR as password.
.PP
Note that the current implementation of NNTP authorization is only
experimental, and has therefore not been implemented very portably.
The result of this is that it only works with plain-style password
databases; shadow passwords will not be recognized.
.PP
.NH 3
\&\fBnntpd\fR\ Interaction\ with\ Cnews
.br
.PP
.PP
When receiving an article, \fBnntpd\fR has to deliver it to the news
subsystem. Depending on whether it was received as a result of an
\&\fBIHAVE\fR or \fBPOST\fR command, the article is handed to \fBrnews\fR
or \fBinews\fR, respectively. Instead of invoking \fBrnews\fR, you may also
configure it (at compile time) to batch the incoming articles and move
the resulting batches to \fB/usr/spool/news\fR\fB/in.coming\fR, where they are
left for \fBrelaynews\fR to pick them up at the next queue run.
.PP
When you compile \fBnntpd\fR, make sure it is compatible with your Cnews
configuration. Beside the correct paths, this includes making sure
they agree on the format of your history file. For example, some people
link Cnews with a replacement for the \fBdbm\fR library, called \fBdbz\fR.
For \fBnntpd\fR to work properly, it thus has to be linked with \fBdbz\fR,
too.
.FS 
I don't know if this is true for \fBnewspak\fR.
.FE
 A typical symptom of \fBnntp\fR and Cnews disagreeing on the database
format are error messages in the system log that \fBnntpd\fR could not
open it properly, as well as duplicate articles received via NNTP.
A good test is to pick some articles from your spool area and
batch them for NNTP transfer to your own site.
When being offered them by \fBnntpxmit\fR, \fBnntpd\fR should reject
them.
.PP
.NH 3
\&\fBnntpxmit\fR
.br
.PP
.PP
The \fBnntpd\fR packages also contains sources for two NNTP
clients for pushing and pulling, respectively. The first is
performed by \fBnntpxmit\fR. It takes a list of articles
and tries to transfer them to the remote host via ihave/sendme.
The list of articles may be composed using a \fBsys\fR file
entry with the \fBn\fR flag. (See section See section The sys File.
above).
.PP
There is a \fBnntpsend\fR script in the \fBnntpd\fR sources
which takes this list and feeds it to the pushing client.
However, this script leans heavily on the Bnews side, so you
might have to do some tweaking.
.NH 3
\&\fBnntpxfer\fR
.br
.PP
.PP
\&\fBnntpxfer\fR is a client for pulling news. It is invoked as
.PP
.QP
.nh
nntpxfer \fBsite\fR [\fBgrouplist YYMMDD HHMMSS\fR [<\fBdistlist\fR>]]
.PP
where \fB\fBsite\fR\fR is the site you want to receive articles from.
For each site, it keeps a file named \fBnntp.\fBsite\fR\fR in the newsspool
directory that contains the date of the last connect, the list of groups
it is to request, and an optional list of distributions. If you specify
these on the command line, this file will be ignored.
.PP
\&\fBgrouplist\fR and \fBdistlist\fR must be given as a comma-separated list
without intermediate blanks. Negation of news hierarchies and distributions
using an exclamation mark is permitted.
.PP
\&\fBnntpxfer\fR connects to \fB\fBsite\fR\fR on the \fBnntp\fR port, and queries
it for news having arrived in the listed groups after the last connection.
The server responds by returning a list of message ids, which \fBnntpxfer\fR
checks against the local \fBhistory\fR file. Articles not yet seen are
requested. However, \fBnntpxfer\fR will never transfer more than 500 articles
at once. If there are more articles than it can transfer, it will not
update the time and date fields in the \fBnntp.\fBsite\fR\fR file.
.PP
Like \fBnntpd\fR, \fBnntpxfer\fR may be configured to either batch
incoming articles, or directly hand them to \fBrnews\fR.
.PP
.bp
.NH
Newsreader\ Configuration
.br
.PP
.PP
Newsreaders are intended to offer the user functionality that
allows her to easily acess the functions of the news system, like
posting articles, or skimming the contents of a newsgroup in a
comfortable way. The quality of this interface is subject of endless
flame wars.
.PP
There are a couple of newsreaders available which have been ported to
Linux. Below I will describe the basic setup for the three most
popular ones, namely \fBtin\fR, \fBtrn\fR, and \fBnn\fR.
.PP
.PP
One of the most effective newsreaders is
.PP
.QP
.nh
.DS
.ft CW
find /usr/spool/news -name '[0-9]*' -exec cat {} \e; | more
 
.DE
.ft R
\&\&
.PP
This is the way Un*x die-hards read their news.
.PP
The majority of newsreaders, however, is much more sophisticated.
They usually offer a full-screen interface with separate levels for
displaying all groups the user has subscribed to, for displaying an
overview of all articles in one group. and for individual articles.
.PP
At the newsgroup level, most newsreaders display a list of articles,
showing their subject line, and the author. In big groups, it is impossible
for the user to keep track of articles relating to each other, although
it is possible to identify responses to earlier articles.
.PP
A response usually repeats the original article's subject, prepending
it with ``\fBRe: \fR''. Additionally, the message id of the article
it is a direct follow-up to may be given in the \fBReferences:\fR 
header line. Sorting articles by these two criteria generates
small clusters (in fact, trees) of articles, which are called
\&\fIthreads\fR. One of the tasks in writing a newsreader is devising
an efficient scheme of threading, because the time required for this
is proportional to the square of the number of articles.
.PP
Here, we will not dig any further into how the user interfaces are
built. All newsreaders currently available for Linux have a good
help function, so you ought to get along.
.PP
In the following, we will only deal with administrative tasks. Most
of these relate to creation of the threads databases and accounting.
.PP
.NH 2
\&\fBtin\fR\ Configuration
.br
.PP
.PP
The most versatile newsreader with respect to threading is \fBtin\fR.
It was written by Iain Lea and is loosely modeled on an older newsreader
named \fBtass\fR.
.FS 
Written by Rich Skrenta.
.FE
 It does its threading when the user enters the newsgroup, and it is
pretty fast at this unless you're doing this via NNTP.
.FS 
On my 486DX50, it takes roughly 30 seconds to thread 1000
articles on \fBcomp.os.linux\fR. Over NNTP to a loaded news
server, this would be somewhere above 5 minutes.
.FE
 You may improve this by cyclically updating your index file
with the \fB-u\fR option, or by invoking it with the \fB-U\fR option.
.PP
Usually, \fBtin\fR dumps its threading databases in the user's
home directory below \fB.tin/index\fR. This may however be costly
in terms of resources, so that you should want to keep a single copy
of them in a central location. This may be achieved by making \fBtin\fR
setuid to \fBnews\fR, for example, or some entirely unprivileged
account.
.FS 
However, do \fInot\fR use \fBnobody\fR for this. As a rule, no files
or commands whatsoever should be associated with this user.
.FE
 \fBtin\fR will then keep all thread databases below
\&\fB/usr/spool/news/.index\fR.
For any file access or shell escape, it will reset its effective uid to
the real uid of the user who invoked it.
.FS 
This is the reason why you will get ugly error messages when invoking
it as super user. But then, you shouldn't work as \fBroot\fR, anyway.
.FE
.PP
A better solution is to install the \fBtind\fR indexing daemon
that runs as a daemon and regularly updates the index files.
This daemon is however not included in any release of Linux,
so you would have to compile it yourself. If you are running
a LAN with a central news server, you may even run \fBtind\fR
on the server and have all clients retrieve the index files
via NNTP. This, of course, requires an extension to NNTP. Patches
for \fBnntpd\fR that implement this extension are included in
the \fBtin\fR source.
.PP
The current version of \fBtin\fR included in SLS has no
NNTP support compiled in. If however, you compile it yourself,
or there should be a release with NNTP support one day,
here's how: When invoked as \fBrtin\fR or the \fB-r\fR
option, alternatively, \fBtin\fR tries to connect to the NNTP
server specified in the file \fB/etc/nntpserver\fR or
in the \fBNNTPSERVER\fR environment variable. The \fBnntpserver\fR
file simply contains the server's name on a single line.
.PP
.NH 2
\&\fBtrn\fR\ Configuration
.br
.PP
.PP
\&\fBtrn\fR is the successor to an older newsreader, too, namely
\&\fBrn\fR (which means \fIread news\fR). The ``t'' in its name
stands for ``threaded''.  It was written by Wayne Davidson.
.PP
Unlike \fBtin\fR, \fBtrn\fR has no provision for generating its 
threading database at run-time, but uses those prepared by a
program called \fBmthreads\fR. It has to be invoked regularly
from \fBcron\fR to update the index files. If you're receiving
news during the night, you will customarily run it once in the morning,
else you might want to do so more frequently.
.PP
Not running \fBmthreads\fR, however, doesn't mean you cannot access
new articles, it only means you will have all those lovely
``Is 386BSD better than Linix??!?!'' articles scattered
across your article selection menu, instead of a single thread
you can wipe out in one keystroke (harharhar).
.PP
\&\fBmthreads\fR is invoked with a list of newsgroups you want it
to thread. The list is made up in exactly the same fashion as the
one in the \fBsys\fR file:
.PP
.QP
.nh
.DS
.ft CW
mthreads comp,rec,!rec.games.go
 
.DE
.ft R
\&\&
.PP
will thread all of \fBcomp\fR and \fBrec\fR, except for \fBrec.games.go\fR
(people who play Go don't need fancy threads). You perform threading
of all groups found in your \fBactive\fR file by specifying a group list
of \fBall\fR, or none at all.
.PP
Sites that have very heavy traffic may also run \fBmthreads\fR in daemon mode.
If it is started at boot time using the \fB-d\fR option, it puts itself
in the background, and wakes up every 10 minutes to check if there are
any newly-arrived articles. To do so, put the following line in your
\&\fB/etc/rc.d/rc.local\fR script:
.PP
.QP
.nh
.DS
.ft CW
 
.DE
.ft R
\&\&
.PP
\&\fBtrn\fR also needs to have old articles removed from the index files.
By default, only articles whose number is below the low water mark
will be removed from the index files.
.FS 
Note that Cnews doesn't update this low water mark automatically;
you have to run \fBupact\fR to do so. Please refer to
section See section Exiring News..
.FE
 Articles above this number who have been expired nevertheless
(because the oldest article has been assigned an long expiry date
by an \fBExpires:\fR header field) may be removed by giving 
\&\fBmthreads\fR the \fB-e\fR option. When running in daemon mode,
it will put in such an ``enhanced'' expiry run once a day. By default,
this is the first run after 12:30am.
.PP
.NH 2
\&\fBnn\fR\ Configuration
.br
.PP
.PP
\&\fBnn\fR, written by Kim F. Storm, claims to be a newsreader whose ultimate
goal is not to read news. It's name stands for ``No News'', and its motto is
``No news is good news. \fBnn\fR is better.''
.PP
To achieve this ambitious goal, \fBnn\fR comes along with a large
assortment of maintenance tools that not only allow generation of threads,
but also extensive checks on the consistency of these databases, accounting,
gathering of usage statistics, and access restrictions. There is also an
administration program called \fBnnadmin\fR, which allows you to
perform these tasks interactively. It is very intuitive, hence we will not
dwell on these aspects, and only deal with the generation of the index files.
.PP
The \fBnn\fR database manager is called \fBnnmaster\fR. It is usually run as
a daemon, started from the \fBrc.local\fR script. It is invoked as
.PP
.QP
.nh
.DS
.ft CW
/usr/local/lib/nn/nnmaster -l -r -C
 
.DE
.ft R
\&\&
.PP
This enables threading for all newsgroups present in your \fBactive\fR
file.
.PP
Equivalently, you may invoke \fBnnmaster\fR periodically from \fBcron\fR,
giving it a list of groups to act upon. This list is very similar to
the subscription list in the \fBsys\fR file, except that it uses blanks
instead of commas. Instead of the fake group name \fBall\fR, an empty argument
of \fB""\fR should be used to denote all groups.
A sample invocation is
.PP
.QP
.nh
.DS
.ft CW
/usr/local/lib/nn/nnmaster !rec.games.go rec comp
 
.DE
.ft R
\&\&
.PP
Note that the order is significant here: The leftmost group specification
that matches always wins. Thus, if we had put \fB!rec.games.go\fR after
\&\fBrec\fR, all articles from this group had been threaded nevertheless.
.PP
\&\fBnn\fR offers several methods to remove expired articles from its databases.
The first is to update the database by scanning the news group directories
and discarding the entries whose corresponding article is no longer available.
This is the default operation obtained by invoking \fBnnmaster\fR with the
\&\fB-E\fR option. It is reasonably fast unless you're doing this via NNTP.
Method 2 behaves exactly like a default expiry run of \fBmthreads\fR, in that
it only removes those entries that refer to articles whose number is below
the low water mark in the \fBactive\fR file. It may be enabled using the \fB-e\fR
option. Finally, a third strategy is to discard the entire database and recollect
all articles. This may be done by giving \fB-E3\fR to \fBnnmaster\fR.
The list of groups to be expired is given by the \fB-F\fR option in the same
fashion as above. However, if you have \fBnnmaster\fR running as daemon,
you must kill it (using \fB-k\fR) before expiry can take place.
However, since this kills the \fBnnmaster\fR daemon, you have to re-start it
with the original options afterwards.
Thus the proper command to run expire on all groups using method 1 is:
.PP
.QP
.nh
.DS
.ft CW
/usr/local/lib/nn/nnmaster -kF ""; /usr/local/lib/nn/nnmaster -lrC
 
.DE
.ft R
\&\&
.PP
There are many more flags that may be used to fine-tune the behavior
of \fBnn\fR. If you are concerned about removing bad articles or digestifying
article digests, read the \fBnnmaster\fR manual page.
.PP
\&\fBnnmaster\fR relies on a file named \fBGROUPS\fR, which is
located in \fB/usr/local/lib/nn\fR. If it does not exist initally, it is created.
For each newsgroup, it contains a line that begins with the group's name,
optionally followed by a time stamp, and flags. You may edit these flags to enable
certain behavior for the group in question, but you may not change the order in
which the groups appear.
.FS 
This is because their order has to agree with that of the entries in the
(binary) \fBMASTER\fR file.
.FE
 The flags allowed and their effects are detailed in the \fBnnmaster\fR manual page,
too.
.PP
.PP
.bp
.NH
A\ Null\ Printer\ Cable\ for\ PLIP
.br
.PP
.PP
To make a Null Printer Cable for use with a PLIP connection, you need
two 25-pin connectors (called DB-25) and some 12-conductor cable.
The cable must be at most 15 meters long.
.PP
If you look at the connector, you should be able to read tiny numbers
at the base of each pin, from 1 for the pin top left (if you hold the 
broader side up) to 25 for the pin bottom right. For the Null Printer 
cable, you have to connect the following pins of both connectors
with each other:
.PP
.PP
.PP
All remaining pins remain unconnected. If the cable is shielded,
the shield should be connected to the DB-25's metallic shell
on one end only.
.PP
.bp
.NH
The\ GNU\ General\ Public\ License
.br
.PP
.PP
.PP
Printed below is the GNU General Public License (the \fIGPL\fR or 
\&\fIcopyleft\fR), under which Linux is licensed. It is reproduced here to
clear up some of the confusion about Linux's copyright status---Linux 
is \fInot\fR shareware, and it is \fInot\fR in the public domain. The
bulk of the Linux kernel is copyright \(co1993 by Linus Torvalds, 
and other software and parts of the kernel are copyrighted by their authors.
Thus, Linux \fIis\fR copyrighted, however, you may redistribute it under
the terms of the GPL printed below.
.PP
.ce
\&\fBGNU\ GENERAL\ PUBLIC\ LICENSE\fR
.PP
.ce
Version\ 2,\ June\ 1991
.PP
.PP
Copyright (C) 1989, 1991 Free Software Foundation, Inc.
675 Mass Ave, Cambridge, MA 02139, USA
Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.
.PP
.NH 2
Preamble
.br
.PP
The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.
.PP
When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.
.PP
To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.
.PP
For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.
.PP
We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.
.PP
Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.
.PP
Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.
.PP
The precise terms and conditions for copying, distribution and
modification follow.
.PP
.NH 2
Terms\ and\ Conditions\ for\ Copying,\ Distribution,\ and\ Modification
.br
.PP
.PP
.IP 1.\ 
[0.] This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The ``Program'', below,
refers to any such program or work, and a ``work based on the Program''
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term ``modification''.)  Each licensee is addressed as ``you''.
.IP
Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.
.IP
.IP 2.\ 
[1.] You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.
.IP
You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.
.IP
.IP 3.\ 
[2.] You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:
.IP
.RS
.IP 1.\ 
[a.] You must cause the modified files to carry prominent notices
stating that you changed the files and the date of any change.
.IP
.IP 2.\ 
[b.] You must cause any work that you distribute or publish, that in
whole or in part contains or is derived from the Program or any
part thereof, to be licensed as a whole at no charge to all third
parties under the terms of this License.
.IP
.IP 3.\ 
[c.] If the modified program normally reads commands interactively
when run, you must cause it, when started running for such
interactive use in the most ordinary way, to print or display an
announcement including an appropriate copyright notice and a
notice that there is no warranty (or else, saying that you provide
a warranty) and that users may redistribute the program under
these conditions, and telling the user how to view a copy of this
License.  (Exception: if the Program itself is interactive but
does not normally print such an announcement, your work based on
the Program is not required to print an announcement.)
.RE
These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.
.IP
Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.
.IP
In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.
.IP
.IP 4.\ 
[3.] You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:
.IP
.RS
.IP 1.\ 
[a.] Accompany it with the complete corresponding machine-readable
source code, which must be distributed under the terms of Sections
1 and 2 above on a medium customarily used for software interchange; or,
.IP
.IP 2.\ 
[b.] Accompany it with a written offer, valid for at least three
years, to give any third party, for a charge no more than your
cost of physically performing source distribution, a complete
machine-readable copy of the corresponding source code, to be
distributed under the terms of Sections 1 and 2 above on a medium
customarily used for software interchange; or,
.IP
.IP 3.\ 
[c.] Accompany it with the information you received as to the offer
to distribute corresponding source code.  (This alternative is
allowed only for noncommercial distribution and only if you
received the program in object code or executable form with such
an offer, in accord with Subsection b above.)
.RE
The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.
.IP
If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.
.IP
.IP 5.\ 
[4.] You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.
.IP
.IP 6.\ 
[5.] You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.
.IP
.IP 7.\ 
[6.] Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.
.IP
.IP 8.\ 
[7.] If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.
.IP
If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.
.IP
It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.
.IP
This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.
.IP
.IP 9.\ 
[8.] If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.
.IP
.IP 10.\ 
[9.] The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.
.IP
Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and ``any
later version'', you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.
.IP
.IP 11.\ 
[10.] If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.
.IP
.ce
NO\ WARRANTY}
.IP
.IP
.IP 12.\ 
[11.] BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM ``AS IS'' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.
.IP
.IP 13.\ 
[12.] IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.
.IP
.ce
END\ OF\ TERMS\ AND\ CONDITIONS}
.PP
.PP
.NH 2
Appendix:\ How\ to\ Apply\ These\ Terms\ to\ Your\ New\ Programs
.br
.PP
.PP
If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.
.PP
To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the ``copyright'' line and a pointer to where the full notice is found.
.PP
.QP
.nh
<one line to give the program's name and a brief idea of 
what it does.>
Copyright \(co19yy  <name of author>
\&\&
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
\&\&
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
\&\&
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.PP
Also add information on how to contact you by electronic and paper mail.
.PP
If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:
.PP
.QP
.nh
Gnomovision version 69, Copyright (C) 19yy name of author
Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
This is free software, and you are welcome to redistribute it
under certain conditions; type `show c' for details.
.PP
The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.
.PP
You should also get your employer (if you work as a programmer) or your
school, if any, to sign a ``copyright disclaimer'' for the program, if
necessary.  Here is a sample; alter the names:
.PP
.QP
.nh
Yoyodyne, Inc., hereby disclaims all copyright interest in the program
`Gnomovision' (which makes passes at compilers) written by James Hacker.
\&\&
<signature of Ty Coon>, 1 April 1989
Ty Coon, President of Vice
.PP
This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.
.PP
.bp
.NH
Annotated\ Bibliography
.br
.PP
.NH 2
Books
.br
.PP
.PP
\&\fBMeta:\fR Well, maybe this doesn't look very neat yet. Any
suggestions for improvement welcome. Also, the list below
is  a very quick shot. So anybody who would like to amend it
or ``enhance'' the abstracts is invited to do so.
.PP
 hunt-tcpip Hunt92 TCP/IP Network Administration Craig Hunt O'Reilly and Associates, 1992   If the Linux Network Administration Guide is not enough
for for you, get this book. It 
deals with everything from obtaining an IP address to
troubleshooting your network to security issues.
.PP
Its focus is on setting up TCP/IP, that is, interface
configuration, the setup of routing, and name resolution.
It includes a detailed description of the facilities offered by
the routing daemons \fBrouted\fR and \fBgated\fR, which
supply dynamic routing.
.PP
It also describes the configuration of application programs
and network daemons, such as \fBinetd\fR, the \fBr\fR 
commands, NIS, and NFS.
.PP
The appendix has a detailed reference of the \fBgated\fR,
\&\fBnamed\fR, and a description of Berkeley's \fBsendmail\fR
configuration.
 stern-nfs Stern92
Managing NIS and NFS Hal Stern O'Reilly and Associates, 19xx   This is a companion book to Craig Hunt's ``TCP/IP Network Administration''
book. It covers the use of NIS, the Network Information System, and
NFS, the Network File System, in extenso.
 reilly-uucp OReilly89 Managing UUCP and Usenet Tim O'Reilly and Grace Todino, 10th ed O'Reilly and Associates, 1992 0-93717593-5  This is the standard book on UUCP networking. It covers
Version 2 UUCP as well as BNU. It helps you setting up your
UUCP node from the start, giving practical tips and solutions
for many problems, like testing the connection, or writing good
chat scripts. It also deals with more exotic topics, like
how to set up a travelling UUCP node, or the
subtleties present in different flavors of UUCP.
.PP
The second part of the book deals with Usenet and netnews software.
It explains the configuration of both Bnews (version 2.11) and 
Cnews, and introduces you to netnews maintenance tasks.
 ast89 Tanen89 Computer Networks Andrew S. Tanenbaum Prentice Hall International, 1989 0-13-166836-6
.FS 
The ISBN under which it is available in North America might
me different.
.FE
  This book gives you a very good insight into general networking
issues. Using the OSI Reference Model, it explains the design
issues of each layer, and the algorithms that may be used to achieve
these. At each layer, the implementations of several networks,
among them the Arpanet, are compared to each other.
.PP
The only drawback this book has is the abundance of abbreviations,
which sometimes makes it hard to follow what the author says.
But this is probably inherent to networking.
 feit-93 Feit93 TCP/IP --- Architecture, Protocol, and Implementation Sidnie Feit McGraw-Hill, 1993 0-07-020346-6  This is an all-singing-all-dancing book on TCP/IP networking.
In fact, its more like an encyclopedia than like a book.
It describes the major protocols, like IP, TCP, and UDP
in great detail, and works its way up to the application programs.
It explains everything quite exhaustively. For example, the chapter
on \fBtelnet\fR includes a tour of the \fBtelnet\fR network terminal.
.PP
This book is for people who want to know more about \fIhow\fR
TCP/IP and its applications work, but don't want to read RFCs.
