/*---------------------------------------------------------------------------
 Module FmAwPopup

 (c) Simon Marlow 1990-92
 (c) Albert Graef 1994

 Functions & data for creating the popup 'install application' window
---------------------------------------------------------------------------*/

#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Drawing.h>

#include "Am.h"

/*---------------------------------------------------------------------------
  STATIC DATA
---------------------------------------------------------------------------*/

static Widget install_popup;

static int app_number;

static char app_name[MAXAPPSTRINGLEN], app_directory[MAXAPPSTRINGLEN],
  app_fname[MAXAPPSTRINGLEN], app_icon[MAXAPPSTRINGLEN],
  app_push_action[MAXAPPSTRINGLEN], app_drop_action[MAXAPPSTRINGLEN];

/*---------------------------------------------------------------------------
  PRIVATE FUNCTIONS
---------------------------------------------------------------------------*/

static FmCallbackProc installOkCb, installCancelCb;

static void installOkCb(Widget w, FileWindowRec *fw, XtPointer call_data)
{
  XtPopdown(install_popup);

  if (app_number != -1)
    replaceApplication(aw.apps+app_number, app_name, app_directory, app_fname,
		       app_icon, app_push_action, app_drop_action);
  else
    installApplication(app_name, app_directory, app_fname, app_icon,
		       app_push_action, app_drop_action);

  updateApplicationDisplay();
}

/*---------------------------------------------------------------------------*/

static void installCancelCb(Widget w, FileWindowRec *fw, 
			    XtPointer call_data)
{
  XtPopdown(install_popup);
}

/*---------------------------------------------------------------------------
  Question and button data
---------------------------------------------------------------------------*/

static QuestionRec install_questions[] = {
  { "Name:", app_name, MAXAPPSTRINGLEN, NULL },
  { "Directory:", app_directory, MAXAPPSTRINGLEN, NULL },
  { "File name:", app_fname, MAXAPPSTRINGLEN, NULL },
  { "Icon:", app_icon, MAXAPPSTRINGLEN, NULL },
  { "Push action:", app_push_action, MAXAPPSTRINGLEN, NULL },
  { "Drop action:", app_drop_action, MAXAPPSTRINGLEN, NULL }
};

static ButtonRec install_buttons[] = {
  { "install", "Install", installOkCb },
  { "cancel", "Cancel", installCancelCb }
};

/*---------------------------------------------------------------------------
  PUBLIC FUNCTIONS
---------------------------------------------------------------------------*/

void createInstallPopup()
{
  install_popup = createPopupQuestions("install", "Install Application", None,
		       install_questions, XtNumber(install_questions),
		       install_buttons, XtNumber(install_buttons));
}

/*----------------------------------------------------------------------------*/

void installNewPopup()
{
  register int i;

  for (i=0; i < XtNumber(install_questions); i++) {
    install_questions[i].value[0] = '\0';
    XtVaSetValues(install_questions[i].widget, XtNstring, 
		  install_questions[i].value, NULL);
  }

  app_number = -1;

  popupByCursor(install_popup, XtGrabExclusive);
}

/*----------------------------------------------------------------------------*/

void installExistingPopup()
{
  register int i;

  for (i=0; i<aw.n_apps; i++)
    if (aw.apps[i].selected) {
      app_number = i;
      strcpy(install_questions[0].value, aw.apps[i].name);
      strcpy(install_questions[1].value, aw.apps[i].directory);
      strcpy(install_questions[2].value, aw.apps[i].fname);
      strcpy(install_questions[3].value, aw.apps[i].icon);
      strcpy(install_questions[4].value, aw.apps[i].push_action);
      strcpy(install_questions[5].value, aw.apps[i].drop_action);
      break;
    }

  for (i=0; i < XtNumber(install_questions); i++) {
    XtVaSetValues(install_questions[i].widget, XtNstring, 
		  install_questions[i].value, NULL);
  }

  popupByCursor(install_popup, XtGrabExclusive);
}
