/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"

#ifdef	HAVE_XPM
#include "icons.h"
#else
#include "bitmaps.h"
#endif

/*
 * The Cursor-bitmaps are only needed in this file
 */
#include "cursor.h"
#include "cursorm.h"
#include "fcursor.h"
#include "fcursorm.h"
#include "wcursor.h"
#include "wcursorm.h"


/*
 * Global variables
 */

#ifdef HAVE_XPM
static	XpmAttributes	attr;
#endif


/*********************************************************
 * name:	makeCursor
 * description:	Erzeugt einen Cursor aus einem Icon und einem Text
 * input:	Pixmap	icon
 *		char	*label
 * output:	Zeiger auf den Cursor
 * date:	Main 93
 *********************************************************/
void	makeCursor ()
{
	Pixmap	pmap;
	Pixmap	smap;
	XColor	fg,bg;

	/*
	 * Die Pixmap erzeugen
	 */
	fg.red = fg.blue = fg.green = 0;
	bg.red = bg.blue = bg.green = 0xffff;
	pmap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), cursor_bits,
					   cursor_width,cursor_height, 1,0, 1);
	smap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), cursorm_bits,
					   cursorm_width,cursorm_height, 1,0, 1);

	def_cursor = XCreatePixmapCursor(XtDisplay(toplevel),pmap,smap,&fg,&bg,
					 cursor_x_hot,cursor_y_hot);

	pmap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), fcursor_bits,
					   fcursor_width,fcursor_height, 1,0, 1);
	smap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), fcursorm_bits,
					   fcursorm_width,fcursorm_height, 1,0, 1);

	file_cursor = XCreatePixmapCursor(XtDisplay(toplevel),pmap,smap,&fg,&bg,
					  fcursor_x_hot,fcursor_y_hot);

	pmap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), wcursor_bits,
					   wcursor_width,wcursor_height, 1,0, 1);
	smap = XCreatePixmapFromBitmapData(XtDisplay(toplevel), XtWindow(toplevel), wcursorm_bits,
					   wcursorm_width,wcursorm_height, 1,0, 1);

	busy_cursor = XCreatePixmapCursor(XtDisplay(toplevel),pmap,smap,&fg,&bg,0,0);
}




/*********************************************************
 * name:	drawDir
 * description:	zeichnet das Icon und den Names eine Dirs
 *		im Dir-Feld
 * input:	Widget		window;		Zielfenster
 *		Dir_Glyph	*dir;		Dir-Eintrag
 *		Boolean		selected;	Angewaehlt
 *		Boolean		back;		Hintergrund zeichnen
 * output:	-
 * date:	10.6.1993
 *********************************************************/
void	drawDir (Widget window, Dir_Glyph *dir, Boolean selected, Boolean back)
{
	Pixmap	pmap;
	GC	gc = line_gc;
	char	buf[400];

	if (dir->flags&DIR_LINK && dir->link)
		sprintf(buf,"%s -> %s",dir->name,dir->link);
	else
		sprintf(buf,"%s",dir->name);

	/*
	 * Ueberpruefen ob der Hintergrund gezeichnet werden soll oder nicht
	 */
	if (back) {
		/*
		 * Nachsehen ob der Eintrag angewaehlt ist oder nicht
		 */
		if (selected) {
			XFillRectangle (XtDisplay(window),XtWindow(window), selc_gc,
					dir->x + 20, dir->y, 
					XTextWidth(defaults.icon_font,buf,
					strlen(buf)) + 8, 16);
			gc = white_gc;
		}
		else
			XFillRectangle (XtDisplay(window),XtWindow(window), back_gc,
					dir->x + 20, dir->y, 
					XTextWidth(defaults.icon_font,buf,
					strlen(buf)) + 8, 16);
	}

	/*
	 * Den Label ausgeben
	 */
	XDrawString (XtDisplay(window),XtWindow(window), gc,
			dir->x + 24, dir->y + 12, buf,
			strlen(buf));

	/*
	 * Das Icon ausgeben
	 */
	if (!(dir->flags & DIR_READABLE))
		pmap = Dir_Locked_PM;
	else if (dir->flags & DIR_LINK)
		pmap = File_DLink_PM;
	else if (dir->open)
		pmap = Dir_Opened_PM;
	else
		pmap = Dir_Closed_PM;

	XCopyArea (XtDisplay(window), pmap, 
			XtWindow(window), line_gc, 0,0, 16,16,
			dir->x, dir->y);
}



/*********************************************************
 * name:	drawFile
 * description:	zeichnet das Icon und den Names eine File
 *		im Dir-Feld
 * input:	Folder_Glyph	*folder;		Zielfenster
 *		Dimension	entry;		File-Eintrag
 *		Boolean		selected;	Angewaehlt
 *		Boolean		back;		Hintergrund zeichnen
 * output:	-
 * date:	10.6.1993
 *********************************************************/
void	drawFile (Folder_Glyph *folder, int entry,
		  Boolean selected, Boolean back)
{
	Pixmap		pmap;
	Widget		window;
	File_Glyph	*file;
	GC		gc = line_gc;

	window = folder->window;
	file = folder->file[entry];

	/*
	 * Ueberpruefen ob der Hintergrund gezeichnet werden soll oder nicht
	 */
	if (back) {
		/*
		 * Nachsehen ob der Eintrag angewaehlt ist oder nicht
		 */
		if (selected) {
			XFillRectangle (XtDisplay(window),XtWindow(window), selc_gc,
					40, entry*DIR_Y_STEP + 6,
					folder->max_length - DIR_X_STEP + 50
					+ typelength, 16);
			gc = white_gc;
		}
		else
			XFillRectangle (XtDisplay(window),XtWindow(window), back_gc,
					40, entry*DIR_Y_STEP + 6,
					folder->max_length - DIR_X_STEP + 50
					+ typelength, 16);
	}

	/*
	 * Den Label ausgeben
	 */
	XDrawString (XtDisplay(window),XtWindow(window), gc,
			44, entry*DIR_Y_STEP + 18, file->name,
			strlen(file->name));

	{	char	buf[100];

		sprintf(buf,"%8d Bytes",file->size);
		XDrawString(XtDisplay(window),XtWindow(window), gc,
				44 + folder->max_length - DIR_X_STEP
				- XTextWidth(defaults.icon_font,buf,
					     strlen(buf)), 
				entry*DIR_Y_STEP + 18, buf, strlen(buf));

#ifdef SHOWRIGHTS
		/* Rechte ausgeben */
		sprintf(buf,"%c%c%c%c%c%c%c%c%c%c", 
#ifndef COHERENT
			S_ISLNK(file->mode) ? 'l' :
#endif
			S_ISDIR(file->mode) ? 'd' :
			S_ISCHR(file->mode) ? 'c' :
			S_ISBLK(file->mode) ? 'b' : '-',
			S_IRUSR&file->mode ? 'r' : '-',
			S_IWUSR&file->mode ? 'w' : '-',
			S_IXUSR&file->mode ? 'x' : '-',
			S_IRGRP&file->mode ? 'r' : '-',
			S_IWGRP&file->mode ? 'w' : '-',
			S_ISUID&file->mode ? 's' :
			S_ISGID&file->mode ? 'g' :
			S_IXGRP&file->mode ? 'x' : '-',
			S_IROTH&file->mode ? 'r' : '-',
			S_IWOTH&file->mode ? 'w' : '-',
			S_ISUID&file->mode ? 's' :
			S_ISGID&file->mode ? 'g' :
			S_IXOTH&file->mode ? 'x' : '-');
		XDrawString(XtDisplay(window),XtWindow(window),gc,
				34 + folder->max_length,entry*DIR_Y_STEP + 18,
				buf,strlen(buf));
		/*
		 * First I though of also displaying the user names, but this would
		 * be to much at this place.
		 */
#endif
		/* Kurzbeschreibung */
/*		if (file->prog_type < max_filetypes)
			XDrawString (XtDisplay(window),XtWindow(window),gc,
				44 + folder->max_length,entry*DIR_Y_STEP + 18,
				filetypes[file->prog_type].description,
				strlen(filetypes[file->prog_type].description));
*/	}

	/*
	 * Das Icon ausgeben
	 */
	switch (file->prog_type) {
		case FILE_ROOT:
			pmap = File_Root_PM;
			break;
		case FILE_LINK:
			pmap = File_Link_PM;
			break;
		case FILE_LOCK:
			pmap = File_Lock_PM;
			break;
		case FILE_DIR:
			pmap = Dir_Closed_PM;
			break;
		case FILE_LDIR:
			pmap = File_DLink_PM;
			break;
		case FILE_EXEC:
			pmap = File_Exec_PM;
			break;
		case FILE_TAR:
			pmap = File_Tar_PM;
			break;
		case FILE_CTAR:
			pmap = File_CTar_PM;
			break;
		case FILE_GHOST:
			pmap = File_Ghost_PM;
			break;
		default: {
			int	i = 0;
			Boolean	NOT_ENDE = 1;

			pmap = File_Plain_PM;
			if (file->prog_type != FILE_PLAIN && 
			    filetypes[file->prog_type].pmap)
				pmap = *filetypes[file->prog_type].pmap;
		}
	}
	XCopyArea (XtDisplay(window), pmap, XtWindow(window), line_gc,
			0,0, 16,16,20,entry*DIR_Y_STEP + 6);
}


/*********************************************************
 * name:	drawWSE
 * description:	Zeichnen eines Workspaceentries in einem
 *		Workspacewindow
 * input:	WS_Glyph	*ws	- der Workspace
 *		Dimension	entry	- Eintragnummer
 *		Boolean		selected - Selcetiert?
 *		Boolean		back	- Hintergrund
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
void	drawWSE (WS_Glyph *ws, Dimension entry,
		 Boolean selected, Boolean back)
{
	Pixmap		pmap;
	Widget		window;
	WSE_Glyph	*wse;
	GC		gc = line_gc;
	Dimension	tl;

	window = ws->window;
	wse = ws->wse[entry];
	tl = XTextWidth(defaults.icon_font,wse->label,strlen(wse->label)) + 8;

	/*
	 * Ueberpruefen ob der Hintergrund gezeichnet werden soll oder nicht
	 */
	if (back) {
		/*
		 * Nachsehen ob der Eintrag angewaehlt ist oder nicht
		 */
		if (selected) {
			XFillRectangle (XtDisplay(window),XtWindow(window), selc_gc,
					wse->x - tl/2 + 2, wse->h + wse->y + 5,
					tl, 16);
			gc = white_gc;
		}
		else
			XFillRectangle (XtDisplay(window),XtWindow(window), back_gc,
					wse->x - tl/2 + 2, wse->h + wse->y + 5,
					tl, 16);
	}

	/*
	 * Icon raussuchen und ausgeben
	 */
	if (!wse->pmap) {
		XDrawString (XtDisplay(window),XtWindow(window), gc,
				wse->x - tl/2 + 6, wse->y + 32, 
				wse->label,strlen(wse->label));
		XCopyArea (XtDisplay(window),File_Exec_PM,XtWindow(window), gc,
			   0,0,16,16,wse->x - 8, wse->y);
	}
	else {
		XDrawString (XtDisplay(window),XtWindow(window), gc,
				wse->x - tl/2 + 6, wse->h + wse->y + 16, 
				wse->label,strlen(wse->label));
/*		if (wse->shape)
			XShapeCombineMask(XtDisplay(window),XtWindow(window),
					ShapeBounding,wse->x - wse->w/2, wse->y,
					wse->shape,ShapeSet);
*/		XCopyArea (XtDisplay(window),wse->pmap,XtWindow(window), gc,
			   0,0,wse->w,wse->h,wse->x - wse->w/2, wse->y);
	}
}


/*********************************************************
 * name:	load icons
 * description:	einlesen der icons aus dem Datenfile
 * input:	none
 * output:	none
 * date:	10.5.93
 *********************************************************/
void	loadIcons (void)
{
#ifdef HAVE_XPM
	/*
	 * Die Pixmaps fuer die Pictogramme laden
	 */
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_move,
				     &Icon_Move_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Move Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_copy,
				     &Icon_Copy_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Copy Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_delete,
				     &Icon_Delete_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Delete Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_warning,
				     &Icon_Warning_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Warning Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_goto,
				     &Icon_Goto_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Goto Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_newdir,
				     &Icon_Newdir_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Newdir Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_info,
				     &Icon_Info_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Info Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_hide,
				     &Icon_Hide_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Hide Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_help,
				     &Icon_Help_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Help Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_filter,
				     &Icon_Filter_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Filter Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_exec,
				     &Icon_Exec_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Exec Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_wsedit,
				     &Icon_WSE_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get WSEdit Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_wsdelete,
				     &Icon_WSD_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get WSDelete Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_makelink,
				     &Icon_Link_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Makelink Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_pack,
				     &Icon_Pack_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Pack Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_unpack,
				     &Icon_Unpack_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get unpack Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), icon_root,
				     &Icon_Root_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Root Icon\n");

	/*
	 * Die IconPixmaps laden
	 */
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), dir_closed,
				     &Dir_Closed_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Closed Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), dir_opened,
				     &Dir_Opened_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Opened Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), dir_locked,
				     &Dir_Locked_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Locked Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_root,
				     &File_Root_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Root Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_tar,
				     &File_CTar_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Tar Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_ctar,
				     &File_CTar_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get CTar Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_plain,
				     &File_Plain_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Plain Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_lock,
				     &File_Lock_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Flock Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_link,
				     &File_Link_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Link Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_ghost,
				     &File_Ghost_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get Ghost Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_exec,
				     &File_Exec_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get exec Icon\n");
	if (XpmCreatePixmapFromData (XtDisplay(toplevel),
				     XtWindow(toplevel), file_dlink,
				     &File_DLink_PM, &smap,
				     &attr) != XpmSuccess)
		FATAL_ERROR("main: Failed to get DLink Icon\n");
#else
	int	b = XBlackPixel(XtDisplay(toplevel),XDefaultScreen(XtDisplay(toplevel)));
	int	w = XWhitePixel(XtDisplay(toplevel),XDefaultScreen(XtDisplay(toplevel)));

	if (!(Icon_Move_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_move, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read move-bitmap");
	if (!(Icon_Copy_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_copy, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read move-bitmap");
	if (!(Icon_Delete_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_delete, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read move-bitmap");
	if (!(Icon_Info_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_info, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read info-bitmap");
	if (!(Icon_Warning_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_warning, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read warn-bitmap");
	if (!(Icon_Newdir_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_newdir, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read newdir-bitmap");
	if (!(Icon_WSE_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_wse, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read wse-bitmap");
	if (!(Icon_WSD_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_wsd, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read wsd-bitmap");
	if (!(Icon_Filter_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_filter, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read filter-bitmap");
	if (!(Icon_Help_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_help, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read help-bitmap");
	if (!(Icon_Hide_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_hide, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read hide-bitmap");
	if (!(Icon_Exec_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_exec, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read exec-bitmap");
	if (!(Icon_Link_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_link, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read makelink-bitmap");
	if (!(Icon_Goto_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_goto, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read goto-bitmap");
	if (!(Icon_Root_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_root, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read root-bitmap");
	if (!(Icon_Pack_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_pack, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read Pack-bitmap");
	if (!(Icon_Unpack_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), icon_unpack, 32,32,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read Unpack-bitmap");


	if (!(File_Root_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_root, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read fileroot-bitmap");
	if (!(File_Plain_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_plain,16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read fileplain-bitmap");
	if (!(File_Exec_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_exec, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read fileexec-bitmap");
	if (!(Dir_Closed_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), dir_closed, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read dirclose-bitmap");
	if (!(Dir_Opened_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), dir_open, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read diropen-bitmap");
	if (!(Dir_Locked_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), dir_lock, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read dirlock-bitmap");
	if (!(File_DLink_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), dir_link, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read dirlink-bitmap");
	if (!(File_Link_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_link, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read filelink-bitmap");
/*	if (!(File_Ghost_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_ghost, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read fileghost-bitmap");
*/	if (!(File_Lock_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_lock, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read filelock-bitmap");
	if (!(File_Tar_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_tar, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read filetar-bitmap");
	if (!(File_CTar_PM = XCreatePixmapFromBitmapData (XtDisplay(toplevel),
					XtWindow(toplevel), file_ctar, 16,16,b,w,
					XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel))))))
		FATAL_ERROR("Failed to read filectar-bitmap");
	File_Ghost_PM = File_Plain_PM;
#endif
}


/*********************************************************
 * name:	ReadPixmapFromFile
 * description:	einlesen einer Pixmap
 * input:	char	*filename;
 *		int	*w	- width_return
 *		int	*h	- height_return
 * output:	Pixmap	pmap;
 * author:	Ove Kalkan
 * date:	9.8.1993
 *********************************************************/
Pixmap	ReadPixmapFromFile(char *filename, int *w, int *h)
{
	Pixmap	back = (Pixmap) NULL;
	char	*s;
	Boolean	predicate (String s);

	Pixmap	tmp;
	int	x,y;

	s = XtResolvePathname(XtDisplay(toplevel),NULL,filename,
			      NULL,defaults.icon_dir,NULL,0,predicate);
	if (!s) {
		s = XtResolvePathname(XtDisplay(toplevel),NULL,filename,
				      ".bm",defaults.icon_dir,NULL,0,predicate);
		if (!s) {
			s = XtResolvePathname(XtDisplay(toplevel),NULL,filename,
					      ".xpm",defaults.icon_dir,NULL,0,predicate);
			if (!s) {
				s = XtResolvePathname(XtDisplay(toplevel),NULL,filename,
						     ".xbm",defaults.icon_dir,NULL,0,predicate);
				if (!s) {
					fprintf(stderr,"Error: Cannot find Icon %s\n",filename);
					return ((Pixmap) NULL);
				}
			}
		}
	}
	*w = 16;
	*h = 16;

#ifdef HAVE_XPM		/* Xpm-Icon lesen */
	smap = (Pixmap) NULL;
	if (XpmReadFileToPixmap(XtDisplay(toplevel),XtWindow(toplevel),
				s,&back,&smap,&attr) != XpmSuccess) {
		back = (Pixmap) NULL;
	}
	else {
		*w = attr.width;
		*h = attr.height;
		return(back);	/* Hat geklappt, also Pixmap zurueckliefern */
	}
#endif			/* X11 Bitmap lesen */
	smap = (Pixmap) NULL;
	if (XReadBitmapFile(XtDisplay(toplevel),XtWindow(toplevel),
				s,(unsigned int *) w,(unsigned int *) h,
				&tmp,&x,&y) != BitmapSuccess) {
		back = (Pixmap) NULL;
	}
	else {
		if (!(back = XCreatePixmap(XtDisplay(toplevel),
						XtWindow(toplevel),
						*w,*h,
						XDisplayPlanes(XtDisplay(toplevel),
						XDefaultScreen(XtDisplay(toplevel)))))) {
			back = (Pixmap) NULL;
		}
		else {
			XCopyPlane(XtDisplay(toplevel),tmp,back,
					XDefaultGC(XtDisplay(toplevel),XDefaultScreen(XtDisplay(toplevel))),
					0,0,*w,*h,0,0,1);
		}
	}
	if (!back)
		fprintf(stderr,"Cannot Read Iconfile %s\n",s);
	return(back);
}

Boolean	predicate (String s)
{
	FILE	*fp;

	if ((fp = fopen(s,"r"))) {
		fclose(fp);
		return(TRUE);
	}
	return(FALSE);
}