/* This file is part of the Project Athena Zephyr Notification System.
 * It contains headers for the windowgram COMPILER, new version.
 *
 *	Created by:	Mark W Eichin
 *
 *	$Source: /mit/zephyr/src/zwgc/RCS/comp_types.h,v $
 *	$Author: jtkohl $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>
#include <stdio.h>		/* for canonical NULL */
#include <ctype.h>
/* windowgram main commands */
#define ZSP	001
#define ZNL	002
#define ZLFT	004
#define ZRT	010
#define ZSYM	020
#define ZMAG	040
#define ZSEP	0100

extern char _dtype_[];
#define is_blank(c) (_dtype_[(c)+1] & ZSP)
#define is_symchar(c) (_dtype_[(c)+1] & ZSYM)
#define is_sepchar(c) (_dtype_[(c)+1] & ZSEP)
#define is_magic(c) (_dtype_[(c)+1] & ZMAG)
#define is_left(c) (_dtype_[(c)+1] & ZLFT)
#define is_right(c) (_dtype_[(c)+1] & ZRT)
#define is_newline(c) (_dtype_[(c)+1] & ZNL)
#define is_char(c) (((int)c)<128)
#include "cmds.h"

typedef struct _cmd {
  char *word;
  token tag;
} cmd;



extern struct _rope *varropes[];	/* char *strand_var[]; gone */
				/* rope *ropes_var[]; */
extern char *strand_field[];
extern char *strand_head[];
extern char *strand_raw[];
