#!/bin/sh

# This build process should really be in a Makefile, but I'd prefer to
# leave Sun's distributed Makefile alone

# Set this variable to be the .../bind/contrib/sunlibc directory to where the
#  special libc .o files were copied.
#resolvobjdir=/usr/local/src/bind-4.9.2/contrib/sunlibc
resolvobjdir=

if [ "${resolvobjdir}x" = "x" ]; then
	echo 'Edit the make_lib script to set $resolvobjdir to the proper'
	echo 'bind directory (.../bind/contrib/sunlibc).'
	exit 1
fi

# Extract and setup the ucb libc
if [ ! -d tmp.ucb ]; then
	rm -f tmp.ucb
	mkdir tmp.ucb
fi
cd tmp.ucb
rm -rf *
ar x ../libc_pic.a
rm __.SYMDEF
for f in *.; do
	mv $f ${f}o
done
rm gethostent.o

# Sun's inet_addr.o and possible getnetent.o are clobbered in this copy
cp $resolvobjdir/*.o .

cd ..
# Extract and setup the sysv libc
if [ ! -d tmp.s5 ]; then
	rm -f tmp.s5
	mkdir tmp.s5
fi
cd tmp.s5
rm -rf *
ar x ../libcs5_pic.a
rm __.SYMDEF
for f in *.; do
	mv $f ${f}o
done
rm gethostent.o

# Sun's inet_addr.o and possible getnetent.o are clobbered in this copy
cp $resolvobjdir/*.o .

# Back to the make directory
cd ..

# Add the res data objects the lorder sparc listing (uncool hack)
if [ ! -f lorder-sparc.orig ]
then
        patch < $resolvobjdir/sun-lorder-sparc.patches
fi
# Fix broken Makefile
# only half needed for version with patch 100890-08+
if [ ! -f Makefile.orig ]
then
        patch < $resolvobjdir/sun-Makefile.patches
fi

# Make the sys5 shared libc
rm -f tmp
ln -s tmp.s5 tmp
time make libcs5.so

# Make the ucb shared libc
rm -f tmp
ln -s tmp.ucb tmp
time make libc.so

# Setup the shared archives
#  Use the latest so as the rev, because the so and sa versions need to
#  match.  Normally they would be the same in /usr/lib, but Sun's patch
#  instructions don't make new ones.
/bin/ls /usr/lib/libc.so.* > TMP_FILE
ucb_sa=libc.sa.`cat TMP_FILE | awk -f awkfile`
/bin/ls /usr/5lib/libc.so.* > TMP_FILE
s5_sa=libc.sa.`cat TMP_FILE | awk -f awkfile`

# copy latest shared arcives to local directory
cp `ls /usr/lib/libc.sa.* | sort -t. +4n | tail -1` $ucb_sa
cp `ls /usr/5lib/libc.sa.* | sort -t. +4n | tail -1` $s5_sa

# ranlib them
ranlib $ucb_sa
ranlib $s5_sa
