------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             E X P _ C H 1 3                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.13 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Atree;    use Atree;
with Einfo;    use Einfo;
with Exp_Ch3;  use Exp_Ch3;
with Nmake;    use Nmake;
with Rtsfind;  use Rtsfind;
with Sem;      use Sem;
with Sinfo;    use Sinfo;
with Snames;   use Snames;
with Sem_Util; use Sem_Util;
with Tbuild;   use Tbuild;

package body Exp_Ch13 is

   ------------------------------------------
   -- Expand_N_Attribute_Definition_Clause --
   ------------------------------------------

   --  Expansion action depends on attribute involved

   procedure Expand_N_Attribute_Definition_Clause (N : Node_Id) is
      Loc : constant Source_Ptr := Sloc (N);
      Ent : constant Entity_Id  := Entity (Name (N));
      V   : Node_Id;

   begin
      case Get_Attribute_Id (Chars (N)) is

      --  Storage_Size

      when Attribute_Storage_Size =>

         --  If the type is a task type, then assign the value of the
         --  storage size to the Size variable associated with the task.
         --    task___Size := expression

         if Ekind (Ent) = E_Task_Type then
            Rewrite_Substitute_Tree (N,
              Make_Assignment_Statement (Loc,
                Name => Make_Identifier (Loc,
                  Chars =>
                    New_External_Name (Chars (Etype (Name (N))), 'Z')),
                Expression =>
                  Make_Type_Conversion (Loc,
                    Subtype_Mark =>
                      New_Reference_To (RTE (RE_Size_Type), Loc),
                    Expression => Expression (N))));

               Analyze (N);

         --  For Storage_Size for an access type, create a variable to hold
         --  the value of the specified size with name typeV and expand an
         --  assignment statement to initialze this value.

         elsif Ekind (Ent) = E_Access_Type then

            V := Make_Defining_Identifier (Loc,
                   New_External_Name (Chars (Ent), 'V'));

            Rewrite_Substitute_Tree (N,
              Make_Assignment_Statement (Loc,
                Name => V,
                Expression =>
                  Make_Type_Conversion (Loc,
                    Subtype_Mark =>
                      New_Reference_To (RTE (RE_Storage_Offset), Loc),
                    Expression => Expression (N))));

            Analyze (N);
            Set_Storage_Size_Variable (Ent, Entity_Id (V));

         --  Other types for Storage_Size attribute need no expansion

         else
            null;
         end if;

         --  Other attributes require no expansion

         when others => null;

      end case;

   end Expand_N_Attribute_Definition_Clause;

   ----------------------------
   -- Expand_N_Freeze_Entity --
   ----------------------------

   procedure Expand_N_Freeze_Entity (N : Node_Id) is
      E : Entity_Id := Entity (N);

   begin
      --  Freeze the type if it is a record type, task type, or array type.
      --  Note that we explicitly check for a type, rather than use the
      --  Is_xxx_Type predicates, because these also include subtypes and
      --  there are no freeze actions for subtypes.

      if Ekind (E) = E_Record_Type
        or else Ekind (E) = E_Task_Type
        or else Ekind (E) = E_Array_Type
        or else Ekind (E) = E_Access_Type
      then
         Freeze_Type (N);
      end if;
   end Expand_N_Freeze_Entity;

end Exp_Ch13;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.11
--  date: Sun Jan  9 11:03:30 1994;  author: dewar
--  Minor reformatting (style checks)
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.12
--  date: Sun May 29 18:32:35 1994;  author: comar
--  (Expand_N_Attribute_Definition_Clause): expand Storage_Size variable in
--   order to elaborate this dynamic expression at the right place.
--  ----------------------------
--  revision 1.13
--  date: Mon May 30 10:45:27 1994;  author: dewar
--  Minor reformatting
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
