#ifdef HAVE_LIBGPM

/* GPM mouse support include file */
#include <gpm.h>

#else

/* Equivalent definations for non-GPM mouse support */
/* These lines are modified version from the lines appearing in the */
/* gpm.h include file of the Linux General Purpose Mouse server */

#define GPM_B_LEFT      4
#define GPM_B_MIDDLE    2
#define GPM_B_RIGHT     1
 
/* Xterm mouse support supports only GPM_DOWN and GPM_UP */
/* If you use others make sure your code also works without them */
enum Gpm_Etype {
  GPM_MOVE=1,
  GPM_DRAG=2,   /* exactly one in four is active at a time */
  GPM_DOWN=4,
  GPM_UP=  8,

#define GPM_BARE_EVENTS(ev) ((ev)&0xF)

  GPM_SINGLE=16,            /* at most one in three is set */
  GPM_DOUBLE=32,
  GPM_TRIPLE=64,
      
  GPM_MFLAG=128,            /* motion during click? */
  GPM_HARD=256             /* if set in the defaultMask, force an already
                              used event to pass over to another handler */
};

typedef struct Gpm_Event {
  int buttons, x, y;
  enum Gpm_Etype type;
} Gpm_Event;

extern int gpm_fd;

#endif

/* General mouse support definitions */

typedef int (*mouse_h)(Gpm_Event *, void *);

typedef struct {
    int x1, y1;
    int x2, y2;
    void *data;
    mouse_h mouse_callback;
    struct MouseEvent *next;
} MouseEvent;

typedef struct {
    int x, y;
    struct Frame *next;
    MouseEvent *mouse_events;
} Frame;

#define NO_MOUSE 0
#define GPM_MOUSE 1
#define XTERM_MOUSE 2

void init_mouse ();
void shut_mouse ();

/* Type of mouse: NO_MOUSE, GPM_MOUSE or XTERM_MOUSE */
extern int use_mouse_p;
/* If use_mouse_p is XTERM_MOUSE: is mouse currently active? */
extern int xmouse_flag;

void push_event (int x1, int y1, int x2, int y2, mouse_h callback, void *d);
void pop_event ();
void push_frame (int x, int y, int relative_to_previous);
void pop_frame ();

int mouse_handler (Gpm_Event *gpm_event);
int click (Gpm_Event *event, void *fn);
int click_auto_repeat (Gpm_Event *event, void *fn);
int null_event (Gpm_Event *event, void *x);
int quit_event (Gpm_Event *event, void *x);
int redo_mouse (Gpm_Event *event);
int set_quit_flag (Gpm_Event *event, void *x);
int click_may_break_loop (Gpm_Event *event, void *fn);

/* Constants returned from mouse handlers */

#define MOU_NORMAL    0x00
#define MOU_REPEAT    0x01
#define MOU_ENDLOOP   0x02
#define MOU_LOCK      0x04

#ifdef DEBUGMOUSE
#define DEBUGM(data) fprintf data
#else
#define DEBUGM(data) 
#endif

#ifdef HAVE_LIBGPM

/* GPM specific mouse support definations */
void show_mouse_pointer (int x, int y);

#else

/* Mouse support definations for non-GPM mouse */
#define show_mouse_pointer()

#endif
