/* Keyboard support routines.
   Copyright (C) 1994 Miguel de Icaza.
   Copyright (C) Janne Kukonlehto
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>		/* FD_ZERO et al */
#include <sys/time.h>		/* struct timeval */
#include <ncurses.h>
#include <ctype.h>
#include "global.h"
#include "main.h"
#include "mouse.h"
#include <errno.h>

static char rcsid [] = "$Id: key.c,v 1.14 1994/10/13 04:27:39 miguel Exp $";

/* This macros were stolen from gpm 0.15 */
#define GET_TIME(tv) (gettimeofday(&tv, (struct timezone *)NULL))
#define DIF_TIME(t1,t2) ((t2.tv_sec -t1.tv_sec) *1000+ \
			 (t2.tv_usec-t1.tv_usec)/1000)

int mou_auto_repeat = 400;
int double_click_speed = 250;

static int max_fd;
static int input_fd;
static fd_set select_set;

void init_key ()
{
    input_fd = fileno (stdin);
#ifdef HAVE_LIBGPM
    max_fd = (gpm_fd > input_fd) ? gpm_fd : input_fd;
#else
    max_fd = input_fd;
#endif
}

void xmouse_get_event (Gpm_Event *ev)
{
    int btn;
    static struct timeval tv1 = { 0, 0 }; /* Force first click as single */
    static struct timeval tv2;
    static int clicks;

    /* Decode Xterm mouse information to a GPM style event */

    /* Variable btn has following meaning: */
    /* 0 = btn1 dn, 1 = btn2 dn, 2 = btn3 dn, 3 = btn up */
    btn = getch () - 32;
    
    /* There seems to be no way of knowing which button was released */
    /* So we assume all the buttons were released */

    if (btn == 3){
        ev->type = GPM_UP | (GPM_SINGLE << clicks);
        ev->buttons = 0;
	GET_TIME (tv1);
	clicks = 0;
    } else {
        ev->type = GPM_DOWN;
	GET_TIME (tv2);
	if (tv1.tv_sec && (DIF_TIME (tv1,tv2) < double_click_speed)){
	    clicks++;
	    clicks %= 3;
	} else
	    clicks = 0;
	
        switch (btn) {
	case 0:
            ev->buttons |= GPM_B_LEFT;
            break;
	case 1:
            ev->buttons |= GPM_B_MIDDLE;
            break;
	case 2:
            ev->buttons |= GPM_B_RIGHT;
            break;
	default:
            /* Nothing */
            break;
        }
    }
    /* Coordinates are 33-based */
    /* Transform them to 1-based */
    ev->x = getch () - 32;
    ev->y = getch () - 32;
}

/* Returns a character read from stdin with appropiate interpretation */
/* Also takes care of generated mouse events */
int mi_getch ()
{
    int c;
    static int pending;			/* Input pending? */
    static int d;			/* The input that is pending */
    static int flag;			/* Return value from select */
    static int xmouse_event_flag = 0;	/* Flag: xterm mouse event waiting? */
    static Gpm_Event ev;		/* Mouse event */
    struct timeval timeout;
    struct timeval *time_addr = NULL;
    int redo_event = 0;
#ifdef DEBUG_MOUSE
    extern FILE *log;
#endif

    /* Repeat if using mouse */
    while (xmouse_flag
#ifdef HAVE_LIBGPM
	   || gpm_flag
#endif
	   ){
	if ((xmouse_flag && !xmouse_event_flag)
#ifdef HAVE_LIBGPM
	    || gpm_flag
#endif
	    )
	{
	    FD_ZERO (&select_set);
	    FD_SET  (input_fd, &select_set);
#ifdef HAVE_LIBGPM
	    if (gpm_flag) {
		FD_SET  (gpm_fd, &select_set);
	    }
#endif

	    timeout.tv_sec = 0;
	    timeout.tv_usec = mou_auto_repeat * 1000;

	    flag = select (max_fd+1, &select_set, NULL, NULL, time_addr);
	    if (flag == 0 && (redo_event & MOU_REPEAT)){
		redo_event = redo_mouse (&ev);
		continue;
	    }
	    if (flag == -1 && errno == EINTR)
	        continue;
	    if (FD_ISSET (input_fd, &select_set))
	        break;
	}
	if (
#ifdef HAVE_LIBGPM
	    (gpm_flag && FD_ISSET (gpm_fd, &select_set)) ||
#endif
	    xmouse_event_flag){
	    xmouse_event_flag = 0;
#ifdef HAVE_LIBGPM
	    if (gpm_flag){
		Gpm_GetEvent (&ev);
		Gpm_FitEvent (&ev);
	    }
#endif    
	    DEBUGM ((log, "+%s\n", redo_event & MOU_REPEAT?"redo":"nor"));
	    if (redo_event & MOU_REPEAT)
	        redo_event = redo_mouse (&ev);
	    else
	        redo_event = mouse_handler (&ev);
	    DEBUGM ((log, "%s\n", redo_event & MOU_REPEAT?"redo":"nor"));

	    if (redo_event & MOU_ENDLOOP)
	        return -1;
	    time_addr = redo_event ? &timeout : NULL;
	    if (quit){
		return -1;
	    }
	    continue;
	}
    }
#ifdef BUGGY_CURSES
    untouchwin (stdscr);
#endif

    c = getch ();
#if defined(_AIX) || defined(__aix__)
    if (c == KEY_SCANCEL)
	return '\t';
#endif

    if (c == KEY_F(0))
	return KEY_F(10);
    
    if (c != ESC_CHAR)
	return c;

    /* If curses didn't find a match for ESC-whatever, then the rest */
    /* of the characters are available for reading.   */

#ifdef BUGGY_CURSES
    wtimeout(stdscr, 500);
#else
    nodelay (stdscr, TRUE);
#endif

    d = getch ();
    nodelay (stdscr, FALSE);
    
    if (d == ERR){
	pending = 0;
	return c;
    }

    switch (d){
    case '0':
	return KEY_F(10); /* special case */
    case '<':
	return KEY_HOME;
    case '>':
	return KEY_END;
    case '[':
	d = getch ();
	if (d == 'M' && xmouse_flag){
	    /* Get a xterm mouse event */
	    xmouse_get_event (&ev);
	    xmouse_event_flag = 1;
	    /* Handle mouse event */
	    return mi_getch ();
	} else if (d == '1'){
	    d = getch ();
	    if (getch () != '~')
	        return -1;
	    switch (d){
	    case '1':
		return KEY_F(1);
	    case '2':
		return KEY_F(2);
	    case '3':
		return KEY_F(3);
	    case '4':
		return KEY_F(4);
	    case '5':
		return KEY_F(5);
	    case '7':
		return KEY_F(6);
	    case '8':
		return KEY_F(7);
	    case '9':
		return KEY_F(8);
	    default:
		return -1;
	    }
	} else if (d == '2'){
	    d = getch ();
	    if (getch () != '~')
	        return -1;
	    switch (d){
	    case '0':
		return KEY_F(9);
	    case '1':
		return KEY_F(10);
	    default:
		return -1;
	    }
	} else {
	    ungetch (d);
	    return '[';
	}
	break;
    default:
        if (isdigit(d))
	    return KEY_F(d-'0');
	if ((d >= 'a' && d <= 'z') || (d >= 'A' && d <= 'Z' )
	    || d == '\n' || d == '\t')
	    return 0x80 | d;
	else {
	    return c;
	    pending = 1;
	}
    }
    return c;
    pending = 1;
}
