#ifdef use_mouse
#include <gpm.h>

typedef int (*mouse_h)(Gpm_Event *, void *);

typedef struct {
    int x1, y1;
    int x2, y2;
    void *data;
    mouse_h mouse_callback;
    struct MouseEvent *next;
} MouseEvent;

typedef struct {
    int x, y;
    struct Frame *next;
    MouseEvent *mouse_events;
} Frame;

void init_mouse ();
void shut_mouse ();
void push_event (int x1, int y1, int x2, int y2, mouse_h callback, void *d);
void pop_event ();
int mouse_handler (Gpm_Event *gpm_event);
int click (Gpm_Event *event, void *fn);
int click_auto_repeat (Gpm_Event *event, void *fn);
int null_event (Gpm_Event *event, void *x);
int quit_event (Gpm_Event *event, void *x);
int redo_mouse (Gpm_Event *event);
void show_mouse_pointer (int x, int y);
int set_quit_flag (Gpm_Event *event, void *x);
int click_may_break_loop (Gpm_Event *event, void *fn);

/* Constants returned from mouse handlers */

#define MOU_NORMAL    0x00
#define MOU_REPEAT    0x01
#define MOU_ENDLOOP   0x02
#define MOU_LOCK      0x04

#ifdef DEBUGMOUSE
#define DEBUGM(data) fprintf data
#else
#define DEBUGM(data) 
#endif

#else
#define push_event(a,b,c,d,e,f)
#define push_frame(a,b,c)
#define pop_frame()
#define pop_event()
#define show_mouse_pointer()
#endif

