/* Keyboard support routines.
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <unistd.h>		/* select () */
#include <sys/types.h>		/* FD_ZERO et al */
#include <sys/time.h>		/* struct timeval */
#include <ncurses.h>
#include <ctype.h>
#include "global.h"
#include "main.h"
#ifdef use_mouse
#include "mouse.h"
#include <errno.h>
#endif

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/key.c,v 1.10 1994/08/18 19:00:17 miguel Exp $";

int mou_auto_repeat = 400;

#ifdef use_mouse
static int max_fd;
static int input_fd;
static fd_set select_set;
#endif

void init_key ()
{
#ifdef use_mouse
    input_fd = fileno (stdin);
    max_fd = (gpm_fd > input_fd) ? gpm_fd : input_fd;
#endif
}

int mi_getch ()
{
    int c;
    static int d;
    static int pending;
#ifdef use_mouse
    static int flag;
    Gpm_Event ev;
    struct timeval timeout;
    struct timeval *time_addr = NULL;
    int redo_event = 0;
    extern FILE *log;
#endif

    if (pending){
	pending = 0;
	return d;
    }
#ifdef use_mouse
    if (gpm_flag){
	while (1){
	    FD_ZERO (&select_set);
	    FD_SET  (input_fd, &select_set);
	    FD_SET  (gpm_fd, &select_set);
	    
	    timeout.tv_sec = 0;
	    timeout.tv_usec = mou_auto_repeat;
	    
	    flag = select (max_fd+1, &select_set, NULL, NULL, time_addr);
	    if (flag == 0 && (redo_event & MOU_REPEAT)){
		redo_event = redo_mouse (&ev);
		continue;
	    }
	    if (flag == -1 && errno == EINTR)
		continue;
	    if (FD_ISSET (input_fd, &select_set))
		break;
	    if (FD_ISSET (gpm_fd, &select_set)){
		Gpm_GetEvent (&ev);
		Gpm_FitEvent (&ev);
		DEBUGM ((log, "+%s\n", redo_event & MOU_REPEAT?"redo":"nor"));
		if (redo_event & MOU_REPEAT)
		    redo_event = redo_mouse (&ev);
		else
		    redo_event = mouse_handler (&ev);
		DEBUGM ((log, "%s\n", redo_event & MOU_REPEAT?"redo":"nor"));
		
		if (redo_event & MOU_ENDLOOP)
		    return -1;
		time_addr = redo_event ? &timeout : NULL;
		if (quit){
		    return -1;
		}
		continue;
	    }
	}
    }
#endif
#ifdef __svr4__
    untouchwin (stdscr);
#endif
    c = getch ();
    if (c != '\e')
	return c;
    nodelay (stdscr, TRUE);
    d = getch ();
    nodelay (stdscr, FALSE);
    if (d == ERR){
	pending = 0;
	return c;
    }
    switch (d){
    case '0':
	return KEY_F(10);
    case '1':
	return KEY_F(1);
    case '2':
	return KEY_F(2);
    case '3':
	return KEY_F(3);
    case '4':
	return KEY_F(4);
    case '5':
	return KEY_F(5);
    case '6':
	return KEY_F(6);
    case '7':
	return KEY_F(7);
    case '8':
	return KEY_F(8);
    case '9':
	return KEY_F(9);
    case '<':
	return KEY_HOME;
    case '>':
	return KEY_END;
	
    default:
	if ((d >= 'a' && d <= 'z') || (d >= 'A' && d <= 'Z' )
	    || d == '\n' || d == '\t')
	    return 0x80 | d;
	else
	    return d;
    }
    return d;
}
