/*
 * statdir.c
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * routines used in statting dirs 
 *
 * Mon May  2 17:36:33 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MAN_MAIN        /* to not define config_file */
#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

extern char *manp;
extern int debug;

char *get_userdb_list(void)
{
	char *newlist, *ret_list, *c1;
	
	newlist = strdup(manp);
	*(ret_list = (char *) malloc (strlen(manp) + 2)) = '\0';

	while ( (c1 = strrchr(newlist, ':')) != NULL){
		*c1 = '\0';
		if ( *(++c1) == '/' && 
		  strncmp(c1, MAN_ROOT, sizeof MAN_ROOT - 1) != 0){
			strcat(ret_list, ":");
			strcat(ret_list, c1);
			strcat(ret_list, LOCAL_DB);
		}
	}
	if ( *newlist == '/' && 
	  strncmp(newlist, MAN_ROOT, sizeof MAN_ROOT - 1) != 0){
		strcat(ret_list, ":");
		strcat(ret_list, c1);
		strcat(ret_list, LOCAL_DB);
	}
	free(newlist);

	if (*ret_list == '\0'){
		free(ret_list);
		return NULL;
	} else 
		return ++ret_list; /* get rid of initial ':' */
}
