#include <stdio.h>
#include <getopt.h>
#include "config.h"
#include "man.h"
#include "gripes.h"

extern char *strdup (), *getenv(), *strchr(), *getval();
extern char *pager, *roff_directive;
extern char *colon_sep_section_list;
extern int debug, apropos, whatis, findall, print_where, do_troff;

int alt_system;
char *alt_system_name;

static char short_opts[] = "C:M:P:S:adfhkm:p:tw?";

static const struct option long_opts[] = {
    { "path",       no_argument,            NULL, 'w' },
    { NULL, 0, NULL, 0 }
};

/*
 * Get options from the command line and user environment.
 * Also reads the configuration file.
 */

void
man_getopt (argc, argv)
     register int argc;
     register char **argv;
{
  register int c;
  register char *p;
  register char *end;
  register struct dir *mp;
  char *config_file = NULL;
  char *manp = NULL;
  extern char *optarg;
  extern int getopt_long ();
  extern void manpath ();

  while ((c = getopt_long (argc, argv, short_opts, long_opts, NULL)) != -1) {
      switch (c) {
	case 'C':
	  config_file = strdup (optarg);
	  break;
	case 'M':
	  manp = strdup (optarg);
	  break;
	case 'P':
	  pager = strdup (optarg);
	  break;
	case 'S':
	  colon_sep_section_list = strdup (optarg); 
	  break;
	case 'a':
	  findall++;
	  break;
	case 'd':
	  debug++;
	  break;
	case 'f':
	  if (do_troff)
	    fatal2 (INCOMPAT, "-f", "-t");
	  if (apropos)
	    fatal2 (INCOMPAT, "-f", "-k");
	  if (print_where)
	    fatal2 (INCOMPAT, "-f", "-w");
	  whatis++;
	  break;
	case 'k':
	  if (do_troff)
	    fatal2 (INCOMPAT, "-k", "-t");
	  if (whatis)
	    fatal2 (INCOMPAT, "-k", "-f");
	  if (print_where)
	    fatal2 (INCOMPAT, "-k", "-w");
	  apropos++;
	  break;
	case 'm':
	  alt_system++;
	  alt_system_name = strdup (optarg);
	  break;
	/* or:  gripe (NO_ALTERNATE); exit(1); */
	case 'p':
	  roff_directive = strdup (optarg);
	  break;
	case 't':
	  if (apropos)
	    fatal2 (INCOMPAT, "-t", "-k");
	  if (whatis)
	    fatal2 (INCOMPAT, "-t", "-f");
	  if (print_where)
	    fatal2 (INCOMPAT, "-t", "-w");
	  do_troff++;
	  break;
	case 'w':
	  if (apropos)
	    fatal2 (INCOMPAT, "-w", "-k");
	  if (whatis)
	    fatal2 (INCOMPAT, "-w", "-f");
	  if (do_troff)
	    fatal2 (INCOMPAT, "-w", "-t");
	  print_where++;
	  break;
	case 'h':
	case '?':
	default:
	  usage();
	  break;
      }
  }

  read_config_file (config_file);

  if (pager == NULL || *pager == '\0')
    if ((pager = getenv ("PAGER")) == NULL)
      pager = getval ("PAGER");

  if (debug)
    gripe1 (PAGER_IS, pager);

  manpath (manp, 0);		/* 0: no error printout */

  if (alt_system_name == NULL || *alt_system_name == '\0')
    if ((alt_system_name = getenv ("SYSTEM")) != NULL)
      alt_system_name = strdup (alt_system_name);

}
