/*
 *
 * Simple VFS definitions for fileio.
 *
 * Authors: Marco van Wieringen <v892273@si.hhs.nl> <mvw@mcs.nl.mugnet.org>
 *          Edvard Tuinder <v892231@si.hhs.nl> <ed@delirium.nl.mugnet.org>
 *
 * Version: $Id: fileio.h,v 1.5 1994/05/30 18:39:42 mvw Exp mvw $
 *
 */
#ifndef _LINUX_FILEIO_H
#define _LINUX_FILEIO_H

#include <linux/config.h>
#include <linux/stat.h>

#ifdef CONFIG_QUOTA

int vfs_write(struct inode *ino, struct file *file, char *addr, size_t bytes);
int vfs_create(struct inode *dir, const char *basename,
               int namelen, int mode, struct inode **res_ino);
int vfs_truncate(struct inode *ino, size_t lenght);
int vfs_mknod(struct inode *dir, const char *basename,
              int namelen, int mode, dev_t dev);
int vfs_mkdir(struct inode *dir, const char *basename, int namelen, int mode);
int vfs_rmdir(struct inode *dir, const char *basename, int namelen);
int vfs_unlink(struct inode *dir, const char *basename, int namelen);
int vfs_symlink(struct inode *dir, const char *basename,
                int namelen, const char *oldname);
int vfs_chown(struct inode *ino, uid_t uid, gid_t gid);
int vfs_rename(struct inode *old_dir, const char *old_base, int old_len,
               struct inode *new_dir, const char *mew_base, int new_len);
void vfs_open(struct file *filp);
void vfs_close(struct file *filp);

#else /* CONFIG_QUOTA */

#define vfs_write(ino, file, addr, bytes) \
(file)->f_op->write((ino),(file),(addr),(bytes))

#define vfs_create(dir, basename, namelen, mode, res_ino) \
(dir)->i_op->create((dir),(basename),(namelen),(mode),(res_ino))

int vfs_truncate(struct inode *ino, size_t lenght);

#define vfs_mknod(dir, basename, namelen, mode, dev) \
(dir)->i_op->mknod((dir),(basename),(namelen),(mode),(dev))

#define vfs_mkdir(dir, basename, namelen, mode) \
(dir)->i_op->mkdir((dir),(basename),(namelen),(mode))

#define vfs_rmdir(dir, basename, namelen) \
(dir)->i_op->rmdir((dir),(basename),(namelen))

#define vfs_unlink(dir, basename, namelen) \
(dir)->i_op->unlink((dir),(basename),(namelen))

#define vfs_symlink(dir, basename, namelen, oldname) \
(dir)->i_op->symlink((dir),(basename),(namelen),(oldname))

int vfs_chown(struct inode *ino, uid_t uid, gid_t gid);

#define vfs_rename(old_dir, old_base, old_len, new_dir, new_base, new_len) \
(old_dir)->i_op->rename((old_dir),(old_base),(old_len),(new_dir),(new_base),(new_len))

void vfs_open(struct file *filp);
void vfs_close(struct file *filp);

#endif /* CONFIG_QUOTA */
#endif /* _LINUX_FILEIO_H */
