/*
 * BDM2: Banked dumb monochrome driver
 * Pascal Haible 8/93, haible@izfm.uni-stuttgart.de
 *
 * bdm2/driver/apollo/apolloPorts.h
 * Hamish Coleman 11/93 hamish@zot.apana.org.au 
 *
 * derived from:
 * hgc1280/*
 * Pascal Haible 8/93, haible@izfm.uni-stuttgart.de
 *
 * see bdm2/COPYRIGHT for copyright and disclaimers.
 */

/* $XFree86: mit/server/ddx/x386/bdm2/drivers/apollo/apolloPorts.h,v 2.0 1994/04/10 05:54:08 dawes Exp $ */

#if 0
#define AP_PORT_BASE		0x3d0
/* Read  Byte  Status Reg */
#define AP_PORT_STATUS		AP_PORT_BASE
/* Write Word  Write Enable Reg */
#define AP_PORT_WRITE_ENABLE	AP_PORT_BASE
/* Read  Byte  Device ID reg */
#define AP_PORT_DEVICE_ID	AP_PORT_BASE+0x01
/* Write Word  Raster Operation Reg */
#define AP_PORT_ROP		AP_PORT_BASE+0x02
/* Write Word  Diagnostic Memory Request */
#define AP_PORT_DIAG_MEM_REQ	AP_PORT_BASE+0x04
/*       Byte  Control Reg 0 - blit Mode & Shift reg */
#define AP_PORT_CONTROL_0	AP_PORT_BASE+0x08
/*       Byte  Control Reg 1 - operation modes */
#define AP_PORT_CONTROL_1	AP_PORT_BASE+0x0a
/*       Byte  Control Reg 2 - Plane acces mode */
#define AP_PORT_CONTROL_2	AP_PORT_BASE+0x0c
/*       Byte  Control Reg 3 - Reset?? */
#define AP_PORT_CONTROL_3	AP_PORT_BASE+0x0e
#endif

#if defined(C_STYLE_HEX_CONSTANTS)
#undef CONST
#define CONST(a)	(a)
#endif

#define AP_PORT_BASE		CONST(0x3b0)
#define AP_PORT_ALTERNATE	CONST(0x3d0)

#define AP_PORT_STATUS		(Apollo_IOBASE)
#define AP_PORT_WRITE_ENABLE	(Apollo_IOBASE)
#define AP_PORT_DEVICE_ID	(Apollo_IOBASE+0x01)
#define AP_PORT_ROP		(Apollo_IOBASE+0x02)
#define AP_PORT_DIAG_MEM_REQ	(Apollo_IOBASE+0x04)
#define AP_PORT_CONTROL_0	(Apollo_IOBASE+0x08)
#define AP_PORT_CONTROL_1	(Apollo_IOBASE+0x0a)
#define AP_PORT_CONTROL_2	(Apollo_IOBASE+0x0c)
#define AP_PORT_CONTROL_3	(Apollo_IOBASE+0x0e)

/* CREG 0 settings */
#define AP_MODE_VECTOR		0x40	/* 010x.xxxx */
#define AP_MODE_DBLT		0x80	/* 100x.xxxx */
#define AP_MODE_NORMAL		0xE0	/* 111x.xxxx */
#define AP_SHIFT_BITS		0x1F	/* xxx1.1111 */

/* CREG 1 settings */
#define AP_BLT_NORMAL		0x80	/* 1xxx.xxxx */
#define AP_BLT_INVERSE		0x00	/* 0xxx.xxxx */
#define AP_BLT_HIBIT		0x40	/* x!xx.xxxx */
#define AP_ROP_ENABLE		0x10	/* xxx1.xxxx */
#define AP_ROP_DISABLE		0x00	/* xxx0.xxxx */
#define AP_SYNC_nRESET		0x08	/* xxxx.1xxx */
#define AP_SYNC_ENABLE		0x02	/* xxxx.xx1x */
#define AP_DISP_ENABLE		0x01	/* xxxx.xxx1 */
#define AP_DISP_DISABLE		0x00	/* xxxx.xxx0 */
#define AP_CREG1_NORMAL		(AP_SYNC_nRESET | AP_SYNC_ENABLE | AP_DISP_ENABLE)

#define AP_BIT_INV		7<<1
#define AP_BIT_HIBIT		6<<1
#define AP_BIT_ROP		4<<1
#define AP_BIT_RESET		3<<1
#define AP_BIT_SYNC		1<<1
#define AP_BIT_DISP		0<<1

#define AP_ON			1
#define AP_OFF			0

/* CREG 2 settings */
#define AP_DATA_1s		0x00	/* 00xx.xxxx */
#define AP_DATA_PIX		0x40	/* 01xx.xxxx */
#define AP_DATA_PLN		0xC0	/* 11xx.xxxx */

/* CREG 3 settings */
#define AP_RESET_CREG		0x80	/* 1000.0000 */

/* ROP's */
#define AP_ROP_SRC		0x3

/* ID Numbers */
#define AP_MONO_HIRES		0x09
